		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	bpl_stars_0
		XREF	bpl_stars_1
		XREF	bpl_stars_2
		XREF	bpl_stars_3
		XREF	bpl_stars_4
		XREF	bpl_stars_5
		XREF	bpl_stars_6
		XREF	bpl_stars_7
		XREF	bpl_stars_8
		XREF	stars_positions

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_steps
		XREF	fader_colors
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal
		XREF	blackpal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	salir

		XREF	sinus

		XDEF	stars_main


		IFND	WASIMACROs
		include	include:macros2.i
		ENDC

		include	include:exec/exec_lib.i

		incdir	'starfield'

		section	starfield,code
wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM


stars_main
		RESET_SPRITES	cop_stars_spr

		;move.l	#cop_palette,fader_copper
		;move.l	#blackpal,fader_original
		;move.l	#pal1,fader_target
		;move.w	#7,fader_steps
		;move.w	#15,fader_colors
		;jsr	fader_makecopper
		;jsr	fader_initcrossfade

		lea	(bpl_stars_0+64*256*10).l,a4
		move.l	#((64*256*10)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
.chiploop	rept	16
		movem.l	d1-d7/a3,-(a4)
		endr
		dbf	d0,.chiploop

		move.l	#bpl_stars_0,d0
		lea	cop_stars,a0
		moveq.l	#7,d1
.loop2		addq.l	#2,a0
		swap	d0
		move.w	d0,(a0)+
		addq.l	#2,a0
		swap	d0
		move.w	d0,(a0)+
		add.l	#320*256/8,d0
		dbf	d1,.loop2

		bsr	stars_dbuffer
		bsr	stars_init
		bsr	stars_makepal

		move.l	#stars_move,lv3_vblank

		move.l	#cop_stars,$dff080

.loop		wrast	255

		;btst	#2,$dff016			; pon aqui el chekeo de modulo para el cambio de velocidad
		;bne.b	.no

;		cmp.w	#33,p61_pos
;		blt	.no
;		move.w	#1,stars_moving
;		move.l	#pal1,fader_original
;		move.l	#pal2,fader_target
;		move.w	#9,fader_steps
;		jsr	fader_initcrossfade
;.no
		bsr	stars_dbuffer
		bsr	stars_clear
		bsr	stars_makematrix
		bsr	stars_draw

		;btst	#6,$bfe001
		;bne.b	.loop

		tst.l	salir
		bne	.adios
		cmp.w	#36,p61_pos
		blt	.loop
		cmp.w	#58,p61_crow
		blt	.loop

.adios		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


.makestop	move.w	(a0),d0
		move.w	d0,d7
		bgt.b	.pos1
		neg.w	d0
.pos1		add.w	d2,d0
		cmp.w	d1,d0
		bgt.b	.ok1
		move.w	d1,d0
.ok1		tst	d7
		bgt.b	.pos2
		neg.w	d0
.pos2		move.w	d0,(a0)
		rts
		cnop	0,16
pal1		incbin	'pal.stars'
pal2		dcb.l	256,$000000

stars_makepal	lea	pal1(pc),a0
		lea	pal2(pc),a1

		move.w	#63,d7
.loop1		move.l	(a0)+,d0
		lsr.l	#1,d0
		and.l	#$7f7f7f,d0
		move.l	d0,(a1)+
		dbra	d7,.loop1

		lea	pal1(pc),a2
		move.w	#63,d7
.loop2		move.l	(a2)+,(a0)+
		move.l	#$aaaaaa,(a1)+
		dbra	d7,.loop2
		lea	pal1(pc),a2
		move.w	#63,d7
.loop3		move.l	(a2)+,(a0)+
		move.l	#$555555,(a1)+
		dbra	d7,.loop3
		lea	pal1(pc),a2
		move.w	#63,d7
.loop4		move.l	(a2)+,(a0)+
		move.l	#$ffffff,(a1)+
		dbra	d7,.loop4

		move.l	#cop_palette,fader_copper
		move.l	#pal1,fader_original
		move.l	#pal1,fader_target
		move.w	#1,fader_steps
		move.w	#255,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade

		lea	brushfast,a0
		lea	bpl_stars_8,a1
		move.w	#511,d7
.loop5
		rept	320/32
		move.l	(a0)+,(a1)+
		endr
		lea	(64-40)(a1),a1
		dbra	d7,.loop5
		rts

stars_init	lea	stars_positions,a0
		move.w	#(8192)-1,d7

		move.l	#'netw',d0
		move.l	#'ork ',d1

.rndloop	add.w	d1,d0
		addx.l	d0,d1
		roxr.b	#3,d0
		eor.l	d0,d1
		swap	d0
		
		move.l	d0,(a0)+
		move.w	d1,(a0)+

		dbra	d7,.rndloop

		lea	sinus,a0
		lea	((65536*2).l,a0),a1

.fixloop	move.l	(a0),d0
		cmp.l	#$10000,d0
		blt.b	.ok1
		move.l	#$0ffff,d0
.ok1		cmp.l	#-$10000,d0
		bgt.b	.ok2
		move.l	#-$0ffff,d0
.ok2		move.l	d0,(a0)+
		cmp.l	a1,a0
		blt.b	.fixloop
		rts

stars_moving	dc.w	0

stars_xang	dc.w	0
stars_yang	dc.w	0
stars_zang	dc.w	0
stars_xpos	dc.w	0
stars_ypos	dc.w	0
stars_zpos	dc.w	0

stars_xangs	dc.w	300
stars_yangs	dc.w	200
stars_zangs	dc.w	100
stars_xposs	dc.w	55
stars_yposs	dc.w	90
stars_zposs	dc.w	-70

stars_move	jsr	fader_setpalette

		move.w	p61_pos,d0
		lsl.w	#8,d0
		move.w	p61_crow,d1
		move.b	d1,d0
		cmp.w	#(35<<8),d0
		bne	.no
		move.w	#1,stars_moving
		move.l	#pal1,fader_original
		move.l	#pal2,fader_target
		move.w	#9,fader_steps
		jsr	fader_initcrossfade
.no
		;bra	.nochange

		move.w	stars_xangs,d0
		move.w	stars_yangs,d1
		move.w	stars_zangs,d2
		move.w	stars_xposs,d3
		move.w	stars_yposs,d4
		move.w	stars_zposs,d5
		add.w	d0,stars_xang
		add.w	d1,stars_yang
		add.w	d2,stars_zang
		add.w	d3,stars_xpos
		add.w	d4,stars_ypos
		add.w	d5,stars_zpos

		tst.w	stars_moving
		beq.b	.nochange

		clr.w	d1
		move.w	#-3,d2
		lea	stars_xangs(pc),a0
		bsr	.makestop

		clr.w	d1
		move.w	#-3,d2
		lea	stars_yangs(pc),a0
		bsr	.makestop

		move.w	#50,d1
		move.w	#-1,d2
		lea	stars_zangs(pc),a0
		bsr	.makestop

		move.w	#0,d1
		move.w	#-1,d2
		lea	stars_xposs(pc),a0
		bsr	.makestop

		move.w	#0,d1
		move.w	#-1,d2
		lea	stars_yposs(pc),a0
		bsr	.makestop

		move.w	#50,d1
		move.w	#-1,d2
		lea	stars_zposs(pc),a0
		bsr	.makestop

.nochange

		cmp.w	#36,p61_pos
		bne	.nofade
		cmp.w	#42,p61_crow
		bne	.nofade
		move.l	#cop_palette,fader_copper
		move.l	#pal1,fader_original
		move.l	#blackpal,fader_target
		move.w	#6,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
.nofade		rts

.makestop	move.w	(a0),d0
		move.w	d0,d7
		bgt.b	.pos1
		neg.w	d0
.pos1		add.w	d2,d0
		cmp.w	d1,d0
		bgt.b	.ok1
		move.w	d1,d0
.ok1		tst	d7
		bgt.b	.pos2
		neg.w	d0
.pos2		move.w	d0,(a0)
		rts

stars_makematrix
		lea	sinus,a6
		lea	16384(a6),a5
		moveq.l	#16-2,d6

		lea	stars_xang(pc),a0
		move.w	(a0)+,d3
		move.w	(a0)+,d4
		move.w	(a0)+,d5
		lsr.w	#2,d3
		lsr.w	#2,d4
		lsr.w	#2,d5

		move.l	(a5,d3.w*4),d0
		move.l	(a6,d3.w*4),d1
		asr.l	#2,d0
		asr.l	#2,d1
		move.l	d1,a0

		move.l	(a5,d4.w*4),d1
		move.l	(a6,d4.w*4),d2
		asr.l	#2,d1
		asr.l	#2,d2
		move.l	d2,a1

		move.l	(a5,d5.w*4),d2
		move.l	(a6,d5.w*4),d3
		asr.l	#2,d2
		asr.l	#2,d3
		move.l	d3,a2

		moveq.l	#16-2,d6

ca equr d0
sa equr a0
cb equr d1
sb equr a1
cc equr d2
sc equr a2

		move.w	sb,d7
		muls.w	cc,d7
		asr.l	d6,d7

		move.w	cb,d3
		muls.w	cc,d3
		asr.l	d6,d3
		move.w	d3,m1	; m1

		move.w	sa,d3
		muls.w	d7,d3
		move.w	sc,d4
		muls.w	ca,d4
		sub.l	d4,d3
		asr.l	d6,d3
		move.w	d3,m2	; m2

		move.w	ca,d3
		muls.w	d7,d3
		move.w	sc,d4
		move.w	sa,d5
		muls.w	d5,d4
		add.l	d4,d3
		asr.l	d6,d3
		move.w	d3,m3	; m3

		move.w	sb,d7
		move.w	sc,d3
		muls.w	d3,d7
		asr.l	d6,d7

		move.w	sc,d3
		muls.w	cb,d3
		asr.l	d6,d3
		move.w	d3,m4	; m4

		move.w	sa,d3
		muls.w	d7,d3
		move.w	cc,d4
		muls.w	ca,d4
		add.l	d4,d3
		asr.l	d6,d3
		move.w	d3,m5	; m5

		move.w	ca,d3
		muls.w	d7,d3

		move.w	sa,d4
		muls.w	cc,d4
		sub.l	d4,d3
		asr.l	d6,d3
		move.w	d3,m6	; m6

		move.w	sb,d3
		neg.w	d3
		move.w	d3,m7	; m7

		move.w	sa,d3
		muls.w	cb,d3
		asr.l	d6,d3
		move.w	d3,m8	; m8
		muls.w	ca,cb
		asr.l	d6,cb
		move.w	cb,m9	; m9
		rts

stars_draw	move.l	4.w,a6
		jsr	_LVOCacheClearU(a6)

		lea	stars_positions,a0
		move.l	stars_bpl_draw(pc),a1

		move.w	stars_xpos(pc),a2
		move.w	stars_ypos(pc),a3
		move.w	stars_zpos(pc),a4
		move.w	#$2000,a5
		move.w	#1023+512,d7
loop		move.w	#$3fff,d0
		move.w	(a0)+,d2
		move.w	(a0)+,d3
		move.w	(a0)+,d4
		add.w	a2,d2
		add.w	a3,d3
		add.w	a4,d4
		and.w	d0,d2
		and.w	d0,d3
		and.w	d0,d4
		sub.w	a5,d2
		sub.w	a5,d3
		sub.w	a5,d4

		move.w	d2,d0
		move.w	d3,d5
		move.w	d4,d6
m1		equ	*+2
		muls.w	#$4000,d0
m2		equ	*+2
		muls.w	#$0000,d5
m3		equ	*+2
		muls.w	#$0000,d6
		add.l	d6,d5
		add.l	d5,d0

		move.w	d2,d1
		move.w	d3,d5
		move.w	d4,d6
m4		equ	*+2
		muls.w	#$0000,d1
m5		equ	*+2
		muls.w	#$4000,d5
m6		equ	*+2
		muls.w	#$0000,d6
		add.l	d6,d5
		add.l	d5,d1

m7		equ	*+2
		muls.w	#$0000,d2
m8		equ	*+2
		muls.w	#$0000,d3
m9		equ	*+2
		muls.w	#$4000,d4
		add.l	d4,d3
		add.l	d3,d2
		add.l	d2,d2
		swap	d2
		add.w	#$a00,d2
		ble.b	no

		asr.l	#8,d0
		divs.w	d2,d0
		add.w	#160,d0
		cmp.w	#318,d0
		bcc.b	no

		asr.l	#8,d1
		divs.w	d2,d1
		add.w	#128,d1
		cmp.w	#254,d1
		bcc.b	no

		ext.l	d0
		lsl.w	#6,d1

		cmp.w	#$a00,d2
		blt.b	z1
		bfset	(a1,d1.w){d0:1}
no		dbra	d7,loop
		rts
z1		cmp.w	#$400,d2
		blt.b	z2
		bfset	(a1,d1.w){d0:2}
		dbra	d7,loop
		rts
z2		lea	(a1,d1.w),a6
		bfset	-64(a6){d0:1}
		bfset	64(a6){d0:1}
		subq.l	#1,d0
		bfset	(a6){d0:3}
		dbra	d7,loop
		rts


stars_clear	lea	$dff000,a6
		move.l	stars_bpl_clear(pc),d0
		BWAIT
		move.l	#$01000000,$40(a6)
		move.w	#64-40,$66(a6)
		move.l	d0,$54(a6)
		move.w	#(256<<6)|20,$58(a6)
		rts

stars_dbuffer	lea	stars_bpl_clear,a0

		movem.l	(a0),d0-d7
		move.l	d1,(a0)+
		move.l	d2,(a0)+
		move.l	d3,(a0)+
		move.l	d4,(a0)+
		move.l	d5,(a0)+
		move.l	d6,(a0)+
		move.l	d7,(a0)+
		move.l	d0,(a0)+

		lea	cop_stars,a1

		move.w	d7,6(a1)
		swap	d7
		move.w	d7,2(a1)

		move.w	d6,14(a1)
		swap	d6
		move.w	d6,10(a1)

		move.w	d5,22(a1)
		swap	d5
		move.w	d5,18(a1)

		move.w	d4,30(a1)
		swap	d4
		move.w	d4,26(a1)

		move.w	d3,38(a1)
		swap	d3
		move.w	d3,34(a1)

		move.w	d2,46(a1)
		swap	d2
		move.w	d2,42(a1)

		move.l	#bpl_stars_8,d0
		move.l	d0,d1
		add.l	#16384,d1
		lea	cop_starsbrsh,a0
		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		move.w	d1,14(a0)
		swap	d1
		move.w	d1,10(a0)
		rts

stars_bpl_clear		dc.l	bpl_stars_7
stars_bpl_raster5	dc.l	bpl_stars_6
stars_bpl_raster4	dc.l	bpl_stars_5
stars_bpl_raster3	dc.l	bpl_stars_4
stars_bpl_raster2	dc.l	bpl_stars_3
stars_bpl_raster1	dc.l	bpl_stars_2
stars_bpl_visible	dc.l	bpl_stars_1
stars_bpl_draw		dc.l	bpl_stars_0

		cnop	0,8
brushfast	incbin	'bpl.thorus'

		section	data_c,data_c

		cnop	0,8
cop_stars	dc.w	$f4,0,$f6,0
		dc.w	$f0,0,$f2,0
		dc.w	$ec,0,$ee,0
		dc.w	$e8,0,$ea,0
		dc.w	$e4,0,$e6,0
		dc.w	$e0,0,$e2,0

sprite	set	$120
cop_stars_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

cop_starsbrsh	dc.w	$fc,0,$fe,0
		dc.w	$f8,0,$fa,0

		dc.w	$08e,$2881
		dc.w	$090,$28c1
		dc.w	$092,14*4
		dc.w	$094,44*4

		dc.w	$108,64-40
		dc.w	$10a,64-40

		dc.w	$2007,$fffe
cop_palette	ds.b	2112

		dc.w	$1fc,$000f
		dc.w	$100,$0211
		dc.w	$102,$0000
		dc.w	$104,$0224
		dc.w	$106,$0020

		dc.l	-2,-2

		cnop	0,16
spr_off		ds.l	8
