		;machine	68030
	
		opt	debug,l+,c-,p=68030

		XREF	yoriko_planes

		XREF	blackpal
		XREF	whitepal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette
		XREF	fader_finish

		XREF	p61_pos
		XREF	p61_crow

		XREF	yoryko_sinus

		XREF	salir

		XREF	yorykobpl
		XDEF	scrollwipe_main


		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	'scrollwipe'

		section	code,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

scrollwipe_main	clr.l	lv3_vblank

		RESET_SPRITES	cop_spr

		bsr	setupall
		move.l	#fader_setpalette,lv3_vblank
		move.l	#cop_main,$dff080
		move.w	d0,$dff088

		bsr	wipe
		nop
.exit		bsr	finish
		rts

finish		rts

setupall	;move.l	#cop_palette,fader_copper
		;move.l	#yorykopal,fader_original
		;move.l	#yorykopal,fader_target
		;move.w	#1,fader_steps
		;move.w	#255,fader_colors

		move.l	#cop_palette,fader_copper
		move.l	#whitepal,fader_original
		move.l	#yorykopal,fader_target
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade

		jsr	fader_makecopper
		jsr	fader_initcrossfade
		;jsr	fader_setpalette

		bsr	setup_sinus
		rts

setup_sinus	moveq.l	#1,d1
		moveq.l	#0,d0	; a = d0 = sin(0)
		swap	d1

		moveq.l	#0,d7
.loop1		move.l	d0,-(sp)

		move.l	#105414357,d4	; d = d4 = pi/128
.inner1		move.l	d1,d2
		muls.l	d4,d3:d2
		sub.l	d3,d0
		exg.l	d0,d1
		neg.l	d4
		blt.b	.inner1
		addq.b	#1,d7
		bne.b	.loop1
		move.l	d0,-(sp)

		lea	yoryko_sinus,a2
		moveq.l	#0,d7
.loop2		moveq.l	#15,d2
		move.l	(sp)+,d0
		move.l	(sp),d1
		asl.l	d2,d0
		asl.l	d2,d1
		sub.l	d0,d1
		asr.l	#6,d1

		moveq.l	#15,d5
		moveq.l	#63,d4
.inner2		move.l	d0,d2
		asr.l	d5,d2
		add.l	d1,d0
		move.l	d2,(a2)+
		dbra	d4,.inner2
		addq.b	#1,d7
		bne.b	.loop2
		addq.l	#4,sp
		rts

greypal
a		set	0
		rept	256
		dc.b	0,a,a,a
a		set	a+1
		endr


		section	data_c,data_c

		cnop	0,16
cop_main	dc.w	$1fc,$000f

		dc.w	$8e,$3081
		dc.w	$90,$20c1
		dc.w	$92,4*10
		dc.w	$94,4*48

		dc.w	$100,$8215
		dc.w	$102,$0000
		dc.w	$104,$0000
		dc.w	$108,88
		dc.w	$10a,88
		
		dc.w	$1007,$fffe
cop_palette	ds.b	2112

		dc.w	$106,$0020

cop_bpls	dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

sprite	set	$120
cop_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

cop_scroll
y		set	$2f
		rept	240
		dc.b	y,$df,$ff,$fe
		dc.w	$102,0
y		set	(y+1)&$ff
		endr

		dc.w	$3807,$fffe
		dc.w	$9c,$8010	; set copper
		dc.l	-2,-2

		cnop	0,16
spr_off		ds.l	8


;------------------------------------------------------------

		section	code,code

wipe		wrast	255

		lea	yoriko_planes,a0
		lea	yorykobpl,a1
		move.w	#(480*8)-1,d7
.yloop	
		clr.l	(a0)+
		rept	20
		move.l	(a1)+,(a0)+
		endr
		clr.l	(a0)+
		dbra	d7,.yloop

		bsr	wipe_setup

		bsr	wipe_redraw

.pera		wrast	255
		lea	cop_bpls,a0
		move.l	#yoriko_planes,d0
		btst	#7,$dff004
		beq.b	.nointl
		add.l	#88,d0
.nointl		moveq.l	#7,d7
.loop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	#88*480,d0
		dbra	d7,.loop
		tst.l	salir
		bne	.exit
		cmp.w	#27,p61_pos
		blt.b	.pera
		cmp.w	#40,p61_crow
		blt.b	.pera

		move.l	#yorykopal,fader_original
		move.l	#blackpal,fader_target
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade



.wait		wrast	255

		lea	cop_bpls,a0
		move.l	#yoriko_planes,d0
		btst	#7,$dff004
		beq.b	.nointl2
		add.l	#88,d0
.nointl2	moveq.l	#7,d7
.loop2		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	#88*480,d0
		dbra	d7,.loop2

		bsr	wipe_redraw

		move.l	wipe_force2(pc),d0
		add.l	d0,wipe_force

		;btst	#6,$bfe001
		;bne	.wait
		
		tst.l	salir
		bne	.exit
		cmp.w	#28,p61_pos
		blt.b	.wait
.exit
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

wipe_setup
		lea	wipe_scrtab,a0
		move.w	#255,d7
.loop		move.w	d7,d6
		sub.w	#64,d6
		move.w	#%00000011,d0
		move.w	#%00111100,d1
		move.w	#%11000000,d2
		and.w	d6,d0
		and.w	d6,d1
		and.w	d6,d2

		ror.b	#2,d0
		rol.w	#2,d0
		rol.w	#4,d2
		or.w	d2,d0
		ror.b	#2,d1
		or.w	d1,d0

		move.w	d0,d1
		lsl.w	#4,d1
		or.w	d1,d0
		move.w	d0,(a0,d7.w*2)
		dbra	d7,.loop
		rts

wipe_force	dc.l	0
wipe_force2	dc.l	1
wipe_random	dc.b	'network '
wipe_scrtab	ds.w	256

		cnop	0,16
wipe_redraw	lea	cop_scroll+6,a0
		lea	wipe_scrtab,a1

		movem.l	wipe_random(pc),d0/d1
		move.l	wipe_force(pc),d4

		move.w	#$ff,d5
		moveq.l	#15,d6

		muls.w	d4,d4
		asr.l	#8,d4

		move.w	#239,d7
.loop		move.w	d4,d2
		muls.w	d0,d2
		asr.l	d6,d2
		and.w	d5,d2
		move.w	(a1,d2.w*2),(a0)

		rol.l	d1,d0
		roxr.w	#3,d1
		eor.l	d1,d0
		swap	d0
		add.l	d0,d1
		roxl.l	#2,d0

		addq.l	#8,a0

		dbra	d7,.loop
		movem.l	d0/d1,wipe_random
		rts

yorykopal	incbin	'gfx/pal.yoryko'
;yorykobpl	dc.l	0	;incbin	'gfx/bpl.yoryko'
