	opt	p=68030

	section	code,code

	;jsr	setupall
	;jsr	wipe_setup
	;jmp	wipe_redraw

	include	'macros/macros.gs'
	include	'lvo.asm'
	include	'exec/execbase.i'

	section	code,code

InitSys	bsr	OSout		; Quitamos el control al Amiga OS
	bsr	Main		; Nuestro PROGRAMA !!!
	bsr	OSin		; Devolvemos el control al Amiga OS
	rts			; ADIOS !!!

OSout	movea.l	4.w,a6		; System Base
	lea	GfxLib,a1
	moveq	#0,d0
	jsr	-552(a6)		; OpenLibrary
	move.l	d0,GfxBase		; Save Graphics_lib base
	move.l	d0,a6
	move.l	38(a6),OldCopper	; gb_CopInit	Sys Copper
	move.l	34(a6),OldView		; gb_ActiView	Sys View
	jsr	-456(a6)		; Own Blitter
	lea	0.w,a1		;LoadView Null
	jsr	-222(a6)		;LoadView

	move.w	#(10*1)-1,d7
.loop	jsr	-270(a6)		; lots of WaitTOF
	dbra	d7,.loop

	movea.l	4.w,a6		; System Base
	jsr	-132(a6)		; Forbid
	jsr	-150(a6)		; SuperState
	move.l	d0,SysStack		; System stack
	btst.b	#0,$129(a6)		; are we at least 68010? ($129=AttnFlags+1)
	beq.b	.68000		; nope.
	dc.w	$4e7a,$0801		;=movec.l vbr,d0 ; pero MDevPac no lo acepta
	move.l	d0,VectorBase		; Get Real VBR

.68000
	move.l	SysStack,d0		; Systemstack
	jsr	-156(a6)		; UserState

	move	$dff01c,IntEnaR		; Initialize custom chips
	move	$dff01e,IntReqR		; Save old valours first
	move	$dff002,DmaConR
	move	$dff010,AdkConR
	move	#%0111111111111111,$dff09a	; INTENA
	move	#%1100000001010000,$dff09a	* Enable desired IRQs
.Spr	move.l	$dff004,D0		; Wait RASTER to
	and.l	#$0001FF00,D0		; disable SPRITES
	bne.b	.Spr
	move	#%0111111111111111,$dff096	; DMACONW
	move	#%1000001111000000,$dff096	* Enable desired DMAs

	move	$dff07c,d0		;Ponerlo en/antes/despues de Copper?
	cmp.b	#$f8,d0
	bne.b	.NotAGA		; Not AGA
	move	#0,$dff1fc		* Fix AGA Res     (Ponerlo en Copper?)

.NotAGA	move.l	VectorBase,a0
	move.l	$6c(a0),Int3Save	; Save level 3 vector
	move.l	#level3,$6c(a0)		; Set OUR! own interrupt
	rts

OSin	move.l	VectorBase,a0
	move.l	Int3Save,$6c(a0)	; Reset Interrupts

	move	IntEnaR,d7		; Reset custom chips
	bset	#$f,d7
	move	d7,$dff09a		; Reset Interrupts

	move	IntReqR,d7
	bset	#$f,d7
	move	d7,$dff09c		; Reset interrupt request

	move	DmaConR,d7
	bset	#$f,d7
	move	d7,$dff096		; Reset DMAConw

	move	AdkConR,d7
	bset	#$f,d7
	move	d7,$dff09e		; Reset ADK

	move.l	GfxBase,a6
	movea.l	OldView,a1
	jsr	-222(a6)		; LoadView
	move.l	OldCopper,$dff080	; Reset System Copper
	jsr	-462(a6)		; DisOwn Blitter

	movea.l	4.w,a6		; System Base
	move.l	GfxBase,a1		; Close Graphics_lib
	jsr	-414(a6)		; CloseLibrary
	jsr	-138(a6)		; Permit

	moveq.l	#0,d0
	rts

GfxLib	dc.b	"graphics.library",0,0
GfxBase	dc.l	0
IntEnaR	dc.w	0
IntReqR	dc.w	0
DmaConR	dc.w	0
AdkConR	dc.w	0
SysStack	dc.l	0
Int3Save	dc.l	0
OldCopper	dc.l	0
OldView	dc.l	0
VectorBase	dc.l	0

***************** INTERRUPCION

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	lv3_blit,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)

.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		rte

.noblit		btst	#4,d0
		beq.b	.nocopper

		jsr	fader_setpalette

		move.l	lv3_vblank,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)

.no1		btst	#6,$bfe001
		bne.b	.no2
		st	goout

.no2		moveq.l	#0,d0
		lea	$dff000,a6


		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		rte

lv3_vblank	dc.l	0
lv3_blit	dc.l	0

goout	dc.l	0

sync	macro
	cmp.w	#\1,P61_Pos
	bge.b	.nosync\@
	jsr	\2
	tst	goout
	bne.b	.exit
.nosync\@
	endm

Main		bsr	setupall
		move.l	#cop_main,$dff080
		move.w	d0,$dff088
		bsr	wipe
		nop
.exit		bsr	finish
		rts

finish		rts

setupall	move.l	#cop_palette,fader_copper
		move.l	#blackpal,fader_original
		move.l	#blackpal,fader_target
		move.w	#0,fader_steps
		move.w	#255,fader_colors

		jsr	fader_makecopper
		jsr	fader_initcrossfade
		jsr	fader_setpalette

		bsr	setup_sinus
		rts

setup_sinus	moveq.l	#1,d1
		moveq.l	#0,d0	; a = d0 = sin(0)
		swap	d1

		moveq.l	#0,d7
.loop1		move.l	d0,-(sp)

		move.l	#105414357,d4	; d = d4 = pi/128
.inner1		move.l	d1,d2
		muls.l	d4,d3:d2
		sub.l	d3,d0
		exg.l	d0,d1
		neg.l	d4
		blt.b	.inner1
		addq.b	#1,d7
		bne.b	.loop1
		move.l	d0,-(sp)

		lea	sinus,a2
		moveq.l	#0,d7
.loop2		moveq.l	#15,d2
		move.l	(sp)+,d0
		move.l	(sp),d1
		asl.l	d2,d0
		asl.l	d2,d1
		sub.l	d0,d1
		asr.l	#6,d1

		moveq.l	#15,d5
		moveq.l	#63,d4
.inner2		move.l	d0,d2
		asr.l	d5,d2
		add.l	d1,d0
		move.l	d2,(a2)+
		dbra	d4,.inner2
		addq.b	#1,d7
		bne.b	.loop2
		addq.l	#4,sp
		rts

whitepal	dcb.l	256,$ffffff
blackpal	dcb.l	256,$000000

greypal
a		set	0
		rept	256
		dc.b	0,a,a,a
a		set	a+1
		endr

	include	'fader.asm'

		section	data_c,data_c

		cnop	0,16
cop_main	dc.w	$1fc,$000f

		dc.w	$8e,$3081
		dc.w	$90,$20c1
		dc.w	$92,4*10
		dc.w	$94,4*48

		dc.w	$100,$8215
		dc.w	$102,$0000
		dc.w	$104,$0000
		dc.w	$108,88
		dc.w	$10a,88
		
		dc.w	$1007,$fffe
cop_palette	ds.b	fader_palsize

		dc.w	$106,$0020

cop_bpls	dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

cop_scroll
y		set	$2f
		rept	240
		dc.b	y,$df,$ff,$fe
		dc.w	$102,0
y		set	(y+1)&$ff
		endr

		dc.w	$3807,$fffe
		dc.w	$9c,$8010	; set copper
		dc.l	-2,-2

		section	bss_c,bss_c
		cnop	0,16

planes1		ds.b	(8*88*480)

		cnop	0,16
Buffer0		ds.b	(1024*512)

		section	bss,bss
		cnop	0,16
chunky		ds.b	320*256
sinus		ds.b	64*1024
Buffer1		ds.b	(1024*1024*2)

;------------------------------------------------------------

		section	code,code
wipe		wrast	255
		move.l	#yorykopal,fader_original
		move.l	#blackpal,fader_target
		move.w	#6,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade

		lea	planes1,a0
		lea	yorykobpl,a1
		move.w	#(480*8)-1,d7
.yloop	
		clr.l	(a0)+
		rept	20
		move.l	(a1)+,(a0)+
		endr
		clr.l	(a0)+
		dbra	d7,.yloop


		bsr	wipe_setup

.wait		wrast	255

		lea	cop_bpls,a0
		move.l	#planes1,d0
		btst	#7,$dff004
		beq.b	.nointl
		add.l	#88,d0
.nointl		moveq.l	#7,d7
.loop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	#88*480,d0
		dbra	d7,.loop

		bsr	wipe_redraw

		move.l	wipe_force2(pc),d0
		add.l	d0,wipe_force

		btst	#6,$bfe001
		bne	.wait
		rts

wipe_setup	lea	wipe_scrtab,a0
		move.w	#255,d7
.loop		move.w	d7,d6
		sub.w	#64,d6
		move.w	#%00000011,d0
		move.w	#%00111100,d1
		move.w	#%11000000,d2
		and.w	d6,d0
		and.w	d6,d1
		and.w	d6,d2

		ror.b	#2,d0
		rol.w	#2,d0
		rol.w	#4,d2
		or.w	d2,d0
		ror.b	#2,d1
		or.w	d1,d0

		move.w	d0,d1
		lsl.w	#4,d1
		or.w	d1,d0
		move.w	d0,(a0,d7.w*2)
		dbra	d7,.loop
		rts

wipe_force	dc.l	0
wipe_force2	dc.l	1
wipe_random	dc.b	'network '
wipe_scrtab	ds.w	256

		cnop	0,16
wipe_redraw	lea	cop_scroll+6,a0
		lea	wipe_scrtab,a1

		movem.l	wipe_random(pc),d0/d1
		move.l	wipe_force(pc),d4

		move.w	#$ff,d5
		moveq.l	#15,d6

		muls.w	d4,d4
		asr.l	#8,d4

		move.w	#239,d7
.loop		move.w	d4,d2
		muls.w	d0,d2
		asr.l	d6,d2
		and.w	d5,d2
		move.w	(a1,d2.w*2),(a0)

		rol.l	d1,d0
		roxr.w	#3,d1
		eor.l	d1,d0
		swap	d0
		add.l	d0,d1
		roxl.l	#2,d0

		addq.l	#8,a0

		dbra	d7,.loop
		movem.l	d0/d1,wipe_random
		rts

yorykopal	incbin	'gfx/pal.yoryko'
yorykobpl	incbin	'gfx/bpl.yoryko'