		;machine	68030
	
		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	bump_chunky1
		XREF	bump_chunky2
		XREF	bump_offsets

		XREF	lv3_vblank
		XREF	lv3_blit
		XREF	lv3_copper

		XREF	P61_Pos
		XREF	P61_CRow

		XREF	salir
		XREF	sinus

		XREF	scrollbump_phongmap
		
		XREF	scrollbump_bumpmap

		XDEF	bump_main

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_makecopper
		XREF	fader_initcrossfade
		XREF	fader_setpalette

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC	WASIMACROS

		incdir	'scrollbump'

		section	scrollbump,code

wrast		macro
.wr1\@		cmp.b	#\1,$dff006
		bne.b	.wr1\@
.wr2\@		cmp.b	#\1,$dff006
		beq.b	.wr2\@
		endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
		lea	\1,a0
		moveq.l	#7,d0
		move.w	#$0120,d1
		move.l	#spr_off,d2
.spr_count\@
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		dbf	d0,.spr_count\@
		ENDM

bump_main
		RESET_SPRITES	c_bump_spr

		lea	(planes1+8*40*100).l,a0
		lea	(planes2+8*40*100).l,a1
		move.l	#((8*40*100)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		endr
		dbf	d0,.chiploop2

		lea	c_bump_bpls,a0
		move.l	#planes1,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*256,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		move.l	#c_bump_pal,fader_copper
		move.l	#bump_palette,fader_original
		move.l	#bump_palette,fader_target
		move.w	#255,fader_colors
		move.w	#1,fader_steps
		jsr	fader_makecopper
		jsr	fader_initcrossfade

		move.l	#c_bump,$dff080

		jsr	bump_make1
		clr.w	bump_counter
		move.l	#bump_lv3,lv3_vblank

.loop1		jsr	c2p_cpu
		jsr	bump_redraw

		tst.l	salir
		bne	.salscrollbump

		cmp.w	#26,P61_Pos
		bne.b	.no
		cmp.w	#56,P61_CRow
		blt.b	.no
		tst	.hola
		bne.b	.no
		st	.hola

		move.l	#bump_palette,fader_original
		move.l	#bump_blackpal,fader_target
		move.w	#5,fader_steps
		move.w	#$4000,$dff09a
		jsr	fader_initcrossfade
		move.w	#$c000,$dff09a
		st	bump_fortabaco

.no		cmp.w	#27,P61_Pos
		bne	.loop1

.salscrollbump	bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts
.hola		dc.w	0

		dc.b	'mijac se esta copiando el quake de alguien :)))',0
		cnop	0,16

wid	set	320
hei	set	72

bump_lv3	move.w	bump_xmpos(pc),d0
		add.w	bump_xmspd(pc),d0
		cmp.w	#2528-16,d0
		blt.b	.ok1
		move.w	#0,bump_xmspd
.ok1		move.w	d0,bump_xmpos

		add.l	#$5555,bump_xlpos1
		add.l	#$7777,bump_ylpos1
		addq.w	#1,bump_counter

		tst	bump_fortabaco
		beq.b	.no
		addq.l	#1,bump_tabaco

.no		jsr	fader_setpalette
		rts

		cnop	0,16
bump_palette	incbin	'pal.phongmap'
bump_blackpal	dcb.l	256,0

bump_counter	dc.w	0
bump_xmpos	dc.w	0
bump_xmspd	dc.w	5

bump_xlpos1	dc.l	0
bump_ylpos1	dc.l	0

bump_tabaco	dc.l	0
bump_fortabaco	dc.l	0

bump_redraw	lea	bump_offsets,a0
		move.l	c2p__chunky,a1
		lea	scrollbump_phongmap,a2

		move.w	#$3fff,d7
		lea	sinus,a6
		move.l	bump_xlpos1(pc),d0
		move.l	bump_ylpos1(pc),d1
		lsr.l	#8,d0
		lsr.l	#8,d1
		and.w	d7,d0
		and.w	d7,d1
		move.l	(a6,d0.w*4),d0
		move.l	(a6,d1.w*4),d1
		muls.l	#140,d0
		muls.l	#32,d1
		swap	d0
		swap	d1
		add.w	#96,d0

		asr.w	#1,d0
		subx.l	d6,d6
		asr.w	#1,d1
		subx.l	d7,d7

		lsl.w	#8,d1		
		move.b	d0,d1
		and.l	#$ffff,d1
		lea	(a2,d1.w),a2
		add.l	#256*78,a2
		add.l	bump_tabaco(pc),a2

		moveq.l	#0,d0
		move.w	bump_xmpos(pc),d0
		lea	(a0,d0.l*2),a0

		move.l	#(2528-320)*2,d3
		move.l	#256-160,d4
		move.l	#-160,d5

		tst.w	d7
		beq.b	.noexg
		exg	d4,d5
.noexg		tst.w	d6
		bne	.odd

.even		move.w	#hei-1,d7
.yloop1		exg.l	d4,d5
		move.w	#(320/32)-1,d6
.xloop1
		rept	8
		move.w	(a0)+,d0
		move.w	0(a2,d0.w),d1
		move.w	(a0)+,d0
		move.b	0(a2,d0.w),d1
		swap	d1
		move.w	(a0)+,d0
		move.w	1(a2,d0.w),d1
		move.w	(a0)+,d0
		move.b	1(a2,d0.w),d1
		move.l	d1,(a1)+
		addq.l	#2,a2
		endr
		dbra	d6,.xloop1
		add.l	d3,a0
		add.l	d4,a2
		dbra	d7,.yloop1
		rts

.odd		move.w	#hei-1,d7
.yloop2		exg.l	d4,d5
		move.w	#(320/32)-1,d6
.xloop2
		rept	8
		move.w	(a0)+,d0
		move.w	0(a2,d0.w),d1
		move.w	(a0)+,d0
		move.b	1(a2,d0.w),d1
		swap	d1
		move.w	(a0)+,d0
		move.w	1(a2,d0.w),d1
		move.w	(a0)+,d0
		move.b	2(a2,d0.w),d1
		move.l	d1,(a1)+
		addq.l	#2,a2
		endr
		dbra	d6,.xloop2
		add.l	d3,a0
		add.l	d4,a2
		dbra	d7,.yloop2
		rts


bump_make1	lea	scrollbump_bumpmap,a0
		lea	bump_offsets,a1

		moveq.l	#-12,d5
		move.w	#71,d7
.yloop		tst.w	d5
		bgt.b	.ok1

		move.w	#2527,d6
.loop1		clr.w	(a1)+
		dbra	d6,.loop1
		bra.b	.ok2

.ok1		move.w	#2527,d6
.xloop
		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3

		move.b	-1(a0),d0
		move.b	1(a0),d1
		sub.w	d1,d0

		move.b	-2528(a0),d2
		move.b	2528(a0),d3
		sub.w	d3,d2

		asr.w	#2,d0
		asr.w	#2,d2

		lsl.l	#8,d2
		move.b	d0,d2
		move.w	d2,(a1)+

		addq.l	#1,a0
		dbra	d6,.xloop
.ok2		addq.l	#1,d5
		dbra	d7,.yloop
		rts

		cnop	0,16
;scrollbump_phongmap	dc.l	0	;incbin	'chk.phongmap'
;
;		cnop	0,16
;		;dcb.b	4096,0
;scrollbump_bumpmap		dc.l	0	;incbin	'chk.bumpmap'
;		;dcb.b	4096,0

plsize	set	wid*hei/8
plsiz2	set	plsize*2

c2p_wait	BWAIT
		tst.b	c2p_proceed
		bne.b	c2p_wait
		rts

c2p_cpu		move.l	c2p__chunky(pc),a6
		move.l	c2p_pixels(pc),a5
		add.l	a6,a5

		move.l	c2p__bltbuf_(pc),a4
		lea	plsiz2(a4),a3
		lea	plsiz2(a3),a2
		lea	plsiz2(a2),a1

		move.l	a7,c2p_stack

		move.l	-(a3),a7
		move.l	-(a2),a0
		move.l	-(a1),d7

		move.l	#$0f0f0f0f,d4
		move.l	#$00ff00ff,d5
		move.l	#$55555555,d6

		bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	bump_chunky1
c2p__chunky_	dc.l	bump_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge		macro
		move.l	\2,\3
		lsr.l	#\5,\3
		eor.l	\1,\3
		and.l	\4,\3
		eor.l	\3,\1
		ifnc	'','\6'
		move.l	\1,\6
		endc
		lsl.l	#\5,\3
		eor.l	\3,\2
		endm

word		macro
		move.l	\1,\3
		swap	\2
		move.w	\2,\1
		move.w	\3,\2
		swap	\2
		endm

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

		cmp.l	a5,a6
		bcs	c2p_loop

		move.l	d7,(a1)+
		move.l	a0,(a2)+
		move.l	a7,(a3)+

		move.l	c2p_stack,a7

		bsr	c2p_wait
		st	c2p_proceed

		bsr	c2p_dbuff

		lea	$dff000,a6

		moveq.l	#-1,d0
		moveq.l	#2,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	d0,$44(a6)
		move.w	#$cccc,$70(a6)

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1

		add.l	#(4*wid*hei/8)-2,a1

		move.l	a0,$50(a6)		; orig 1
		subq.l	#2,a0
		move.l	a0,$4c(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.l	#$eDE40000,$40(a6)

		move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
		move.w	#1,$5e(a6)			; size_h

		move.l	#c2p_blit2,lv3_blit
		rts


c2p_blit2	lea	$dff000,a6
		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1

		move.l	a0,$50(a6)		; orig 1
		addq.l	#2,a0
		move.l	a0,$4C(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.l	#$0DE42000,$40(a6)

		move.w	#4*wid*hei/16,$5c(a6)	; size_v
		move.w	#1,$5e(a6)		; size_h

		move.l	#c2p_blit3,lv3_blit
		rts

c2p_blit3	clr.l	c2p_proceed
		clr.l	lv3_blit
		rts

c2p_dbuff	lea	c2p__chunky(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		lea	c2p__bltbuf(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		lea	c2p__planes(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		wrast	255

		lea	c_bump_bpls,a0
		move.l	c2p__planes_,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#wid*hei/8,d0
		addq.l	#8,a0
		dbra	d7,.sloop
		rts

;		section	scrollbump,data
;		cnop	0,16
;phongmap	incbin	'chk.phongmap'
;
;		cnop	0,16
;		dcb.b	4096,0
;bumpmap		incbin	'chk.bumpmap'
;		dcb.b	4096,0


		section	data_c,data_c

		cnop	0,64
c_bump		dc.w	$1fc,$0007
		dc.w	$100,$0201

sprite	set	$120
c_bump_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

c_bump_bpls	dc.w	$ec,0,$ee,0
		dc.w	$e8,0,$ea,0
		dc.w	$fc,0,$fe,0
		dc.w	$f8,0,$fa,0

		dc.w	$e4,0,$e6,0
		dc.w	$e0,0,$e2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f0,0,$f2,0

		dc.w	$08e,$2881
		dc.w	$090,$28C1

		dc.w	$092,4*14
		dc.w	$094,4*44

		dc.w	$100,$0201|$0000
		dc.w	$102,$0000
		dc.w	$104,$0200
		dc.w	$106,$0020

		dc.w	$108,0
		dc.w	$10a,0

		dc.b	$94-(hei/2),$07,$ff,$fe
		dc.w	$100,$0201|$0010
		dc.b	$94+(hei/2),$07,$ff,$fe
		dc.w	$100,$0201|$0000

		dc.w	$ffdf,$fffe
c_bump_pal	ds.b	2112

		dc.l	-2,-2

		cnop	0,16
spr_off		ds.l	8
