		;machine	68030
		
		opt 	debug,l+,c-,p=68030

		XREF	prot_chunky1
		XREF	prot_chunky2
		XREF	prot_tabpos

		XREF	prot_texturemap

		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal
		XREF	blackpal

		XREF	sinus

		XREF	salir

		XREF	cpu060

		XDEF	prot_main
	

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		include	include:hardware/custom.i

		incdir	include:
		include	exec/exec_lib.i

		incdir	'rotozoom_perspective'



		section	prot,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

wid		set	160
hei		set	192

prot_main

		RESET_SPRITES	c_prot_spr

		move.l	#blackpal,fader_original
		move.l	#prot_pal,fader_target
		move.l	#c_prot_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade


		bsr	prot_setup

		move.l	#c_prot,$dff080
		move.l	#prot_move,lv3_vblank

.loop1		bsr	prot_redraw
		jsr	c2p_cpu

		tst.l	salir
		bne	.salprot
		cmp.w	#37,p61_pos
		blt	.loop1

.salprot
		bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


prot_setup	move.l	#prot_keyframes,splines_keydata
		move.w	#50*0,splines_frame
		rts

prot_redraw	bsr	prot_setvars
		bsr	prot_mkvec
		tst.w	cpu060
		beq	.no060
		bsr	prot_calc060
		bra	prot_draw

.no060
		bsr	prot_calc
		bra	prot_draw

prot_xpos	dc.l	$10000*000
prot_ypos	dc.l	$10000*008
prot_zpos	dc.l	$10000*000

prot_xlook	dc.l	$10000*000
prot_ylook	dc.l	$10000*001
prot_zlook	dc.l	$10000*000

prot_xpos0	dc.l	0
prot_ypos0	dc.l	0
prot_zpos0	dc.l	0

prot_vectors	dc.l	$00000,$00000,$00000
prot_vectors2	dc.l	$00000,$00000,$00000
		dc.l	$00000,$00000,$00000

prot_xvec	dc.l	$00000,$00000,$00000
prot_yvec	dc.l	$00000,$00000,$00000
prot_zvec

xps0	set	88
yps0	set	-80
zps0	set	72


prot_move	jsr	swap_screens
		jsr	fader_setpalette

		addq.w	#1,splines_frame
		rts

prot_setvars	bsr	calcspline
		lea	splines_actdata,a0
		lea	prot_xpos,a1
		rept	6
		move.l	(a0)+,(a1)+
		endr
		rts

mkspl		macro
		dc.w	\1*50
		dc.w	\2*$100,\3*$100,\4*$100
		dc.w	\5*$100,\6*$100,\7*$100
		endm

prot_keyframes	dc.w	34*50,6			; 30 secs (4 secs of security space), 6 channels
		mkspl	00,000,030,010,000,000,000
		mkspl	00,000,030,010,000,000,000
		mkspl	00,000,030,010,000,000,000

		mkspl	01,010,050,-010,000,000,000
		mkspl	02,-010,070,-010,000,000,000
		mkspl	03,-010,050,010,000,000,000
		mkspl	04,010,030,010,000,000,000
		mkspl	05,010,050,-010,000,000,000
		mkspl	06,-010,070,-010,000,000,000
		mkspl	07,-010,050,010,000,000,000
		mkspl	08,010,030,010,000,000,000
		mkspl	09,010,060,-010,000,000,000
		mkspl	10,-010,090,-010,000,000,000

		mkspl	11,-020,002,020,000,001,000
		mkspl	12,030,001,040,000,001,000
		mkspl	13,060,001,080,000,001,000
		mkspl	14,040,040,050,000,001,000
		mkspl	15,020,080,020,000,001,-020
		mkspl	16,000,040,000,020,001,-040
		mkspl	17,000,020,-030,010,001,-060
		mkspl	18,000,010,-060,020,001,-040
		mkspl	19,000,005,-090,020,001,-020

		mkspl	20,-005,005,-090,010,001,-000
		mkspl	21,-010,025,-040,000,001,-005
		mkspl	22,-020,040,-010,-10,001,-010
		mkspl	23,-030,080,-020,-30,001,-030
		mkspl	24,-040,070,-030,-50,001,-060
		mkspl	25,-050,050,-040,-70,001,-025

		mkspl	26,-050,050,-040,-70,001,025
		mkspl	27,-050,050,-040,-70,001,050
		mkspl	28,-050,050,-040,-70,001,075


		mkspl	34,030,010,-090,040,001,-040
		mkspl	36,030,010,-060,040,001,-060
		mkspl	38,030,010,-060,040,001,-060

vecx		set	-256			;128,221,256
vecy		set	(-vecx*hei)/(2*wid)	; 97,181,192
vecz		set	256

prot_mkvec
	bsr	MakeCamera

	lea	prot_vectors(pc),a6
	lea	prot_zvec(pc),a5
	moveq.l	#0,d7

	move.w	#0+vecx,d2
	move.w	#0-vecy,d3
	move.w	#0+vecz,d4
	bsr.b	.rotvector
	move.l	d0,(a6)+
	move.l	d1,(a6)+
	move.l	d2,(a6)+

	move.w	#0-vecx,d2
	move.w	#0-vecy,d3
	move.w	#0+vecz,d4
	bsr.b	.rotvector
	move.l	d0,(a6)+
	move.l	d1,(a6)+
	move.l	d2,(a6)+

	move.w	#0-vecx,d2
	move.w	#0+vecy,d3
	move.w	#0+vecz,d4
	bsr.b	.rotvector

	move.l	#hei,d6
	move.l	-(a6),a2
	sub.l	a2,d2
	divs.l	d6,d2
	move.l	d2,-(a5)

	move.l	-(a6),a1
	sub.l	a1,d1
	divs.l	d6,d1
	move.l	d1,-(a5)

	move.l	-(a6),a0
	sub.l	a0,d0
	divs.l	d6,d0
	move.l	d0,-(a5)

	move.l	-(a6),d2
	sub.l	a2,d2
	move.l	d2,-(a5)

	move.l	-(a6),d1
	sub.l	a1,d1
	move.l	d1,-(a5)

	move.l	-(a6),d0
	sub.l	a0,d0
	move.l	d0,-(a5)
	rts

.rotvector
	move.w	d2,d0
	move.w	d3,d5
	move.w	d4,d6

	muls.w	cam_m1(pc),d0
	muls.w	cam_m2(pc),d5
	muls.w	cam_m3(pc),d6
	add.l	d5,d0
	add.l	d6,d0
	asr.l	#4,d0

	move.w	d2,d1
	move.w	d3,d5
	move.w	d4,d6

	muls.w	cam_m4(pc),d1
	muls.w	cam_m5(pc),d5
	muls.w	cam_m6(pc),d6
	add.l	d5,d1
	add.l	d6,d1
	asr.l	#4,d1

	muls.w	cam_m7(pc),d2
	muls.w	cam_m8(pc),d3
	muls.w	cam_m9(pc),d4
	add.l	d3,d2
	add.l	d4,d2
	asr.l	#4,d2
	rts

prot_calc060	lea	prot_tabpos,a6

		move.l	prot_xpos(pc),a0
		move.l	prot_ypos(pc),a1
		move.l	prot_zpos(pc),a2

		movem.l	prot_vectors2(pc),d0-d2
		lea	prot_xvec(pc),a3
		lea	prot_yvec(pc),a4

		move.w	#hei-1,d7
.hloop	
		moveq.l	#0,d4		; left edge
		move.l	a1,d3
		;muls.l	d0,d4:d3
		;divs.l	d1,d4:d3
		fmove.l	d0,fp0
		fmove.l	d1,fp1
		fmove.l	d3,fp3
		fmul	fp0,fp3
		fdiv	fp1,fp3
		fmove.l	fp3,d3
		neg.l	d3
		add.l	a0,d3
		move.l	d3,(a6)+	; store xpos

		moveq.l	#0,d4
		move.l	a1,d3
		;muls.l	d2,d4:d3
		;divs.l	d1,d4:d3

		fmove.l	d2,fp0
		fmove.l	d1,fp1
		fmove.l	d3,fp3
		fmul	fp0,fp3
		fdiv	fp1,fp3
		fmove.l	fp3,d3
		neg.l	d3
		add.l	a2,d3
		move.l	d3,(a6)+	; store zpos

		add.l	(a3)+,d0
		add.l	(a3)+,d1
		add.l	(a3)+,d2

		moveq.l	#0,d4		; right edge
		move.l	a1,d3
		;muls.l	d0,d4:d3
		;divs.l	d1,d4:d3
		fmove.l	d0,fp0
		fmove.l	d1,fp1
		fmove.l	d3,fp3
		fmul	fp0,fp3
		fdiv	fp1,fp3
		fmove.l	fp3,d3
		neg.l	d3
		add.l	a0,d3
		move.l	d3,(a6)+	; store xpos

		moveq.l	#0,d4
		move.l	a1,d3
		;muls.l	d2,d4:d3
		;divs.l	d1,d4:d3
		fmove.l	d2,fp0
		fmove.l	d1,fp1
		fmove.l	d3,fp3
		fmul	fp0,fp3
		fdiv	fp1,fp3
		fmove.l	fp3,d3
		neg.l	d3
		add.l	a2,d3
		move.l	d3,(a6)+	; store zpos

		sub.l	-(a3),d2
		sub.l	-(a3),d1
		sub.l	-(a3),d0

		add.l	(a4)+,d0
		add.l	(a4)+,d1
		add.l	(a4)+,d2
		lea	-12(a4),a4

		cmp.l	#-$800,d1
		bge.b	.exit
		dbra	d7,.hloop
.exit		neg	d7
		add.w	#hei,d7
		move.w	d7,prot_drawhei
		rts

prot_drawhei	dc.w	0


prot_calc	lea	prot_tabpos,a6

		move.l	prot_xpos(pc),a0
		move.l	prot_ypos(pc),a1
		move.l	prot_zpos(pc),a2

		movem.l	prot_vectors2(pc),d0-d2
		lea	prot_xvec(pc),a3
		lea	prot_yvec(pc),a4

		move.w	#hei-1,d7
.hloop	
		moveq.l	#0,d4		; left edge
		move.l	a1,d3
		muls.l	d0,d4:d3
		divs.l	d1,d4:d3
		neg.l	d3
		add.l	a0,d3
		move.l	d3,(a6)+	; store xpos

		moveq.l	#0,d4
		move.l	a1,d3
		muls.l	d2,d4:d3
		divs.l	d1,d4:d3
		neg.l	d3
		add.l	a2,d3
		move.l	d3,(a6)+	; store zpos;

		add.l	(a3)+,d0
		add.l	(a3)+,d1
		add.l	(a3)+,d2

		moveq.l	#0,d4		; right edge
		move.l	a1,d3
		muls.l	d0,d4:d3
		divs.l	d1,d4:d3
		neg.l	d3
		add.l	a0,d3
		move.l	d3,(a6)+	; store xpos

		moveq.l	#0,d4
		move.l	a1,d3
		muls.l	d2,d4:d3
		divs.l	d1,d4:d3
		neg.l	d3
		add.l	a2,d3
		move.l	d3,(a6)+	; store zpos

		sub.l	-(a3),d2
		sub.l	-(a3),d1
		sub.l	-(a3),d0

		add.l	(a4)+,d0
		add.l	(a4)+,d1
		add.l	(a4)+,d2
		lea	-12(a4),a4

		cmp.l	#-$800,d1
		bge.b	.exit
		dbra	d7,.hloop
.exit		neg	d7
		add.w	#hei,d7
		move.w	d7,prot_drawhei
		rts

;prot_drawhei	dc.w	0


prot_draw	lea	prot_tabpos,a6
	lea	prot_texturemap,a1

	move.l	c2p__chunky,a0
	move.l	a0,-(sp)

	moveq.l	#0,d0
	move.w	#(hei*wid/16)-1,d7
.clr
	rept	4
	move.l	d0,(a0)+
	endr
	dbra	d7,.clr

	move.l	(sp)+,a0
	add.l	#wid*(hei-1),a0

	move.w	prot_drawhei(pc),d7
	cmp.w	#hei,d7
	blt.b	.yenter
	move.w	#hei,d7

.yenter	subq.w	#1,d7
	cmp.w	#-1,d7
	beq	.nodraw

.yloop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	asr.l	#2,d0
	asr.l	#2,d1
	asr.l	#2,d2
	asr.l	#2,d3

	sub.l	d0,d2
	sub.l	d1,d3
	divs.l	#wid,d2
	divs.l	#wid,d3

	add.l	#$8000,d0
	add.l	#$8000,d1

	swap	d0
	swap	d1
	swap	d2
	swap	d3

	rol.l	#8,d1
	rol.l	#8,d3

	move.w	d0,d6
	move.w	d1,d0
	move.w	d6,d1

	move.w	d2,d6
	move.w	d3,d2
	move.w	d6,d3

	sub.l	d5,d5
	move.l	d3,d6
	eor.w	d6,d6
	add.l	d3,d1

	move.w	#(wid/8)-1,d6
.xloop
	rept	2
	move.w	d0,d5
	addx.l	d2,d0
	move.b	d1,d5
	addx.l	d3,d1
	move.w	(a1,d5.l),d4
	move.w	d0,d5
	addx.l	d2,d0
	move.b	d1,d5
	addx.l	d3,d1
	move.b	(a1,d5.l),d4
	swap	d4
	move.w	d0,d5
	addx.l	d2,d0
	move.b	d1,d5
	addx.l	d3,d1
	move.w	(a1,d5.l),d4
	move.w	d0,d5
	addx.l	d2,d0
	move.b	d1,d5
	addx.l	d3,d1
	move.b	(a1,d5.l),d4
	move.l	d4,(a0)+
	endr
	dbra	d6,.xloop
	lea	(-2*wid)(a0),a0
	dbra	d7,.yloop
.nodraw	rts

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	prot_chunky1
c2p__chunky_	dc.l	prot_chunky2
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid	set	wid*2
bhei	set	hei
plsize	set	bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_7,lv3_blit
	rts

c2p_blit_7	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#6*plsize,a1

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_8,lv3_blit
	rts

c2p_blit_8	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#7*plsize,a1

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts

c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	;move.w	#$555,$dff180
	wrast	250						; RASTERTIME
	;move.w	#$000,$dff180

	move.l	d0,newplanes
	bsr	swap_screens
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	planes2

swap_screens	move.l	newplanes(pc),d0
		lea	c_prot_bpls,a0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#plsize,d0
		addq.l	#8,a0
		dbra	d7,.sloop
		rts

		include	'camera_wind.asm'
		include	'splines.asm'

		;cnop	0,16
;prot_texturemap	incbin	'chk.txt3'
		;incbin	'chk.txt3'

		cnop	0,16
prot_pal	incbin	txt3.pal

		section	prot,data_c

	cnop	0,64
c_prot	dc.w	$1fc,$0007
	dc.w	$100,$0201

	dc.w	$08e,$0a82|(($100-hei)<<8)
	dc.w	$090,$0aC1

	dc.w	$092,4*14
	dc.w	$094,4*44
	dc.w	$102,$0010

c_prot_pal
	ds.b	2112		;incbin	'pal.txt3'

	dc.w	$100,$0201|$0010
	dc.w	$104,$0200
	dc.w	$106,$0020

	dc.w	$108,0
	dc.w	$10a,0

sprite	set	$120
c_prot_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

c_prot_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$fe8f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
