		;machine	68030
		
		opt debug,l+,c-,p=68030

		XREF	voxel_chunky1
		XREF	voxel_chunky2
		XREF	voxel_drawing
		XREF	voxel_divutab
		XREF	voxel_texheimap

		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal
		XREF	blackpal

		XREF	sinus

		XREF	salir

		XREF	voxel_heightmap
		XREF	voxel_texturemap
		XREF	voxel_shademap

		XDEF	voxel_main
	
		;include	'macros/macros.gs'
		;include	'hardware/custom.i'
		;include	'exec/macros.i'
		;include	'lvo.asm'
		
		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		include	include:hardware/custom.i

		incdir	include:
		;include	exec/memory.i
		include	exec/exec_lib.i

		incdir	'rotovoxel'

		section	rotovoxel,code

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

drawsize	set	204
wid		set	160
hei		set	128

voxel_main
		move.l	#blackpal,fader_original
		move.l	#voxel_pal,fader_target
		move.l	#c_pal,fader_copper
		move.w	#255,fader_colors
		move.w	#8,fader_steps
		jsr	fader_makecopper
		jsr	fader_initcrossfade

		;bsr	voxel_allocvec

		RESET_SPRITES	c_voxel_spr
		move.l	#c_voxel,$dff080

		jsr	voxel_setup

		move.l	#voxel_move,lv3_vblank

.loop1		;move.w	#$555,$dff180		; rastertiem XDDD
.ll		cmp.b	#255,$dff006
		bne.b	.ll
		;move.w	#$000,$dff180

		jsr	c2p_cpu
		bsr	voxel_paint
		bsr	voxel_rotate

		cmp.w	#3,p61_pos
		blt	.no
		move.l	#blackpal,fader_target
		move.l	#voxel_pal,fader_original
		move.l	#c_pal,fader_copper
		move.w	#255,fader_colors
		move.w	#5,fader_steps
		jsr	fader_initcrossfade

.no
		tst.l	salir
		bne	.salrotovoxel
		cmp.w	#4,p61_pos
		blt	.loop1

.salrotovoxel	;bsr	voxel_freevec
		bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

voxel_pal	incbin	'txt6.pal'

;voxel_allocvec	
;		move.l	$4.w,a6
;		move.l	#(320*256*2)+(256*256*5),d0
;		move.l	#$10000,d1		;MEMF_CHIP|MEMF_CLEAR
;		jsr	_LVOAllocVec(a6)
;		move.l	d0,voxel_totalmemory
;
;		move.l	d0,c2p__chunky
;		add.l	#320*256,d0
;		move.l	d0,c2p__chunky_
;		add.l	#320*256,d0
;		move.l	d0,voxel_drawing
;		add.l	#256*256,d0
;		move.l	d0,voxel_divutab
;		add.l	#256*256*2,d0
;		move.l	d0,voxel_texheimap
;		
;		rts
;
;voxel_freevec
;		move.l	$4.w,a6
;		move.l	voxel_totalmemory,a1
;		jsr	_LVOFreeVec(a6)
;		rts
;
;voxel_totalmemory	dc.l	0
;
;voxel_drawing		dc.l	0
;voxel_divutab		dc.l	0
;voxel_texheimap		dc.l	0

maxz		equ	128-16		; Z maxima de calculo

shading		equ	1		; para activar la shadetable
double		equ	0
flip		equ	0		; si pones 1, sale en forma de cueva

bigmap		equ	0		; para hacer un scale del mapa

pers		equ	(1+bigmap)*60	; amplitud de perspectiva
dist		equ	6		; factor de distancia

		ifeq	flip
camy		equ	256
center		equ	drawsize*3/4
maxy		equ	drawsize
		else
camy		equ	255
center		equ	1+(drawsize/2)
maxy		equ	drawsize/2
		endc

voxel_move	jsr	swap_screens

		jsr	fader_setpalette
	
		cmp.w	#2,p61_pos
		blt	.norotate
		add.l	#$155,voxel_zang		; rotacion eje Z
.norotate
		add.w	#$55,voxel_angs+2		; rotacion eje Y
		add.l	#$07777,voxel_xpos		; estooooooooo..........................
		add.l	#$0aaaa,voxel_zpos
		rts

voxel_setup	lea	voxel_divutab+65536,a0

		moveq.l	#0,d0
		move.w	#maxz-1,d7
.yloop		move.w	#255,d6
.xloop		moveq.l	#0,d3

		moveq.l	#0,d1
		move.w	d6,d1
		muls.w	#pers,d1

		moveq.l	#0,d2
		move.w	d7,d2
		mulu.w	#dist,d2

		move.l	d1,d3
		sub.l	#camy*pers,d3
		move.w	#dist+(maxz*dist),d4
		sub.w	d2,d4
		divs.w	d4,d3

		add.w	#center,d3

		cmp.w	#maxy,d3
		blt.b	.noclip1
		move.w	#maxy,d3
.noclip1	tst.w	d3
		bgt.b	.noclip2
		moveq.l	#0,d3
.noclip2

		move.w	d6,d0
		lsl.w	#8,d0
		move.b	d7,d0
		move.w	d3,(a0,d0.w*2)
		
		dbra	d6,.xloop
		dbra	d7,.yloop

		lea	voxel_heightmap,a0
		lea	voxel_texturemap,a1
		lea	voxel_texheimap,a2
		move.w	#255,d7
.loop1		move.w	#255,d6
.loop2		move.b	(a0)+,(a2)+
		move.b	(a1)+,(a2)+
		dbra	d6,.loop2
		dbra	d7,.loop1
		rts

voxel_paint	bsr	voxel_mkvec

		move.l	(voxel_xvec+0)(pc),d0
		move.l	(voxel_xvec+8)(pc),d1
		ifne	bigmap
		asr.l	#bigmap,d0
		asr.l	#bigmap,d1
		endc
		movem.l	d0/d1,.xvecs

		move.l	(voxel_vectors2+0)(pc),d0
		move.l	(voxel_vectors2+8)(pc),d1
		ifne	bigmap
		asr.l	#bigmap,d0
		asr.l	#bigmap,d1
		endc
		move.l	d0,a0
		move.l	d1,a1

		move.l	voxel_xpos(pc),d0
		move.l	voxel_zpos(pc),d1
		ifne	bigmap
		asr.l	#bigmap,d0
		asr.l	#bigmap,d1
		endc

		lea	voxel_drawing,a2
		;move.l	c2p__chunky,a2
		lea	voxel_texheimap+65536,a3
		lea	voxel_divutab+65536,a4

		move.w	#drawsize-1,d7
.xloop		swap	d7
		ifne	shading
		lea	voxel_shademap+(256*255),a5
		;lea	(256*255,a5),a5
		;adda.l	#256*255,a5
		endc
		moveq.l	#-1,d6

		movem.l	d0/d1,-(sp)
		move.w	#maxz-1,d7
.zloop		move.l	d1,d2
		lsr.l	#8,d2
		move.l	d0,d3
		swap	d3
		move.b	d3,d2

		move.w	(a3,d2.w*2),d3		; read texture color
		move.w	d3,d5			; read height
		move.b	d7,d5
		move.w	(a4,d5.w*2),d5		; read perspective

		move.w	d5,d4
		sub.w	d6,d4
		ble.b	.nozpaint

		ifne	shading
		and.w	#$ff,d3
		move.b	(a5,d3.w),d3
		endc

		lea	1(a2,d6.w),a6
		move.w	d5,d6

		ifne	double

		move.b	d3,d5
		rol.w	#8,d3
		move.b	d5,d3
		lsr.w	#1,d4
		bcc.b	.even
		move.b	d3,(a6)+
		bra.b	.even
.ploop		move.w	d3,(a6)+
.even		dbra	d4,.ploop

		else

		subq.w	#1,d4
.ploop		move.b	d3,(a6)+
		dbra	d4,.ploop

		endc

.nozpaint	add.l	a0,d0
		add.l	a1,d1
		ifne	shading
		lea	-512(a5),a5		; step shade
		endc
		dbra	d7,.zloop

		movem.l	.xvecs(pc),d0/d1
		add.l	d0,a0
		add.l	d1,a1

		movem.l	(sp)+,d0/d1

		moveq.l	#0,d3
		move.w	#drawsize,d4
		sub.w	d6,d4
		lsr.w	#4,d4
.cloop		move.l	d3,(a6)+
		move.l	d3,(a6)+
		move.l	d3,(a6)+
		move.l	d3,(a6)+
.cloope		dbra	d4,.cloop


		ifne	flip
		move.l	a2,a6
		lea	drawsize(a2),a5
		moveq.l	#(drawsize/8)-1,d4
.floop		move.l	(a6)+,d3
		rol.w	#8,d3
		swap	d3
		rol.w	#8,d3
		move.l	d3,-(a5)
		dbra	d4,.floop
		endc
		lea	256(a2),a2
		swap	d7
		dbra	d7,.xloop
		rts
.xvecs		dc.l	0,0

voxel_rotate	lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		move.l	voxel_zang(pc),d0
		asr.l	#3,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d3
		add.w	#4096,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d2

		move.l	#-wid/2,d0
		move.l	#-hei/2,d5
		muls.l	d2,d0
		muls.l	d3,d5
		sub.l	d5,d0

		move.l	#-wid/2,d1
		move.l	#-hei/2,d5
		muls.l	d3,d1
		muls.l	d2,d5
		add.l	d5,d1

		add.l	#((drawsize/2)<<16)|$8000,d0
		add.l	#((drawsize/2)<<16)|$8000,d1

		lea	voxel_drawing,a6
		move.l	c2p__chunky,a5

		move.l	d2,d5
		move.l	d3,d4
		neg.l	d4

rotozoom_drawtiled
		move.l	d2,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dudxt

		move.l	d3,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dvdxt

		swap	d2
		swap	d3
		swap	d4
		swap	d5

		rol.l	#8,d3
		rol.l	#8,d5

		move.w	d2,d6
		move.w	d4,d7
		move.w	d5,d4
		move.w	d3,d2
		move.w	d6,d3
		move.w	d7,d5

		move.l	d2,a2
		move.l	d4,a3
		move.l	#$fefefefe,d2

		move.w	#(wid/16)-1,d7
.xtloop
		movem.l	d0/d1/d7/a5,-(sp)
		bsr.b	.drawcolumn16
		movem.l	(sp)+,d0/d1/d7/a5

		add.l	rotozoom_dudxt(pc),d0
		add.l	rotozoom_dvdxt(pc),d1
		lea	16(a4),a4
		lea	16(a5),a5

		dbra	d7,.xtloop
		rts

.drawcolumn16	move.l	#$00ffffff,d6
		and.l	d6,d0
		and.l	d6,d1

		swap	d0
		swap	d1

		rol.l	#8,d1

		move.w	d0,d6
		move.w	d1,d0
		move.w	d6,d1

		moveq.l	#0,d6
		move.w	#hei-1,d7
.yloop
		move.l	d0,a0
		move.l	d1,a1

		rept	4

		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.w	d0,d6
		swap	d4
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.l	d4,(a5)+

		endr

		move.l	a0,d0
		move.l	a1,d1
		lea	(wid-16)(a5),a5

		add.l	a3,d0
		addx.l	d5,d1

		dbra	d7,.yloop
		rts

rotozoom_dudxt	dc.l	0
rotozoom_dvdxt	dc.l	0

		rts

voxel_xpos	dc.l	0
voxel_ypos	dc.l	0
voxel_zpos	dc.l	0
voxel_zang	dc.l	16384*2

voxel_angs2	dc.w	$0000,$0000,$0000
voxel_angs	dc.w	$0000,$0000,$0000

voxel_vectors	dc.l	$00000,$00000,$00000
voxel_vectors2	dc.l	$00000,$00000,$00000
voxel_vectors3	dc.l	$00000,$00000,$00000

voxel_xvec	dc.l	$00000,$00000,$00000
voxel_yvec	dc.l	$00000,$00000,$00000
voxel_zvec

vecx	set	128	;128,221,256
vecy	set	128	; 97,181,192
vecz	set	256

voxel_mkvec	bsr	.mkvec1

		move.w	#$4000,$dff000+intena

		lea	voxel_vectors(pc),a6
		lea	voxel_zvec(pc),a5
		moveq.l	#0,d7

		move.w	#0+vecx,d2
		move.w	#0-vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		move.l	d0,(a6)+
		move.l	d1,(a6)+
		move.l	d2,(a6)+

		move.w	#0-vecx,d2
		move.w	#0-vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		move.l	d0,(a6)+
		move.l	d1,(a6)+
		move.l	d2,(a6)+

		move.w	#0-vecx,d2
		move.w	#0+vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		movem.l	d0/d1/d2,(a6)

		move.l	#drawsize,d6
		move.l	-(a6),a2
		sub.l	a2,d2
		divs.l	d6,d2
		move.l	d2,-(a5)

		move.l	-(a6),a1
		sub.l	a1,d1
		divs.l	d6,d1
		move.l	d1,-(a5)

		move.l	-(a6),a0
		sub.l	a0,d0
		divs.l	d6,d0
		move.l	d0,-(a5)

		move.l	#drawsize,d6
		move.l	-(a6),d2
		sub.l	a2,d2
		divs.l	d6,d2
		move.l	d2,-(a5)

		move.l	-(a6),d1
		sub.l	a1,d1
		divs.l	d6,d1
		move.l	d1,-(a5)

		move.l	-(a6),d0
		sub.l	a0,d0
		divs.l	d6,d0
		move.l	d0,-(a5)

		move.w	#$c000,$dff000+intena
		rts

.rotvector	move.w	d2,d0
		move.w	d3,d5
		move.w	d4,d6

		muls.w	.m1(pc),d0
		muls.w	.m2(pc),d5
		muls.w	.m3(pc),d6
		add.l	d5,d0
		add.l	d6,d0

		move.w	d2,d1
		move.w	d3,d5
		move.w	d4,d6

		muls.w	.m4(pc),d1
		muls.w	.m5(pc),d5
		muls.w	.m6(pc),d6
		add.l	d5,d1
		add.l	d6,d1

		muls.w	.m7(pc),d2
		muls.w	.m8(pc),d3
		muls.w	.m9(pc),d4
		add.l	d3,d2
		add.l	d4,d2
		rts

.m1		dc.w	0
.m2		dc.w	0
.m3		dc.w	0
.m4		dc.w	0
.m5		dc.w	0
.m6		dc.w	0
.m7		dc.w	0
.m8		dc.w	0
.m9		dc.w	0

.mkvec1	lea	sinus,a6
	lea	16384(a6),a5
	moveq.l	#0,d6

	movem.w	voxel_angs(pc),d3-d5

	lsr.w	#2,d3
	addx.w	d6,d3
	lsr.w	#2,d4
	addx.w	d6,d4
	lsr.w	#2,d5
	addx.w	d6,d5

	move.w	1(a5,d3.w*4),d0
	move.w	1(a6,d3.w*4),a0

	move.w	1(a5,d4.w*4),d1
	move.w	1(a6,d4.w*4),a1

	move.w	1(a5,d5.w*4),d2
	move.w	1(a6,d5.w*4),a2

ca equr d0
sa equr a0
cb equr d1
sb equr a1
cc equr d2
sc equr a2

	move.w	sb,d7
	muls.w	cc,d7
	asr.l	#8,d7
	addx.w	d6,d7

	move.w	cb,d3
	muls.w	cc,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m1	; m1

	move.w	sa,d3
	muls.w	d7,d3
	move.w	sc,d4
	muls.w	ca,d4
	sub.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m2	; m2

	move.w	ca,d3
	muls.w	d7,d3
	move.w	sc,d4
	move.w	sa,d5
	muls.w	d5,d4
	add.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m3	; m3

	move.w	sb,d7
	move.w	sc,d3
	muls.w	d3,d7
	asr.l	#8,d7
	addx.w	d6,d7

	move.w	sc,d3
	muls.w	cb,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m4	; m4

	move.w	sa,d3
	muls.w	d7,d3
	move.w	cc,d4
	muls.w	ca,d4
	add.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m5	; m5

	move.w	ca,d3
	muls.w	d7,d3

	move.w	sa,d4
	muls.w	cc,d4
	sub.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m6	; m6

	move.w	sb,d3
	neg.w	d3
	move.w	d3,.m7	; m7

	move.w	sa,d3
	muls.w	cb,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m8	; m8

	muls.w	ca,cb
	asr.l	#8,cb
	addx.w	d6,d3
	move.w	cb,.m9	; m9
	rts

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	voxel_chunky1
c2p__chunky_	dc.l	voxel_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_7,lv3_blit
	rts

c2p_blit_7	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#6*plsize,a1

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_8,lv3_blit
	rts

c2p_blit_8	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#7*plsize,a1

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts

c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	addq.l	#1,timing_frame2
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	0

swap_screens	move.l	newplanes(pc),d0

	lea	c_voxel_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#plsize,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	addq.l	#1,timing_frame1
	rts

test_speed	move.l	c2p__chunky(pc),a0
	move.l	timing_frame1(pc),d0
	move.l	timing_frame2(pc),d1

	tst.l	d0
	beq.b	.no

	mulu.w	#wid,d1
	divs.l	d0,d1
	move.l	d1,timing_speed

	moveq.l	#0,d2

	move.l	a0,a1
	move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	dbra	d7,.clrloop

	add.l	d1,a0
	add.l	#wid*2,a0

	move.w	#3,d7
.loop	movem.l	a0-a4,(a0)
	add.l	#wid,a0
	dbra	d7,.loop

.no	rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0
		cnop	0,16
;voxel_heightmap		dc.l	0	;incbin	'chk.voxelmap'
;voxel_texturemap	dc.l	0	;incbin	'chk.txt4'
;voxel_shademap		dc.l	0	;incbin	'shd.txt4'


	section	data_c,data_c

	cnop	0,64
c_voxel	dc.w	$1fc,$4007
	dc.w	$100,$0201

	dc.w	$08e,$2882
	dc.w	$090,$28C1		* DIWindow Size YX
	dc.w	$092,$0038
	dc.w	$094,$00D0-(4*8)	* DDFetch

c_pal	ds.b	2112

	dc.w	$100,$0201|$0010
	dc.w	$102,$0010
	dc.w	$104,$0200
	dc.w	$106,$0020

	dc.w	$108,-40
	dc.w	$10a,0
sprite	set	$120
c_voxel_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

c_voxel_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$fe8f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
