	opt	p=68030

	include	'macros/macros.gs'
	include	'lvo.asm'

	;jmp	voxel_setup
	;jmp	voxel_paint

	section	code,code

InitSys	bsr	OSout		; Quitamos el control al Amiga OS
	bsr	Main		; Nuestro PROGRAMA !!!
	bsr	OSin		; Devolvemos el control al Amiga OS
	rts			; ADIOS !!!

OSout	movea.l	4.w,a6			; System Base
	lea	GfxLib,a1
	moveq	#0,d0
	jsr	-552(a6)		; OpenLibrary
	move.l	d0,GfxBase		; Save Graphics_lib base
	move.l	d0,a6
	move.l	38(a6),OldCopper	; gb_CopInit	Sys Copper
	move.l	34(a6),OldView		; gb_ActiView	Sys View
	jsr	-456(a6)		; Own Blitter
	lea	0.w,a1		; LoadView Null
	jsr	-222(a6)		; LoadView

	move.w	#(10*1)-1,d7
.loop	jsr	-270(a6)		; lots of WaitTOF
	dbra	d7,.loop

	movea.l	4.w,a6			; System Base
	jsr	-132(a6)		; Forbid
	jsr	-150(a6)		; SuperState
	move.l	d0,SysStack		; System stack
	btst.b	#0,$129(a6)		; are we at least 68010? ($129=AttnFlags+1)
	beq.b	.68000			; nope.
	dc.w	$4e7a,$0801		;=movec.l vbr,d0 ; pero MDevPac no lo acepta
	move.l	d0,VectorBase		; Get Real VBR

.68000
	move.l	SysStack,d0		; Systemstack
	jsr	-156(a6)		; UserState

	move	$dff01c,IntEnaR		; Initialize custom chips
	move	$dff01e,IntReqR		; Save old valours first
	move	$dff002,DmaConR
	move	$dff010,AdkConR
	move	#%0111111111111111,$dff09a	; INTENA
	move	#%1100000001010000,$dff09a	* Enable desired IRQs
.Spr	move.l	$dff004,D0			; Wait RASTER to
	and.l	#$0001FF00,D0			; disable SPRITES
	bne.b	.Spr
	move	#%0111111111111111,$dff096	; DMACONW
	move	#%1000001111000000,$dff096	* Enable desired DMAs

	move	$dff07c,d0			;Ponerlo en/antes/despues de Copper?
	cmp.b	#$f8,d0
	bne.b	.NotAGA				; Not AGA
	move	#0,$dff1fc			* Fix AGA Res     (Ponerlo en Copper?)

.NotAGA	move.l	VectorBase,a0
	move.l	$6c(a0),Int3Save		; Save level 3 vector
	move.l	#level3,$6c(a0)			; Set OUR! own interrupt
	rts

OSin	move.l	VectorBase,a0
	move.l	Int3Save,$6c(a0)	; Reset Interrupts

	move	IntEnaR,d7		; Reset custom chips
	bset	#$f,d7
	move	d7,$dff09a		; Reset Interrupts

	move	IntReqR,d7
	bset	#$f,d7
	move	d7,$dff09c		; Reset interrupt request

	move	DmaConR,d7
	bset	#$f,d7
	move	d7,$dff096		; Reset DMAConw

	move	AdkConR,d7
	bset	#$f,d7
	move	d7,$dff09e		; Reset ADK

	move.l	GfxBase,a6
	movea.l	OldView,a1
	jsr	-222(a6)		;LoadView
	move.l	OldCopper,$dff080	; Reset System Copper
	jsr	-462(a6)		; DisOwn Blitter

	movea.l	4.w,a6			; System Base
	move.l	GfxBase,a1		; Close Graphics_lib
	jsr	-414(a6)		; CloseLibrary
	jsr	-138(a6)		; Permit

	move.l	timing_speed,d0
	rts

GfxLib	dc.b	"graphics.library",0,0
GfxBase	dc.l	0
IntEnaR	dc.w	0
IntReqR	dc.w	0
DmaConR	dc.w	0
AdkConR	dc.w	0
SysStack	dc.l	0
Int3Save	dc.l	0
OldCopper	dc.l	0
OldView	dc.l	0
VectorBase	dc.l	0

***************** INTERRUPCION

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

level3	movem.l	d0-a6,-(sp)

	move.w	$dff01e,d0
	btst	#6,d0
	beq.b	.noblit

	move.l	lv3_blit,d0
	beq.b	.no0

	move.l	d0,a0
	jsr	(a0)

.no0	movem.l	(sp)+,d0-a6
	move.w	#$40,$dff09c
	rte

.noblit	btst	#4,d0
	beq.b	.nocopper

	jsr	swap_screens

	move.l	lv3_vblank,d0
	beq.b	.no1
	move.l	d0,a0
	jsr	(a0)
.no1

	movem.l	(sp)+,d0-a6
	move.w	#$10,$dff09c
	rte

.nocopper	movem.l	(sp)+,d0-a6
	move.w	#$70,$dff09c
	rte

lv3_vblank	dc.l	0
lv3_blit	dc.l	0

Main	bsr	voxel
	rts

drawsize	set	204
wid		set	160
hei		set	128

voxel_setup	lea	voxel_divutab+65536,a0

		moveq.l	#0,d0
		move.l	#127,d7
.yloop		move.w	#255,d6
.xloop		moveq.l	#0,d3

		moveq.l	#0,d1
		move.w	d6,d1
		muls.w	#drawsize,d1

		moveq.l	#0,d2
		move.w	d7,d2
		mulu.w	#16,d2

		move.l	d1,d3
		sub.l	#280*drawsize,d3
		move.w	#(256*8)+2,d4
		sub.w	d2,d4
		divs.w	d4,d3

		add.w	#drawsize*6/8,d3

		cmp.w	#drawsize,d3
		blt.b	.noclip1
		move.w	#drawsize,d3
.noclip1	tst.w	d3
		bgt.b	.noclip2
		moveq.l	#0,d3
.noclip2

		move.w	d6,d0
		lsl.w	#8,d0
		move.b	d7,d0
		move.w	d3,(a0,d0.w*2)
		
		dbra	d6,.xloop
		dbra	d7,.yloop

		lea	heightmap,a0
		lea	texturemap,a1
		lea	voxel_texheimap,a2
		move.w	#255,d7
.loop1		move.w	#255,d6
.loop2		move.b	(a0)+,(a2)+
		move.b	(a1)+,(a2)+
		dbra	d6,.loop2
		dbra	d7,.loop1
		rts

voxel		move.l	#c_voxel,$dff080

		jsr	voxel_setup

		move.l	#voxel_move,lv3_vblank

.loop1		;move.w	#$555,$dff180
.ll		;cmp.b	#255,$dff006
		;bne.b	.ll
		;move.w	#$000,$dff180

		jsr	c2p_cpu
		bsr	voxel_paint
		bsr	voxel_rotate

		btst	#6,$bfe001
		bne.b	.loop1

		moveq.l	#24,d7
.loop2		wrast	255
		dbra	d7,.loop2
		rts

voxel_paint	bsr	voxel_mkvec

		move.l	(voxel_xvec+0)(pc),d0
		move.l	(voxel_xvec+8)(pc),d1
		movem.l	d0/d1,.xvecs

		move.l	(voxel_vectors2+0)(pc),d0
		move.l	(voxel_vectors2+8)(pc),d1
		move.l	d0,a0
		move.l	d1,a1

		move.l	voxel_xpos(pc),d0
		move.l	voxel_zpos(pc),d1

		lea	voxel_drawing,a2
		lea	voxel_texheimap+65536,a3
		lea	voxel_divutab+65536,a4

		move.w	#drawsize-1,d7
.xloop		swap	d7
		lea	shademap+(256*255),a5
		moveq.l	#-1,d6

		movem.l	d0/d1,-(sp)
		move.w	#127,d7
.zloop		move.l	d1,d2
		lsr.l	#8,d2
		move.l	d0,d3
		swap	d3
		move.b	d3,d2

		move.w	(a3,d2.w*2),d3		; read texture color
		move.w	d3,d5			; read height
		move.b	d7,d5
		move.w	(a4,d5.w*2),d5		; read perspective

		move.w	d5,d4
		sub.w	d6,d4
		ble.b	.nozpaint

		and.w	#$ff,d3
		move.b	(a5,d3.w),d3

		lea	1(a2,d6.w),a6
		move.w	d5,d6
		subq.w	#1,d4
.ploop		move.b	d3,(a6)+
		dbra	d4,.ploop

.nozpaint	add.l	a0,d0
		add.l	a1,d1
		lea	-512(a5),a5		; step shade
		dbra	d7,.zloop

		movem.l	.xvecs(pc),d0/d1
		add.l	d0,a0
		add.l	d1,a1

		movem.l	(sp)+,d0/d1
		lea	256(a2),a2

		moveq.l	#0,d3
		move.w	#drawsize,d4
		sub.w	d6,d4
.cloop		move.b	d3,(a6)+
.cloope		dbra	d4,.cloop

		swap	d7
		dbra	d7,.xloop
		rts
.xvecs		dc.l	0,0


voxel_rotate	lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		move.l	voxel_zang(pc),d0
		asr.l	#3,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d3
		add.w	#4096,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d2

		move.l	#-wid/2,d0
		move.l	#-hei/2,d5
		muls.l	d2,d0
		muls.l	d3,d5
		sub.l	d5,d0

		move.l	#-wid/2,d1
		move.l	#-hei/2,d5
		muls.l	d3,d1
		muls.l	d2,d5
		add.l	d5,d1

		add.l	#((drawsize/2)<<16)|$8000,d0
		add.l	#((drawsize/2)<<16)|$8000,d1

		lea	voxel_drawing,a6
		move.l	c2p__chunky,a5

		move.l	d2,d5
		move.l	d3,d4
		neg.l	d4

rotozoom_drawtiled
		move.l	d2,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dudxt

		move.l	d3,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dvdxt

		swap	d2
		swap	d3
		swap	d4
		swap	d5

		rol.l	#8,d3
		rol.l	#8,d5

		move.w	d2,d6
		move.w	d4,d7
		move.w	d5,d4
		move.w	d3,d2
		move.w	d6,d3
		move.w	d7,d5

		move.l	d2,a2
		move.l	d4,a3
		move.l	#$fefefefe,d2

		move.w	#(wid/16)-1,d7
.xtloop
		movem.l	d0/d1/d7/a5,-(sp)
		bsr.b	.drawcolumn16
		movem.l	(sp)+,d0/d1/d7/a5

		add.l	rotozoom_dudxt(pc),d0
		add.l	rotozoom_dvdxt(pc),d1
		lea	16(a4),a4
		lea	16(a5),a5

		dbra	d7,.xtloop
		rts

.drawcolumn16	move.l	#$00ffffff,d6
		and.l	d6,d0
		and.l	d6,d1

		swap	d0
		swap	d1

		rol.l	#8,d1

		move.w	d0,d6
		move.w	d1,d0
		move.w	d6,d1

		moveq.l	#0,d6
		move.w	#hei-1,d7
.yloop
		move.l	d0,a0
		move.l	d1,a1

		rept	4

		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.w	d0,d6
		swap	d4
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.l	d4,(a5)+

		endr

		move.l	a0,d0
		move.l	a1,d1
		lea	(wid-16)(a5),a5

		add.l	a3,d0
		addx.l	d5,d1

		dbra	d7,.yloop
		rts

rotozoom_dudxt	dc.l	0
rotozoom_dvdxt	dc.l	0

		rts

voxel_xpos	dc.l	0
voxel_ypos	dc.l	0
voxel_zpos	dc.l	0
voxel_zang	dc.l	0

voxel_angs2	dc.w	$0000,$0000,$0000
voxel_angs	dc.w	$0000,$0000,$0000

voxel_vectors	dc.l	$00000,$00000,$00000
voxel_vectors2	dc.l	$00000,$00000,$00000
voxel_vectors3	dc.l	$00000,$00000,$00000

voxel_xvec	dc.l	$00000,$00000,$00000
voxel_yvec	dc.l	$00000,$00000,$00000
voxel_zvec

voxel_move	add.l	#$100,voxel_zang
		add.w	#$40,voxel_angs+2
		add.l	#$03333,voxel_xpos
		add.l	#$10000,voxel_zpos
		rts

vecx	set	256	;128,221,256
vecy	set	256	; 97,181,192
vecz	set	256

voxel_mkvec	bsr	.mkvec1

		lea	voxel_vectors(pc),a6
		lea	voxel_zvec(pc),a5
		moveq.l	#0,d7

		move.w	#0+vecx,d2
		move.w	#0-vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		move.l	d0,(a6)+
		move.l	d1,(a6)+
		move.l	d2,(a6)+

		move.w	#0-vecx,d2
		move.w	#0-vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		move.l	d0,(a6)+
		move.l	d1,(a6)+
		move.l	d2,(a6)+

		move.w	#0-vecx,d2
		move.w	#0+vecy,d3
		move.w	#0+vecz,d4
		bsr.b	.rotvector
		movem.l	d0/d1/d2,(a6)

		move.l	#drawsize,d6
		move.l	-(a6),a2
		sub.l	a2,d2
		divs.l	d6,d2
		move.l	d2,-(a5)

		move.l	-(a6),a1
		sub.l	a1,d1
		divs.l	d6,d1
		move.l	d1,-(a5)

		move.l	-(a6),a0
		sub.l	a0,d0
		divs.l	d6,d0
		move.l	d0,-(a5)

		move.l	#drawsize,d6
		move.l	-(a6),d2
		sub.l	a2,d2
		divs.l	d6,d2
		move.l	d2,-(a5)

		move.l	-(a6),d1
		sub.l	a1,d1
		divs.l	d6,d1
		move.l	d1,-(a5)

		move.l	-(a6),d0
		sub.l	a0,d0
		divs.l	d6,d0
		move.l	d0,-(a5)
		rts

.rotvector	move.w	d2,d0
		move.w	d3,d5
		move.w	d4,d6

		muls.w	.m1(pc),d0
		muls.w	.m2(pc),d5
		muls.w	.m3(pc),d6
		add.l	d5,d0
		add.l	d6,d0

		move.w	d2,d1
		move.w	d3,d5
		move.w	d4,d6

		muls.w	.m4(pc),d1
		muls.w	.m5(pc),d5
		muls.w	.m6(pc),d6
		add.l	d5,d1
		add.l	d6,d1

		muls.w	.m7(pc),d2
		muls.w	.m8(pc),d3
		muls.w	.m9(pc),d4
		add.l	d3,d2
		add.l	d4,d2
		rts

.m1		dc.w	0
.m2		dc.w	0
.m3		dc.w	0
.m4		dc.w	0
.m5		dc.w	0
.m6		dc.w	0
.m7		dc.w	0
.m8		dc.w	0
.m9		dc.w	0

.mkvec1	lea	sinus,a6
	lea	16384(a6),a5
	moveq.l	#0,d6

	movem.w	voxel_angs(pc),d3-d5

	lsr.w	#2,d3
	addx.w	d6,d3
	lsr.w	#2,d4
	addx.w	d6,d4
	lsr.w	#2,d5
	addx.w	d6,d5

	move.w	1(a5,d3.w*4),d0
	move.w	1(a6,d3.w*4),a0

	move.w	1(a5,d4.w*4),d1
	move.w	1(a6,d4.w*4),a1

	move.w	1(a5,d5.w*4),d2
	move.w	1(a6,d5.w*4),a2

ca equr d0
sa equr a0
cb equr d1
sb equr a1
cc equr d2
sc equr a2

	move.w	sb,d7
	muls.w	cc,d7
	asr.l	#8,d7
	addx.w	d6,d7

	move.w	cb,d3
	muls.w	cc,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m1	; m1

	move.w	sa,d3
	muls.w	d7,d3
	move.w	sc,d4
	muls.w	ca,d4
	sub.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m2	; m2

	move.w	ca,d3
	muls.w	d7,d3
	move.w	sc,d4
	move.w	sa,d5
	muls.w	d5,d4
	add.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m3	; m3

	move.w	sb,d7
	move.w	sc,d3
	muls.w	d3,d7
	asr.l	#8,d7
	addx.w	d6,d7

	move.w	sc,d3
	muls.w	cb,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m4	; m4

	move.w	sa,d3
	muls.w	d7,d3
	move.w	cc,d4
	muls.w	ca,d4
	add.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m5	; m5

	move.w	ca,d3
	muls.w	d7,d3

	move.w	sa,d4
	muls.w	cc,d4
	sub.l	d4,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m6	; m6

	move.w	sb,d3
	neg.w	d3
	move.w	d3,.m7	; m7

	move.w	sa,d3
	muls.w	cb,d3
	asr.l	#8,d3
	addx.w	d6,d3
	move.w	d3,.m8	; m8

	muls.w	ca,cb
	asr.l	#8,cb
	addx.w	d6,d3
	move.w	cb,.m9	; m9
	rts

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	voxel_chunky1
c2p__chunky_	dc.l	voxel_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_7,lv3_blit
	rts

c2p_blit_7	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#6*plsize,a1

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_8,lv3_blit
	rts

c2p_blit_8	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#7*plsize,a1

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts

c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	addq.l	#1,timing_frame2
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	0

swap_screens	move.l	newplanes(pc),d0

	lea	c_voxel_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#plsize,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	addq.l	#1,timing_frame1
	rts

test_speed	move.l	c2p__chunky(pc),a0
	move.l	timing_frame1(pc),d0
	move.l	timing_frame2(pc),d1

	tst.l	d0
	beq.b	.no

	mulu.w	#wid,d1
	divs.l	d0,d1
	move.l	d1,timing_speed

	moveq.l	#0,d2

	move.l	a0,a1
	move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	dbra	d7,.clrloop

	add.l	d1,a0
	add.l	#wid*2,a0

	move.w	#3,d7
.loop	movem.l	a0-a4,(a0)
	add.l	#wid,a0
	dbra	d7,.loop

.no	rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0

		cnop	0,16
heightmap	incbin	'chk.voxelmap'
texturemap	incbin	'chk.txt2'
shademap	incbin	'shd.txt2'
		dcb.b	65536,0

sinus	incbin	'tables/sinus64k.bin'
	incbin	'tables/sinus64k.bin'

	section	data_c,data_c

	cnop	0,64
c_voxel	dc.w	$1fc,$4007
	dc.w	$100,$0201

	dc.w	$08e,$2882
	dc.w	$090,$28C1		* DIWindow Size YX
	dc.w	$092,$0038
	dc.w	$094,$00D0-(4*8)	* DDFetch

	incbin	'pal.txt2'

	dc.w	$100,$0201|$0010
	dc.w	$102,$0010
	dc.w	$104,$0200
	dc.w	$106,$0000

	dc.w	$108,-40
	dc.w	$10a,0

c_voxel_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$fe8f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	section	bss_c,bss_c
	cnop	0,16
bltbuf1	ds.b	8*40*256
bltbuf2	ds.b	8*40*256
planes1	ds.b	8*40*256
planes2	ds.b	8*40*256

	section	bss,bss
	cnop	0,16
Buffer1	ds.b	(1024*2048)

	BUFFER	1
	RESERVE	1,voxel_chunky1,(320*256)
	RESERVE	1,voxel_chunky2,(320*256)
	RESERVE	1,voxel_drawing,(256*256)
	RESERVE	1,voxel_divutab,(256*256*2)
	RESERVE	1,voxel_texheimap,(256*256*2)