		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	bltbuf3

		XREF	rotozoom_shit
		XREF	rotozoom_chunky1
		XREF	rotozoom_chunky2
		XREF	rotozoom_tex1
		XREF	rotozoom_tex2
		XREF	rotozoom_tex3
		XREF	rotozoom_tex4

		XREF	lv3_vblank
		XREF	lv3_copper	
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	salir

		XREF	sinus
		
		XDEF	rotozoom_main


		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	'rotofire_new'

		section	rotozoom_new,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM
	
rotozoom_main
		RESET_SPRITES c_rotozoom_spr

		;lea	(bltbuf1+8*40*256).l,a0
		;lea	(bltbuf2+8*40*256).l,a1
		;lea	(bltbuf3+8*40*256).l,a2
		lea	(planes1+8*40*256).l,a4
		lea	(planes2+8*40*256).l,a5
		lea	(planes3+8*40*256).l,a6
		move.l	#((8*40*256)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5
.chiploop	rept	16
		;movem.l	d1-d7/a3,-(a0)
		;movem.l	d1-d7/a3,-(a1)
		;movem.l	d1-d7/a3,-(a2)
		movem.l	d1-d7/a3,-(a4)
		movem.l	d1-d7/a3,-(a5)
		movem.l	d1-d7/a3,-(a6)
		endr
		dbf	d0,.chiploop

		move.l	#planes1,d0
		lea	c_bpls,a0
		moveq.l	#7,d1
.loop2		addq.l	#2,a0
		swap	d0
		move.w	d0,(a0)+
		addq.l	#2,a0
		swap	d0
		move.w	d0,(a0)+
		add.l	#320*256/8,d0
		dbf	d1,.loop2

		move.l	#c_rotozoom,$dff080

		jsr	setup
		move.l	#rotozoom_lv3,lv3_vblank

.loop1		jsr	c2p_cpu
		jsr	rotozoom_draw

		tst.l	salir
		bne	.exit
		cmp.w	#14,p61_pos
		blt	.loop1

.exit		bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

wid	set	320
hei	set	128-16

rotozoom_xspd	dc.l	20			; velocidad de giro
rotozoom_zspd	dc.l	-$970

rotozoom_xang	dc.l	0

rotozoom_zpos	dc.l	$60000

rotozoom_acttex	dc.l	rotozoom_tex1

xpspd	set	128
ypspd	set	096

zacc	set	64-8
zspd0	set	4096

rotozoom_lv3	move.l	rotozoom_xspd,d0
		add.l	d0,rotozoom_xang
		move.l	rotozoom_zspd,d0
		add.l	d0,rotozoom_zpos

		jsr	fader_setpalette

		cmp.w	#16,p61_crow
		blt	.no
		move.w	.cnt,d0
		lsl.w	#4,d0
		move.w	p61_crow,d1
		sub.w	#16,d1
		cmp.w	d1,d0
		bne	.no
		addq.w	#1,.cnt

		move.l	#20,rotozoom_xang
		move.l	#$60000,rotozoom_zpos
		neg.l	rotozoom_xspd

.no		moveq.l	#3,d0
		and.w	.cnt(pc),d0
		swap	d0
		lea	rotozoom_tex1,a0
		lea	(a0,d0.l),a1
		move.l	a1,rotozoom_acttex
		rts
.cnt		dc.w	0
;.first		dc.b	0

		cnop	0,16

rotozoom_draw	lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		move.l	rotozoom_xang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d3
		add.w	#4096,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d2

		move.l	rotozoom_zpos(pc),d0

		muls.l	d0,d5:d2
		move.w	d5,d2
		swap	d2

		muls.l	d0,d5:d3
		move.w	d5,d3
		swap	d3

		move.l	#-wid/2,d0
		move.l	#-hei/1,d5
		muls.l	d2,d0
		muls.l	d3,d5
		sub.l	d5,d0

		move.l	#-wid/2,d1
		move.l	#-hei/1,d5
		muls.l	d3,d1
		muls.l	d2,d5
		add.l	d5,d1

		add.l	#$808000,d0
		add.l	#$808000,d1

		movem.l	c2p__chunky,a5/a6
		move.l	a6,a4
		move.l	rotozoom_acttex(pc),a6

		move.l	d2,d5
		move.l	d3,d4
		neg.l	d4

		add.l	d4,d4
		add.l	d5,d5

rotozoom_drawtiled
		move.l	d2,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dudxt

		move.l	d3,d6
		asl.l	#4,d6
		move.l	d6,rotozoom_dvdxt

		swap	d2
		swap	d3
		swap	d4
		swap	d5

		rol.l	#8,d3
		rol.l	#8,d5

		move.w	d2,d6
		move.w	d4,d7
		move.w	d5,d4
		move.w	d3,d2
		move.w	d6,d3
		move.w	d7,d5

		move.l	d2,a2
		move.l	d4,a3
		move.l	#$3f3f3f3f,d2

		move.w	#(wid/16)-1,d7
.xtloop
		movem.l	d0/d1/d7/a4/a5,-(sp)
		bsr.b	.drawcolumn16
		movem.l	(sp)+,d0/d1/d7/a4/a5

		add.l	rotozoom_dudxt(pc),d0
		add.l	rotozoom_dvdxt(pc),d1
		lea	16(a4),a4
		lea	16(a5),a5

		dbra	d7,.xtloop
		rts

.drawcolumn16	move.l	#$00ffffff,d6
		and.l	d6,d0
		and.l	d6,d1

		swap	d0
		swap	d1

		rol.l	#8,d1

		move.w	d0,d6
		move.w	d1,d0
		move.w	d6,d1

		moveq.l	#0,d6
		move.w	#hei-1,d7
.yloop
		move.l	d0,a0
		move.l	d1,a1

		rept	4

		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.w	d0,d6
		swap	d4
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4

		add.l	(wid*2)(a4),d4
		add.l	(wid-1)(a4),d4
		add.l	(wid+1)(a4),d4
		lsr.l	#2,d4
		and.l	d2,d4
		add.l	(a4)+,d4
		lsr.l	#1,d4
		and.l	d2,d4
		move.l	d4,(a5)+

		endr

		move.l	a0,d0
		move.l	a1,d1
		lea	(wid-16)(a4),a4
		lea	(wid-16)(a5),a5

		add.l	a3,d0
		addx.l	d5,d1

		dbra	d7,.yloop
		rts

rotozoom_dudxt	dc.l	0
rotozoom_dvdxt	dc.l	0

		cnop	0,16
setup		move.l	#c_pal,fader_copper
		move.l	#efectpal,fader_original
		move.l	#efectpal,fader_target
		move.w	#1,fader_steps
		move.w	#63,fader_colors

		jsr	fader_makecopper
		jsr	fader_initcrossfade

		lea	.dat(pc),a0
		lea	rotozoom_tex1,a1
		bsr	.make
		bsr	.make
		bsr	.make
		bsr	.make
		rts

.make		move.w	#255,d7
.yloop		move.w	#(256/16)-1,d6
.xloop		move.w	(a0)+,d0
		rept	16
		add.w	d0,d0
		subx.w	d1,d1
		and.b	#63,d1
		move.b	d1,(a1)+
		endr
		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

		cnop	0,16
.dat		incbin	'gfx/bpl.b1'
		incbin	'gfx/bpl.b2'
		incbin	'gfx/bpl.b3'
		incbin	'gfx/bpl.b4'

		cnop	0,16
whitepal	dcb.l	256,$ffffff
blackpal	dcb.l	256,$000000
efectpal	incbin	'pal.fire'

changestuff	dc.w	0
timer		dc.w	0


plsize	set	wid*hei/8
plsiz2	set	plsize*2

c2p_wait	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	lea.l	c2p__chunky(pc),a0
	movem.l	(a0),a5-a6
	move.l	a6,(a0)+
	move.l	a5,(a0)+

	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4
	lea	plsiz2(a4),a3
	lea	plsiz2(a3),a2
	lea	plsiz2(a2),a1

	move.l	a7,c2p_stack

	move.l	-(a3),a7
	move.l	-(a2),a0
	move.l	-(a1),d7

	move.l	#$0f0f0f0f,d4
	move.l	#$00ff00ff,d5
	move.l	#$55555555,d6

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	rotozoom_chunky1
c2p__chunky_	dc.l	rotozoom_chunky2
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2
c2p__planes__	dc.l	planes3
c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

	cmp.l	a5,a6
	bcs	c2p_loop

	move.l	d7,(a1)+
	move.l	a0,(a2)+
	move.l	a7,(a3)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	move.l	#c2p_blit2,lv3_blit

	lea	$dff000,a6

	moveq.l	#-1,d0
	moveq.l	#2,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	add.l	#(4*wid*hei/8)-2,a1

	move.l	a0,$50(a6)		; orig 1
	subq.l	#2,a0
	move.l	a0,$4c(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#$cccc,$70(a6)
	move.l	#$eDE40000,$40(a6)

	move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts


c2p_blit2	move.l	#c2p_blit3,lv3_blit

	lea	$dff000,a6
	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	move.l	a0,$50(a6)		; orig 1
	addq.l	#2,a0
	move.l	a0,$4C(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$0DE42000,$40(a6)

	move.w	#4*wid*hei/16,$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts

c2p_blit3	clr.l	c2p_proceed
	clr.l	lv3_blit
	rts

c2p_dbuff	movem.l	c2p__bltbuf,a0-a1
	exg.l	a0,a1
	movem.l	a0-a1,c2p__bltbuf

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d2
	move.l	d2,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	;move.w	#$555,$dff180
	wrast	255
	;move.w	#$000,$dff180

	lea	c_bpls,a0
	move.l	c2p__planes_,d0
	moveq.l	#7,d7

.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#wid*hei/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop
	rts

	section	data_c,data_c

	cnop	0,64
c_rotozoom
	dc.w	$1fc,$400f
	dc.w	$100,$0201

	dc.w	$2007,$fffe

sprite	set	$120
c_rotozoom_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

c_bpls	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0
	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

yst set $118-2*hei
	dc.w	$08e,$0081|(yst<<8)
	dc.w	$090,$18c1

	dc.w	$092,4*14
	dc.w	$094,4*44

	dc.w	$100,$0201|$6000
	dc.w	$102,$0000
	dc.w	$104,$0224
	dc.w	$106,$0000
	dc.w	$10c,$0088

	dc.w	$108,-40
	dc.w	$10a,0

	dc.w	$ffdf,$fffe
	dc.w	$3007,$fffe
c_pal	ds.b	2112

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
