		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	planes4
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	rotobump_chunky1
		XREF	rotobump_chunky2
		XREF	rotobump_bump_
		XREF	rotobump_phong_

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_steps
		XREF	fader_colors
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	blackpal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	salir

		XREF	sinus

		XREF	rotobump_texture
		XREF	rotobump_phong
		XREF	rotobump_shade
		XREF	rotobump_bump


		XDEF	rotobump_main


		IFND	WASIMACROs
		include	include:macros2.i
		ENDC

		incdir	'rotobump'

		section	rotobump,code
wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

rotobump_main
	RESET_SPRITES	c_roto_spr

	;lea	(bltbuf1+8*40*256).l,a0
	;lea	(bltbuf2+8*40*256).l,a1
	;lea	(bltbuf3+8*40*256).l,a2
	lea	(planes1+8*40*256).l,a4
	lea	(planes2+8*40*256).l,a5
	lea	(planes3+8*40*256).l,a6
	move.l	#((8*40*256)/(32*16))-1,d0
	moveq.l	#0,d1
	moveq.l	#0,d2
	moveq.l	#0,d3
	moveq.l	#0,d4
	moveq.l	#0,d5
	moveq.l	#0,d6
	moveq.l	#0,d7
	sub.l	a3,a3
	;sub.l	a4,a4
	;sub.l	a5,a5
.chiploop
	rept	16
	;movem.l	d1-d7/a3,-(a0)
	;movem.l	d1-d7/a3,-(a1)
	;movem.l	d1-d7/a3,-(a2)
	movem.l	d1-d7/a3,-(a4)
	movem.l	d1-d7/a3,-(a5)
	movem.l	d1-d7/a3,-(a6)
	endr
	dbf	d0,.chiploop

	move.l	#planes1,d0
	lea	c_bpls,a0
	moveq.l	#7,d1
.loop2	
	addq.l	#2,a0
	swap	d0
	move.w	d0,(a0)+
	addq.l	#2,a0
	swap	d0
	move.w	d0,(a0)+
	add.l	#320*256/8,d0
	dbf	d1,.loop2


	move.l	#c_pal,fader_copper
	move.l	#rotobump_pal,fader_original
	move.l	#rotobump_pal,fader_target
	move.w	#1,fader_steps
	move.w	#255,fader_colors
	jsr	fader_makecopper
	jsr	fader_initcrossfade
	jsr	fader_setpalette


	move.l	#c_pal,fader_copper
	move.l	#blackpal,fader_target
	move.l	#rotobump_pal,fader_original
	move.w	#6,fader_steps
	move.w	#255,fader_colors
	jsr	fader_initcrossfade

	move.l	#c_roto,$dff080

	jsr	rotobump_setup
	move.l	#rotobump_lv3,lv3_vblank

.loop1	jsr	c2p_cpu
	jsr	rotobump_draw

	cmp.w	#29,p61_pos
	blt	.nomove
	move.l	#091,roto_xspd0
	move.l	#023,roto_zspd0
	move.l	#027,roto_ypspd
.nomove


	tst.l	salir
	bne	.exit
	cmp.w	#32,p61_pos
	blt	.loop1

.exit
	bsr	c2p_wait
	clr.l	lv3_vblank
	clr.l	lv3_blit
	clr.l	lv3_copper
	rts

wid	set	320
hei	set	192/2

roto_xspd0	dc.l	0			; velocidad de giro
roto_zspd0	dc.l	0
roto_ypspd	dc.l	0

roto_xang0	dc.l	0
roto_xang1	dc.l	0

roto_zang0	dc.l	0
roto_zang1	dc.l	0

roto_xpang	dc.l	0
roto_ypang	dc.l	0
roto_xlang	dc.l	0
roto_ylang	dc.l	0

roto_xpos	dc.l	0
roto_ypos	dc.l	0
roto_xlpos	dc.l	0
roto_ylpos	dc.l	0

xpspd	set	30
xlspd	set	33
ylspd	set	29

zacc	set	64-8
zspd0	set	4096

rotobump_lv3
		cmp.w	#31,p61_pos
		bne	.nofade
		cmp.w	#48,p61_crow
		blt	.nofade
		jsr	fader_setpalette
.nofade

		move.l	roto_xspd0,d0			; angulo de giro
		add.l	d0,roto_xang0

		move.l	roto_zspd0,d0			; angulo de zoom
		add.l	d0,roto_zang0

		move.l	roto_ypspd,d0			; scroll vertical
		add.l	d0,roto_ypang

		add.l	#xpspd,roto_xpang		; mueve el scroll pal lado

		add.l	#xlspd,roto_xlang		; mueve la luz
		add.l	#ylspd,roto_ylang

		lea	sinus,a6
		move.l	#16383,d7

		moveq.l	#8,d6
		move.l	roto_xpang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asl.l	d6,d0
		move.l	d0,roto_xpos

		move.l	roto_ypang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asl.l	d6,d0
		move.l	d0,roto_ypos

		moveq.l	#8,d6
		move.l	roto_xlang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asr.l	d6,d0
		move.l	d0,roto_xlpos

		move.l	roto_ylang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asr.l	d6,d0
		move.l	d0,roto_ylpos

		rts

rotobump_draw	lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		move.l	roto_xang0(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asr.l	#5,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d3
		add.w	#4096,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d2

		move.l	roto_zang0(pc),d4
		and.l	d7,d4
		move.l	(a6,d4.l*4),d0
		add.l	#$18000,d0
		asr.l	#1,d0

		muls.l	d0,d5:d2
		move.w	d5,d2
		swap	d2

		muls.l	d0,d5:d3
		move.w	d5,d3
		swap	d3

		move.l	#-wid/2,d0
		move.l	#-hei/1,d5
		muls.l	d2,d0
		muls.l	d3,d5
		sub.l	d5,d0

		move.l	#-wid/2,d1
		move.l	#-hei/1,d5
		muls.l	d3,d1
		muls.l	d2,d5
		add.l	d5,d1

		add.l	roto_xpos(pc),d0
		add.l	roto_ypos(pc),d1

		move.l	c2p__chunky,a6
		lea	rotobump_texture,a5
		lea	rotobump_phong_,a4
		lea	rotobump_shade,a3
		lea	rotobump_bump_,a2

		move.l	roto_xlpos(pc),d6
		move.l	roto_ylpos(pc),d7
		lsl.l	#8,d7
		move.b	d6,d7
		and.l	#$ffff,d7
		add.l	d7,a4

		move.l	d2,d5
		move.l	d3,d4
		neg.l	d4

		add.l	d4,d4
		add.l	d5,d5

rotobump_drawtiled
		move.l	d2,d6
		asl.l	#3,d6
		move.l	d6,rotobump_dudxt

		move.l	d3,d6
		asl.l	#3,d6
		move.l	d6,rotobump_dvdxt

		swap	d2
		swap	d3
		swap	d4
		swap	d5

		rol.l	#8,d3
		rol.l	#8,d5

		move.w	d2,d6
		move.w	d4,d7
		move.w	d5,d4
		move.w	d3,d2
		move.w	d6,d3
		move.w	d7,d5

		move.l	d2,a0
		move.l	d4,rotobump_dudy

		move.w	#(wid/8)-1,d7
.xtloop
		movem.l	d0/d1/d7/a6,-(sp)
		bsr.b	.drawcolumn8
		movem.l	(sp)+,d0/d1/d7/a6

		add.l	rotobump_dudxt(pc),d0
		add.l	rotobump_dvdxt(pc),d1
		lea	8(a6),a6

		dbra	d7,.xtloop
		rts

.drawcolumn8	move.l	#$00ffffff,d6
		and.l	d6,d0
		and.l	d6,d1

		swap	d0
		swap	d1

		rol.l	#8,d1

		move.w	d0,d6
		move.w	d1,d0
		move.w	d6,d1

		moveq.l	#0,d6
		moveq.l	#0,d4

		move.w	#hei-1,d7
.yloop		movem.l	d0/d1,-(sp)

		rept	8
		move.w	d0,d6
		add.l	a0,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	d6,d4
		add.w	(a2,d6.l*2),d4
		move.w	(a4,d4.l),d4
		move.b	(a5,d6.l),d4
		move.b	(a3,d4.l),(a6)+
		endr

		movem.l	(sp)+,d0/d1
		lea	(wid-8)(a6),a6
		add.l	rotobump_dudy(pc),d0
		addx.l	d5,d1
		dbra	d7,.yloop
		rts

rotobump_dudy	dc.l	0
rotobump_dudxt	dc.l	0
rotobump_dvdxt	dc.l	0

		cnop	0,16
rotobump_setup	lea	rotobump_phong,a0
		lea	rotobump_phong_,a1
		move.l	#256*256,d7
		lea	(a1,d7.l),a2

.loop1		move.l	(a0)+,d0
		move.l	d0,(a1)+
		move.l	d0,(a2)+
		subq.l	#4,d7
		bgt.b	.loop1

		lea	rotobump_bump,a0
		lea	rotobump_bump_,a1

		move.w	#255,d7
.yloop		move.w	#255,d6
.xloop		moveq.l	#0,d0

		move.b	d7,d0
		move.b	d6,d1
		sub.b	#1,d0
		lsl.w	#8,d0
		move.b	d1,d0
		lea	(a0,d0.l),a2

		move.b	d7,d0
		move.b	d6,d1
		add.b	#1,d0
		lsl.w	#8,d0
		move.b	d1,d0
		lea	(a0,d0.l),a3

		move.b	d7,d0
		move.b	d6,d1
		sub.b	#1,d1
		lsl.w	#8,d0
		move.b	d1,d0
		lea	(a0,d0.l),a4

		move.b	d6,d0
		move.b	d7,d1
		add.b	#1,d1
		lsl.w	#8,d0
		move.b	d1,d0
		lea	(a0,d0.l),a5

		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3

		move.b	(a2),d0
		move.b	(a3),d1
		move.b	(a5),d2
		move.b	(a4),d3

		sub.w	d0,d1
		sub.w	d2,d3

		asl.b	#1,d1
		asl.b	#1,d3

		lsl.w	#8,d3
		move.b	d1,d3
		ror.w	#8,d3

		move.b	d6,d0
		move.b	d7,d1
		lsl.w	#8,d0
		move.b	d1,d0
		move.w	d3,(a1,d0.l*2)

		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

changestuff	dc.w	0
timer		dc.w	0


rotobump_pal	incbin	txt3.pal

plsize	set	wid*hei/8
plsiz2	set	plsize*2

c2p_wait	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	lea.l	c2p__chunky(pc),a0
	movem.l	(a0),a5-a6
	move.l	a6,(a0)+
	move.l	a5,(a0)+

	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4
	lea	plsiz2(a4),a3
	lea	plsiz2(a3),a2
	lea	plsiz2(a2),a1

	move.l	a7,c2p_stack

	move.l	-(a3),a7
	move.l	-(a2),a0
	move.l	-(a1),d7

	move.l	#$0f0f0f0f,d4
	move.l	#$00ff00ff,d5
	move.l	#$55555555,d6

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	rotobump_chunky1
c2p__chunky_	dc.l	rotobump_chunky2
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2
c2p__planes__	dc.l	planes3
c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

	cmp.l	a5,a6
	bcs	c2p_loop

	move.l	d7,(a1)+
	move.l	a0,(a2)+
	move.l	a7,(a3)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	move.l	#c2p_blit2,lv3_blit

	lea	$dff000,a6

	moveq.l	#-1,d0
	moveq.l	#2,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	add.l	#(4*wid*hei/8)-2,a1

	move.l	a0,$50(a6)		; orig 1
	subq.l	#2,a0
	move.l	a0,$4c(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#$cccc,$70(a6)
	move.l	#$eDE40000,$40(a6)

	move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts


c2p_blit2	move.l	#c2p_blit3,lv3_blit

	lea	$dff000,a6
	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	move.l	a0,$50(a6)		; orig 1
	addq.l	#2,a0
	move.l	a0,$4C(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$0DE42000,$40(a6)

	move.w	#4*wid*hei/16,$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts

c2p_blit3	clr.l	c2p_proceed
	clr.l	lv3_blit
	rts

c2p_dbuff	movem.l	c2p__bltbuf,a0-a1
	exg.l	a0,a1
	movem.l	a0-a1,c2p__bltbuf

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d2
	move.l	d2,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	;move.w	#$555,$dff180
	wrast	255
	;move.w	#$000,$dff180

	lea	c_bpls,a0
	move.l	c2p__planes_,d0
	moveq.l	#7,d7

.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#wid*hei/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop
	rts

			cnop	0,16
;rotobump_texture	incbin	'chk.txt3'
;rotobump_phong		incbin	'chk.phong'
;rotobump_shade		incbin	'bin.shade'
;rotobump_bump		incbin	'chk.bump'

	section	data_c,data_c

	cnop	0,64
c_roto	dc.w	$1fc,$400f
	dc.w	$100,$0201

	dc.w	$1007,$fffe
c_pal	ds.b	2112		;	incbin	'pal.txt3'

c_bpls	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0
	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

sprite	set	$120
c_roto_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

yst set $100-2*hei
	dc.w	$08e,$0081|(yst<<8)
	dc.w	$090,$00c1

	dc.w	$092,4*14
	dc.w	$094,4*44

	dc.w	$100,$0201|$0010
	dc.w	$102,$0000
	dc.w	$104,$0024
	dc.w	$106,$0000
	dc.w	$10c,$0000

	dc.w	$108,-40
	dc.w	$10a,0

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
