
		machine	68030

		opt	l+,c-

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	recursive_chunky1

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit
		XREF	P61_Pos

		XREF	salir

		XDEF	_ck_8bit_gfx

		XDEF	recursive_main



		section	recursive,code

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

recursive_main
		RESET_SPRITES	c_recur_spr

		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		lea	c_recur_bpls,a0
		move.l	#planes1,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*256,d0
		addq.l	#8,a0
		dbra	d7,.sloop


		move.l	#c_recur,$dff080
	
		clr.l	lv3_blit
		move.l	#recursive_lv3,lv3_vblank
		move.l	#swap_screens,lv3_copper

.loop1		jsr	recurc2p_cpu

		bsr	recur
		bsr	copy

		tst.l	salir
		bne	.salrecursive
		cmp.w	#22,p61_pos	; 30
		blt.b	.loop1
.salrecursive	clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


		CNOP	0,16
recursive_lv3
		add.w	#5,ang1
		add.w	#9,ang2
		add.w	#42,zoom	;move.w	#360,zoom
		add.w	#60,scroll
		rts

;------------------------------------------------------------------
		CNOP	0,16

copy		move.l	_ck_8bit_gfx,a0
		adda.l	#(256*64+48),a0
		move.l	_ck_8bit_buffer,a1
		move.l	#(128)-1,d1

		;move.l	#$7f7f7f7f,d2

.loop
		rept	(160/4)
		move.l	(a1)+,(a0)+
		endr

		add.l	#(256-160),a0
		dbf	d1,.loop
		rts

;------------------------------- Rotater ----------------------------
V	equ	128
H	equ	160


		CNOP	0,16

recur		lea	sinus_,a5
		move.w	#$7fe,d4

		move.w	ang1,d1
		and.w	d4,d1
		move.w	(a5,d1.w),d0

		move.w	ang2,d1
		and.w	d4,d1
		add.w	(a5,d1.w),d0

		asr.w	#1,d0
		add.w	#512-32,d0
		and.w	d4,d0

		move.w	(a5,d0.w),d1	;seno(a)*256
		addi.w	#512,d0
		and.w	d4,d0
		move.w	(a5,d0.w),d2	;coseno(a)*256

		move.w	zoom,d0
		and.w	d4,d0
		move.w	(a5,d0.w),d3	;seno(zoom)*256

		asr.w	#5,d3
		add.l	#270,d3

		muls	d3,d1		;seno(a)*seno(zoom)*256
		muls	d3,d2		;coseno(a)*seno(zoom)*256
			
		lsr.l	#8,d1		;/256
		lsr.l	#8,d2		;/256
		
		move.w	#-H/2,d4
		move.w	#-V/2,d5
		muls	d2,d4
		muls	d1,d5
		add.l	d5,d4		;v/2*cos(a)-h/2*sin(a)
		move.w	scroll,d3
		andi.w	#$7fe,d3
		move.w	(a5,d3.w),d3
		ext.l	d3
		asl.l	#2,d3
		add.l	d3,d4

		move.w	#-H/2,d5
		move.w	#V/2,d6
		muls	d1,d5
		muls	d2,d6
		add.l	d6,d5		;-v/2*sin(a)+h/2*cos(a)
		move.w	scroll,d3
		andi.w	#$7fe,d3
		move.w	(a5,d3.w),d3
		ext.l	d3
		asl.l	#2,d3
		add.l	d3,d5
		
		move.w	d4,a2
		move.w	d5,a3


		move.l	_ck_8bit_buffer,a0
		move.l	_ck_8bit_gfx,a1
		adda.l	#(256*v)+128,a1

		moveq.l	#0,d3
;		sub.l	a4,a4

		move.l	d1,a4
		move.l	d2,a5

		moveq.l	#0,d1
		moveq.l	#0,d2
		nop
		nop

		move.w	#V-1,d0
.yloop		move.w	a2,d6
		move.w	a3,d7
		adda.l	a4,a2
		suba.l	a5,a3

		moveq.l	#(h/8)-1,d5
.xloop
		rept	8
		move.w	d6,d4
		move.w	d7,d3
		lsr.w	#8,d3
		move.b	d3,d4

		move.b	(a1,d4.w),d3
		add.b	(a0),d3
		roxr.b	#1,d3
		move.b	d3,(a0)+

;		move.b	(a1,d4.w),(a0)+

;		move.b	(a1,d4.w),d3
;		add.b	(-2-256,a0),d3
;		roxr.b	#1,d3
;		move.b	d3,(a0)+


		add.l	a5,d6
		add.l	a4,d7
		endr
	
		dbf	d5,.xloop
		dbf	d0,.yloop
		rts
;--------------------------------------------------------------------


plsize	set	2*160*128/8
plsiz2	set	2*plsize*2

recurc2p_wait	BWAIT
		tst.b	recurc2p_proceed
		bne.b	recurc2p_wait
		rts

recurc2p_cpu		move.l	recurc2p__chunky(pc),a6
		move.l	recurc2p_pixels(pc),a5
		add.l	a6,a5

		move.l	recurc2p__bltbuf_(pc),a4

		move.l	a7,recurc2p_stack

		move.l	#$00ff00ff,d7
		move.l	#$0f0f0f0f,d6
		move.l	#$33333333,d5

		move.l	-(a4),a2
		move.l	-(a4),a1
		move.l	-(a4),d4

		bra.b	recurc2p_loop

recurc2p_data
recurc2p__chunky	dc.l	recursive_chunky1
recurc2p__chunky_	dc.l	recursive_chunky1

recurc2p__planes	dc.l	planes1
recurc2p__planes_	dc.l	planes2
recurc2p__planes__	dc.l	planes3

recurc2p__bltbuf	dc.l	bltbuf1
recurc2p__bltbuf_	dc.l	bltbuf2

recurc2p_stack	dc.l	0
recurc2p_pixels	dc.l	160*128
recurc2p_proceed	dc.l	0

		cnop	0,16
recurc2p_loop	move.l	(a6)+,d0
		move.l	(a6)+,d1
		move.l	(a6)+,d2
		move.l	(a6)+,d3

		;word	d0,d2,d4
		;word	d1,d3,d4
		;merge	d0,d1,d4,d7,8
		;merge	d2,d3,d4,d7,8
		;merge	d0,d2,d4,d6,4
		;merge	d1,d3,d4,d6,4
		;merge	d0,d1,d4,d5,2
		;merge	d2,d3,d4,d5,2

				move.l	d4,(a4)+

		swap    d2	;  4
		move.w  d0,d4	;  6
		move.w  d2,d0	;  8
		move.w  d4,d2	; 10
		swap    d2	; 14

		swap    d3	; 18
		move.w  d1,d4	; 20
		move.w  d3,d1	; 22
		move.w  d4,d3	; 24
		swap    d3	; 28

				move.l	a1,(a4)+

		move.l  d2,d4
		lsr.l   #4,d4
		eor.l   d0,d4
		and.l   d6,d4
		eor.l   d4,d0
		lsl.l   #4,d4
		eor.l   d4,d2

		move.l  d3,d4
		lsr.l   #4,d4
		eor.l   d1,d4
		and.l   d6,d4
		eor.l   d4,d1
		lsl.l   #4,d4
		eor.l   d4,d3

				move.l	a2,(a4)+

		move.l  d1,d4
		lsr.l   #8,d4
		eor.l   d0,d4
		and.l   d7,d4
		eor.l   d4,d0
		lsl.l   #8,d4
		eor.l   d4,d1

		move.l  d3,d4
		lsr.l   #8,d4
		eor.l   d2,d4
		and.l   d7,d4
		eor.l   d4,d2
		lsl.l   #8,d4
		eor.l   d4,d3

		move.l  d1,d4
		lsr.l   #2,d4
		eor.l   d0,d4
		and.l   d5,d4
		eor.l   d4,d0
				move.l	d0,(a4)+
		lsl.l   #2,d4	;  4
		eor.l   d4,d1	;  6
				move.l	d1,a1

		move.l  d3,d4	;  8
		lsr.l   #2,d4	; 12
		eor.l   d2,d4	; 14
		and.l   d5,d4	; 16
		eor.l   d4,d2	; 18
		lsl.l   #2,d4	; 22
		eor.l   d3,d4	; 24

				move.l	d2,a2

		cmp.l	a5,a6
		bne	recurc2p_loop

		move.l	d4,(a4)+
		move.l	a1,(a4)+
		move.l	a2,(a4)+

		move.l	recurc2p_stack,a7

		bsr	recurc2p_wait
		st	recurc2p_proceed

		bsr	recurc2p_dbuff

		lea	$dff000,a6

plsize set 320*128/8

		moveq.l	#-1,d0
		moveq.l	#12,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	d0,$44(a6)
		move.l	#$0DE41000,$40(a6)

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		addq.l	#4,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#(plsize/4),$5c(a6)	; size_v
		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_2,lv3_blit
		rts

recurc2p_blit_2	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#plsize,a1
		addq.l	#4,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_3,lv3_blit
		rts

recurc2p_blit_3	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#plsize*2,a1
		add.l	#12,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_4,lv3_blit
		rts

recurc2p_blit_4	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#3*plsize,a1
		add.l	#12,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_5,lv3_blit
		rts

recurc2p_blit_5	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#4*plsize,a1
		addq.l	#8,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_6,lv3_blit
		rts

recurc2p_blit_6	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#5*plsize,a1
		addq.l	#8,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_7,lv3_blit
		rts

recurc2p_blit_7	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#6*plsize,a1

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_8,lv3_blit
		rts

recurc2p_blit_8	lea	$dff000,a6

		move.l	recurc2p__bltbuf,a0
		move.l	recurc2p__planes,a1
		add.l	#7*plsize,a1

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#recurc2p_blit_end,lv3_blit
		rts

recurc2p_blit_end	clr.l	recurc2p_proceed
		clr.l	lv3_blit

		lea	recurc2p__planes(pc),a0
		movem.l	(a0),d0-d2
		move.l	d1,(a0)+
		move.l	d2,(a0)+
		move.l	d0,(a0)+

		move.l	d0,newplanes
		rts

recurc2p_dbuff	lea	recurc2p__chunky(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		lea	recurc2p__bltbuf(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)
		rts

newplanes	dc.l	planes1

swap_screens	move.l	newplanes(pc),d0

		lea	c_recur_bpls,a0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*128,d0
		addq.l	#8,a0
		dbra	d7,.sloop
		rts

pl_8bit_buffer	dc.l	0
_ck_8bit_buffer	dc.l	recursive_chunky1
_ck_8bit_gfx	dc.l	0		;incbin	'recursive/chk.plasma'
sinus_		include	'recursive/sinuslist.s'

ang1		dc.w	0
ang2		dc.w	0
zoom		dc.w	0
sinang		dc.w	0
scroll		dc.w	0
counter		dc.w	0



		section	recursive,data_c

		cnop	0,64
c_recur		dc.w	$1fc,$4007
		dc.w	$100,$0201

sprite		set	$120
c_recur_spr
		dc.w	sprite,   0,sprite+2, 0
		dc.w	sprite+4, 0,sprite+6, 0
		dc.w	sprite+8, 0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

		dc.w $08e,$2881,$090,$28C1	* DIWindow Size YX
		dc.w $092,$0038,$094,$00D0	* DDFetch

		incbin	'recursive/pal.plasma'

		dc.w	$100,$0201|$0010
		dc.w	$102,$0010
		dc.w	$104,$0200
		dc.w	$106,$0020

		dc.w	$108,-48
		dc.w	$10a,-8

c_recur_bpls	dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

		dc.w	$fe3f,$fffe
		dc.w	$9c,$8010		; set copper

		dc.l	-2,-2


		cnop	0,16
spr_off		ds.l	8
