		opt	p=68030,c-

	include	'macros/macros.gs'
;	include	'lvo.gs'
	include	'exec/execbase.i'

InitSys	bsr	OSout			; Quitamos el control al Amiga OS
	bsr	Main			; Nuestro PROGRAMA !!!
	bsr	OSin			; Devolvemos el control al Amiga OS
	rts				; ADIOS !!!

OSout	movea.l	4.w,a6			; System Base
	lea	GfxLib,a1
	moveq	#0,d0
	jsr	-552(a6)		; OpenLibrary
	move.l	d0,GfxBase		; Save Graphics_lib base
	move.l	d0,a6
	move.l	38(a6),OldCopper	; gb_CopInit	Sys Copper
	move.l	34(a6),OldView		; gb_ActiView	Sys View
	jsr	-456(a6)		; Own Blitter
	lea	0.w,a1			;LoadView Null
	jsr	-222(a6)		;LoadView

	move.w	#(10*1)-1,d7
.loop	jsr	-270(a6)		; lots of WaitTOF
	dbra	d7,.loop

	movea.l	4.w,a6			; System Base
	jsr	-132(a6)		; Forbid
	jsr	-150(a6)		; SuperState
	move.l	d0,SysStack		; System stack
	btst.b	#0,$129(a6)		; are we at least 68010? ($129=AttnFlags+1)
	beq.b	.68000			; nope.
	dc.w	$4e7a,$0801		;=movec.l vbr,d0 ; pero MDevPac no lo acepta
	move.l	d0,VectorBase		; Get Real VBR

.68000
	move.l	SysStack,d0		; Systemstack
	jsr	-156(a6)		; UserState

	move	$dff01c,IntEnaR		; Initialize custom chips
	move	$dff01e,IntReqR		; Save old valours first
	move	$dff002,DmaConR
	move	$dff010,AdkConR
	move	#%0111111111111111,$dff09a	; INTENA
	move	#%1100000001010000,$dff09a	* Enable desired IRQs
.Spr	move.l	$dff004,D0			; Wait RASTER to
	and.l	#$0001FF00,D0			; disable SPRITES
	bne.b	.Spr
	move	#%0111111111111111,$dff096	; DMACONW
	move	#%1000001111000000,$dff096	* Enable desired DMAs

	move	$dff07c,d0			;Ponerlo en/antes/despues de Copper?
	cmp.b	#$f8,d0
	bne.b	.NotAGA				; Not AGA
	move	#0,$dff1fc			* Fix AGA Res     (Ponerlo en Copper?)

.NotAGA	move.l	VectorBase,a0
	move.l	$6c(a0),Int3Save		; Save level 3 vector
	move.l	#level3,$6c(a0)			; Set OUR! own interrupt
	rts

OSin	move.l	VectorBase,a0
	move.l	Int3Save,$6c(a0)	; Reset Interrupts

	move	IntEnaR,d7		; Reset custom chips
	bset	#$f,d7
	move	d7,$dff09a		; Reset Interrupts

	move	IntReqR,d7
	bset	#$f,d7
	move	d7,$dff09c		; Reset interrupt request

	move	DmaConR,d7
	bset	#$f,d7
	move	d7,$dff096		; Reset DMAConw

	move	AdkConR,d7
	bset	#$f,d7
	move	d7,$dff09e		; Reset ADK

	move.l	GfxBase,a6
	movea.l	OldView,a1
	jsr	-222(a6)		;LoadView
	move.l	OldCopper,$dff080	; Reset System Copper
	jsr	-462(a6)		; DisOwn Blitter

	movea.l	4.w,a6			; System Base
	move.l	GfxBase,a1		; Close Graphics_lib
	jsr	-414(a6)		; CloseLibrary
	jsr	-138(a6)		; Permit

	move.l	timing_speed,d0
	rts

GfxLib		dc.b	"graphics.library",0,0
GfxBase		dc.l	0
IntEnaR		dc.w	0
IntReqR		dc.w	0
DmaConR		dc.w	0
AdkConR		dc.w	0
SysStack	dc.l	0
Int3Save	dc.l	0
OldCopper	dc.l	0
OldView		dc.l	0
VectorBase	dc.l	0

***************** INTERRUPCION

wrast		macro
.wr1\@		cmp.b	#\1,$dff006
		bne.b	.wr1\@
.wr2\@		cmp.b	#\1,$dff006
		beq.b	.wr2\@
		endm

wmouse		macro
.wm1\@	btst	#6,$bfe001
		bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
		beq.b	.wm2\@
		endm

resetcopper	macro
		bsr	off_sprites
		endm

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	lv3_blit,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)

.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		rte

.noblit		btst	#4,d0
		beq.b	.nocopper

		jsr	swap_screens

		move.l	lv3_vblank,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)
.no1

		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		rte

lv3_vblank	dc.l	0
lv3_blit	dc.l	0

timer_old	dc.l	0
timer_new	dc.l	0
timer_diff	dc.l	0
timer_ref	dc.l	0

gettime		sub.l	d0,d0
		move.b	$bfea01,d0
		lsl.l	#8,d0
		move.b	$bfe901,d0
		lsl.l	#8,d0
		move.b	$bfe801,d0

		move.l	timer_new,d1
		move.l	d1,timer_old
		move.l	d0,timer_new
		sub.l	d1,d0
		move.l	d0,timer_diff
		rts

main		bsr	roto
		rts

roto		move.l	#c_roto,$dff080


.loop1		;move.w	#$fff,$dff180
		;wrast	255
		;move.w	#$000,$dff180

		jsr	c2p_cpu

		add.w	#5,ang1
		add.w	#9,ang2
		add.w	#42,zoom	;move.w	#360,zoom
		add.w	#60,scroll

		bsr	Rotater

		bsr	copy
;		CHECKRASTER		
;		VBEAMWAIT 255
;		bsr	DBuffer

		btst	#6,$bfe001
		bne	.loop1

		moveq.l	#24,d7
.loop2		wrast	255
		dbra	d7,.loop2
		rts

;------------------------------------------------------------------
		CNOP	0,8

copy		lea	ck_8bit_gfx+(256*64+48),a0
		move.l	ck_8bit_buffer,a1
		move.l	#(128)-1,d1

		move.l	#$7f7f7f7f,d2

.loop
		rept	(160/4)
		move.l	(a1)+,(a0)+
		endr

		add.l	#(256-160),a0
		dbf	d1,.loop
		rts

;------------------------------- Rotater ----------------------------
V	equ	128
H	equ	160

wid set h
hei set v


;V	equ	200
;H	equ	320

		CNOP	0,8

Rotater		lea	sinus,a5
		move.w	#$7fe,d4

		move.w	ang1,d1
		and.w	d4,d1
		move.w	(a5,d1.w),d0

		move.w	ang2,d1
		and.w	d4,d1
		add.w	(a5,d1.w),d0

		asr.w	#1,d0
		add.w	#512-32,d0
		and.w	d4,d0

		move.w	(a5,d0.w),d1	;seno(a)*256
		addi.w	#512,d0
		and.w	d4,d0
		move.w	(a5,d0.w),d2	;coseno(a)*256

		move.w	zoom,d0
		and.w	d4,d0
		move.w	(a5,d0.w),d3	;seno(zoom)*256

		asr.w	#5,d3
		add.l	#270,d3

		muls	d3,d1		;seno(a)*seno(zoom)*256
		muls	d3,d2		;coseno(a)*seno(zoom)*256
			
		lsr.l	#8,d1		;/256
		lsr.l	#8,d2		;/256
		
		move.w	#-H/2,d4
		move.w	#-V/2,d5
		muls	d2,d4
		muls	d1,d5
		add.l	d5,d4		;v/2*cos(a)-h/2*sin(a)
		move.w	scroll,d3
		andi.w	#$7fe,d3
		move.w	(a5,d3.w),d3
		ext.l	d3
		asl.l	#2,d3
		add.l	d3,d4

		move.w	#-H/2,d5
		move.w	#V/2,d6
		muls	d1,d5
		muls	d2,d6
		add.l	d6,d5		;-v/2*sin(a)+h/2*cos(a)
		move.w	scroll,d3
		andi.w	#$7fe,d3
		move.w	(a5,d3.w),d3
		ext.l	d3
		asl.l	#2,d3
		add.l	d3,d5
		
		move.w	d4,a2
		move.w	d5,a3


		move.l	ck_8bit_buffer,a0
		lea	ck_8bit_gfx+((256*v)+128),a1

		moveq.l	#0,d3
;		sub.l	a4,a4

		move.l	d1,a4
		move.l	d2,a5

		moveq.l	#0,d1
		moveq.l	#0,d2
		nop
		nop

		move.w	#V-1,d0
.yloop		move.w	a2,d6
		move.w	a3,d7
		adda.l	a4,a2
		suba.l	a5,a3

		moveq.l	#(h/8)-1,d5
.xloop
		rept	8
		move.w	d6,d4
		move.w	d7,d3
		lsr.w	#8,d3
		move.b	d3,d4

		move.b	(a1,d4.w),d3
		add.b	(a0),d3
		roxr.b	#1,d3
		move.b	d3,(a0)+

;		move.b	(a1,d4.w),(a0)+

;		move.b	(a1,d4.w),d3
;		add.b	(-2-256,a0),d3
;		roxr.b	#1,d3
;		move.b	d3,(a0)+


		add.l	a5,d6
		add.l	a4,d7
		endr
	
		dbf	d5,.xloop
		dbf	d0,.yloop
		rts
;--------------------------------------------------------------------


plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	BWAIT
		tst.b	c2p_proceed
		bne.b	c2p_wait
		rts

rotozoom_test	ds.b	160*128		;incbin	'chk.test'

c2p_cpu		move.l	c2p__chunky(pc),a6
		move.l	c2p_pixels(pc),a5
		add.l	a6,a5

		move.l	c2p__bltbuf_(pc),a4

		move.l	a7,c2p_stack

		move.l	#$00ff00ff,d7
		move.l	#$0f0f0f0f,d6
		move.l	#$33333333,d5

		move.l	-(a4),a2
		move.l	-(a4),a1
		move.l	-(a4),d4

		bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	rotozoom_test
c2p__chunky_	dc.l	rotozoom_test

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2
c2p__planes__	dc.l	planes3

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	160*128
c2p_proceed	dc.l	0

merge		macro
		move.l	\2,\3
		lsr.l	#\5,\3
		eor.l	\1,\3
		and.l	\4,\3
		eor.l	\3,\1
		ifnc	'','\6'
		move.l	\1,\6
		endc
		lsl.l	#\5,\3
		eor.l	\3,\2
		endm

wordmerge	macro
		move.l	\1,\3
		swap	\2
		move.w	\2,\1
		move.w	\3,\2
		swap	\2
		endm

		cnop	0,16
c2p_loop	move.l	(a6)+,d0
		move.l	(a6)+,d1
		move.l	(a6)+,d2
		move.l	(a6)+,d3

		;word	d0,d2,d4
		;word	d1,d3,d4
		;merge	d0,d1,d4,d7,8
		;merge	d2,d3,d4,d7,8
		;merge	d0,d2,d4,d6,4
		;merge	d1,d3,d4,d6,4
		;merge	d0,d1,d4,d5,2
		;merge	d2,d3,d4,d5,2

				move.l	d4,(a4)+

		swap    d2	;  4
		move.w  d0,d4	;  6
		move.w  d2,d0	;  8
		move.w  d4,d2	; 10
		swap    d2	; 14

		swap    d3	; 18
		move.w  d1,d4	; 20
		move.w  d3,d1	; 22
		move.w  d4,d3	; 24
		swap    d3	; 28

				move.l	a1,(a4)+

		move.l  d2,d4
		lsr.l   #4,d4
		eor.l   d0,d4
		and.l   d6,d4
		eor.l   d4,d0
		lsl.l   #4,d4
		eor.l   d4,d2

		move.l  d3,d4
		lsr.l   #4,d4
		eor.l   d1,d4
		and.l   d6,d4
		eor.l   d4,d1
		lsl.l   #4,d4
		eor.l   d4,d3

				move.l	a2,(a4)+

		move.l  d1,d4
		lsr.l   #8,d4
		eor.l   d0,d4
		and.l   d7,d4
		eor.l   d4,d0
		lsl.l   #8,d4
		eor.l   d4,d1

		move.l  d3,d4
		lsr.l   #8,d4
		eor.l   d2,d4
		and.l   d7,d4
		eor.l   d4,d2
		lsl.l   #8,d4
		eor.l   d4,d3

		move.l  d1,d4
		lsr.l   #2,d4
		eor.l   d0,d4
		and.l   d5,d4
		eor.l   d4,d0
				move.l	d0,(a4)+
		lsl.l   #2,d4	;  4
		eor.l   d4,d1	;  6
				move.l	d1,a1

		move.l  d3,d4	;  8
		lsr.l   #2,d4	; 12
		eor.l   d2,d4	; 14
		and.l   d5,d4	; 16
		eor.l   d4,d2	; 18
		lsl.l   #2,d4	; 22
		eor.l   d3,d4	; 24

				move.l	d2,a2

		cmp.l	a5,a6
		bne	c2p_loop

		move.l	d4,(a4)+
		move.l	a1,(a4)+
		move.l	a2,(a4)+

		move.l	c2p_stack,a7

		bsr	c2p_wait
		st	c2p_proceed

		bsr	c2p_dbuff

		lea	$dff000,a6

bwid set 320
bhei set 128
plsize set bwid*bhei/8

		moveq.l	#-1,d0
		moveq.l	#12,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	d0,$44(a6)
		move.l	#$0DE41000,$40(a6)

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		addq.l	#4,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#(plsize/4),$5c(a6)	; size_v
		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_2,lv3_blit
		rts

c2p_blit_2	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#plsize,a1
		addq.l	#4,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_3,lv3_blit
		rts

c2p_blit_3	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#plsize*2,a1
		add.l	#12,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_4,lv3_blit
		rts

c2p_blit_4	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#3*plsize,a1
		add.l	#12,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_5,lv3_blit
		rts

c2p_blit_5	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#4*plsize,a1
		addq.l	#8,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_6,lv3_blit
		rts

c2p_blit_6	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#5*plsize,a1
		addq.l	#8,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_7,lv3_blit
		rts

c2p_blit_7	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#6*plsize,a1

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_8,lv3_blit
		rts

c2p_blit_8	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#7*plsize,a1

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_end,lv3_blit
		rts

c2p_blit_end	clr.l	c2p_proceed
		clr.l	lv3_blit

		lea	c2p__planes(pc),a0
		movem.l	(a0),d0-d2
		move.l	d1,(a0)+
		move.l	d2,(a0)+
		move.l	d0,(a0)+

		move.l	d0,newplanes
		addq.l	#1,timing_frame2
		rts

c2p_dbuff	lea	c2p__chunky(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		lea	c2p__bltbuf(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)
		rts

newplanes	dc.l	0

swap_screens	move.l	newplanes(pc),d0

		lea	c_bpls,a0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#plsize,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		addq.l	#1,timing_frame1
		rts

test_speed	move.l	c2p__chunky(pc),a0
		move.l	timing_frame1(pc),d0
		move.l	timing_frame2(pc),d1

		tst.l	d0
		beq.b	.no

		mulu.w	#wid,d1
		divs.l	d0,d1
		move.l	d1,timing_speed

		moveq.l	#0,d2

		move.l	a0,a1
		move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
		move.l	d2,(a1)+
		move.l	d2,(a1)+
		move.l	d2,(a1)+
		dbra	d7,.clrloop

		add.l	d1,a0
		add.l	#wid*2,a0

		move.w	#3,d7
.loop		movem.l	a0-a4,(a0)
		add.l	#wid,a0
		dbra	d7,.loop

.no		rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0

	 	section	c2pdata,data

pl_8bit_buffer	dc.l	0
ck_8bit_buffer	dc.l	rotozoom_test
ck_8bit_gfx	incbin	'chk.plasma'


		section	misc,data

sinus		include	'sinuslist.s'

ang1		dc.w	0
ang2		dc.w	0
zoom		dc.w	0
sinang		dc.w	0
scroll		dc.w	0

counter		dc.w	0

		section	chip,data_c

		cnop	0,64
c_roto		dc.w	$1fc,$4007
		dc.w	$100,$0201

		dc.w $08e,$2881,$090,$28C1	* DIWindow Size YX
		dc.w $092,$0038,$094,$00D0	* DDFetch

		incbin	'pal.plasma'

		dc.w	$100,$0201|$0010
		dc.w	$102,$0010
		dc.w	$104,$0200
		dc.w	$106,$0000

		dc.w	$108,-48
		dc.w	$10a,-8

c_bpls		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

		dc.w	$fe3f,$fffe
		dc.w	$9c,$8010		; set copper

		dc.l	-2,-2

		section	bbb,bss_c
		cnop	0,16
bltbuf1		ds.b	8*40*128
bltbuf2		ds.b	8*40*128
planes1		ds.b	8*40*128
planes2		ds.b	8*40*128
planes3		ds.b	8*40*128

		section	ccc,bss
		cnop	0,16
buffer1		ds.b	(1024*1024)

		BUFFER	1
		RESERVE	1,rotozoom_chunky1,(160*128)
		RESERVE	1,rotozoom_chunky2,(160*128)