		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	planes4
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	rotozoomrecur_chunky1
		XREF	rotozoomrecur_chunky2
		XREF	rotozoomrecur_freespace

		XREF	brush0
		XREF	brush1
		XREF	brush2
		XREF	brush3
		XREF	brush4
		XREF	brush5
		XREF	brush6
		XREF	brush7
		XREF	brush8
		XREF	brush9

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_steps
		XREF	fader_colors
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal
		XREF	blackpal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow
		XREF	p61_play

		XREF	salir

		XREF	sinus

		XDEF	roto_main

		incdir	'include:'

		IFND	EXEC_LIB_I
		include	exec/exec_lib.i
		ENDC

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC



		incdir	'recursive-intro'

		;section	recursiveintro,code
		section	code,code


wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

roto_main
	clr.l	lv3_vblank

	move.l	#planes2,d0
	lea	c_bpls,a0
	moveq.l	#7,d1
.loop2	addq.l	#2,a0
	swap	d0
	move.w	d0,(a0)+
	addq.l	#2,a0
	swap	d0
	move.w	d0,(a0)+
	add.l	#320*256/8,d0
	dbf	d1,.loop2

	bsr	setup
	move.l	#roto_lv3,lv3_vblank
	move.l	#c_roto,$dff080

	st	P61_Play

	;move.w	#144-16,fader_colors

.loop1	;move.l	4.w,a6
	;move.l	#1<<12,d0
	;move.l	d0,d1
	;jsr	_LVOCacheControl(a6)

	jsr	c2p_cpu
	jsr	morralla
	jsr	brushes
	jsr	rotozoomrecur

;	tst.l	mierdafade
;	beq	.nomierdafade
;	lea	conta,a0
;	cmp.w	#15,(a0)
;	bge	.nocodefade
;	add.w	#64,(1,a0)
;.nocodefade
;	bsr	sprites_up
;.nomierdafade

	;move.l	4.w,a6
	;move.l	#(1<<12),d1
	;moveq.l	#0,d0
	;jsr	_LVOCacheControl(a6)

	tst.l	salir
	bne	.exit
	
	tst.l	roto_counter
	bgt	.loop1

.exit	clr	P61_Play
	jsr	c2p_wait
	clr.l	lv3_vblank
	clr.l	lv3_blit
	clr.l	lv3_copper
	rts

mierdafade	dc.l	0

skip	set	64
wid	set	256
hei	set	256-skip

roto_counter	dc.l	3370

roto_xspd0	dc.l	40			; velocidad de giro
roto_zspd0	dc.l	0

roto_xang0	dc.l	0
roto_xang1	dc.l	0

roto_zang0	dc.l	0
roto_zang1	dc.l	0

roto_xpang	dc.l	0
roto_ypang	dc.l	0

roto_xpos	dc.l	0
roto_ypos	dc.l	0

roto_nmorralla	dc.w	15

xpspd	set	128
ypspd	set	096

zacc	set	64-8
zspd0	set	4096



roto_lv3
		subq.l	#1,roto_counter

		move.l	roto_xspd0,d0
		add.l	d0,roto_xang0

		move.l	roto_zspd0,d0
		add.l	d0,roto_zang0

		add.l	#zacc,roto_zspd0
		add.l	#xpspd,roto_xpang
		add.l	#ypspd,roto_ypang

		lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		moveq.l	#4,d6
		move.l	roto_xpang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		muls.l	roto_zspd0(pc),d1:d0
		move.w	d1,d0
		swap	d0
		asl.l	d6,d0
		move.l	d0,roto_xpos

		moveq.l	#3,d6
		move.l	roto_ypang(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		muls.l	roto_zspd0(pc),d1:d0
		move.w	d1,d0
		swap	d0
		asl.l	d6,d0
		move.l	d0,roto_ypos

		subq.w	#1,timer

		move.w	P61_CRow,d0
		cmp.w	.cmpval,d0
		bne.b	.noreset

		st	changestuff
		eor.w	#32,.cmpval

		move.l	palact(pc),fader_original
		move.l	palnew(pc),fader_target
		move.w	#6,fader_steps
		jsr	fader_initcrossfade
.noreset
		cmp.w	#5,p61_pos
		bne	.nop
		cmp.w	#59,p61_crow
		bne	.nop
		move.l	#pal1+12*256,fader_original
		move.l	#blackpal,fader_target
		move.w	#7,fader_steps
		jsr	fader_initcrossfade
.nop
		jsr	sprites
		jsr	fader_setpalette
		rts

.cmpval		dc.w	0

Sprites_up	
		lea	palettes,a0
		move.w	conta,d0
		mulu.w	#136,d0
		lea	(a0,d0.w),a0
		
		lea	c_pal+$420,a1
		
		addq.l	#4,a0
		addq.l	#4,a1
		
		rept	16
		move.l	(a0)+,(a1)+
		endr
		
		addq.l	#4,a0
		add.l	#62+6,a1
		
		rept	16
		move.l	(a0)+,(a1)+
		endr
		rts

conta		dc.w	0,0


rotozoomrecur	lea	sinus,a6
		move.l	#16383,d7
		moveq.l	#0,d6

		move.l	roto_xang0(pc),d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d0
		asr.l	#7,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d3
		add.w	#4096,d0
		and.l	d7,d0
		move.l	(a6,d0.l*4),d2

		move.l	roto_zang0(pc),d4
		asr.l	#8,d4
		and.l	d7,d4
		move.l	(a6,d4.l*4),d0
		asr.l	#2,d0
		neg.l	d0				; palante/patras
		add.l	#$10000,d0

		muls.l	d0,d5:d2
		move.w	d5,d2
		swap	d2

		muls.l	d0,d5:d3
		move.w	d5,d3
		swap	d3

		move.l	#-wid/2,d0
		move.l	#-hei/2,d5
		muls.l	d2,d0
		muls.l	d3,d5
		sub.l	d5,d0

		move.l	#-wid/2,d1
		move.l	#-hei/2,d5
		muls.l	d3,d1
		muls.l	d2,d5
		add.l	d5,d1

		add.l	#$808000,d0
		add.l	#$808000,d1
		sub.l	#(skip/2)<<16,d1

		add.l	roto_xpos(pc),d0
		add.l	roto_ypos(pc),d1

		movem.l	c2p__chunky,a5/a6
		move.l	a6,a4

		move.l	d2,d5
		move.l	d3,d4
		neg.l	d4

rotozoomrecur_drawtiled
		move.l	d2,d6
		asl.l	#4,d6
		move.l	d6,rotozoomrecur_dudxt

		move.l	d3,d6
		asl.l	#4,d6
		move.l	d6,rotozoomrecur_dvdxt

		swap	d2
		swap	d3
		swap	d4
		swap	d5

		rol.l	#8,d3
		rol.l	#8,d5

		move.w	d2,d6
		move.w	d4,d7
		move.w	d5,d4
		move.w	d3,d2
		move.w	d6,d3
		move.w	d7,d5

		move.l	d2,a2
		move.l	d4,a3
		move.l	#$fefefefe,d2

		move.w	#(wid/16)-1,d7
.xtloop
		movem.l	d0/d1/d7/a4/a5,-(sp)
		bsr.b	.drawcolumn16
		movem.l	(sp)+,d0/d1/d7/a4/a5

		add.l	rotozoomrecur_dudxt(pc),d0
		add.l	rotozoomrecur_dvdxt(pc),d1
		lea	16(a4),a4
		lea	16(a5),a5

		dbra	d7,.xtloop
		rts

.drawcolumn16	move.l	#$00ffffff,d6
		and.l	d6,d0
		and.l	d6,d1

		swap	d0
		swap	d1

		rol.l	#8,d1

		move.w	d0,d6
		move.w	d1,d0
		move.w	d6,d1

		moveq.l	#0,d6
		move.w	#hei-1,d7
.yloop
		move.l	d0,a0
		move.l	d1,a1

		rept	4

		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4
		move.w	d0,d6
		swap	d4
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.w	(a6,d6.l),d4
		move.w	d0,d6
		add.l	a2,d0
		move.b	d1,d6
		addx.l	d3,d1
		move.b	(a6,d6.l),d4

		add.l	(a4)+,d4
		and.l	d2,d4
		ror.l	#1,d4
		move.l	d4,(a5)+

		endr

		move.l	a0,d0
		move.l	a1,d1
		lea	(wid-16)(a4),a4
		lea	(wid-16)(a5),a5

		add.l	a3,d0
		addx.l	d5,d1

		dbra	d7,.yloop
		rts

rotozoomrecur_dudxt	dc.l	0
rotozoomrecur_dvdxt	dc.l	0

		cnop	0,16
morralla	move.l	c2p__chunky_,a0

		lea	((256*(hei/2))+(128))(a0),a0
		sub.l	#16+(256*16),a0

		movem.l	.random(pc),d0-d3
		moveq.l	#0,d4

		move.w	roto_nmorralla(pc),d7
.loop		add.w	d1,d0
		roxr.w	#1,d3
		eor.l	d2,d3
		swap	d0
		eor.l	d3,d1
		rol.l	#5,d2
		roxr.b	#3,d0
		swap	d1

		move.b	d0,d4
		lsl.w	#8,d4
		move.b	d1,d4
		and.w	#$1f1f,d4
		move.b	d3,(a0,d4.l)

		dbra	d7,.loop

		movem.l	d0-d3,.random
		rts
.random		dc.b	'tortuga ar shava sieso!'

makepal		macro
		move.l	#\1,d0
		bsr	.makepal
		endm

		cnop	0,16
setup		move.l	#c_pal,fader_copper
		move.l	#whitepal,fader_original
		move.l	#whitepal,fader_target
		move.w	#1,fader_steps
		move.w	#144,fader_colors
		jsr	fader_makecopper

		lea	pal1,a0

		makepal	$00ff00
		makepal	$ff7f00
		makepal	$40c0ff
		makepal	$8040c0
		makepal	$ff007f
		makepal	$007fff
		makepal	$c0ffc0
		makepal	$8040c0
		makepal	$00ff00
		makepal	$ff7f00
		makepal	$40c0ff
		makepal	$8040c0
		rts

.makepal	move.l	d0,d1
		move.l	d0,d2
		and.l	#$ff0000,d0
		and.l	#$00ff00,d1
		and.l	#$0000ff,d2
		lsr.l	#7,d0
		lsl.l	#1,d1
		lsl.l	#8,d2
		lsl.l	#1,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		move.w	#127,d7
.loop		clr.b	(a0)+
		swap	d3
		move.b	d3,(a0)+
		swap	d3
		swap	d4
		move.b	d4,(a0)+
		swap	d4
		swap	d5
		move.b	d5,(a0)+
		swap	d5
		add.l	d0,d3
		add.l	d1,d4
		add.l	d2,d5
		dbra	d7,.loop
		move.l	#$00ffffff,-04(a0)

b		set	0
a		set	0
		rept	16
		move.l	#b,a(a0)
b		set	b+$00111111
a		set	a+4
		endr

		add.l	#4*128,a0
		rts

		cnop	0,16
pal1		ds.l	20*256

palact		dc.l	whitepal
palnew		dc.l	pal1

changestuff	dc.w	0
timer		dc.w	0

		cnop	0,16
brushes		tst.w	changestuff(pc)
		beq.b	.noreset

		clr	changestuff

		move.w	#10,timer
		lea	palact(pc),a0
		move.l	4(a0),(a0)
		add.l	#1024,palnew

		cmp.w	#0,P61_Pos
		bgt.b	.ok1

		move.l	#whitepal,(a0)
		subq.l	#4,brushpoi

.ok1		cmp.w	#6,P61_Pos
		bne.b	.norulez
		cmp.w	#48,P61_CRow
		bgt.b	.rulez
		rts

.norulez	addq.l	#4,brushpoi
		clr.l	roto_xang0
		move.l	#zspd0,roto_zspd0
		clr.l	roto_zang0
		neg.l	roto_xspd0		; cambia giro izq/der alternativamente

.noreset	cmp.w	#0,P61_Pos
		bgt.b	.ok2
		rts
.ok2		tst	timer
		bgt.b	.paint
		rts

.rulez		move.w	#511,roto_nmorralla
		rts

.paint		move.l	brushpoi(pc),a0
		move.l	(a0),a0
		move.l	c2p__chunky_,a1
		add.l	#256*(skip/2),a1

		move.l	#$7f7f7f7f,d2

		move.w	#127,d7
.yloop		moveq.l	#15,d6
.xloop		move.w	(a0)+,d0

		rept	4
		add.w	d0,d0
		subx.w	d1,d1
		add.w	d0,d0
		subx.b	d1,d1
		swap	d1
		add.w	d0,d0
		subx.w	d1,d1
		add.w	d0,d0
		subx.b	d1,d1
		and.l	d2,d1
		or.l	d1,(a1)+
		endr

		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

		cnop	0,16
brushpoi	dc.l	brushpoi
		dc.l	brush0
		dc.l	brush1
		dc.l	brush2
		dc.l	brush3
		dc.l	brush4
		dc.l	brush5
		dc.l	brush6
		dc.l	brush7
		dc.l	brush8
		dc.l	brush9
		rept	16
		dc.l	rotozoomrecur_freespace
		endr

		cnop	0,16
;brush0		incbin	'gfx/raw.wasi'
;brush1		incbin	'gfx/raw.wind'

;brush2		incbin	'gfx/raw.leunam'
;brush3		incbin	'gfx/raw.zaac'
;brush4		incbin	'gfx/raw.made'
;brush5		incbin	'gfx/raw.rogu3'
;brush6		incbin	'gfx/raw.hh'

;brush7		incbin	'gfx/raw.nork'
;brush8		incbin	'gfx/raw.djuno'
;brush9		incbin	'gfx/raw.blue'

		cnop	0,16
sprites		tst.b	.nomoresprites
		bne	.nonewspr
		lea	.sprpoi(pc),a0
		move.l	(a0),a1
		movem.l	(a1)+,d0/d1/d2
		cmp.w	P61_Pos,d0
		bne	.nonewspr
		cmp.w	P61_CRow,d1
		bgt	.nonewspr
		move.l	a1,(a0)

		cmp.l	#-1,d2
		bne	.cont
		st	.nomoresprites
		clr.l	d5
		lea	c_sprs,a0
		bra	.clearsprites

.cont

		move.l	d2,a1
		lea	c_sprs,a0
		move.l	(a1)+,d0	;numero de sprites
		move.l	d0,d5		;resto de sprites pa limpiar luego
		move.l	(a1)+,d1	;altura del sprite
		move.w	spr_xpos,d2
		move.w	d1,d3
		lsl.w	#8,d3
		move.b	#$06,d3
		
		addq.l	#2,d1		;
		lsl.l	#4,d1		;altura*16

		subq.l	#1,d0
.loop
		move.w	d2,(a1)
		move.w	d3,(8,a1)
		move.l	a1,d4
		move.w	d4,(6,a0)
		swap	d4
		move.w	d4,(2,a0)
		
		add.b	#$80,d3		;set ATT
		addq.l	#8,a0		;siguiente sprite
		add.l	d1,a1		

		move.w	d2,(a1)
		move.w	d3,(8,a1)
		move.l	a1,d4
		move.w	d4,(6,a0)
		swap	d4
		move.w	d4,(2,a0)
		
		add.b	#8,d2

		add.b	#$80,d3		;clear ATT
		addq.l	#8,a0
		add.l	d1,a1
		
		dbf	d0,.loop

		;borra el resto de los sprites
.clearsprites	move.l	#null_sprites,d3
		add.l	d5,d5
		moveq.l	#8,d4
		sub.l	d5,d4
		beq	.nonewspr
		subq.l	#1,d4
.clrsprloop
		move.w	d3,(6,a0)
		swap	d3
		move.w	d3,(2,a0)
		swap	d3
		addq.l	#8,a0
		dbf	d4,.clrsprloop

.nonewspr	rts

.nomoresprites	dc.b	0
		even
		
.sprpoi		dc.l	.spr1
.spr1		dc.l	1,0,sprcode
		dc.l	2,0,sprgfx
		dc.l	4,32,sprmusic
		dc.l	5,54,-1

spr_xpos	dc.w	$0050
		
plsize	set	wid*hei/8
plsiz2	set	plsize*2

c2p_wait
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	lea.l	c2p__chunky(pc),a0
	movem.l	(a0),a5-a6
	move.l	a6,(a0)+
	move.l	a5,(a0)+

	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4
	lea	plsiz2(a4),a3
	lea	plsiz2(a3),a2
	lea	plsiz2(a2),a1

	move.l	a7,c2p_stack

	move.l	-(a3),a7
	move.l	-(a2),a0
	move.l	-(a1),d7

	move.l	#$0f0f0f0f,d4
	move.l	#$00ff00ff,d5
	move.l	#$55555555,d6

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	rotozoomrecur_chunky1
c2p__chunky_	dc.l	rotozoomrecur_chunky2
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2
c2p__planes__	dc.l	planes3
c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

	cmp.l	a5,a6
	bcs	c2p_loop

	move.l	d7,(a1)+
	move.l	a0,(a2)+
	move.l	a7,(a3)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	move.l	#c2p_blit2,lv3_blit

	lea	$dff000,a6

	moveq.l	#-1,d0
	moveq.l	#2,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	add.l	#(4*wid*hei/8)-2,a1

	move.l	a0,$50(a6)		; orig 1
	subq.l	#2,a0
	move.l	a0,$4c(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#$cccc,$70(a6)
	move.l	#$eDE40000,$40(a6)

	move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts


c2p_blit2	move.l	#c2p_blit3,lv3_blit

	lea	$dff000,a6
	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	move.l	a0,$50(a6)		; orig 1
	addq.l	#2,a0
	move.l	a0,$4C(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$0DE42000,$40(a6)

	move.w	#4*wid*hei/16,$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts

c2p_blit3	clr.l	c2p_proceed
	clr.l	lv3_blit
	rts

c2p_dbuff	movem.l	c2p__bltbuf,a0-a1
	exg.l	a0,a1
	movem.l	a0-a1,c2p__bltbuf

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d2
	move.l	d2,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	;move.w	#$555,$dff180
	;wrast	255
	;move.w	#$000,$dff180

	lea	c_bpls,a0
	move.l	c2p__planes_,d0
	moveq.l	#7,d7

.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#wid*hei/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop
	rts

	section	data_c,data_c

	cnop	0,64
c_roto	dc.w	$1fc,$000f
	dc.w	$100,$0201

	dc.w	$2007,$fffe

c_bpls	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0
	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

;c_sprs	dc.w	$120,0,$122,0
;	dc.w	$124,0,$126,0
;	dc.w	$128,0,$12a,0
;	dc.w	$12c,0,$12e,0
;	dc.w	$130,0,$132,0
;	dc.w	$134,0,$136,0
;	dc.w	$138,0,$13a,0
;	dc.w	$13c,0,$13e,0

xst set	14	; 14 14
xnd set	36	; 44 36

yst set $100-hei
	dc.w	$08e,$00a1|(yst<<8)
	dc.w	$090,$00a1

	dc.w	$092,xst*4
	dc.w	$094,xnd*4

	dc.w	$100,$0201|$7000
	dc.w	$102,$8800
	dc.w	$104,$0024
	dc.w	$106,$0000|$00c0|$0002
	dc.w	$10c,$0088

	dc.w	$108,0
	dc.w	$10a,0

	dc.w	$ffdf,$fffe
	dc.w	$3007,$fffe

	dc.w	$106,$00c0

c_sprs	dc.w	$120,0,$122,0
	dc.w	$124,0,$126,0
	dc.w	$128,0,$12a,0
	dc.w	$12c,0,$12e,0
	dc.w	$130,0,$132,0
	dc.w	$134,0,$136,0
	dc.w	$138,0,$13a,0
	dc.w	$13c,0,$13e,0

c_pal	ds.b	2112

	dc.l	-2,-2


null_sprites	dc.l	0,0,0,0,0,0,0,0

	cnop	0,16
sprcode	dc.l	2,11	;numero de sprites en el fichero,altura
	incbin	'brush/spr.codeattach'
sprgfx	dc.l	4,13
	incbin	'brush/spr.gfxattach'
sprmusic
	dc.l	3,11
	incbin	'brush/spr.musicattach'


palettes
	incbin	brush/1.pal
	incbin	brush/2.pal
	incbin	brush/3.pal
	incbin	brush/4.pal
	incbin	brush/5.pal
	incbin	brush/6.pal
	incbin	brush/7.pal
	incbin	brush/8.pal
	incbin	brush/9.pal
	incbin	brush/10.pal
	incbin	brush/11.pal
	incbin	brush/12.pal
	incbin	brush/13.pal
	incbin	brush/14.pal
	incbin	brush/15.pal
	incbin	brush/16.pal



