
      ;machine 68030

      opt   debug,l+,c-,p=68030

      XREF  planes1
      XREF  planes2
      XREF  planes3
      XREF  bltbuf1
      XREF  bltbuf2
      XREF  bltbuf3

      XREF  rtun_chunky1
      XREF  rtun_chunky2
      XREF  rtun_grid
      XREF  rtun_bumpmap
      XREF  rtun_atan

      XREF  lv3_vblank
      XREF  lv3_copper  
      XREF  lv3_blit

      XREF  p61_pos
      XREF  p61_crow

      XREF  fader_target
      XREF  fader_original
      XREF  fader_copper
      XREF  fader_colors
      XREF  fader_steps
      XREF  fader_finish
      XREF  fader_initcrossfade
      XREF  fader_makecopper
      XREF  fader_setpalette

      XREF  salir

      XREF  sinus

      XREF  rtun_texturemap
      XREF  rtun_shademap
      
      XDEF  rtun_main
      

      IFND  WASIMACROS
      include  include:macros2.i
      ENDC

      incdir   'raytunnel'

      section  raytunnel,code

wrast macro
.wr1\@   cmp.b #\1,$dff006
   bne.b .wr1\@
.wr2\@   cmp.b #\1,$dff006
   beq.b .wr2\@
   endm

RESET_SPRITES MACRO  ;\1=copperlist sprite label
   lea   \1,a0
   moveq.l  #7,d0
   move.w   #$0120,d1
   move.l   #spr_off,d2
.spr_count\@
   move.w   d1,(a0)+
   swap  d2
   move.w   d2,(a0)+
   addq.w   #2,d1
   move.w   d1,(a0)+
   swap  d2
   move.w   d2,(a0)+
   addq.w   #2,d1
   dbf   d0,.spr_count\@
   ENDM


wid set 160
hei set 128

rtun_main
   RESET_SPRITES  c_rtun_spr

   lea   (bltbuf1+8*40*256).l,a0
   lea   (bltbuf2+8*40*256).l,a1
   lea   (bltbuf3+8*40*256).l,a2
   lea   (planes1+8*40*256).l,a4
   lea   (planes2+8*40*256).l,a5
   lea   (planes3+8*40*256).l,a6
   move.l   #((8*40*256)/(32*16))-1,d0
   moveq.l  #0,d1
   moveq.l  #0,d2
   moveq.l  #0,d3
   moveq.l  #0,d4
   moveq.l  #0,d5
   moveq.l  #0,d6
   moveq.l  #0,d7
   sub.l a3,a3
   ;sub.l   a4,a4
   ;sub.l   a5,a5
.chiploop
   rept  16
   movem.l  d1-d7/a3,-(a0)
   movem.l  d1-d7/a3,-(a1)
   movem.l  d1-d7/a3,-(a2)
   movem.l  d1-d7/a3,-(a4)
   movem.l  d1-d7/a3,-(a5)
   movem.l  d1-d7/a3,-(a6)
   endr
   dbf   d0,.chiploop

   move.l   #planes1,d0
   lea   c_rtun_bpls,a0
   moveq.l  #7,d1
.loop2   move.w   d0,6(a0)
   swap  d0
   move.w   d0,2(a0)
   swap  d0
   addq.l   #8,a0
   add.l #320*256/8,d0
   dbf   d1,.loop2

   move.l   #c_rtun,$dff080

;.pera   btst  #6,$bfe001
;  bne   .pera

   bsr   rtun_make0
   move.l   #rtun_newtime,lv3_vblank
   move.l   #rtun_keyframes,splines_keydata
   move.w   #50*00,splines_frame

.loop1
   ;move.w  #$555,$dff180
.ll   cmp.b #255,$dff006
   bne.b .ll
   ;move.w  #$000,$dff180

   jsr   c2p_cpu

   bsr   rtun_redraw

   tst.l salir
   bne   .salray
   cmp.w #22,p61_pos
   blt   .loop1

.salray
   bsr   c2p_wait
   clr.l lv3_vblank
   clr.l lv3_blit
   clr.l lv3_copper
   rts

twid     set   (wid/8)+1
thei     set   (hei/8)+1

rtun_zpos   dc.l  0

rtun_angs   dc.l  $0000,$0000,$0000

rtun_size   dc.l  0
rtun_angdis dc.l  0

rtun_vectors   dc.l  $00000,$00000,$00000
rtun_vectors2  dc.l  $00000,$00000,$00000
      dc.l  $00000,$00000,$00000

rtun_xvec   dc.l  $00000,$00000,$00000
rtun_yvec   dc.l  $00000,$00000,$00000
rtun_zvec

rtun_redraw
   bsr   rtun_move
   bsr   rtun_mkvec
   bsr   rtun_calc
   bra   rtun_draw

rtun_newtime
      jsr   swap_screens

      addq.w   #1,splines_frame
      rts

rtun_move   bsr   calcspline
      moveq.l  #10,d6
      lea   splines_actdata,a0

      move.l   (a0)+,d0
      move.l   d0,rtun_zpos

      move.l   (a0)+,d0
      asr.l d6,d0
      move.l   d0,rtun_angdis
      move.l   #(1<<28)-(1<<27),d2
      asl.l #8,d1
      add.l d1,d2
      move.l   d2,rtun_size

      move.l   (a0)+,d0
      move.l   d0,rtun_angs+00

      move.l   (a0)+,d0
      move.l   d0,rtun_angs+04

      move.l   (a0)+,d0
      move.l   d0,rtun_angs+08
      rts

mkspl    macro
      dc.w  \1*50
      dc.w  \2,\3,\4,\5,\6
      endm

rtun_keyframes dc.w  55*50,5              ; 55 secs, 5 channels

;        fr, zzzz,  dist ,xxxxxx,yyyyyy,zzzzzz

      mkspl 00,$0000,$0000,$0000,$0000,$0000
      mkspl 00,$0000,$0000,$0000,$0000,$0000

      mkspl 01,$0800,$0000,$0000,$0000,$0040
      mkspl 02,$1000,$0000,$0000,$0000,$0080
      mkspl 03,$1800,$0000,$0000,$0000,$0040
      mkspl 04,$2000,$0000,$0000,$0000,-$0000
      mkspl 05,$2800,$0000,$0000,$0000,-$0040
      mkspl 06,$3000,$0000,$0020,$0020,-$0080
      mkspl 07,$3800,$0000,-$0020,$0020,-$0040
      mkspl 08,$4000,$0000,$0020,-$0020,$0000
      mkspl 09,$4800,$0000,-$0020,-$0020,$0040
      mkspl 10,$5000,$0000,$0020,$0020,$0080
      mkspl 11,$5800,$0000,-$0020,$0020,$0040
      mkspl 12,$6000,$0000,$0020,-$0020,$0000
      mkspl 13,$6800,$0000,-$0020,-$0020,$0000
      mkspl 14,$6c00,$0000,$0040,$0000,$0000

      mkspl 15,$6c00,$0000,$0081,$0000,$0080
      mkspl 16,$6c00,$0000,$0081,$0000,$0080
      mkspl 17,$6800,$0000,$0100,-$0030,$0000
      mkspl 18,$6400,$0000,$0100,-$0030,$0000
      mkspl 19,$6000,$0000,$0100,-$0030,$0000
      mkspl 20,$5c00,$0000,$0081,$0000,$0080
      mkspl 21,$5800,$0000,$0080,$0020,$0000
      mkspl 22,$5400,$0000,$0080,$0040,$0000
      mkspl 23,$5000,$0000,$0080,$0060,$0000
      mkspl 24,$4c00,$0000,$0080,$0080,$0080
      mkspl 25,$4800,$0000,$0080,$00a0,$0000
      mkspl 26,$4400,$0000,$0080,$00c0,$0000

      mkspl 27,$4000,$0000,$0080,$00e0,$0000
      mkspl 28,$3c00,$0000,$0080,$00e0,$0080
      mkspl 29,$3c00,$0800,$0080,$0100,$0100
      mkspl 30,$3c00,$0800,$0100,$0100,$0180
      mkspl 31,$3800,$0800,$0186,$0100,$0200
      mkspl 32,$3000,$0800,$0186,$0100,$01c0
      mkspl 33,$2800,$0800,$0186,$00c0,$0180
      mkspl 34,$2000,$0400,$0186,$0080,$0140
      mkspl 35,$1800,$0200,$0186,$0040,$0100
      mkspl 36,$1000,$0200,$0186,$0000,$00c0
      mkspl 37,$0800,$0200,$0186,$0000,$0080
      mkspl 38,$0000,$0200,$0186,$0000,$0040
      mkspl 39,-$0800,$0200,$0186,$0000,$0000

      mkspl 40,-$1000,$0600,$0186,$0010,-$0000
      mkspl 41,-$1800,$0c00,$0186,$0020,-$0000
      mkspl 42,-$2000,$0c00,$0186,$0020,-$0000
      mkspl 43,-$2800,$0000,$0186,$0020,-$0000
      mkspl 44,-$3000,$0000,$0186,$0020,-$0000
      mkspl 45,-$3800,$0c00,$0186,$0020,-$0000
      mkspl 46,-$3800,$0c00,$0100,$0020,-$0000
      mkspl 47,-$3800,$0000,$0080,$0040,-$0000
      mkspl 48,-$3800,$0000,$0000,$0080,-$0000
      mkspl 49,-$3800,$0c00,$0000,$0040,-$0000
      mkspl 50,-$3800,$0600,$0000,$0020,$0000
      mkspl 51,-$3800,$0400,$0000,$0010,$0080
      mkspl 52,-$3800,$0000,$0000,$0000,$0100

      mkspl 53,-$3800,$0000,$0000,$0000,$0100
      mkspl 54,-$3800,$0000,$0000,$0000,$0100
      mkspl 55,-$3800,$0000,$0000,$0000,$0100
      mkspl 55,-$3800,$0000,$0000,$0000,$0100
      mkspl 55,-$3800,$0000,$0000,$0000,$0100
      mkspl 55,-$3800,$0000,$0000,$0000,$0100

;
; 12-13
; 25-26
;

vecx  set   256      ;128,221,256
vecy  set   vecx*128/160   ; 97,181,192
vecz  set   256

rtun_mkvec
   bsr   .mkvec1

   lea   rtun_vectors(pc),a6
   lea   rtun_zvec(pc),a5
   moveq.l  #0,d7

   move.w   #0+vecx,d2
   move.w   #0-vecy,d3
   move.w   #0+vecz,d4
   bsr.b .rotvector
   move.l   d0,(a6)+
   move.l   d1,(a6)+
   move.l   d2,(a6)+

   move.w   #0-vecx,d2
   move.w   #0-vecy,d3
   move.w   #0+vecz,d4
   bsr.b .rotvector
   move.l   d0,(a6)+
   move.l   d1,(a6)+
   move.l   d2,(a6)+

   move.w   #0-vecx,d2
   move.w   #0+vecy,d3
   move.w   #0+vecz,d4
   bsr.b .rotvector

   moveq.l  #thei,d6
   move.l   -(a6),a2
   sub.l a2,d2
   divs.l   d6,d2
   move.l   d2,-(a5)

   move.l   -(a6),a1
   sub.l a1,d1
   divs.l   d6,d1
   move.l   d1,-(a5)

   move.l   -(a6),a0
   sub.l a0,d0
   divs.l   d6,d0
   move.l   d0,-(a5)

   moveq.l  #twid,d6
   move.l   -(a6),d2
   sub.l a2,d2
   divs.l   d6,d2
   move.l   d2,-(a5)

   move.l   -(a6),d1
   sub.l a1,d1
   divs.l   d6,d1
   move.l   d1,-(a5)

   move.l   -(a6),d0
   sub.l a0,d0
   divs.l   d6,d0
   move.l   d0,-(a5)
   rts

.rotvector  move.w   d2,d0
   move.w   d3,d5
   move.w   d4,d6

   muls.w   .m1(pc),d0
   muls.w   .m2(pc),d5
   muls.w   .m3(pc),d6
   add.l d5,d0
   add.l d6,d0

   move.w   d2,d1
   move.w   d3,d5
   move.w   d4,d6

   muls.w   .m4(pc),d1
   muls.w   .m5(pc),d5
   muls.w   .m6(pc),d6
   add.l d5,d1
   add.l d6,d1

   muls.w   .m7(pc),d2
   muls.w   .m8(pc),d3
   muls.w   .m9(pc),d4
   add.l d3,d2
   add.l d4,d2
   rts

.m1   dc.w  0
.m2   dc.w  0
.m3   dc.w  0
.m4   dc.w  0
.m5   dc.w  0
.m6   dc.w  0
.m7   dc.w  0
.m8   dc.w  0
.m9   dc.w  0

.mkvec1  lea   sinus,a6
   lea   16384(a6),a5
   moveq.l  #0,d6
   move.l   #16383,d0

   movem.l  rtun_angs(pc),d3-d5

   asr.l #6,d3
   addx.l   d6,d3
   asr.l #6,d4
   addx.l   d6,d4
   asr.l #6,d5
   addx.l   d6,d5

   and.l d0,d3
   and.l d0,d4
   and.l d0,d5

   move.w   1(a5,d3.w*4),d0
   move.w   1(a6,d3.w*4),a0

   move.w   1(a5,d4.w*4),d1
   move.w   1(a6,d4.w*4),a1

   move.w   1(a5,d5.w*4),d2
   move.w   1(a6,d5.w*4),a2

ca equr d0
sa equr a0
cb equr d1
sb equr a1
cc equr d2
sc equr a2

   move.w   sb,d7
   muls.w   cc,d7
   asr.l #8,d7
   addx.w   d6,d7

   move.w   cb,d3
   muls.w   cc,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m1   ; m1

   move.w   sa,d3
   muls.w   d7,d3
   move.w   sc,d4
   muls.w   ca,d4
   sub.l d4,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m2   ; m2

   move.w   ca,d3
   muls.w   d7,d3
   move.w   sc,d4
   move.w   sa,d5
   muls.w   d5,d4
   add.l d4,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m3   ; m3

   move.w   sb,d7
   move.w   sc,d3
   muls.w   d3,d7
   asr.l #8,d7
   addx.w   d6,d7

   move.w   sc,d3
   muls.w   cb,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m4   ; m4

   move.w   sa,d3
   muls.w   d7,d3
   move.w   cc,d4
   muls.w   ca,d4
   add.l d4,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m5   ; m5

   move.w   ca,d3
   muls.w   d7,d3

   move.w   sa,d4
   muls.w   cc,d4
   sub.l d4,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m6   ; m6

   move.w   sb,d3
   neg.w d3
   move.w   d3,.m7   ; m7

   move.w   sa,d3
   muls.w   cb,d3
   asr.l #8,d3
   addx.w   d6,d3
   move.w   d3,.m8   ; m8

   muls.w   ca,cb
   asr.l #8,cb
   addx.w   d6,d3
   move.w   cb,.m9   ; m9
   rts

rtun_calc   movem.l  rtun_vectors2(pc),a0-a2
   lea   rtun_grid,a6
   lea   rtun_atan,a5
   move.l   rtun_zpos(pc),a4

   move.w   #thei-1,d7
.hloop   swap  d7

   movem.l  a0-a2,-(sp)
   move.w   #twid-1,d7
.wloop
   moveq.l  #0,d0
   move.l   a0,d4
   move.l   a1,d5
   move.l   a2,d6

   asr.l #8,d4
   addx.l   d0,d4

   asr.l #8,d5
   addx.l   d0,d5

   asr.l #8,d6
   addx.l   d0,d6

   moveq.l  #0,d3

   move.l   a0,d1
   asr.l #2,d1
   addx.l   d3,d1

   move.l   a1,d2
   asr.l #2,d2
   addx.l   d3,d2

   lsr.w #8,d1
   move.w   d2,d3
   move.b   d1,d3
   add.w #$8080,d3
   move.w   1(a5,d3.l*4),d3
   move.w   d3,d2
   add.w d2,d2
   add.w d3,d2
   move.w   d2,(a6)+    ; store angle

   move.l   d4,d1
   move.l   d5,d2

   muls.l   d2,d2
   muls.l   d1,d1
   add.l d2,d1       ; d1 = (dx^2)+(dy^2)
   lsr.l #1,d1
   bne.b .ok
   move.l   #1,d1

.ok   lea   sinus,a3
   muls.w   #3,d3
   asr.l #2,d3
   and.w #16383,d3
   move.l   (a3,d3.w*4),d0
   add.l #65536,d0
   asr.l #2,d0
   muls.l   rtun_angdis(pc),d0

   add.l #(1<<26)+(1<<25),d0
   divu.l   d1,d0       ; d0 = t = r/((dx*dx)+(dy*dy))

   sub.l d3,d3
   muls.l   d0,d6

   move.l   d6,d0
   bgt.b .ok0
   neg.l d0

.ok0  add.l a4,d6
   asr.l #7,d6
   addx.w   d3,d6
   move.w   d6,(a6)+    ; store zpos

   move.l   #-$4000,d1
   lsr.l #6,d0
   addx.l   d1,d0
   move.l   #$0900,d1
   cmp.l d1,d0
   bpl.b .no1
   move.w   d1,d0
   bra.b .done

.no1  move.l   #$fe00,d1
   cmp.l d1,d0
   bcs.b .done

   move.w   d1,d0

.done move.w   #$ffff,d1
   sub.w d0,d1
   move.w   d1,(a6)+    ; store dist

   lea   rtun_xvec(pc),a3
   add.l (a3)+,a0
   add.l (a3)+,a1
   add.l (a3)+,a2
   dbra  d7,.wloop

   movem.l  (sp)+,a0-a2
   lea   rtun_yvec(pc),a3
   add.l (a3)+,a0
   add.l (a3)+,a1
   add.l (a3)+,a2

   swap  d7
   dbra  d7,.hloop
   rts

esiz  set   6
wsiz  set   6*twid

u2 set   (6*twid)-6
v2 set   (6*twid)-4
t2 set   (6*twid)-2

u3 set   (6*twid)
v3 set   (6*twid)+2
t3 set   (6*twid)+4

rtun_draw   move.l   c2p__chunky(pc),a6
   lea   rtun_texturemap,a5
   lea   rtun_shademap,a4
   lea   rtun_grid,a3
   lea   rtun_dat,a0

   eor.l d3,d3
   eor.l d4,d4
   eor.l d5,d5
   eor.l d6,d6

   move.w   #thei-2,d7
.hloop   swap  d7
   move.w   #twid-2,d7
.wloop   move.l   d7,-(sp)

   eor.l d7,d7

   move.w   (a3)+,d0
   move.w   (a3)+,d1
   move.w   (a3)+,d2

   move.w   (wsiz-6)(a3),d3
   sub.w d0,d3
   move.w   d0,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   move.w   (wsiz-4)(a3),d3
   sub.w d1,d3
   move.w   d1,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   move.w   (wsiz-2)(a3),d3
   sub.w d2,d3
   move.w   d2,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   move.w   (a3),d0
   move.w   2(a3),d1
   move.w   4(a3),d2

   move.w   (wsiz)(a3),d3
   sub.w d0,d3
   move.w   d0,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   move.w   (wsiz+2)(a3),d3
   sub.w d1,d3
   move.w   d1,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   move.w   (wsiz+4)(a3),d3
   sub.w d2,d3
   move.w   d2,(a0)+
   asr.w #3,d3
   move.w   d3,10(a0)

   suba.w   #12,a0

   eor.l d7,d7
   move.w   #8,-2(a0)
.iloop
   eor.l d0,d0
   move.w   (a0)+,d0

   eor.l d1,d1
   move.w   (a0)+,d1

   eor.l d2,d2
   move.w   (a0)+,d2

   eor.l d3,d3
   move.w   (a0)+,d3
   sub.w d0,d3
   asr.w #3,d3

   eor.l d4,d4
   move.w   (a0)+,d4
   sub.w d1,d4
   asr.w #3,d4

   eor.l d5,d5
   move.w   (a0)+,d5
   sub.w d2,d5
   asr.w #3,d5

   ror.l #8,d1
   eor.l d1,d0
   eor.w d1,d0
   
   ror.l #8,d4
   eor.l d4,d3
   eor.w d4,d3

   rept  8
   move.w   d0,d6
   move.b   d1,d6
   move.l   d2,d7
   move.b   (a5,d6.l),d7
   add.w d5,d2
   add.l d3,d0
   addx.w   d4,d1
   move.b   (a4,d7.l),(a6)+
   endr

   rept  6
   move.w   10(a0),d3
   add.w d3,-(a0)
   endr

   adda.w   #160-8,a6
   subq.w   #1,-2(a0)
   bne   .iloop

   move.l   (sp)+,d7
   adda.w   #8-8*160,a6
   dbra  d7,.wloop

   adda.w   #160*7,a6
   addq.l   #6,a3

   swap  d7
   dbra  d7,.hloop
   rts

   ds.w  32
rtun_dat ds.w  32

rtun_make0  lea   atan,a0
   lea   rtun_atan,a1

   moveq.l  #13,d1
   move.w   #(256*256)-1,d7
.loop1
   eor.l d0,d0
   move.w   (a0)+,d0
   lsl.l d1,d0
   move.l   d0,(a1)+

   dbra  d7,.loop1
   rts

plsize   set   2*wid*hei/8
plsiz2   set   2*plsize*2

c2p_wait lea   $dff000,a6
   BWAIT
   tst.b c2p_proceed
   bne.b c2p_wait
   rts

c2p_cpu  move.l   c2p__chunky(pc),a6
   move.l   c2p_pixels(pc),a5
   add.l a6,a5

   move.l   c2p__bltbuf_(pc),a4

   move.l   a7,c2p_stack

   move.l   #$00ff00ff,d7
   move.l   #$0f0f0f0f,d6
   move.l   #$33333333,d5

   move.l   -(a4),a2
   move.l   -(a4),a1
   move.l   -(a4),d4

   bra.b c2p_loop

c2p_data
c2p__chunky dc.l  rtun_chunky1
c2p__chunky_   dc.l  rtun_chunky2

c2p__planes dc.l  planes1
c2p__planes_   dc.l  planes2

c2p__bltbuf dc.l  bltbuf1
c2p__bltbuf_   dc.l  bltbuf2

c2p_stack   dc.l  0
c2p_pixels  dc.l  wid*hei
c2p_proceed dc.l  0

merge macro
   move.l   \2,\3
   lsr.l #\5,\3
   eor.l \1,\3
   and.l \4,\3
   eor.l \3,\1
   lsl.l #\5,\3
   eor.l \3,\2
   endm

wordmerge   macro
   move.l   \1,\3
   swap  \2
   move.w   \2,\1
   move.w   \3,\2
   swap  \2
   endm

   cnop  0,16
c2p_loop move.l   (a6)+,d0
   move.l   (a6)+,d1
   move.l   (a6)+,d2
   move.l   (a6)+,d3

   ;word d0,d2,d4
   ;word d1,d3,d4
   ;merge   d0,d1,d4,d7,8
   ;merge   d2,d3,d4,d7,8
   ;merge   d0,d2,d4,d6,4
   ;merge   d1,d3,d4,d6,4
   ;merge   d0,d1,d4,d5,2
   ;merge   d2,d3,d4,d5,2

      move.l   d4,(a4)+

   swap    d2  ;  4
   move.w  d0,d4  ;  6
   move.w  d2,d0  ;  8
   move.w  d4,d2  ; 10
   swap    d2  ; 14

   swap    d3  ; 18
   move.w  d1,d4  ; 20
   move.w  d3,d1  ; 22
   move.w  d4,d3  ; 24
   swap    d3  ; 28

      move.l   a1,(a4)+

   move.l  d2,d4
   lsr.l   #4,d4
   eor.l   d0,d4
   and.l   d6,d4
   eor.l   d4,d0
   lsl.l   #4,d4
   eor.l   d4,d2

   move.l  d3,d4
   lsr.l   #4,d4
   eor.l   d1,d4
   and.l   d6,d4
   eor.l   d4,d1
   lsl.l   #4,d4
   eor.l   d4,d3

      move.l   a2,(a4)+

   move.l  d1,d4
   lsr.l   #8,d4
   eor.l   d0,d4
   and.l   d7,d4
   eor.l   d4,d0
   lsl.l   #8,d4
   eor.l   d4,d1

   move.l  d3,d4
   lsr.l   #8,d4
   eor.l   d2,d4
   and.l   d7,d4
   eor.l   d4,d2
   lsl.l   #8,d4
   eor.l   d4,d3

   move.l  d1,d4
   lsr.l   #2,d4
   eor.l   d0,d4
   and.l   d5,d4
   eor.l   d4,d0
      move.l   d0,(a4)+
   lsl.l   #2,d4  ;  4
   eor.l   d4,d1  ;  6
   
      move.l   d1,a1
   move.l  d3,d4  ;  8
   lsr.l   #2,d4  ; 12
   eor.l   d2,d4  ; 14
   and.l   d5,d4  ; 16
   eor.l   d4,d2  ; 18
   lsl.l   #2,d4  ; 22
   eor.l   d3,d4  ; 24

      move.l   d2,a2

   cmp.l a5,a6
   bne   c2p_loop

   move.l   d4,(a4)+
   move.l   a1,(a4)+
   move.l   a2,(a4)+

   move.l   c2p_stack,a7

   bsr   c2p_wait
   st c2p_proceed

   bsr   c2p_dbuff

   lea   $dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

   moveq.l  #-1,d0
   moveq.l  #12,d1

   move.w   d1,$62(a6)
   move.w   d1,$64(a6)
   move.w   #0,$66(a6)
   move.l   d0,$44(a6)
   move.l   #$0DE41000,$40(a6)

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   addq.l   #4,a0

   move.w   #$5555,$70(a6)

   move.l   a0,$4c(a6)     ; orig 1
   move.l   a0,$50(a6)     ; orig 2
   move.l   a1,$54(a6)     ; dest

   move.w   #(plsize/4),$5c(a6)  ; size_v
   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_2,lv3_blit
   rts

c2p_blit_2  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #plsize,a1
   addq.l   #4,a0

   move.w   #$aaaa,$70(a6)

   move.l   a0,$50(a6)     ; orig 1
   move.l   a0,$4c(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_3,lv3_blit
   rts

c2p_blit_3  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #plsize*2,a1
   add.l #12,a0

   move.w   #$5555,$70(a6)

   move.l   a0,$4c(a6)     ; orig 1
   move.l   a0,$50(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_4,lv3_blit
   rts

c2p_blit_4  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #3*plsize,a1
   add.l #12,a0

   move.w   #$aaaa,$70(a6)

   move.l   a0,$50(a6)     ; orig 1
   move.l   a0,$4c(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_5,lv3_blit
   rts

c2p_blit_5  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #4*plsize,a1
   addq.l   #8,a0

   move.w   #$5555,$70(a6)

   move.l   a0,$4c(a6)     ; orig 1
   move.l   a0,$50(a6)     ; orig 2
   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_6,lv3_blit
   rts

c2p_blit_6  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #5*plsize,a1
   addq.l   #8,a0

   move.w   #$aaaa,$70(a6)

   move.l   a0,$50(a6)     ; orig 1
   move.l   a0,$4c(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_7,lv3_blit
   rts

c2p_blit_7  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #6*plsize,a1

   move.w   #$5555,$70(a6)

   move.l   a0,$4c(a6)     ; orig 1
   move.l   a0,$50(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_8,lv3_blit
   rts

c2p_blit_8  lea   $dff000,a6

   move.l   c2p__bltbuf,a0
   move.l   c2p__planes,a1
   add.l #7*plsize,a1

   move.w   #$aaaa,$70(a6)

   move.l   a0,$50(a6)     ; orig 1
   move.l   a0,$4c(a6)     ; orig 2

   move.l   a1,$54(a6)     ; dest

   move.w   #2,$5e(a6)     ; size_h
   move.l   #c2p_blit_end,lv3_blit
   rts

c2p_blit_end   clr.l c2p_proceed
   clr.l lv3_blit

   lea   c2p__planes(pc),a0
   movem.l  (a0),d0-d1
   move.l   d1,(a0)+
   move.l   d0,(a0)+

   move.l   d0,newplanes
   addq.l   #1,timing_frame2
   rts

c2p_dbuff   lea   c2p__chunky(pc),a0
   movem.l  (a0),d0-d1
   exg.l d0,d1
   movem.l  d0-d1,(a0)

   lea   c2p__bltbuf(pc),a0
   movem.l  (a0),d0-d1
   exg.l d0,d1
   movem.l  d0-d1,(a0)
   rts

newplanes   dc.l  planes1

swap_screens   move.l   newplanes(pc),d0

   lea   c_rtun_bpls,a0
   moveq.l  #7,d7
.sloop   move.w   d0,6(a0)
   swap  d0
   move.w   d0,2(a0)
   swap  d0
   add.l #plsize,d0
   addq.l   #8,a0
   dbra  d7,.sloop

   addq.l   #1,timing_frame1
   rts

test_speed  move.l   c2p__chunky(pc),a0
   move.l   timing_frame1(pc),d0
   move.l   timing_frame2(pc),d1

   tst.l d0
   beq.b .no

   mulu.w   #wid,d1
   divs.l   d0,d1
   move.l   d1,timing_speed

   moveq.l  #0,d2

   move.l   a0,a1
   move.w   #(wid*8/16)-1,d7
.clrloop move.l   d0,(a1)+
   move.l   d2,(a1)+
   move.l   d2,(a1)+
   move.l   d2,(a1)+
   dbra  d7,.clrloop

   add.l d1,a0
   add.l #wid*2,a0

   move.w   #3,d7
.loop movem.l  a0-a4,(a0)
   add.l #wid,a0
   dbra  d7,.loop

.no   rts

timing_frame1  dc.l  0
timing_frame2  dc.l  0
timing_speed   dc.l  0

      include  'splines.asm'

;     cnop  0,16
;rtun_texturemap  dc.l  0  ;ncbin   'chk.txt2'
;rtun_shademap dc.l  0  ;incbin  'shd.txt2'
      ;dcb.b   65536,0

atan     incbin   'atan2048.bin'

   section  data_c,data_c

   cnop  0,64
c_rtun   dc.w  $1fc,$4007
   dc.w  $100,$0201

   dc.w  $08e,$2882
   dc.w  $090,$28C1     * DIWindow Size YX
   dc.w  $092,$0038
   dc.w  $094,$00D0-(4*8)  * DDFetch


   dc.w  $100,$0201|$0010
   dc.w  $102,$0010
   dc.w  $104,$0200
   dc.w  $106,$0000

   dc.w  $108,-40
   dc.w  $10a,0


sprite   set   $120
c_rtun_spr
   dc.w  sprite,0,sprite+2,0
   dc.w  sprite+4,0,sprite+6,0
   dc.w  sprite+8,0,sprite+10,0
   dc.w  sprite+12,0,sprite+14,0
   dc.w  sprite+16,0,sprite+18,0
   dc.w  sprite+20,0,sprite+22,0
   dc.w  sprite+24,0,sprite+26,0
   dc.w  sprite+28,0,sprite+30,0

   dc.w  $1007,$fffe

c_rtun_bpls
   dc.w  $e0,0,$e2,0
   dc.w  $e4,0,$e6,0
   dc.w  $e8,0,$ea,0
   dc.w  $ec,0,$ee,0
   dc.w  $f0,0,$f2,0
   dc.w  $f4,0,$f6,0
   dc.w  $f8,0,$fa,0
   dc.w  $fc,0,$fe,0

   dc.w  $ffdf,$fffe
   dc.w  $2807,$fffe
   incbin   'pal.txt2'

   dc.l  -2,-2


   cnop  0,16
spr_off  ds.l  8
