;**********************************
;
; ESCALADO DE LA ESCENA = >>>38<<<
;
;**********************************

		
		;machine	68030
		
		opt	debug,c-,l+,p=68030

		XREF	engine__chunky
		XREF	engine_cpu
		XREF	engine_swap_screens
		XREF	engine_wait

		XREF	begin_tex1
		XREF	begin_tex2

		XREF	engine_chunky1
		XREF	engine_chunky2
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit
		XREF	salir
		XREF	P61_Pos
		XREF	P61_CRow
		XREF	senos

		XREF	Setup
		XREF	PrecalcCameraMotion
		XREF	PrecalcObjectsMotion
		XREF	CalcCameraStep
		XREF	CalcObjectsStep
		XREF	CalcCameraStepIEEE
		XREF	CalcObjectsStepIEEE
		XREF	PrecalcMatrix
		XREF	RotatePoints
		XREF	RotateNormals
		XREF	PrecalcCameraMatrix
		XREF	TransformToCamera
		XREF	MakeRadixTable
		XREF	RadixSort
		XREF	MakePolys
		XREF	MapTriangle
		XREF	tpolyclip_updown
		XREF	tpolyclip_leftright
		XREF	DDA_Main
		XREF	engine_texture

		XREF	blackpal
		XREF	whitepal

		xref	fader_original
		xref	fader_target
		xref	fader_steps
		xref	fader_copper
		xref	fader_colors
		xref	fader_position
		xref	fader_palsize
		xref	fader_makecopper
		xref	fader_initcrossfade
		xref	fader_setpalette

		;XDEF	step

		XDEF	begin_main
		
		
		section	principio,code

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

Begin_InitEngine
		lea	Begin_SceneFile,a0
		lea	Begin_ObjectList,a1
		lea	Begin_TextureList,a2
		lea	c_engine_bpls,a3
		jsr	Setup
		move.l	d0,nframes
		move.l	d1,Begin_palette

		move.l	Begin_palette,fader_target
		move.l	#whitepal,fader_original
		move.l	#c_engine_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade

		lea	begin_logopal,a0
		lea	begin_palette2,a1
		move.l	(a0)+,(a1)+
		move.l	(a0)+,(a1)+
		move.l	(a0)+,(a1)+
		move.l	(a0)+,(a1)+
		move.l	begin_palette,a0
		lea	(16,a0),a0
		rept	256-4
		move.l	(a0)+,(a1)+
		endr
		rts

Begin_Main
		RESET_SPRITES	c_engine_spr

;		move.l	#planes1,d0
;		lea	c_engine_bpls,a0
;		moveq.l	#7,d1
;.loop2		addq.l	#2,a0
;		swap	d0
;		move.w	d0,(a0)+
;		addq.l	#2,a0
;		swap	d0
;		move.w	d0,(a0)+
;		add.l	#320*256/8,d0
;		dbf	d1,.loop2
		

		move.l	#c_engine,$dff080
		jsr	Begin_InitEngine	


.pera		;tst.l	salir
		;bne	.salbegin
		cmp.w	#0,p61_pos
		beq	.pera

		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle

		move.l	#begin_advance,lv3_vblank
.loop		

		jsr	engine_cpu

		;jsr	begin_clearbuffer
		jsr	begin_copybackground
		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		;jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle
		
		cmp.w	#1,p61_pos
		bne	.no
		cmp.w	#40,p61_crow
		bne	.no
		move.l	begin_palette,fader_original
		move.l	#begin_palette2,fader_target
		move.l	#c_engine_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
.no

		move.w	p61_pos+1,d0
		move.b	p61_crow+1,d0
		cmp.w	#2<<8,d0
		bne	.no2
		move.l	#begin_palette2,fader_original
		move.l	#blackpal,fader_target
		move.l	#c_engine_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
.no2

		tst.l	salir
		bne	.salbegin
		cmp.w	#3,P61_Pos
		blt	.loop
.salbegin	jsr	engine_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

begin_advance
		jsr	engine_swap_screens

		lea	step,a0
		add.l	#(2<<8)+128,(1,a0)
		move.l	nframes,d0
		cmp.l	step,d0
		bgt	.nada
		move.l	d0,step
.nada
		cmp.w	#1,p61_pos
		bne	.noini
		cmp.w	#58,p61_crow
		bgt	.noini
		jmp	fader_setpalette
.noini

		cmp.w	#2,p61_pos
		bne	.nofade
		jmp	fader_setpalette

.nofade
		rts

nframes		dc.l	0
step		dc.l	0

		CNOP	0,16
begin_copybackground
		move.l	(engine__chunky).l,a0
		adda.l	#320*192,a0
		move.l	#((320*200)/(4*12))-1,d7
		lea	(begin_texturelist+4).l,a1
		move.l	(a1),a1
		adda.l	#(320*200)-48,a1
.mierda
		movem.l	(a1),d0-d6/a2-a6
		movem.l	d0-d6/a2-a6,-(a0)
		suba.l	#48,a1
		dbf	d7,.mierda
		movem.l	(a1),d0-d6/a2-a6
		movem.l	d0-d6/a2-a6,-(a0)

		rts

		CNOP	0,16
begin_clearbuffer
		move.l	engine__chunky,a0
		adda.l	#320*192,a0
		move.l	#((320*200)/(4*13*3))-1,d7
		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6

.loop		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		dbf	d7,.loop
		movem.l	d0-d6/a1-a4,-(a0)
		rts


Begin_palette	dc.l	0
begin_logopal	incbin	sources:scenes/network/network.320x77.pal
begin_palette2	ds.l	256

Begin_ObjectList
		dc.l	.dd
		dc.w	%11	;(1<<0)	;pointertoobject,rotation flag
.dd		incbin	"sources:scenes/network/donut.wob"

Begin_SceneFile	incbin	"sources:scenes/network/donut-intro2.wsc" 

Begin_TextureList
		dc.l	c_engine_pal
		dc.l	begin_tex2,.bbp,0,16,320*200,0,0,0
		dc.l	begin_tex1,.aap,16,128,256*256,0,0,0	;0=allign long
		dc.l	$ABADCAFE
		
		incdir	"sources:scenes/network"
;.aa		incbin	foco1.bin	;"Phongmap-Shaft7.bin"
.aap		incbin	foco1.pal	;"pal.Phongmap-Shaft7"
;.bb		incbin	logo.bin
.bbp		dcb.l	256,0	;incbin	network.320x77.pal

		section	copper,data_c
wid	set	320
hei	set	192

		cnop	0,64
c_engine
	dc.w	$2007 ,$fffe
	dc.w	$1fc,$0007
	dc.w	$100,$0201

	dc.w	$08e,$2881
	dc.w	$090,$28C1

sprite	set	$120
c_engine_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

xst set 14	; 14 14
xnd set	36	; 44 36

	ifeq	wid-320
xnd	set	44
	else
xnd	set	36
	endc

yst set $100-(hei)
	dc.w	$08e,$0a81|(yst<<8)
	dc.w	$090,$0ac1

	dc.w	$092,xst*4
	dc.w	$094,xnd*4

	dc.w	$100,$0201|$010
	dc.w	$102,$0000
	dc.w	$104,$0200
	dc.w	$106,$0c40

	dc.w	$108,0
	dc.w	$10a,0

c_engine_pal	incbin	demo:blackpal.pal	;dcb.b	2112	;incbin	"sources:scenes/fly/scene.cop.pal"

c_engine_bpls
	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0

	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

	dc.w	$fe3f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
