;**********************************************************
;
;               SYNTHESIS BY NETWORK IN 1998
;
; Estructura de carga de la demo:
;
;     1.- Parte de introduccion
;     2.- Primera parte principal
;     3.- Segunda parte principal
;     4.- Parte final
;
; Los datos se iran cargando por partes. Para ello
; tendremos 4 ficheros de datos cada uno para una
; parte:
;
;	- Synthesis.exe
;	- NTW_SYNTH1.DAT
;       - NTW_SYNTH2.DAT
;	- NTW_SYNTH3.DAT
;       - NTW_SYNTH4.DAT
;
; En el comienzo de cada parte se leera >>completamente<<
; el fichero de datos correspondiente y una vez cargado
; se hara el reparto de memoria para cada cosa.
;
; Los ficheros de datos estan construidos usando el
; sistema de Xele, de hecho se usa el mismo codigo que
; usamos para la Trashcan para construir los fichero de
; datos de la revista. He aadido una modificacion a este
; sistema para acomodarlo a la demo y es que, los ficheros
; incluidos en cada fichero de datos iran precedidos de un
; flag que nos indique si los datos se deben copiar en chip
; o en fast, ya que, dentro de cada fichero, hay datos
; mezclados de chip y de fast, debido a la organizacion por
; partes de los ficheros.
;
; Al final, los ficheros de datos no contendran datos
; pequeos como las paletas, estas y los copperlists y demas
; iran incluidos en el ejecutable. En los fichero solo
; estaran los modulos, los tablas y los graficos.
;**********************************************************

CHIP_BUFFER	EQU	300*512
FAST_BUFFER	EQU	400*1024*2


	;machine 68030

	opt	debug,l+,c-,p=68030


	section	main,code

	XDEF	_MathIeeeSingBasBase
	XDEF	_MathIeeeSingTransBase		

	XDEF	salir
	XDEF	whitepal
	XDEF	blackpal

	;XREF	_GfxBase
	;XREF	_DosBase

	;XDEF	main
	XDEF	lv3_vblank
	XDEF	lv3_blit
	XDEF	lv3_copper
	XDEF	P61_music
	XDEF	salir

;***********************************************************
;                   DEFINES E INCLUDES
;***********************************************************

	;include	'dh1:dev/devpac/macros.source'
	incdir	'include:'
	include	'exec/execbase.i'
	include	'exec/exec_lib.i'
	include 'graphics/graphics_lib.i'
	include 'dos/dos.i'
	include 'libraries/dos_lib.i'
	include 'include:macros2.i'

makeplayer	set	1
startmodpos	set	0

wid set 160
hei set 90


; 12 = phong1
; 15 = dottunnel
; 19 = textunnel
; 23 = zaac
; 26 = roto peska suxx
; 28 = recursive

;***********************************************************
;                         MACROS
;***********************************************************

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

resetstuff	macro
	clr.l	lv3_blit
	clr.l	lv3_vblank
	clr.l	lv3_copper
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

;***********************************************************
;                      GENERAL CODE
;***********************************************************
InitSys	;move.l	a7,backsp
	move.l	(sp)+,back
	move.l	(sp)+,a0
	pea	level3
	jsr	(a0)
	move.l	(sp)+,_MathIeeeSingBasBase
	move.l	(sp)+,_MathIeeeSingTransBase
	bsr	Main			; Nuestro PROGRAMA !!
	move.l	(sp)+,a0
	jsr	(a0)
	;move.l	backsp,a7
	;rts				; ADIOS !!!
	move.l	salir,-(sp)
	move.l	back,a0
	jmp	(a0)

back	dc.l	0
_MathIeeeSingBasBase	dc.l	0
_MathIeeeSingTransBase	dc.l	0

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	LV3_BLIT,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)
.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		btst	#6,$bfe001
		bne	.nosalir
		move.l	#-1,SALIR
.nosalir

		;ifne	makeplayer
		lea	$dff000,a6
		jsr	P61_MUSIC
		;endc

		move.l	LV3_VBLANK,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)
.no1		movem.l	(sp)+,d0-a6
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		rte

.novblank	btst	#4,d0
		beq.b	.nocopper

		move.l	LV3_COPPER,d0
		beq.b	.no2
		move.l	d0,a0
		jsr	(a0)
.no2		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		rte

salir		dc.l	0
lv3_copper	dc.l	0
lv3_vblank	dc.l	0
lv3_blit	dc.l	0
exitcode	dc.l	0

;------------ fader routine ------------
	include	'/faderrecur.asm'
;---------------------------------------

;------------    TP6.1A     ------------
example=0
asmone=0
start = 0
fade  = 0
jump = 1
system = 0
CIA = 0
exec = 1
lev6 = 1
opt020 = 1
channels = 4
use = -1
	
	incdir	'/player6.1a/source/'
	include	'include/player61.i'
	include	'P6104.asm'
;---------------------------------------

	XDEF	planes1
	XDEF	planes2
	XDEF	planes3
	XDEF	planes4
	XDEF	bltbuf1
	XDEF	bltbuf2
	XDEF	bltbuf3
	XDEF	sinus
	XDEF	senos


	;RotoVoxel DEFs and REFs
	XDEF	voxel_chunky1
	XDEF	voxel_chunky2
	XDEF	voxel_drawing
	XDEF	voxel_divutab
	XDEF	voxel_texheimap
	XDEF	voxel_heightmap
	XDEF	voxel_texturemap
	XDEF	voxel_shademap
	XREF	voxel_main
	;-----------------------

	;Zoom part DEFs and REFs
	XDEF	zoom_bpl_sh0
	XDEF	zoom_bpl_0
	XDEF	zoom_bpl_1
	XDEF	zoom_bpl_2
	XDEF	zoom_bpl_3
	XDEF	zoom_bpl_4
	XDEF	zoom_bpl_5
	XDEF	zoom_bpl_6
	XDEF	zoom_bpl_7
	XDEF	zoom_bpl_8
	XDEF	zoom_bpl_sh1
	XDEF	zoom_multable
	XDEF	zoom_coltable1
	XDEF	zoom_coltable2
	XDEF	zoom_tempbpl
	XDEF	zoom_palette
	XREF	zoom_main
	;-----------------------

	;Water 2d part DEFs and REFs
	XDEF	water2d_chunky1
	XDEF	water2d_chunky2
	XDEF	chk_water2dhei_0
	XDEF	chk_water2dhei_1
	XDEF	water_texture
	XREF	waterback_main
	;---------------------------

	;Vaso part DEFs and REFs
	XDEF	vaso_pic
	XREF	vaso_main
	XDEF	vaso_chippic
	;-----------------------

	;Engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	engine_3_main
	XDEF	_3dpart2_tex1
	XDEF	_3dpart2_tex2
	XDEF	_3dpart2_tex3
	;-------------------------

	;Rotozoom new part DEFs and REFs
	XDEF	rotozoom_shit
	XDEF	rotozoom_chunky1
	XDEF	rotozoom_chunky2
	XDEF	rotozoom_tex1
	XREF	rotozoom_main
	;-------------------------------

	;Raycasting tunnel part DEFs and REFs
	XDEF	rtun_chunky1
	XDEF	rtun_chunky2
	XDEF	rtun_grid
	XDEF	rtun_bumpmap
	XDEF	rtun_atan
	XDEF	rtun_texturemap
	XDEF	rtun_shademap
	XREF	rtun_main
	;------------------------------------

	;Greets part DEFs and REFs
	XDEF	greets_chunky1
	XDEF	greets_buffer
	XREF	greets_main
	;-------------------------

	;Yoriko part DEFs and REFs
	XDEF	yoriko_planes
	XDEF	yoryko_sinus
	XDEF	yorykobpl
	XREF	scrollwipe_main
	;-------------------------

	;Rotobump part DEFs and REFs
	XDEF	rotobump_chunky1
	XDEF	rotobump_chunky2
	XDEF	rotobump_bump_
	XDEF	rotobump_phong_
	XDEF	rotobump_texture
	XDEF	rotobump_phong
	XDEF	rotobump_shade
	XDEF	rotobump_bump
	XREF	rotobump_main
	;---------------------------

	;Starfield part DEFs and REfs
	XDEF	bpl_stars_0
	XDEF	bpl_stars_1
	XDEF	bpl_stars_2
	XDEF	bpl_stars_3
	XDEF	bpl_stars_4
	XDEF	bpl_stars_5
	XDEF	bpl_stars_6
	XDEF	bpl_stars_7
	XDEF	bpl_stars_8
	XDEF	stars_positions
	XREF	stars_main

Main

	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init

	;bra	.cojo

	jsr	voxel_main
	tst.l	salir
	bne	Fin

	jsr	zoom_main
	tst.l	salir
	bne	Fin

	jsr	waterback_main
	tst.l	salir
	bne	Fin

	jsr	vaso_main
	tst.l	salir
	bne	Fin

	jsr	engine_3_main
	tst.l	salir
	bne	Fin

	jsr	rotozoom_main
	tst.l	salir
	bne	Fin

	jsr	rtun_main
	tst.l	salir
	bne	Fin

	jsr	greets_main
	tst.l	salir
	bne	Fin

	jsr	scrollwipe_main
	tst.l	salir
	bne	Fin

	jsr	rotobump_main
	tst.l	salir
	bne	Fin

	jsr	stars_main
	tst.l	salir
	bne	Fin

;***********************************************************
;*							   *
;*			 THE END			   *
;*							   *
;***********************************************************

Fin	resetstuff

	lea	$dff000,a6
	moveq.l	#0,d0
	bsr	p61_end

	;jsr	osin

	rts


	section	GenData,data

		cnop	0,16
senos		include	include:sinuslist.s

		cnop	0,16
sinus		incbin	'/sinus64k.bin'
		incbin	'/sinus64k.bin'

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

MemList_Part2	dc.l	samples
;		dc.l	voxel_heightmap
;		dc.l	voxel_texturemap
;		dc.l	voxel_shademap

;		dc.l	water_texture

;		dc.l	vaso_pic

		dc.l	rtun_texturemap
		dc.l	rtun_shademap

		dc.l	yorykobpl
		dc.l	$ABADCAFE


;**********************************************************
;                       COPPER LISTS
;**********************************************************
	section	copper,data_c
	cnop	0,64
c_none	dc.w	$1fc,$0007
	dc.w	$100,$0201
	dc.w	$106,$0020
	dc.w	$180,$000
sprite	set	$120
c_none_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite,8,sprite+10,0
	dc.w	sprite,12,sprite+14,0
	dc.w	sprite,16,sprite+18,0
	dc.w	sprite,20,sprite+22,0
	dc.w	sprite,24,sprite+26,0
	dc.w	sprite,28,sprite+30,0

	dc.l	-2,-2


;--------------------------------------------------

	section	data,data_c
	cnop	0,16
samples	incbin	mod/P61.LOVE_IS_PARADISE.FINAL2

	section	bbb,bss_c
	cnop	0,16
spr_off	ds.l	8

planes4	ds.b	320*256

	cnop	0,16
buffer0	ds.l	(CHIP_BUFFER)

	BUFFER	0
	RESERVE	0,bltbuf1,(8*40*256)
	RESERVE	0,bltbuf2,(8*40*256)
	RESERVE	0,bltbuf3,(8*40*256)
	RESERVE	0,planes1,(8*40*256)
	RESERVE	0,planes2,(8*40*256)
	RESERVE	0,planes3,(8*40*256)

	BUFFER	0
	RESERVE	0,ham8_chipplanes,(1024*480)
	RESERVE	0,water_sprt00,(16*256*1)
	RESERVE	0,water_sprt01,(16*256*1)
	RESERVE	0,water_sprt02,(16*256*1)
	RESERVE	0,water_sprt03,(16*256*1)
	RESERVE	0,water_sprt04,(16*256*1)

	BUFFER	0
	RESERVE	0,zoom_bpl_sh0,40*64
	RESERVE	0,zoom_bpl_0,40*257
	RESERVE	0,zoom_bpl_1,40*257
	RESERVE	0,zoom_bpl_2,40*257
	RESERVE	0,zoom_bpl_3,40*257
	RESERVE	0,zoom_bpl_4,40*257
	RESERVE	0,zoom_bpl_5,40*257
	RESERVE	0,zoom_bpl_6,40*257
	RESERVE	0,zoom_bpl_7,40*257
	RESERVE	0,zoom_bpl_8,40*257
	RESERVE	0,zoom_bpl_sh1,40*64

	BUFFER	0
	RESERVE	0,vaso_chippic,(640*512)

	BUFFER	0
	RESERVE	0,yoriko_planes,(8*88*480)

	BUFFER	0
	RESERVE	0,bpl_stars_0,(64*260*1)
	RESERVE	0,bpl_stars_1,(64*260*1)
	RESERVE	0,bpl_stars_2,(64*260*1)
	RESERVE	0,bpl_stars_3,(64*260*1)
	RESERVE	0,bpl_stars_4,(64*260*1)
	RESERVE	0,bpl_stars_5,(64*260*1)
	RESERVE	0,bpl_stars_6,(64*260*1)
	RESERVE	0,bpl_stars_7,(64*260*1)
	RESERVE	0,bpl_stars_8,(64*260*2)



	section	ccc,bss

	cnop	0,16
buffer1	ds.l	(FAST_BUFFER)

	BUFFER	1
	RESERVE	1,voxel_chunky1,(320*256)
	RESERVE	1,voxel_chunky2,(320*256)
	RESERVE	1,voxel_drawing,(256*256)
	RESERVE	1,voxel_divutab,(256*256*2)
	RESERVE	1,voxel_texheimap,(256*256*2)

	RESERVE	1,zoom_multable,(4*512)
	RESERVE	1,zoom_coltable1,(4*5120)
	RESERVE	1,zoom_coltable2,(4*1280)
	RESERVE	1,zoom_tempbpl,40*257
	RESERVE	1,zoom_palette,4*256

	RESERVE	1,water2d_chunky1,(320*256)
	RESERVE	1,water2d_chunky2,(320*256)
	RESERVE	1,chk_water2dhei_0,(320*256*2)
	RESERVE	1,chk_water2dhei_1,(320*256*2)

	RESERVE	1,rotozoom_shit,4096
	RESERVE	1,rotozoom_chunky1,320*256
	RESERVE	1,rotozoom_chunky2,320*256
	RESERVE	1,rotozoom_tex1,256*256
	RESERVE	1,rotozoom_freespace,256*128/8

	RESERVE	1,rtun_chunky1,(320*256)
	RESERVE	1,rtun_chunky2,(320*256)
	RESERVE	1,rtun_grid,(8*((160/8)+1)*((128/8)+1))
	RESERVE	1,rtun_bumpmap,(256*256*2)
	RESERVE	1,rtun_atan,(256*256*4)

	RESERVE 1,dummy1,(320*256)
	RESERVE	1,engine_chunky1,(320*256)
	RESERVE	1,engine_chunky2,(320*256)
	RESERVE 1,dummy2,(320*256)

	RESERVE	1,greets_dummy,(320*2)
	RESERVE	1,greets_chunky1,(320*256)
	RESERVE	1,greets_buffer,(320*128)
	RESERVE	1,greets_dummy2,(320*2)

	RESERVE	1,yoryko_sinus,64*1024

	RESERVE	1,rotobump_shit,4096
	RESERVE	1,rotobump_chunky1,320*256
	RESERVE	1,rotobump_chunky2,320*256
	RESERVE	1,rotobump_bump_,256*256*2
	RESERVE	1,rotobump_phong_,256*256*2

	RESERVE	1,stars_positions,(2*3*8192)



	section	bigdata,data
 
buffer3	incbin	ntw_syn3.bin

	BUFFER	3
	RESERVE	3,voxel_heightmap,65536
	RESERVE	3,voxel_texturemap,65536
	RESERVE	3,voxel_shademap,65536
	RESERVE	3,water_texture,65536
	RESERVE	3,vaso_pic,327680
	RESERVE	3,_3dpart2_tex1,65536
	RESERVE	3,_3dpart2_tex2,65536
	RESERVE	3,_3dpart2_tex3,65536
	RESERVE	3,rtun_texturemap,65536
	RESERVE	3,rtun_shademap,65536
	RESERVE	3,yorykobpl,307200
	RESERVE	3,rotobump_texture,65536
	RESERVE	3,rotobump_phong,65536
	RESERVE	3,rotobump_shade,65536
	RESERVE	3,rotobump_bump,65536
