;**********************************************************
;
;               SYNTHESIS BY NETWORK IN 1998
;
; Estructura de carga de la demo:
;
;     1.- Parte de introduccion
;     2.- Primera parte principal
;     3.- Segunda parte principal
;     4.- Parte final
;
; Los datos se iran cargando por partes. Para ello
; tendremos 4 ficheros de datos cada uno para una
; parte:
;
;	- Synthesis.exe
;	- NTW_SYNTH1.DAT
;       - NTW_SYNTH2.DAT
;	- NTW_SYNTH3.DAT
;       - NTW_SYNTH4.DAT
;
; En el comienzo de cada parte se leera >>completamente<<
; el fichero de datos correspondiente y una vez cargado
; se hara el reparto de memoria para cada cosa.
;
; Los ficheros de datos estan construidos usando el
; sistema de Xele, de hecho se usa el mismo codigo que
; usamos para la Trashcan para construir los fichero de
; datos de la revista. He aadido una modificacion a este
; sistema para acomodarlo a la demo y es que, los ficheros
; incluidos en cada fichero de datos iran precedidos de un
; flag que nos indique si los datos se deben copiar en chip
; o en fast, ya que, dentro de cada fichero, hay datos
; mezclados de chip y de fast, debido a la organizacion por
; partes de los ficheros.
;
; Al final, los ficheros de datos no contendran datos
; pequeos como las paletas, estas y los copperlists y demas
; iran incluidos en el ejecutable. En los fichero solo
; estaran los modulos, los tablas y los graficos.
;**********************************************************

CHIP_BUFFER	EQU	512*512
FAST_BUFFER	EQU	400*1024*2


	;machine 68030

	opt	debug,l+,c-,p=68030


	section	main,code

	XDEF	_MathIeeeSingBasBase
	XDEF	_MathIeeeSingTransBase		

	XDEF	salir
	XDEF	whitepal
	XDEF	blackpal
	XDEF	cpu060

	;XREF	_GfxBase
	;XREF	_DosBase

	;XDEF	main
	XDEF	lv3_vblank
	XDEF	lv3_blit
	XDEF	lv3_copper
	XDEF	P61_music

;***********************************************************
;                   DEFINES E INCLUDES
;***********************************************************

	;include	'dh1:dev/devpac/macros.source'
	incdir	'include:'
	include	'exec/execbase.i'
	include	'exec/exec_lib.i'
	include 'graphics/graphics_lib.i'
	include 'dos/dos.i'
	include 'libraries/dos_lib.i'
	include 'include:macros2.i'

makeplayer	set	1
startmodpos	set	0

wid set 160
hei set 90


; 12 = phong1
; 15 = dottunnel
; 19 = textunnel
; 23 = zaac
; 26 = roto peska suxx
; 28 = recursive

;***********************************************************
;                         MACROS
;***********************************************************

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

resetstuff	macro
	clr.l	lv3_blit
	clr.l	lv3_vblank
	clr.l	lv3_copper
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

;***********************************************************
;                      GENERAL CODE
;***********************************************************
InitSys	;movea.l	4.w,a6			; System Base
	;lea	MathLib,a1
	;moveq.l	#0,d0
	;jsr	-552(a6)
	;move.l	d0,_MathIeeeSingBasBase
	;lea	MathTrans,a1
	;moveq.l	#0,d0
	;jsr	-552(a6)
	;move.l	d0,_MathIeeeSingTransBase


	;move.l	a7,backsp
	move.l	(sp)+,back
	move.l	(sp)+,a0
	pea	level3
	jsr	(a0)
	move.l	(sp)+,_MathIeeeSingBasBase
	move.l	(sp)+,_MathIeeeSingTransBase
	bsr	Main_part1			; Nuestro PROGRAMA !!!
	move.l	(sp)+,a0
	jsr	(a0)
	;move.l	backsp,a7
	;rts				; ADIOS !!!
	move.l	salir,-(sp)
	move.l	back,a0
	jmp	(a0)

back	dc.l	0
_MathIeeeSingBasBase	dc.l	0
_MathIeeeSingTransBase	dc.l	0

MathLib		dc.b	'mathieeesingbas.library',0
MathTrans	dc.b	"mathieeesingtrans.library",0

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	LV3_BLIT,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)
.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		btst	#6,$bfe001
		bne	.nosalir
		move.l	#-1,SALIR
.nosalir

		;ifne	makeplayer
		lea	$dff000,a6
		jsr	P61_MUSIC
		;endc

		move.l	LV3_VBLANK,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)
.no1		movem.l	(sp)+,d0-a6
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		rte

.novblank	btst	#4,d0
		beq.b	.nocopper

		move.l	LV3_COPPER,d0
		beq.b	.no2
		move.l	d0,a0
		jsr	(a0)
.no2		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		rte

cpu060		dc.w	0
salir		dc.l	0
lv3_copper	dc.l	0
lv3_vblank	dc.l	0
lv3_blit	dc.l	0
exitcode	dc.l	0


;------------ fader routine ------------
	include	'/faderrecur.asm'
;---------------------------------------

;------------    TP6.1A     ------------
example=0
asmone=0
start = 0
fade  = 0
jump = 1
system = 0
CIA = 0
exec = 1
lev6 = 1
opt020 = 1
channels = 4
use = -1
	
	incdir	'/player6.1a/source/'
	include	'include/player61.i'
	include	'P6104.asm'
;---------------------------------------

;main
;	RESET_SPRITES	c_none_spr
;	bsr	main_part1
;	tst.l	salir
;	bne	.adeu
;.adeu	rts

	XDEF	planes1
	XDEF	planes2
	XDEF	planes3
	XDEF	planes4
	XDEF	bltbuf1
	XDEF	bltbuf2
	XDEF	bltbuf3
	XDEF	sinus
	XDEF	senos

	;Begin Part DEFs and REFs
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XDEF	begin_tex1
	XDEF	begin_tex2
	XREF	begin_main
	;------------------------

	;Cross Part DEFs and REFs
	XDEF	cross_texture1
	XDEF	cross_texture2
	XDEF	cross_pals
	XREF	cross
	XREF	cross060
	XDEF	cross_gfx1
	XDEF	cross_gfx2
	;------------------------

	;1st engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XDEF	objs_tex1
	XDEF	objs_tex2
	XDEF	objs_tex3
	XREF	engine_main
	XREF	engine_2_main
	;-----------------------------

	;Rock engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	shirley3d_main
	;------------------------------

	XDEF	textunel_chunky1
	XDEF	textunel_chunky2
	XDEF	textunel_offsets
	XDEF	textunel_texture
	XREF	textunel_main
	XDEF	textunel_tex
	XDEF	textunel_shade
	XDEF	textunel_tab1
	XDEF	textunel_tab2


	;AnimalReign Part DEFs and REFs
	XDEF	ham8_empty
	XDEF	ham8_chipplanes
	XDEF	water_sprt00
	XDEF	water_sprt01
	XDEF	water_sprt02
	XDEF	water_sprt03
	XDEF	water_sprt04
	XDEF	water_map1
	XDEF	ham8_fastpic
	XREF	ham8_show
	;------------------------------

	;Recursive Part DEFs and REFs	
	XDEF	recursive_shit
	XDEF	recursive_chunky1
	XDEF	recursive_chunky2
	XDEF	recursive_texturemap
	XREF	recursive_main
	;------------------------------

	;Water3d Part DEFs and REFs
	XDEF	water3d_chunky1
	XDEF	water3d_chunky2
	XDEF	chk_water3dhei_0
	XDEF	chk_water3dhei_1
	XREF	water3d_main
	;------------------------------

	;ScrollBump Part DEFs and REFs
	XDEF	bump_chunky1
	XDEF	bump_chunky2
	XDEF	bump_offsets
	XDEF	scrollbump_phongmap
	XDEF	scrollbump_bumpmap
	XREF	bump_main
	;-----------------------------

	;Shyrley Part DEFS and REFs
	XREF	water_init
	XREF	water_fadeinit
	XREF	water_cop
	XREF	water_main
	XDEF	water_ck_8bit_gfx
	XDEF	water_y_table
	XDEF	water_shade
	XDEF	shyrley_chunky1
	XDEF	shyrley_chunky2
	XDEF	shirley_tex1
	XDEF	shirley_tex2
	XDEF	planes4
	;--------------------------

	;Persp Rotator part DEFs and REFs
	XDEF	prot_chunky1
	XDEF	prot_chunky2
	XDEF	prot_tabpos
	XDEF	prot_texturemap
	XREF	prot_main
	;--------------------------------

	XDEF	yoryko_sinus
	XDEF	yoriko_planes
	XDEF	gafasbpl
	XREF	gafas_main

main_part1
	move.l	#c_none,$dff080
	move.l	#c_none,$dff080
	nop
	move.l	#c_none,$dff080
	move.l	#c_none,$dff080
	nop

	clr.w	cpu060
	move.l	$4.w,a6
	move.w	AttnFlags(a6),d0
	btst	#AFB_68060,d0
	beq	.no060
	move.w	#-1,cpu060
.no060
	
;--------------- Let's the show begin ----------------------

	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init

	st	p61_play

	;bra	.pepe

	jsr	Begin_main
	tst.l	salir
	bne	Fin

	tst.w	cpu060
	beq	.nocross060
	jsr	cross060
	tst.l	salir
	bne	Fin
	bra	.cross060
.nocross060
	jsr	cross
	tst.l	salir
	bne	Fin

.cross060

	jsr	Engine_Main
	tst.l	salir
	bne	Fin

	jsr	textunel_main
	tst.l	salir
	bne	Fin

	jsr	ham8_show
	tst.l	salir
	bne	Fin

	jsr	recursive_main
	tst.l	salir
	bne	Fin

	jsr	water3d_main
	tst.l	salir
	bne	Fin

	jsr	bump_main
	tst.l	salir
	bne	Fin

	jsr	shirley3d_main
	tst.l	salir
	bne	Fin

	move.w	#7,d0
	move.w	#31,d1
	jsr	water_fadeinit
	jsr	water_main
	tst.l	salir
	bne	Fin

	jsr	prot_main
	tst.l	salir
	bne	Fin

	jsr	gafas_main
	tst.l	salir
	bne	fin

	sf	p61_play

        lea     $dff000,a6                                             
        moveq.l #0,d0                                                  
        bsr     p61_end                                                

	clr.w	p61_pos
	clr.w	p61_crow

	resetstuff

	rts
;-----------------------------------------------------------


;***********************************************************
;*							   *
;*			 THE END			   *
;*							   *
;***********************************************************

Fin	resetstuff

	lea	$dff000,a6
	moveq.l	#0,d0
	bsr	p61_end

	;jsr	osin

	rts

	section	GenData,data

		cnop	0,16
senos		include	include:sinuslist.s

		cnop	0,16
sinus		incbin	'/sinus64k.bin'
		incbin	'/sinus64k.bin'

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

;MemList_Part1	
;		dc.l	samples
;		dc.l	cross_gfx1
;		dc.l	cross_gfx2
;
;		dc.l	textunel_tex
;		dc.l	textunel_shade
;		dc.l	textunel_tab1
;		dc.l	textunel_tab2
;
;		dc.l	ham8_fastpic
;
;		dc.l	water_ck_8bit_gfx
;		dc.l	water_y_table
;		dc.l	water_shade
;
;		dc.l	recursive_texturemap
;
;		dc.l	phongmap
;		dc.l	bumpmap
;		dc.l	$ABADCAFE

;MemList_Part2	dc.l	samples
;		dc.l	voxel_heightmap
;		dc.l	voxel_texturemap
;		dc.l	voxel_shademap
;
;		dc.l	water_texture
;
;		dc.l	vaso_pic
;
;		dc.l	rtun_texturemap
;		dc.l	rtun_shademap
;
;		dc.l	yorykobpl
;		dc.l	$ABADCAFE
;

;**********************************************************
;                       COPPER LISTS
;**********************************************************
	section	copper,data_c
	cnop	0,64
c_none	dc.w	$2007,$fffe
	dc.w	$1fc,$0007
	dc.w	$100,$0201
	dc.w	$106,$0020
	dc.w	$180,$000
sprite	set	$120
c_none_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite,8,sprite+10,0
	dc.w	sprite,12,sprite+14,0
	dc.w	sprite,16,sprite+18,0
	dc.w	sprite,20,sprite+22,0
	dc.w	sprite,24,sprite+26,0
	dc.w	sprite,28,sprite+30,0

	dc.l	-2,-2

;--------------------------------------------------

	section	aaa,data_c
	cnop	0,16
samples	incbin	mod/P61.Nk-PowerCuts4	;ds.b	560000


	section	bbb,bss_c
	cnop	0,16
spr_off	ds.l	8

planes4	ds.b	320*256

	cnop	0,16
buffer0	ds.l	(CHIP_BUFFER)

	BUFFER	0
	RESERVE	0,bltbuf1,(8*40*256)
	RESERVE	0,bltbuf2,(8*40*256)
	RESERVE	0,bltbuf3,(8*40*256)
	RESERVE	0,planes1,(8*40*256)
	RESERVE	0,planes2,(8*40*256)
	RESERVE	0,planes3,(8*40*256)

	BUFFER	0
	RESERVE	0,ham8_empty,(1024*480)
	RESERVE	0,ham8_chipplanes,(1024*480)
	RESERVE	0,water_sprt00,(16*256*1)
	RESERVE	0,water_sprt01,(16*256*1)
	RESERVE	0,water_sprt02,(16*256*1)
	RESERVE	0,water_sprt03,(16*256*1)
	RESERVE	0,water_sprt04,(16*256*1)

	BUFFER	0
	RESERVE	0,yoriko_planes,(8*88*480)

	section	ccc,bss
	;cnop	0,16
buffer1	ds.l	(FAST_BUFFER)

	BUFFER	1
	RESERVE	1,cross_texture1,(256*256*3)
	RESERVE	1,cross_texture2,(256*256*3)
	RESERVE	1,cross_pals,(1024*257)

	RESERVE	1,textunel_chunky1,(160*128)
	RESERVE	1,textunel_chunky2,(160*128)
	RESERVE	1,textunel_offsets,(320*256*4)
	RESERVE	1,textunel_texture,(256*256*2)

	RESERVE 1,dummy1,(320*256)
	RESERVE	1,engine_chunky1,(320*256)
	RESERVE	1,engine_chunky2,(320*256)
	RESERVE 1,dummy2,(320*256)

	RESERVE	1,recursive_shit,4096
	RESERVE	1,recursive_chunky1,320*256
	RESERVE	1,recursive_chunky2,320*256

	RESERVE	1,water3d_chunky1,(320*256)
	RESERVE	1,water3d_chunky2,(320*256)
	RESERVE	1,chk_water3dhei_0,(160*130*2)
	RESERVE	1,chk_water3dhei_1,(160*130*2)

	RESERVE	1,bump_shit,(1024)
	RESERVE	1,bump_chunky1,(320*90)
	RESERVE	1,bump_chunky2,(320*90)
	RESERVE	1,bump_offsets,(2528*72*4)

	RESERVE	1,shyrley_chunky1,(320*256)
	RESERVE	1,shyrley_chunky2,(320*256)

	RESERVE	1,yoryko_sinus,64*1024


buffer2	ds.b	(320*256+1024*21+2*4*2*256)
	BUFFER	2
	RESERVE	2,prot_shit0,1024*32
	RESERVE	2,prot_chunky1,(320*256)
	RESERVE	2,prot_chunky2,(320*256)
	RESERVE	2,prot_tabpos,(2*4*2*256)


	section	bigdata,data

buffer3	incbin	ntw_syn2.bin
	
	BUFFER	3
	RESERVE	3,begin_tex1,65536
	RESERVE	3,begin_tex2,65600
	RESERVE	3,cross_gfx1,16384
	RESERVE	3,cross_gfx2,16384
	RESERVE	3,objs_tex1,61440
	RESERVE	3,objs_tex2,65536
	RESERVE	3,objs_tex3,65536
	RESERVE	3,textunel_tex,65536
	RESERVE	3,textunel_shade,16384
	RESERVE	3,textunel_tab1,81920
	RESERVE	3,textunel_tab2,163840
	RESERVE	3,ham8_fastpic,491520
	RESERVE	3,water_map1,61440
	RESERVE	3,recursive_texturemap,65536
	RESERVE	3,scrollbump_phongmap,49152
	RESERVE	3,scrollbump_bumpmap,182016
	RESERVE	3,shirley_tex1,65536
	RESERVE	3,shirley_tex2,65536
	RESERVE	3,water_ck_8bit_gfx,81920
	RESERVE	3,water_y_table,81920
	RESERVE	3,water_shade,196608
	RESERVE	3,prot_texturemap,65536
	RESERVE	3,gafasbpl,327680
