;**********************************************************
;
;               SYNTHESIS BY NETWORK IN 1998
;
; Estructura de carga de la demo:
;
;     1.- Parte de introduccion
;     2.- Primera parte principal   
;     3.- Segunda parte principal
;     4.- Parte final
;
; Los datos se iran cargando por partes. Para ello
; tendremos 4 ficheros de datos cada uno para una
; parte:
;
;	- Synthesis.exe
;	- NTW_SYNTH1.DAT
;       - NTW_SYNTH2.DAT
;	- NTW_SYNTH3.DAT
;       - NTW_SYNTH4.DAT
;
; En el comienzo de cada parte se leera >>completamente<<
; el fichero de datos correspondiente y una vez cargado
; se hara el reparto de memoria para cada cosa.
;
; Los ficheros de datos estan construidos usando el
; sistema de Xele, de hecho se usa el mismo codigo que
; usamos para la Trashcan para construir los fichero de
; datos de la revista. He aadido una modificacion a este
; sistema para acomodarlo a la demo y es que, los ficheros
; incluidos en cada fichero de datos iran precedidos de un
; flag que nos indique si los datos se deben copiar en chip
; o en fast, ya que, dentro de cada fichero, hay datos
; mezclados de chip y de fast, debido a la organizacion por
; partes de los ficheros.
;
; Al final, los ficheros de datos no contendran datos
; pequeos como las paletas, estas y los copperlists y demas
; iran incluidos en el ejecutable. En los fichero solo
; estaran los modulos, los tablas y los graficos.
;**********************************************************

CHIP_BUFFER	EQU	8*40*256*6
FAST_BUFFER	EQU	320*256*3


	;machine 68030

	opt	debug,l+,c-,p=68030


	section	main,code

	XDEF	_MathIeeeSingBasBase
	XDEF	_MathIeeeSingTransBase		

	XDEF	salir
	XDEF	whitepal
	XDEF	blackpal

	;XREF	_GfxBase
	;XREF	_DosBase

	;XDEF	main
	XDEF	lv3_vblank
	XDEF	lv3_blit
	XDEF	lv3_copper
	XDEF	P61_music
	XDEF	salir

;***********************************************************
;                   DEFINES E INCLUDES
;***********************************************************

	;include	'dh1:dev/devpac/macros.source'
	incdir	'include:'
	include	'exec/execbase.i'
	include	'exec/exec_lib.i'
	include 'graphics/graphics_lib.i'
	include 'dos/dos.i'
	include 'libraries/dos_lib.i'
	include 'include:macros2.i'

makeplayer	set	1
startmodpos	set	0

wid set 160
hei set 90


; 12 = phong1
; 15 = dottunnel
; 19 = textunnel
; 23 = zaac
; 26 = roto peska suxx
; 28 = recursive

;***********************************************************
;                         MACROS
;***********************************************************

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

resetstuff	macro
	clr.l	lv3_blit
	clr.l	lv3_vblank
	clr.l	lv3_copper
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

;***********************************************************
;                      GENERAL CODE
;***********************************************************
InitSys
	move.l	(sp)+,back
	move.l	(sp)+,a0
	pea	level3
	jsr	(a0)
	move.l	(sp)+,_MathIeeeSingBasBase
	move.l	(sp)+,_MathIeeeSingTransBase
	bsr	main			; Nuestro PROGRAMA !!!
	move.l	(sp)+,a0
	jsr	(a0)
	move.l	salir,-(sp)
	move.l	back,a0
	jmp	(a0)

back	dc.l	0
_MathIeeeSingBasBase	dc.l	0
_MathIeeeSingTransBase	dc.l	0

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	LV3_BLIT,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)
.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		btst	#6,$bfe001
		bne	.nosalir
		move.l	#-1,SALIR
.nosalir

		;ifne	makeplayer
		;;;lea	$dff000,a6
		;;;jsr	P61_MUSIC
		;endc

		move.l	LV3_VBLANK,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)
.no1		movem.l	(sp)+,d0-a6
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		rte

.novblank	btst	#4,d0
		beq.b	.nocopper

		move.l	LV3_COPPER,d0
		beq.b	.no2
		move.l	d0,a0
		jsr	(a0)
.no2		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		rte

salir		dc.l	0
lv3_copper	dc.l	0
lv3_vblank	dc.l	0
lv3_blit	dc.l	0
exitcode	dc.l	0


;------------ fader routine ------------
	include	'/faderrecur.asm'
;---------------------------------------

;------------    TP6.1A     ------------
example=0
asmone=0
start = 0
fade  = 0
jump = 1
system = 0
CIA = 1
exec = 1
lev6 = 0
opt020 = 1
channels = 4
use = -1
	
	incdir	'/player6.1a/source/'
	include	'include/player61.i'
	include	'p6104.asm'
;---------------------------------------

;***********************************************************
;*							   *
;*			INTRO PART			   *
;*		 	    				   *
;*							   *
;***********************************************************
	XDEF	planes1
	XDEF	planes2
	XDEF	planes3
	XDEF	bltbuf1
	XDEF	bltbuf2
	XDEF	bltbuf3

	XDEF	sinus

	;Intro part DEFs and REFs
	XDEF	rotozoomrecur_chunky1
	XDEF	rotozoomrecur_chunky2
	XDEF	rotozoomrecur_freespace
	XDEF	brush0
	XDEF	brush1
	XDEF	brush2
	XDEF	brush3
	XDEF	brush4
	XDEF	brush5
	XDEF	brush6
	XDEF	brush7
	XDEF	brush8
	XDEF	brush9
	XREF	roto_main
	;------------------------

main

	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init

	jsr	roto_main

        lea     $dff000,a6                                             
        moveq.l #0,d0                                                  
        bsr     p61_end                                                

	rts
;-----------------------------------------------------------


;***********************************************************
;*							   *
;*			 THE END			   *
;*							   *
;***********************************************************

Fin	resetstuff

	lea	$dff000,a6
	moveq.l	#0,d0
	bsr	p61_end

	;jsr	osin

	rts

	section	GenData,data

		cnop	0,16
sinus		incbin	'/sinus64k.bin'
		incbin	'/sinus64k.bin'

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

;**********************************************************
;                       COPPER LISTS
;**********************************************************
	section	copper,data_c
	cnop	0,64
c_none	dc.w	$1fc,$0007
	dc.w	$100,$0201
	dc.w	$106,$0020
	dc.w	$180,$000
sprite	set	$120
c_none_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite,8,sprite+10,0
	dc.w	sprite,12,sprite+14,0
	dc.w	sprite,16,sprite+18,0
	dc.w	sprite,20,sprite+22,0
	dc.w	sprite,24,sprite+26,0
	dc.w	sprite,28,sprite+30,0

	dc.l	-2,-2

;--------------------------------------------------

	section	aaa,data_c
	cnop	0,16
samples	incbin	recursive-intro/music/p61.Nk-Principio3


	section	bbb,bss_c
	cnop	0,16
spr_off	ds.l	8

	cnop	0,16
buffer0	ds.b	(CHIP_BUFFER)

	BUFFER	0
	RESERVE	0,bltbuf1,(8*40*256)
	RESERVE	0,bltbuf2,(8*40*256)
	RESERVE	0,bltbuf3,(8*40*256)
	RESERVE	0,planes1,(8*40*256)
	RESERVE	0,planes2,(8*40*256)
	RESERVE	0,planes3,(8*40*256)


	section	ccc,bss
	;cnop	0,16
buffer1	ds.l	(FAST_BUFFER)

	BUFFER	1
	RESERVE	1,rotozoomrecur_shit,4096
	RESERVE	1,rotozoomrecur_chunky1,320*256
	RESERVE	1,rotozoomrecur_chunky2,320*256
	RESERVE	1,rotozoomrecur_freespace,256*128/8

	section	bigdata,data

buffer3	incbin	ntw_syn1.bin
	
	BUFFER	3
	RESERVE	3,brush0,4096
	RESERVE	3,brush1,4096
	RESERVE	3,brush2,4096
	RESERVE	3,brush3,4096
	RESERVE	3,brush4,4096
	RESERVE	3,brush5,4096
	RESERVE	3,brush6,4096
	RESERVE	3,brush7,4096
	RESERVE	3,brush8,4096
	RESERVE	3,brush9,4096
