;**********************************************************
;
;               SYNTHESIS BY NETWORK IN 1998
;
; Estructura de carga de la demo:
;
;     1.- Parte de introduccion
;     2.- Primera parte principal
;     3.- Segunda parte principal
;     4.- Parte final
;
; Los datos se iran cargando por partes. Para ello
; tendremos 4 ficheros de datos cada uno para una
; parte:
;
;	- Synthesis.exe
;	- NTW_SYNTH1.DAT
;       - NTW_SYNTH2.DAT
;	- NTW_SYNTH3.DAT
;       - NTW_SYNTH4.DAT
;
; En el comienzo de cada parte se leera >>completamente<<
; el fichero de datos correspondiente y una vez cargado
; se hara el reparto de memoria para cada cosa.
;
; Los ficheros de datos estan construidos usando el
; sistema de Xele, de hecho se usa el mismo codigo que
; usamos para la Trashcan para construir los fichero de
; datos de la revista. He aadido una modificacion a este
; sistema para acomodarlo a la demo y es que, los ficheros
; incluidos en cada fichero de datos iran precedidos de un
; flag que nos indique si los datos se deben copiar en chip
; o en fast, ya que, dentro de cada fichero, hay datos
; mezclados de chip y de fast, debido a la organizacion por
; partes de los ficheros.
;
; Al final, los ficheros de datos no contendran datos
; pequeos como las paletas, estas y los copperlists y demas
; iran incluidos en el ejecutable. En los fichero solo
; estaran los modulos, los tablas y los graficos.
;**********************************************************

	;machine 68030

	opt	debug,l+,c-,p=68030


	section	main,code

	XDEF	_MathIeeeSingBasBase
	XDEF	_MathIeeeSingTransBase		

	XDEF	salir
	XDEF	whitepal
	XDEF	blackpal

	;XREF	_GfxBase
	;XREF	_DosBase

	;XDEF	main
	XDEF	lv3_vblank
	XDEF	lv3_blit
	XDEF	lv3_copper
	XREF	P61_music
	XDEF	salir

	XREF	scroll_main

;***********************************************************
;                   DEFINES E INCLUDES
;***********************************************************

	;include	'dh1:dev/devpac/macros.source'
	incdir	'include:'
	include	'exec/execbase.i'
	include	'exec/exec_lib.i'
	include 'graphics/graphics_lib.i'
	include 'dos/dos.i'
	include 'libraries/dos_lib.i'
	include 'include:macros2.i'

makeplayer	set	1
startmodpos	set	0

wid set 160
hei set 90


; 12 = phong1
; 15 = dottunnel
; 19 = textunnel
; 23 = zaac
; 26 = roto peska suxx
; 28 = recursive

;***********************************************************
;                         MACROS
;***********************************************************

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

resetstuff	macro
	clr.l	lv3_blit
	clr.l	lv3_vblank
	clr.l	lv3_copper
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

;***********************************************************
;                      GENERAL CODE
;***********************************************************


InitSys
	move.l	(sp)+,back
	move.l	(sp)+,a0
	pea	level3
	jsr	(a0)
	move.l	(sp)+,_MathIeeeSingBasBase
	move.l	(sp)+,_MathIeeeSingTransBase
	jsr	scroll_main			; Nuestro PROGRAMA !!!
	move.l	(sp)+,a0
	jsr	(a0)
	move.l	salir,-(sp)
	move.l	back,a0
	jmp	(a0)

back	dc.l	0
_MathIeeeSingBasBase	dc.l	0
_MathIeeeSingTransBase	dc.l	0

level3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	LV3_BLIT,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)
.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		move.w	#$40,$dff09c
		move.w	#$40,$dff09c
		nop
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		btst	#6,$bfe001
		bne	.nosalir
		move.l	#-1,SALIR
.nosalir

		;ifne	makeplayer
		lea	$dff000,a6
		jsr	P61_MUSIC
		;endc

		move.l	LV3_VBLANK,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)
.no1		movem.l	(sp)+,d0-a6
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		move.w	#$20,$dff09c
		move.w	#$20,$dff09c
		nop
		rte

.novblank	btst	#4,d0
		beq.b	.nocopper

		move.l	LV3_COPPER,d0
		beq.b	.no2
		move.l	d0,a0
		jsr	(a0)
.no2		movem.l	(sp)+,d0-a6
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		move.w	#$10,$dff09c
		move.w	#$10,$dff09c
		nop
		rte

.nocopper	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		move.w	#$70,$dff09c
		move.w	#$70,$dff09c
		nop
		rte

salir		dc.l	0
lv3_copper	dc.l	0
lv3_vblank	dc.l	0
lv3_blit	dc.l	0
exitcode	dc.l	0

;-----------------------------------------------------------


	section	GenData,data

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

