;**********************************************************
;
;               SYNTHESIS BY NETWORK IN 1998
;
; Estructura de carga de la demo:
;
;     1.- Parte de introduccion
;     2.- Primera parte principal
;     3.- Segunda parte principal
;     4.- Parte final
;
; Los datos se iran cargando por partes. Para ello
; tendremos 4 ficheros de datos cada uno para una
; parte:
;
;	- Synthesis.exe
;	- NTW_SYNTH1.DAT
;       - NTW_SYNTH2.DAT
;	- NTW_SYNTH3.DAT
;       - NTW_SYNTH4.DAT
;
; En el comienzo de cada parte se leera >>completamente<<
; el fichero de datos correspondiente y una vez cargado
; se hara el reparto de memoria para cada cosa.
;
; Los ficheros de datos estan construidos usando el
; sistema de Xele, de hecho se usa el mismo codigo que
; usamos para la Trashcan para construir los fichero de
; datos de la revista. He aadido una modificacion a este
; sistema para acomodarlo a la demo y es que, los ficheros
; incluidos en cada fichero de datos iran precedidos de un
; flag que nos indique si los datos se deben copiar en chip
; o en fast, ya que, dentro de cada fichero, hay datos
; mezclados de chip y de fast, debido a la organizacion por
; partes de los ficheros.
;
; Al final, los ficheros de datos no contendran datos
; pequeos como las paletas, estas y los copperlists y demas
; iran incluidos en el ejecutable. En los fichero solo
; estaran los modulos, los tablas y los graficos.
;**********************************************************

CHIP_BUFFER	EQU	300*512
FAST_BUFFER	EQU	400*1024*2


	;machine 68030

	opt	debug,l+,c-,p=68030


	section	main,code

	XDEF	salir
	XDEF	whitepal
	XDEF	blackpal

	;XREF	_GfxBase
	;XREF	_DosBase

	XDEF	main
	XDEF	lv3_vblank
	XDEF	lv3_blit
	XDEF	lv3_copper
	XDEF	P61_music
	XDEF	salir

;***********************************************************
;                   DEFINES E INCLUDES
;***********************************************************

	;include	'dh1:dev/devpac/macros.source'
	incdir	'include:'
	include	'exec/execbase.i'
	include	'exec/exec_lib.i'
	include 'graphics/graphics_lib.i'
	include 'dos/dos.i'
	include 'libraries/dos_lib.i'
	include 'include:macros2.i'

makeplayer	set	1
startmodpos	set	0

wid set 160
hei set 90


; 12 = phong1
; 15 = dottunnel
; 19 = textunnel
; 23 = zaac
; 26 = roto peska suxx
; 28 = recursive

;***********************************************************
;                         MACROS
;***********************************************************

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

resetstuff	macro
	clr.l	lv3_blit
	clr.l	lv3_vblank
	clr.l	lv3_copper
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

salir		dc.l	0
lv3_copper	dc.l	0
lv3_vblank	dc.l	0
lv3_blit	dc.l	0
exitcode	dc.l	0

;***********************************************************
;                      GENERAL CODE
;***********************************************************

;---------- Startup de Troglo ----------
	include	'startupdarkness.s'
;---------------------------------------

;------------ fader routine ------------
	include	'/faderrecur.asm'
;---------------------------------------

;------------    TP6.1A     ------------
example=0
asmone=0
start = 0
fade  = 0
jump = 1
system = 0
CIA = 0
exec = 1
lev6 = 1
opt020 = 1
channels = 4
use = -1
	
	incdir	'/player6.1a/source/'
	include	'include/player61.i'
	include	'tP61.asm'
;---------------------------------------

main
	jsr	osout
	;move.l	$4.w,a6
	;jsr	-132(a6)
	RESET_SPRITES	c_none_spr
	;bsr	main_intropart
	tst.l	salir
	bne	.adeu
	bsr	main_part1
	tst.l	salir
	bne	.adeu
	;bsr	main_part2
	tst.l	salir
	bne	.adeu
	;move.l	$4.w,a6
	;jsr	-138(a6)
.adeu	jsr	osin
	rts

;***********************************************************
;*							   *
;*			INTRO PART			   *
;*		 	    				   *
;*							   *
;***********************************************************

	;Intro part DEFs and REFs
	XDEF	rotozoomrecur_chunky1
	XDEF	rotozoomrecur_chunky2
	XDEF	rotozoomrecur_freespace
	XREF	roto_main
	;------------------------

main_intropart
;-------------- Carga del fichero de datos -----------------

	READ	#datafile,File_IntroPart,File_IntroPart_h,datalength

	 lea	MemList_IntroPart,a0
	lea	datafile,a1
	bsr	LoadData
;-----------------------------------------------------------

	lea	$dff000,a6
	move.w	#$83c0,$096(a6)	; dmacon on
	move.w	#$e070,$09a(a6)	; intena on

	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init

	jsr	roto_main

        lea     $dff000,a6                                             
        moveq.l #0,d0                                                  
        bsr     p61_end                                                

	clr.w	P61_Pos
	clr.w	P61_CRow

        ;lea     $dff000,a6                                             
	;move.w	#$6070,$09a(a6)	; intena off

	resetstuff

	;Antes de ir a la siguiente parte limpiamos toda la chipmem
	lea	buffer0,a0
	move.l	#((CHIP_BUFFER*4)/128)-1,d0
	moveq.l	#0,d1
.clrloop
	rept	32
	move.l	d1,(a0)+
	endr
	dbf	d0,.clrloop

	;Antes de ir a la siguiente parte limpiamos toda la fastmem
	lea	buffer1,a0
	move.l	#((FAST_BUFFER*4)/128)-1,d0
	moveq.l	#0,d1
.clrloop2
	rept	32
	move.l	d1,(a0)+
	endr
	dbf	d0,.clrloop2

	rts



;***********************************************************
;*							   *
;*			 PARTE 1			   *
;* -rotocrossfade 	   				   *
;* -3d							   *
;* -tunnel						   *
;* -textunnel						   *
;* -3d							   *
;* -recursive						   *
;***********************************************************

	XDEF	planes1
	XDEF	planes2
	XDEF	planes3
	XDEF	planes4
	XDEF	bltbuf1
	XDEF	bltbuf2
	XDEF	bltbuf3
	XDEF	sinus
	XDEF	senos

	;Begin Part DEFs and REFs
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	begin_main
	;------------------------

	;Cross Part DEFs and REFs
	XDEF	cross_texture1
	XDEF	cross_texture2
	XDEF	cross_pals
	XREF	cross
	XREF	cross_gfx1
	XREF	cross_gfx2
	;------------------------

	;1st engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	engine_main
	XREF	engine_2_main
	;-----------------------------

	;Rock engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	shirley3d_main
	;------------------------------

	XDEF	textunel_chunky1
	XDEF	textunel_chunky2
	XDEF	textunel_offsets
	XDEF	textunel_texture
	XREF	textunel_main
	XREF	textunel_tex
	XREF	textunel_shade
	XREF	textunel_tab1
	XREF	textunel_tab2


	;AnimalReign Part DEFs and REFs
	XDEF	ham8_chipplanes
	XDEF	water_sprt00
	XDEF	water_sprt01
	XDEF	water_sprt02
	XDEF	water_sprt03
	XDEF	water_sprt04
	XREF	ham8_fastpic
	XREF	ham8_show
	;------------------------------

	;Recursive Part DEFs and REFs	
	XDEF	recursive_shit
	XDEF	recursive_chunky1
	XDEF	recursive_chunky2
	XREF	recursive_main
	XREF	recursive_texturemap
	;------------------------------

	;Water3d Part DEFs and REFs
	XDEF	water3d_chunky1
	XDEF	water3d_chunky2
	XDEF	chk_water3dhei_0
	XDEF	chk_water3dhei_1
	XREF	water3d_main
	;------------------------------

	;ScrollBump Part DEFs and REFs
	XDEF	bump_chunky1
	XDEF	bump_chunky2
	XDEF	bump_offsets
	XREF	phongmap
	XREF	bumpmap
	XREF	bump_main
	;-----------------------------

	;Shyrley Part DEFS and REFs
	XREF	water_init
	XREF	water_fadeinit
	XREF	water_cop
	XREF	water_main
	XREF	water_ck_8bit_gfx
	XREF	water_y_table
	XREF	water_shade
	XDEF	shyrley_chunky1
	XDEF	shyrley_chunky2
	XDEF	planes4
	;--------------------------

	;Persp Rotator part DEFs and REFs
	XDEF	prot_chunky1
	XDEF	prot_chunky2
	XDEF	prot_tabpos
	XREF	prot_main
	;--------------------------------

	XREF	gafas_main
	;XREF	gafasbpl

saveirq

main_part1
	
;-------------- Carga del fichero de datos -----------------

	jsr	osininterdemo

	READ	#datafile,File_Part1,File_Part1_h,datalength

	lea	MemList_Part1,a0
	lea	datafile,a1
	bsr	LoadData

	jsr	osoutinterdemo

;-----------------------------------------------------------


;--------------- Let's the show begin ----------------------
	;lea	$dff000,a6
	;;move.w	#$83c0,$096(a6)	; dmacon on
	;move.w	#%0111111111111111,$096(a6)	; dmacon on
	;move.w	#%1000001111000000,$096(a6)	; dmacon on
	;;move.w	#%0111111111111111,$09a(a6)	; dmacon on
	;move.w	#%1100000001010000,$9a(a6)	* Enable desired IRQs
	;;move.w	#$e070,$09a(a6)	; intena on


	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init


	;jsr	osout

	st	p61_play

	;bra	.pepe

	jsr	Begin_main
	tst.l	salir
	bne	Fin

;.pepe
	;move.l	#9,d0
	;jsr	P61_SetPosition
	jsr	cross
	tst.l	salir
	bne	Fin

.pepe
	;move.l	#10,d0
	;bsr	P61_SetPosition
	jsr	Engine_Main
	tst.l	salir
	bne	Fin

;.pepe
	jsr	textunel_main
	tst.l	salir
	bne	Fin

	;move.l	#18,d0
	;jsr	P61_SetPosition
	jsr	ham8_show
	tst.l	salir
	bne	Fin

;.pepe	;move.l	#19,d0
	;jsr	P61_SetPosition
	jsr	recursive_main
	tst.l	salir
	bne	Fin

	;move.l	#25,d0
	;jsr	P61_SetPosition
	jsr	water3d_main
	tst.l	salir
	bne	Fin


;.pepe:
	;move.l	#22,d0
	;jsr	P61_SetPosition
	jsr	bump_main
	tst.l	salir
	bne	Fin

;.pepe:
	;move.l	#30,d0
	;jsr	P61_Setposition
	;;jsr	Engine_2_Main
	jsr	shirley3d_main
	tst.l	salir
	bne	Fin

;.pepe	;move.l	#33,d0
	;jsr	P61_Setposition
	;jsr	water_init
	move.w	#7,d0
	move.w	#31,d1
	jsr	water_fadeinit
	jsr	water_main
	tst.l	salir
	bne	Fin

;.pepe	move.l	#36,d0
;	jsr	P61_Setposition
	jsr	prot_main
	tst.l	salir
	bne	Fin

;.pepe	move.l	#37,d0
;	jsr	P61_Setposition
	jsr	gafas_main
	tst.l	salir
	bne	fin

        lea     $dff000,a6                                             
        moveq.l #0,d0                                                  
        bsr     p61_end                                                

	clr.w	p61_pos
	clr.w	p61_crow

	resetstuff

	;Antes de ir a la siguiente parte limpiamos toda la chipmem
	lea	buffer0,a0
	move.l	#((CHIP_BUFFER*4)/128)-1,d0
	moveq.l	#0,d1
.clrloop
	rept	32
	move.l	d1,(a0)+
	endr
	dbf	d0,.clrloop

	;Antes de ir a la siguiente parte limpiamos toda la fastmem
	lea	buffer1,a0
	move.l	#((FAST_BUFFER*4)/128)-1,d0
	moveq.l	#0,d1
.clrloop2
	rept	32
	move.l	d1,(a0)+
	endr
	dbf	d0,.clrloop2

	rts
;-----------------------------------------------------------


;***********************************************************
;*							   *
;*							   *
;*			 PARTE 2			   *
;*							   *
;*							   *
;***********************************************************

	;RotoVoxel DEFs and REFs
	XDEF	voxel_chunky1
	XDEF	voxel_chunky2
	XDEF	voxel_drawing
	XDEF	voxel_divutab
	XDEF	voxel_texheimap
	XREF	voxel_heightmap
	XREF	voxel_texturemap
	XREF	voxel_shademap
	XREF	voxel_main
	;-----------------------

	;Zoom part DEFs and REFs
	XDEF	zoom_bpl_sh0
	XDEF	zoom_bpl_0
	XDEF	zoom_bpl_1
	XDEF	zoom_bpl_2
	XDEF	zoom_bpl_3
	XDEF	zoom_bpl_4
	XDEF	zoom_bpl_5
	XDEF	zoom_bpl_6
	XDEF	zoom_bpl_7
	XDEF	zoom_bpl_8
	XDEF	zoom_bpl_sh1
	XDEF	zoom_multable
	XDEF	zoom_coltable1
	XDEF	zoom_coltable2
	XDEF	zoom_tempbpl
	XDEF	zoom_palette
	XREF	zoom_main
	;-----------------------

	;Water 2d part DEFs and REFs
	XDEF	water2d_chunky1
	XDEF	water2d_chunky2
	XDEF	chk_water2dhei_0
	XDEF	chk_water2dhei_1
	XREF	water_texture
	XREF	waterback_main
	;---------------------------

	;Vaso part DEFs and REFs
	XREF	vaso_pic
	XREF	vaso_main
	XDEF	vaso_chippic
	;-----------------------

	;Engine Part DEFS and REFS
	XDEF	engine_chunky1
	XDEF	engine_chunky2
	XREF	engine_3_main
	;-------------------------

	;Rotozoom new part DEFs and REFs
	XDEF	rotozoom_shit
	XDEF	rotozoom_chunky1
	XDEF	rotozoom_chunky2
	XDEF	rotozoom_tex1
	XREF	rotozoom_main
	;-------------------------------

	;Raycasting tunnel part DEFs and REFs
	XDEF	rtun_chunky1
	XDEF	rtun_chunky2
	XDEF	rtun_grid
	XDEF	rtun_bumpmap
	XDEF	rtun_atan
	XREF	rtun_texturemap
	XREF	rtun_shademap
	XREF	rtun_main
	;------------------------------------

	;Greets part DEFs and REFs
	XDEF	greets_chunky1
	XDEF	greets_buffer
	XREF	greets_main
	;-------------------------

	;Yoriko part DEFs and REFs
	XDEF	yoriko_planes
	XDEF	yoryko_sinus
	XREF	yorykobpl
	XREF	scrollwipe_main
	;-------------------------

	;Rotobump part DEFs and REFs
	XDEF	rotobump_chunky1
	XDEF	rotobump_chunky2
	XDEF	rotobump_bump_
	XDEF	rotobump_phong_
	XREF	rotobump_main
	;---------------------------

	;Starfield part DEFs and REfs
	XDEF	bpl_stars_0
	XDEF	bpl_stars_1
	XDEF	bpl_stars_2
	XDEF	bpl_stars_3
	XDEF	bpl_stars_4
	XDEF	bpl_stars_5
	XDEF	bpl_stars_6
	XDEF	bpl_stars_7
	XDEF	bpl_stars_8
	XDEF	stars_positions
	XREF	stars_main

Main_Part2
;-------------- Carga del fichero de datos -----------------
	READ	#datafile,File_Part2,File_Part2_h,datalength

	lea	MemList_Part2,a0
	lea	datafile,a1
	bsr	LoadData
;-----------------------------------------------------------

	lea	$dff000,a6
	;move.w	#$83c0,$096(a6)	; dmacon on
	;move.w	#$e070,$09a(a6)	; intena on

	lea	samples,a0
	sub.l	a1,a1
	sub.l	a2,a2
	moveq.l	#0,d0
	bsr	P61_Init

	;bra	.cojo

	jsr	voxel_main
	tst.l	salir
	bne	Fin

	;move.l	#4,d0
	;jsr	p61_setposition
	jsr	zoom_main
	tst.l	salir
	bne	Fin

	;move.l	#5,d0
	;jsr	p61_setposition
	jsr	waterback_main
	tst.l	salir
	bne	Fin

	;move.l	#7,d0
	;jsr	p61_setposition
	jsr	vaso_main
	tst.l	salir
	bne	Fin

.cojo
	jsr	engine_3_main
	tst.l	salir
	bne	Fin

	;move.l	#13,d0
	;jsr	p61_setposition
	jsr	rotozoom_main
	tst.l	salir
	bne	Fin

	;move.l	#21,d0
	;jsr	p61_setposition
	jsr	rtun_main
	tst.l	salir
	bne	Fin

	;move.l	#22,d0
	;jsr	p61_setposition
	jsr	greets_main
	tst.l	salir
	bne	Fin

	;move.l	#26,d0
	;jsr	p61_setposition
	jsr	scrollwipe_main
	tst.l	salir
	bne	Fin

	jsr	rotobump_main
	tst.l	salir
	bne	Fin

	;move.l	#32,d0
	;jsr	p61_setposition
	jsr	stars_main
	tst.l	salir
	bne	Fin

;***********************************************************
;*							   *
;*			 THE END			   *
;*							   *
;***********************************************************

Fin	resetstuff

	lea	$dff000,a6
	moveq.l	#0,d0
	bsr	p61_end

	;jsr	osin

	rts

;***********************************************************
;             CARGADOR FICHERO DE DATOS
;***********************************************************
	cnop	0,16
LoadData	
	move.l	a1,a2

	move.l	(a2)+,d0		;numero de ficheros
	subq.l	#1,d0
	
.loop	move.l	(a0)+,a4		;puntero de la lista
	cmp.l	#$ABADCAFE,a4
	beq	.end

	move.b	(a2)+,d1		;chip o fast?
	beq	.infastmem		;fast

	move.l	(a2)+,d1
	lea	(a1,d1.l),a3
	move.l	(a2)+,d2
	subq.l	#1,d2
.chiploop	
	move.b	(a3)+,(a4)+
	;dbf	d2,.chiploop
	subq.l	#1,d2
	bge	.chiploop	
	bra	.next

.infastmem				;si esta en fast, no se copia a
	move.l	(a2)+,d1		;ningun sitio.
	lea	(a1,d1.l),a3
	move.l	a3,(a4)
	addq.l	#4,a2

.next	dbf	d0,.loop
.end	rts



	section	GenData,data

		cnop	0,16
senos		include	include:sinuslist.s

		cnop	0,16
sinus		incbin	'/sinus64k.bin'
		incbin	'/sinus64k.bin'

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

File_IntroPart	dc.b	"NTW_SYNTH1.DAT",0
File_Part1	dc.b	"NTW_SYNTH2.DAT",0
File_Part2	dc.b	"NTW_SYNTH3.DAT",0
File_FinalPart	dc.b	"NTW_SYNTH4.DAT",0

File_IntroPart_h
		dc.l	0
File_Part1_h
		dc.l	0
File_Part2_h
		dc.l	0
File_FinalPart_h
		dc.l	0

MemList_IntroPart
		dc.l	samples

		dc.l	raw_wasi
		dc.l	raw_wind
		dc.l	raw_leunam
		dc.l	raw_zaac
		dc.l	raw_made
		dc.l	raw_rogu3
		dc.l	raw_hh
		dc.l	raw_nork
		dc.l	raw_djuno
		dc.l	raw_blue
		dc.l	$ABADCAFE

raw_wasi	dc.l	0
raw_wind	dc.l	0
raw_leunam	dc.l	0
raw_zaac	dc.l	0
raw_made	dc.l	0
raw_rogu3	dc.l	0
raw_hh		dc.l	0
raw_nork	dc.l	0
raw_djuno	dc.l	0
raw_blue	dc.l	0

MemList_Part1	
		dc.l	samples
		dc.l	cross_gfx1
		dc.l	cross_gfx2

		dc.l	textunel_tex
		dc.l	textunel_shade
		dc.l	textunel_tab1
		dc.l	textunel_tab2

		dc.l	ham8_fastpic

		dc.l	water_ck_8bit_gfx
		dc.l	water_y_table
		dc.l	water_shade

		dc.l	recursive_texturemap

		dc.l	phongmap
		dc.l	bumpmap
		dc.l	$ABADCAFE

MemList_Part2	dc.l	samples
		dc.l	voxel_heightmap
		dc.l	voxel_texturemap
		dc.l	voxel_shademap

		dc.l	water_texture

		dc.l	vaso_pic

		dc.l	rtun_texturemap
		dc.l	rtun_shademap

		dc.l	yorykobpl
		dc.l	$ABADCAFE


;**********************************************************
;                       COPPER LISTS
;**********************************************************
	section	copper,data_c
	cnop	0,64
c_none	dc.w	$1fc,$0007
	dc.w	$100,$0201
	dc.w	$106,$0020
	dc.w	$180,$000
sprite	set	$120
c_none_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite,8,sprite+10,0
	dc.w	sprite,12,sprite+14,0
	dc.w	sprite,16,sprite+18,0
	dc.w	sprite,20,sprite+22,0
	dc.w	sprite,24,sprite+26,0
	dc.w	sprite,28,sprite+30,0

	dc.l	-2,-2


;-------------- Intro Part ---------------------------------
	cnop	0,64
c_roto	dc.w	$1fc,$000f
	dc.w	$100,$0201

	dc.w	$2007,$fffe

c_roto_bpls	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0
	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

c_roto_spr	dc.w	$120,0,$122,0
	dc.w	$124,0,$126,0
	dc.w	$128,0,$12a,0
	dc.w	$12c,0,$12e,0
	dc.w	$130,0,$132,0
	dc.w	$134,0,$136,0
	dc.w	$138,0,$13a,0
	dc.w	$13c,0,$13e,0

xst set	14	; 14 14
xnd set	36	; 44 36

yst set $100-(256-64)
	dc.w	$08e,$00a1|(yst<<8)
	dc.w	$090,$00a1

	dc.w	$092,xst*4
	dc.w	$094,xnd*4

	dc.w	$100,$0201|$7000
	dc.w	$102,$8800
	dc.w	$104,$0024
	dc.w	$106,$0000|$00c0|$0002
	dc.w	$10c,$0088

	dc.w	$108,0
	dc.w	$10a,0

	dc.w	$ffdf,$fffe
	dc.w	$3007,$fffe
c_roto_pal	ds.b	2112

	dc.l	-2,-2

;-----------------------------------------------------------

;	cnop	0,64
;c_pic	dc.w	$1fc,$0007
;
;sprite	set	$120
;c_pic_spr
;	dc.w	sprite,0,sprite+2,0
;	dc.w	sprite+4,0,sprite+6,0
;	dc.w	sprite+8,0,sprite+10,0
;	dc.w	sprite+12,0,sprite+14,0
;	dc.w	sprite+16,0,sprite+18,0
;	dc.w	sprite+20,0,sprite+22,0
;	dc.w	sprite+24,0,sprite+26,0
;	dc.w	sprite+28,0,sprite+30,0
;
;xst	set	14	; 14 14
;xnd	set	36	; 44 36
;
;	dc.w	$08e,$2881
;	dc.w	$090,$28c1
;	dc.w	$092,xst*4
;	dc.w	$094,xnd*4
;
;	dc.w	$100,$4201
;	dc.w	$102,$8800
;	dc.w	$104,$0200
;	dc.w	$106,$0020
;
;	dc.w	$108,0
;	dc.w	$10a,0
;
;c_pic_bpls	dc.w	$e0,0,$e2,0
;	dc.w	$e4,0,$e6,0
;	dc.w	$e8,0,$ea,0
;	dc.w	$ec,0,$ee,0
;
;	dc.w	$ffdf,$fffe
;	dc.w	$2807,$fffe
;
;	dc.w	$09c,$8010		; copper de mierda
;
;c_pic_pal	ds.b	fader_palsize
;	dc.l	-2,-2

;--------------------------------------------------

	section	bbb,bss_c
	cnop	0,16
samples	ds.b	560000

	cnop	0,16
spr_off	ds.l	8

planes4	ds.b	320*256

	cnop	0,16
buffer0	ds.l	(CHIP_BUFFER)

	BUFFER	0
	RESERVE	0,bltbuf1,(8*40*256)
	RESERVE	0,bltbuf2,(8*40*256)
	RESERVE	0,bltbuf3,(8*40*256)
	RESERVE	0,planes1,(8*40*256)
	RESERVE	0,planes2,(8*40*256)
	RESERVE	0,planes3,(8*40*256)

	BUFFER	0
	RESERVE	0,ham8_chipplanes,(1024*480)
	RESERVE	0,water_sprt00,(16*256*1)
	RESERVE	0,water_sprt01,(16*256*1)
	RESERVE	0,water_sprt02,(16*256*1)
	RESERVE	0,water_sprt03,(16*256*1)
	RESERVE	0,water_sprt04,(16*256*1)

	BUFFER	0
	RESERVE	0,zoom_bpl_sh0,40*64
	RESERVE	0,zoom_bpl_0,40*257
	RESERVE	0,zoom_bpl_1,40*257
	RESERVE	0,zoom_bpl_2,40*257
	RESERVE	0,zoom_bpl_3,40*257
	RESERVE	0,zoom_bpl_4,40*257
	RESERVE	0,zoom_bpl_5,40*257
	RESERVE	0,zoom_bpl_6,40*257
	RESERVE	0,zoom_bpl_7,40*257
	RESERVE	0,zoom_bpl_8,40*257
	RESERVE	0,zoom_bpl_sh1,40*64

	BUFFER	0
	RESERVE	0,vaso_chippic,(640*512)

	BUFFER	0
	RESERVE	0,yoriko_planes,(8*88*480)

	BUFFER	0
	RESERVE	0,bpl_stars_0,(64*260*1)
	RESERVE	0,bpl_stars_1,(64*260*1)
	RESERVE	0,bpl_stars_2,(64*260*1)
	RESERVE	0,bpl_stars_3,(64*260*1)
	RESERVE	0,bpl_stars_4,(64*260*1)
	RESERVE	0,bpl_stars_5,(64*260*1)
	RESERVE	0,bpl_stars_6,(64*260*1)
	RESERVE	0,bpl_stars_7,(64*260*1)
	RESERVE	0,bpl_stars_8,(64*260*2)



	section	ccc,bss
	cnop	0,16
module	ds.l	1

	;cnop	0,16
buffer1	ds.l	(FAST_BUFFER)

	BUFFER	1
	RESERVE	1,rotozoomrecur_shit,4096
	RESERVE	1,rotozoomrecur_chunky1,320*256
	RESERVE	1,rotozoomrecur_chunky2,320*256
	RESERVE	1,rotozoomrecur_freespace,256*128/8


	BUFFER	1
	RESERVE	1,cross_texture1,(256*256*3)
	RESERVE	1,cross_texture2,(256*256*3)
	RESERVE	1,cross_pals,(1024*257)

	;BUFFER	1
	RESERVE	1,textunel_chunky1,(160*128)
	RESERVE	1,textunel_chunky2,(160*128)
	RESERVE	1,textunel_offsets,(320*256*4)
	RESERVE	1,textunel_texture,(256*256*2)

	;BUFFER	1
	RESERVE 1,dummy1,(320*256)
	RESERVE	1,engine_chunky1,(320*256)
	RESERVE	1,engine_chunky2,(320*256)
	RESERVE 1,dummy2,(320*256)

	;BUFFER	1
	RESERVE	1,recursive_shit,4096
	RESERVE	1,recursive_chunky1,320*256
	RESERVE	1,recursive_chunky2,320*256

	;BUFFER	1
	RESERVE	1,water3d_chunky1,(320*256)
	RESERVE	1,water3d_chunky2,(320*256)
	RESERVE	1,chk_water3dhei_0,(160*130*2)
	RESERVE	1,chk_water3dhei_1,(160*130*2)

	;BUFFER	1
	RESERVE	1,bump_shit,(1024)
	RESERVE	1,bump_chunky1,(320*90)
	RESERVE	1,bump_chunky2,(320*90)
	RESERVE	1,bump_offsets,(2528*72*4)

	;BUFFER	1
	RESERVE	1,shyrley_chunky1,(320*256)
	RESERVE	1,shyrley_chunky2,(320*256)


	BUFFER	1
	RESERVE	1,voxel_chunky1,(320*256)
	RESERVE	1,voxel_chunky2,(320*256)
	RESERVE	1,voxel_drawing,(256*256)
	RESERVE	1,voxel_divutab,(256*256*2)
	RESERVE	1,voxel_texheimap,(256*256*2)

	;BUFFER	1
	RESERVE	1,zoom_multable,(4*512)
	RESERVE	1,zoom_coltable1,(4*5120)
	RESERVE	1,zoom_coltable2,(4*1280)
	RESERVE	1,zoom_tempbpl,40*257
	RESERVE	1,zoom_palette,4*256

	;BUFFER	1
	RESERVE	1,water2d_chunky1,(320*256)
	RESERVE	1,water2d_chunky2,(320*256)
	RESERVE	1,chk_water2dhei_0,(320*256*2)
	RESERVE	1,chk_water2dhei_1,(320*256*2)

	;BUFFER	1
	RESERVE	1,rotozoom_shit,4096
	RESERVE	1,rotozoom_chunky1,320*256
	RESERVE	1,rotozoom_chunky2,320*256
	RESERVE	1,rotozoom_tex1,256*256
	RESERVE	1,rotozoom_freespace,256*128/8

	;BUFFER	1
	RESERVE	1,rtun_chunky1,(320*256)
	RESERVE	1,rtun_chunky2,(320*256)
	RESERVE	1,rtun_grid,(8*((160/8)+1)*((128/8)+1))
	RESERVE	1,rtun_bumpmap,(256*256*2)
	RESERVE	1,rtun_atan,(256*256*4)

	;BUFFER	1
	RESERVE	1,greets_dummy,(320*2)
	RESERVE	1,greets_chunky1,(320*256)
	RESERVE	1,greets_buffer,(320*128)
	RESERVE	1,greets_dummy2,(320*2)

	;BUFFER	1
	RESERVE	1,yoryko_sinus,64*1024

	;BUFFER	1
	RESERVE	1,rotobump_shit,4096
	RESERVE	1,rotobump_chunky1,320*256
	RESERVE	1,rotobump_chunky2,320*256
	RESERVE	1,rotobump_bump_,256*256*2
	RESERVE	1,rotobump_phong_,256*256*2
	;BUFFER	1
	RESERVE	1,stars_positions,(2*3*8192)


buffer2	ds.b	(320*256+1024*21+2*4*2*256)
	BUFFER	2
	RESERVE	2,prot_shit0,1024*32
	RESERVE	2,prot_chunky1,(320*256)
	RESERVE	2,prot_chunky2,(320*256)
	RESERVE	2,prot_tabpos,(2*4*2*256)


;**********************************************************
;            MEMORIA PARA LOS FICHEROS DE DATOS
;**********************************************************
	section	DataFiles,bss
	cnop	0,16

datafile	ds.b	2000000
datalength	ds.l	1
