		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	bltbuf3

		XREF	greets_chunky1
		XREF	greets_buffer

		XREF	lv3_vblank
		XREF	lv3_copper	
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	salir

		XREF	sinus
		
		XDEF	greets_main
		

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		include	include:exec/exec_lib.i


		incdir	'greetings'

wid	set	320
hei	set	256

		section	greetings,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

greets_main
		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		RESET_SPRITES	c_greets_spr

		move.l	#c_greets_pal,fader_copper
		move.l	#greets_pal,fader_original
		move.l	#greets_pal,fader_target
		move.w	#1,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
		jsr	fader_makecopper
		jsr	fader_setpalette

;		lea	greets_chunky1+(320*256),a0
;		move.l	#((320*256)/(32*32))-1,d0
;		moveq.l	#0,d1
;		moveq.l	#0,d2
;		moveq.l	#0,d3
;		moveq.l	#0,d4
;		moveq.l	#0,d5
;		moveq.l	#0,d6
;		moveq.l	#0,d7
;		sub.l	a1,a1
;.clrloop
;		rept	32
;		movem.l	d1-d7/a1,-(a0)
;		endr
;		dbf	d0,.clrloop


		bsr	greetings_initengine	

		clr.w	greets_syncropos
		clr.w	greets_syncroflag

		move.l	#greets_lv3,lv3_vblank

		move.l	#c_greets,$dff080
		
.loop1		wrast	255
	
		jsr	c2p_cpu

		cmp.w	#8,greets_syncropos
		blt	.noengine
		bsr	greetings_engine
.noengine
		cmp.w	#7,greets_syncropos
		blt	.nofire
		bsr	Do_fire
.nofire
		tst.w	greets_syncroflag
		beq	.nodo
		bsr	copylogo2
		cmp.w	#32,greets_syncropos	; 43????
		bgt	.nodo
		add.w	#1,greets_syncropos
		clr.w	greets_syncroflag
.nodo
		tst.l	salir
		bne	.goout

		cmp.w	#26,P61_Pos
		bge	.goout

		bra	.loop1

.goout
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

		dc.b	'we are at the party having a lot of bugs and the deadline is coming even nearer. greetings goto mijac who is coding a bumpmapper :))))',0
		cnop	0,16

;--------------------------------------------------------------------

greets_lv3	lea	greets_syncro,a0
		move.w	greets_syncropos,d0
		move.w	(a0,d0.w*2),d1
		move.w	P61_Pos+1,d2
		move.b	p61_crow+1,d2
		cmp.w	d1,d2
		blt	.ba
		cmp.w	#32,greets_syncropos
		bgt	.ba
		move.w	#1,greets_syncroflag
.ba		
		cmp.w	#8,greets_syncropos
		blt	.nada
		cmp.l	#1100,stepp
		bgt	.nada
		lea	stepp,a0
		add.l	#$80,(1,a0)
				
.nada
		;tst.w	morphya
		;beq	.nada2
		;cmp.w	#24,p61_pos
		;bne	.nada2
		;tst.w	p61_crow
		;blt	.nada2
		;lea	Morph,a0
		;movem.l	(a0),d0-d2
		;exg	d0,d1
		;exg	d1,d2
		;movem.l	d0-d2,(a0)
		;clr.w	morphya
.nada2		rts		


morphya		dc.w	1
;--------------------------------------------------------------------

Do_fire
		move.l	c2p__chunky,a3
		;adda.l	#320,a3
	
		;adda.l	d0,a3

		clr.l	d0
		clr.l	d1
		clr.l	d2
		clr.l	d3
		clr.l	d4
		move.w	#((320*259)/32)-2,d0
		;move.w	#256,d1

		clr.l	d3

		lea	-320(a3),a0
		lea	320(a3),a4
		lea	-1(a3),a5
		lea	1(a3),a6

		move.l	#$fcfcfcfc,d4

.loop2
		rept	8
		move.l	(a0)+,d3
		add.l	(a4)+,d3
		add.l	(a5)+,d3
		add.l	(a6)+,d3
		and.l	d4,d3
		lsr.l	#2,d3
		move.l	d3,(a3)+
		endr
		dbra	d0,.loop2
		;move.l	#(320/16)-2,d0
		;dbra	d1,.loop2
		rts

;--------------------------------------------------------------------
copylogo2	;bra	copylogo3
		cmp.w	#7,greets_syncropos
		bge	copylogo3


		clr.l	d0
		lea	greets_brushes,a0
		move.w	greets_syncropos,d0
		move.l	(a0,d0.w*4),a2
		move.l	c2p__chunky,a1

		adda.l	(a2)+,a1
		move.l	(a2)+,d0
		;subq.l	#1,d0
		move.l	d0,d3
		move.l	(a2)+,d1
		subq.l	#1,d1
		move.l	(a2)+,d4
		;subq.l	#1,d4 
		;lea	greets_buffer,a2
		;lea	(4,a2),a2
.loop		move.b	(a2)+,d5
		or.b	d5,(a1)+
		dbra	d0,.loop
		move.l  d3,d0
		adda.l	d4,a1
		dbra	d1,.loop
		rts

		dc.b	'y mijac dice que quiere la demo para maana, que en verdad es hoy pero que la culpa es de sabino por no tener electricidad el jueves por la noche',0
		cnop	0,16

copylogo3	clr.l	d0
		lea	greets_brushes,a0
		move.w	greets_syncropos,d0
		move.l	(a0,d0.w*4),a2
		move.l	c2p__chunky,a1

		adda.l	(a2)+,a1
		move.l	(a2)+,d0
		move.l	d0,d3

		move.l	(a2)+,d1
		subq.l	#1,d1
		move.l	(a2)+,d4

		move.l	#320,d4
		sub.l	d0,d4
		sub.l	d0,d4
		subq.l	#2,d4

.yloop		move.l  d3,d0

.xloop		move.w	(a2),d5
		move.b	(a2)+,d5
		or.w	d5,(a1)+
		dbra	d0,.xloop

		adda.l	d4,a1
		dbra	d1,.yloop
		rts

stepp		dc.l	0
		dc.l	0
nframess	dc.l	0

greets_syncroflag	dc.w	0
greets_syncropos	dc.w	0
greets_syncro	
		dc.w	(22<<8)+0
		dc.w	(22<<8)+4
		dc.w	(22<<8)+8
		dc.w	(22<<8)+12
		dc.w	(22<<8)+14
		dc.w	(22<<8)+16
		dc.w	(22<<8)+20
		dc.w	(22<<8)+36	;(Pos<<8)+Row
		dc.w	(22<<8)+44
		dc.w	(22<<8)+52
		dc.w	(22<<8)+60
		dc.w	(23<<8)+4
		dc.w	(23<<8)+12
		dc.w	(23<<8)+20
		dc.w	(23<<8)+28
		dc.w	(23<<8)+36
		dc.w	(23<<8)+44
		dc.w	(23<<8)+52
		dc.w	(23<<8)+60
		dc.w	(24<<8)+4
		dc.w	(24<<8)+12
		dc.w	(24<<8)+20
		dc.w	(24<<8)+28
		dc.w	(24<<8)+36
		dc.w	(24<<8)+44
		dc.w	(24<<8)+52
		dc.w	(24<<8)+60
		dc.w	(25<<8)+4
		dc.w	(25<<8)+12
		dc.w	(25<<8)+20
		dc.w	(25<<8)+28
		dc.w	(25<<8)+36
		dc.w	(25<<8)+44	; 33 ;)


greets_pal	incbin	'pal.greets3'

plsize	set	wid*hei/8
plsiz2	set	plsize*2

c2p_wait	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	lea.l	c2p__chunky(pc),a0
	movem.l	(a0),a5-a6
	move.l	a6,(a0)+
	move.l	a5,(a0)+

	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4
	lea	plsiz2(a4),a3
	lea	plsiz2(a3),a2
	lea	plsiz2(a2),a1

	move.l	a7,c2p_stack

	move.l	-(a3),a7
	move.l	-(a2),a0
	move.l	-(a1),d7

	move.l	#$0f0f0f0f,d4
	move.l	#$00ff00ff,d5
	move.l	#$55555555,d6

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	greets_chunky1
c2p__chunky_	dc.l	greets_chunky1
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2
c2p__planes__	dc.l	planes3
c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

	cmp.l	a5,a6
	bcs	c2p_loop

	move.l	d7,(a1)+
	move.l	a0,(a2)+
	move.l	a7,(a3)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	move.l	#c2p_blit2,lv3_blit

	lea	$dff000,a6

	moveq.l	#-1,d0
	moveq.l	#2,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	add.l	#(4*wid*hei/8)-2,a1

	move.l	a0,$50(a6)		; orig 1
	subq.l	#2,a0
	move.l	a0,$4c(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#$cccc,$70(a6)
	move.l	#$eDE40000,$40(a6)

	move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts


c2p_blit2	move.l	#c2p_blit3,lv3_blit

	lea	$dff000,a6
	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1

	move.l	a0,$50(a6)		; orig 1
	addq.l	#2,a0
	move.l	a0,$4C(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$0DE42000,$40(a6)

	move.w	#4*wid*hei/16,$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h
	rts

c2p_blit3	clr.l	c2p_proceed
	clr.l	lv3_blit
	rts

c2p_dbuff	movem.l	c2p__bltbuf,a0-a1
	exg.l	a0,a1
	movem.l	a0-a1,c2p__bltbuf

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d2
	move.l	d2,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	;move.w	#$555,$dff180
	;wrast	255
	;move.w	#$000,$dff180

	lea	c_greets_bpls,a0
	move.l	c2p__planes_,d0
	moveq.l	#7,d7

.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#wid*hei/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop
	rts

;---------------------------------
		include	engine.s
;---------------------------------

	;---------------------------
	include	greetsdata.s
	;===========================

		section	greetings,data_c

		cnop	0,16
c_greets	dc.w	$08e,$2881,$090,$28c1	;$f0c1
		dc.w	$092,$0038,$094,$00D0
		dc.w	$100,$0211
		dc.w	$102,$0000
		dc.w	$104,$0000
		dc.w	$106,$0000
		dc.w	$108,-8
		dc.w	$10a,-8
		dc.w	$1fc,$0007

c_greets_pal	dcb.b	2112

sprite	set	$120
c_greets_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

c_greets_bpls	dc.w	$ec,0,$ee,0
		dc.w	$e8,0,$ea,0
		dc.w	$fc,0,$fe,0
		dc.w	$f8,0,$fa,0

		dc.w	$e4,0,$e6,0
		dc.w	$e0,0,$e2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f0,0,$f2,0

		dc.l	-2,-2
		
		cnop	0,16
spr_off		ds.l	8
