	opt c+,p=68030

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	dos/dos.i
	include	intuition/intuition_lib.i
	include	intuition/screens.i
	include	graphics/graphics_lib.i
	include	graphics/view.i
	include	graphics/videocontrol.i
	include	hardware/intbits.i
			
	include	macros2.i

MAIN
	;moveq.l	#INTB_VERTB,d0			; INTB_COPER for copper interrupt
	;lea	VBlankServer,a1
	;LIBCALL	AddIntServer,4.w

	move.l	$4.w,a6
	lea	_intuitionname,a1
	moveq.l	#0,d0
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,_intuitionbase

	lea	GfxLib,a1
	moveq.l	#0,d0
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,GfxBase

	move.l	$4.w,a6
	lea	_dosname,a1
	moveq.l	#0,d0
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,_dosbase

	bsr	_ScreenOpen

	;bra	.part3

	move.l	GfxBase,a6
	move.l	syn_screen,a0
	lea	(sc_ViewPort,a0),a0
	lea	palbuf,a1
	jsr	_LVOLoadRGB32(a6)

	move.l	_dosbase,a6
	move.l	#file1,d1
	jsr	-150(a6)
	tst.l	d0
	beq	.bye
	move.l	d0,loadsegfile
	move.l	GfxBase,a6
	move.l	#125,d7
.llll	jsr	_LVOWaitTOF(a6)
	dbf	d7,.llll
	move.l	loadsegfile,d0
	asl.l	#2,d0
	addq.l	#4,d0
	move.l	d0,a0
	pea	OSin
	pea	OSout
	jsr	(a0)
	move.l	(sp)+,salir
	move.l	_dosbase,a6
	move.l	loadsegfile,d1
	jsr	-156(a6)
	tst.l	salir
	bne	.bye

.part1
	move.l	GfxBase,a6
	move.l	syn_screen,a0
	lea	(sc_ViewPort,a0),a0
	lea	palbufblack,a1
	jsr	_LVOLoadRGB32(a6)

	move.l	_dosbase,a6
	move.l	#file2,d1
	jsr	-150(a6)
	tst.l	d0
	beq	.bye
	move.l	d0,loadsegfile
	asl.l	#2,d0
	addq.l	#4,d0
	move.l	d0,a0
	pea	OSin
	pea	OSout
	jsr	(a0)
	move.l	(sp)+,d7
	move.l	_dosbase,a6
	move.l	loadsegfile,d1
	jsr	-156(a6)
	tst.l	d7
	bne	.bye

.part2
	move.l	_dosbase,a6
	move.l	#file3,d1
	jsr	-150(a6)
	tst.l	d0
	beq	.bye
	move.l	d0,loadsegfile
	asl.l	#2,d0
	addq.l	#4,d0
	move.l	d0,a0
	pea	OSin
	pea	OSout
	jsr	(a0)
	move.l	(sp)+,d7
	move.l	_dosbase,a6
	move.l	loadsegfile,d1
	jsr	-156(a6)
	tst.l	d7
	bne	.bye

.part3
	move.l	_dosbase,a6
	move.l	#file4,d1
	jsr	-150(a6)
	tst.l	d0
	beq	.bye
	move.l	d0,loadsegfile
	asl.l	#2,d0
	addq.l	#4,d0
	move.l	d0,a0
	pea	OSin
	pea	OSout
	jsr	(a0)
	move.l	(sp)+,d7
	move.l	_dosbase,a6
	move.l	loadsegfile,d1
	jsr	-156(a6)



.bye	bsr	_ScreenClose

	;moveq.l	#INTB_VERTB,d0			;Change for copper interrupt.
	;lea	VBlankServer,a1
    	;LIBCALL	RemIntServer,4.w		;Remove my interrupt

	move.l	GfxBase,a1
	LIBCALL	CloseLibrary,4.w
	move.l	_intuitionbase,a1
	LIBCALL	CloseLibrary,4.w
	move.l	_dosbase,a1
	LIBCALL	CloseLibrary,4.w
	rts
	

loadsegfile	dc.l	0
_dosname	dc.b	"dos.library",0
_dosbase	dc.l	0
_intuitionname	dc.b	"intuition.library",0
_intuitionbase	dc.l	0

salir		dc.l	0

	cnop	0,16
file1	dc.b	"ntw_syn1.dat",0
	cnop	0,16
file2	dc.b	"ntw_syn2.dat",0
	cnop	0,16
file3	dc.b	"ntw_syn3.dat",0
	cnop	0,16
file4	dc.b	"ntw_syn4.dat",0

		cnop	0,16
syn_screen	dc.l	0
syn_screentaglist
		dc.l	SA_Left,0
		dc.l	SA_Top,0
		dc.l	SA_Width,640
		dc.l	SA_Height,512
		dc.l	SA_Depth,5
		dc.l	SA_Type,CUSTOMSCREEN
		dc.l	SA_DisplayID,PAL_MONITOR_ID|HIRESLACE_KEY
		dc.l	SA_Draggable,0
		dc.l	SA_Exclusive,1
		dc.l	SA_VideoControl,syn_videocontroltaglist
		dc.l	SA_Quiet,1
		dc.l	TAG_DONE

syn_videocontroltaglist
		dc.l	VTAG_BORDERBLANK_CLR,1
		dc.l	VTAG_PF1_TO_SPRITEPRI_SET,1
		dc.l	VTAG_PF2_TO_SPRITEPRI_SET,1

syn_window	dc.l	0
syn_windowtaglist
		dc.l	WA_Left,0
		dc.l	WA_Top,0
		dc.l	WA_Width,640
		dc.l	WA_Height,512
		dc.l	WA_IDCMP,0
		dc.l	WA_Flags,0
csr		
		dc.l	WA_CustomScreen,0
		dc.l	WA_Borderless,1
		;dc.l	WA_Pointer,mouseoff
		
		cnop	0,16
_ScreenOpen	
		move.l	_intuitionbase,a6
		sub.l	a0,a0
		lea	syn_screentaglist,a1
		jsr	_LVOOpenScreenTagList(a6)
		;jsr	-612(a6)
		move.l	d0,syn_screen

		;move.l	d0,csr+4
		;sub.l	a0,a0
		;lea	syn_windowtaglist,a1
		;jsr	_LVOOpenWindowTagList(a6)
		;move.l	d0,syn_window

		lea	buffer,a0
		lea	pic,a1
		bsr	decrunch

		lea	palbufblack,a2
		move.l	#(32<<16)+0,(a2)
		move.l	GfxBase,a6
		move.l	syn_screen,a0
		lea	(sc_ViewPort,a0),a0
		move.l	a2,a1
		jsr	_LVOLoadRGB32(a6)
	
		lea	picpal,a0
		lea	palbuf,a1
		move.l	a1,a2
		move.l	#(32<<16)+0,(a1)+
		move.l	#32-1,d0

.loop		move.l	(a0)+,d1
		move.l	d1,d2
		move.l	d1,d3

		andi.l	#$ff0000,d1	;r
		lsl.l	#8,d1
		move.l	d1,(a1)+
		
		andi.l	#$ff00,d2	;g
		swap	d2
		move.l	d2,(a1)+
		
		andi.l	#$ff,d3		;b
		ror.l	#8,d3
		move.l	d3,(a1)+

		dbf	d0,.loop

		clr.l	(a1)+
		clr.l	(a1)+
		clr.l	(a1)+

		lea	buffer,a0
		move.l	syn_screen,a2
		lea	(sc_BitMap,a2),a2
		lea	(bm_Planes,a2),a2
		moveq.l	#5-1,d7
.loop2		move.l	(a2)+,a1
		move.l	#640*512/8,d0
		bsr	_LoadPlane
		dbf	d7,.loop2
		rts
;IN:		
;a0-source
;a1-dest plane
;d0-size
;
;OUT:
;a0-nextplane

_LoadPlane	
		subq.l	#1,d0
.loop		move.b	(a0)+,(a1)+
		dbf	d0,.loop
		rts

_ScreenClose
		move.l	_intuitionbase,a6
		;move.l	syn_window,a0
		;jsr	_LVOCloseWindow(a6)

		move.l	syn_screen,a0
		jsr	_LVOCloseScreen(a6)
		rts
		

IntLevel3:	movem.l	d2-d7/a0-a4,-(sp)

		movem.l	(sp)+,d2-d7/a0-a4
		moveq.l	#0,d0
		rts

VBlankServer:	
		dc.l  0,0                     	;ln_Succ,ln_Pred
		dc.b  2,9                  	;ln_Type,ln_Pri
		dc.l  IntName                 	;ln_Name
		dc.l  0,IntLevel3             	;is_Data,is_Code

IntName:	dc.b "Synthesis v2.0 by Network in 1998",0     
		EVEN

		
;-------------------------------------------------------------------


OSout	move.l	(sp)+,backdemo
	movea.l	4.w,a6			; System Base
	lea	MathLib,a1
	moveq.l	#0,d0
	jsr	-552(a6)
	move.l	d0,_MathIeeeSingBasBase
	lea	MathTrans,a1
	moveq.l	#0,d0
	jsr	-552(a6)
	move.l	d0,_MathIeeeSingTransBase
	;lea	GfxLib,a1
	;moveq	#0,d0
	;jsr	-552(a6)		; OpenLibrary
	;move.l	d0,GfxBase		; Save Graphics_lib base
	move.l	GfxBase,a6
	move.l	38(a6),OldCopper	; gb_CopInit	Sys Copper
	move.l	34(a6),OldView		; gb_ActiView	Sys View
	jsr	-456(a6)		; Own Blitter
	lea	0.w,a1			;LoadView Null
	jsr	-222(a6)		;LoadView

	move.w	#(10*1)-1,d7
.loop	jsr	-270(a6)		; lots of WaitTOF
	dbra	d7,.loop

	movea.l	4.w,a6			; System Base
	jsr	-132(a6)		; Forbid
	jsr	-150(a6)		; SuperState
	move.l	d0,SysStack		; System stack
	btst.b	#0,$129(a6)		; are we at least 68010? ($129=AttnFlags+1)
	beq.b	.68000			; nope.
	dc.w	$4e7a,$0801		;=movec.l vbr,d0 ; pero MDevPac no lo acepta
	move.l	d0,VectorBase		; Get Real VBR

.68000
	move.l	SysStack,d0		; Systemstack
	jsr	-156(a6)		; UserState

	move	$dff01c,_IntEnaR		; Initialize custom chips
	move	$dff01e,_IntReqR		; Save old valours first
	move	$dff002,_DmaConR
	move	$dff010,_AdkConR
	move	#%0111111111111111,$dff09a	; INTENA
	move	#%1100000001110000,$dff09a	* Enable desired IRQs
.Spr	move.l	$dff004,D0			; Wait RASTER to
	and.l	#$0001FF00,D0			; disable SPRITES
	bne.b	.Spr
	move	#%0111111111111111,$dff096	; DMACONW
	move	#%1000001111100000,$dff096	* Enable desired DMAs

	move	$dff07c,d0			;Ponerlo en/antes/despues de Copper?
	cmp.b	#$f8,d0
	bne.b	.NotAGA				; Not AGA
	move	#0,$dff1fc			* Fix AGA Res     (Ponerlo en Copper?)

.NotAGA	move.l	VectorBase,a0
	move.l	$6c(a0),Int3Save		; Save level 3 vector
	;move.l	#level3,$6c(a0)			; Set OUR! own interrupt
	move.l	(sp)+,$6c(a0)			; Set OUR! own interrupt

	move.l	_MathIeeeSingTransBase,-(sp)
	move.l	_MathIeeeSingBasBase,-(sp)
	;rts
	move.l	backdemo,a0
	jmp	(a0)
	
OSin	
	move.l	VectorBase,a0
	move.l	Int3Save,$6c(a0)	; Reset Interrupts

	move	_IntEnaR,d7		; Reset custom chips
	bset	#$f,d7
	move	d7,$dff09a		; Reset Interrupts

	move	_IntReqR,d7
	bset	#$f,d7
	move	d7,$dff09c		; Reset interrupt request
	move	d7,$dff09c		; Reset interrupt request

	move	_DmaConR,d7
	bset	#$f,d7
	move	d7,$dff096		; Reset DMAConw

	move	_AdkConR,d7
	bset	#$f,d7
	move	d7,$dff09e		; Reset ADK

	move.l	GfxBase,a6
	movea.l	OldView,a1
	jsr	-222(a6)		;LoadView
	move.l	OldCopper,$dff080	; Reset System Copper
	jsr	-462(a6)		; DisOwn Blitter

	movea.l	4.w,a6			; System Base
	;move.l	GfxBase,a1		; Close Graphics_lib
	;jsr	-414(a6)		; CloseLibrary
	move.l	_MathIeeeSingBasBase,a1
	jsr	-414(a6)
	move.l	_MathIeeeSingTransBase,a1
	jsr	-414(a6)
	jsr	-138(a6)		; Permit

;	move.l	timing_speed,d0
	rts

backdemo	dc.l	0

GfxLib		dc.b	"graphics.library",0,0
GfxBase		dc.l	0
MathLib		dc.b	'mathieeesingbas.library',0
_MathIeeeSingBasBase
		dc.l	0
MathTrans	dc.b	"mathieeesingtrans.library",0
		even
_MathIeeeSingTransBase	dc.l	0
_IntEnaR		dc.w	0
_IntReqR		dc.w	0
_DmaConR		dc.w	0
_AdkConR		dc.w	0
SysStack	dc.l	0
Int3Save	dc.l	0
OldCopper	dc.l	0
OldView		dc.l	0
VectorBase	dc.l	0

		include	demo:/stonedec.i
		
		section	data,data
pic		incbin	dh3:network/synthesis/mounting/arranque.raw.stc ;dh1:arranque.raw.stc
picpal		incbin	dh3:network/synthesis/mounting/arranque.pal ;dh1:arranque.pal

		section	bss,bss
palincs		ds.b	3*4*32
palbuf		ds.b	4+3*4*33
palbufblack	ds.b	4+3*4*33
buffer		ds.b	204800

		section	data,data_c
		
mouseoff	dc.l	0,0,0,0,0,0,0,0