; Chunky To Planar 1x1, 2x2 version.
		
		;machine	68030
		
		opt	debug,c-,l+,p=68030

		XREF	engine__chunky
		XREF	engine_cpu
		XREF	engine_swap_screens
		XREF	engine_wait

		XREF	engine_chunky1
		XREF	engine_chunky2
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit
		XREF	salir
		XREF	P61_Pos
		XREF	P61_CRow
		XREF	senos

		XREF	Setup
		XREF	PrecalcCameraMotion
		XREF	PrecalcObjectsMotion
		XREF	CalcCameraStep
		XREF	CalcObjectsStep
		XREF	CalcCameraStepIEEE
		XREF	CalcObjectsStepIEEE
		XREF	PrecalcMatrix
		XREF	RotatePoints
		XREF	RotateNormals
		XREF	PrecalcCameraMatrix
		XREF	TransformToCamera
		XREF	MakeRadixTable
		XREF	RadixSort
		XREF	MakePolys
		XREF	MapTriangle
		XREF	tpolyclip_updown
		XREF	tpolyclip_leftright
		XREF	DDA_Main
		XREF	engine_texture

		XREF	_3dpart2_tex1
		XREF	_3dpart2_tex2
		XREF	_3dpart2_tex3

		XDEF	Engine_3_Main

		section	engine,code
		
		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm
		
RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM


InitEngine
		lea	SceneFile,a0
		lea	ObjectList,a1
		lea	TextureList,a2
		lea	c_engine_bpls,a3
		jsr	Setup
		move.l	d0,nframes

		rts

Engine_3_Main
		RESET_SPRITES	c_engine_spr

		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		move.l	#planes1,d0
		lea	c_engine_bpls,a0
		moveq.l	#7,d1
.loop2		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	#320*256/8,d0
		dbf	d1,.loop2

		move.l	#c_engine,$dff080
		jsr	InitEngine	
		move.l	#engine_advance,lv3_vblank
.loop		
		;wrast	255

		jsr	engine_cpu

		jsr	engine_clearbuffer
		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		move.l	step,d0
		jsr	PrecalcMatrix
		move.l	step,d0
		jsr	RotatePoints
		jsr	RotateNormals
		move.l	step,d0
		jsr	PrecalcCameraMatrix
		move.l	step,d0
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle


		tst.l	salir
		bne	.salengine
		cmp.w	#13,P61_Pos	;22
		blt	.loop
.salengine	jsr	engine_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

engine_advance
		jsr	engine_swap_screens

		add.l	#$180,step+1
		move.l	nframes,d0
		cmp.l	step,d0
		bgt	.nada
		move.l	#0,step
.nada
		rts

step		dc.l	0
		dc.l	0
nframes		dc.l	0
	
		CNOP	0,16

engine_clearbuffer
		move.l	engine__chunky,a0
		adda.l	#320*200,a0
		move.l	#((320*200)/(4*13*3))-1,d7
		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6

.loop		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		dbf	d7,.loop
		movem.l	d0-d6/a1-a4,-(a0)
		rts


		incdir	sources:scenes/part2_primera

ObjectList
		dc.l	.aa
		dc.w	%11	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.bb
		dc.w	%10	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.cc
		dc.w	%11	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.dd
		dc.w	%0	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.ee
		dc.w	%10	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.ff
		dc.w	%10	;(1<<0)	;pointertoobject,rotation flag

.aa		incbin	"hola.wob"
.bb		incbin	"pico.wob"
.cc		incbin	"bola3.wob"
.dd		incbin	"circulo2.wob"
.ee		incbin	"centro2.wob"
.ff		incbin	"entorno.wob"

SceneFile	incbin	"scena2.wsc" 

TextureList	dc.l	c_engine_pal
		dc.l	_3dpart2_tex1,.pal,0,256,256*256,0,0,0	;0=allign long
		dc.l	_3dpart2_tex2,0000,0,256,256*256,0,0,0	;0=allign long
		dc.l	_3dpart2_tex3,0000,0,256,256*256,0,0,0	;0=allign long
		dc.l	$ABADCAFE
		
;.aa		incbin	"chk.bola.env2.1"
;.bb		incbin	"chk.bola.env5"
;.cc		incbin	"chk.fondo.256"
.pal		incbin	"pal.escena--"

		section	engine,data_c
wid	set	320
hei	set	192

		cnop	0,64
c_engine
	dc.w	$1fc,$0007
	dc.w	$100,$0201

	dc.w	$08e,$2881
	dc.w	$090,$28C1

sprite	set	$120
c_engine_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

xst set 14	; 14 14
xnd set	36	; 44 36

	ifeq	wid-320
xnd	set	44
	else
xnd	set	36
	endc

yst set $100-(hei)
	dc.w	$08e,$0a81|(yst<<8)
	dc.w	$090,$0ac1

	dc.w	$092,xst*4
	dc.w	$094,xnd*4


	dc.w	$100,$0201|$010
	dc.w	$102,$0000
	dc.w	$104,$0200
	dc.w	$106,$0c40

c_engine_pal	dcb.b	2112	;incbin	"sources:scenes/fly/scene.cop.pal"

	dc.w	$108,0
	dc.w	$10a,0

c_engine_bpls
	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0

	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

	dc.w	$fe3f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8

