; Chunky To Planar 1x1, 2x2 version.
		
		;machine	68030
		
		opt	debug,c-,l+,p=68030

		XREF	engine__chunky
		XREF	engine_cpu
		XREF	engine_swap_screens
		XREF	engine_wait

		XREF	shirley_tex1
		XREF	shirley_tex2

		XREF	engine_chunky1
		XREF	engine_chunky2
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit
		XREF	salir
		XREF	P61_Pos
		XREF	P61_CRow
		XREF	senos

		XREF	blackpal

		XREF	Setup
		XREF	PrecalcCameraMotion
		XREF	PrecalcObjectsMotion
		XREF	CalcCameraStep
		XREF	CalcObjectsStep
		XREF	CalcCameraStepIEEE
		XREF	CalcObjectsStepIEEE
		XREF	PrecalcMatrix
		XREF	RotatePoints
		XREF	RotateNormals
		XREF	PrecalcCameraMatrix
		XREF	TransformToCamera
		XREF	MakeRadixTable
		XREF	RadixSort
		XREF	MakePolys
		XREF	MapTriangle
		XREF	tpolyclip_updown
		XREF	tpolyclip_leftright
		XREF	DDA_Main
		XREF	engine_texture

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_makecopper
		XREF	fader_initcrossfade
		XREF	fader_setpalette

		XREF	water_init
		XREF	water_fadeinit

		XDEF	shirley3d_Main

		section	engine,code
		
		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm
		
RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM


wid set 320
hei set 192

InitEngine
		lea	SceneFile,a0
		lea	ObjectList,a1
		lea	TextureList,a2
		lea	c_engine_bpls,a3
		jsr	Setup
		move.l	d0,nframes
		move.l	d1,engine_pal
		clr.l	step

		;lea	TransformToCamera+200,a0
		;move.w	#(wid/2),(a0)
		;lea	TransformToCamera+208,a0
		;move.w	#(hei/2),(a0)

		;lea	MapTriangle+98,a0
		;move.w	#hei-1,(a0)
		;lea	MapTriangle+108,a0
		;move.w	#hei-1,(a0)
		;lea	MapTriangle+154,a0
		;move.w	#wid-1,(a0)
		;lea	MapTriangle+164,a0
		;move.w	#wid-1,(a0)
		;lea	MapTriangle+564,a0
		;;move.w	#wid,(a0)
		;lea	MapTriangle+688,a0
		;move.w	#wid,(a0)
		;lea	MapTriangle+924,a0
		;move.w	#wid,(a0)
		
		;lea	tpolyclip_updown+36,a0
		;move.w	#hei-1,(a0)
		;lea	tpolyclip_updown+60,a0
		;move.w	#hei-1,(a0)
		;lea	tpolyclip_updown+180,a0
		;move.w	#hei-1,(a0)
		;lea	tpolyclip_updown+208,a0
		;move.w	#hei-1,(a0)
		;lea	tpolyclip_updown+306,a0
		;move.w	#hei-1,(a0)
		;lea	tpolyclip_updown+334,a0
		;move.w	#hei-1,(a0)

		;lea	tpolyclip_leftright+36,a0
		;move.w	#wid-1,(a0)
		;lea	tpolyclip_leftright+60,a0
		;move.w	#wid-1,(a0)
		;lea	tpolyclip_leftright+180,a0
		;move.w	#wid-1,(a0)
		;lea	tpolyclip_leftright+194,a0
		;move.w	#wid-1,(a0)
		;lea	tpolyclip_leftright+306,a0
		;move.w	#wid-1,(a0)
		;lea	tpolyclip_leftright+320,a0
		;move.w	#wid-1,(a0)

		;move.l	$4.w,a6
		;jsr	-636(a6)	;cacheclearu

		rts

shirley3d_Main


		RESET_SPRITES	c_engine_spr
	
		jsr	InitEngine	

		jsr	water_init
		move.w	#3,d0
		move.w	#31,d1
		jsr	water_fadeinit

		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		jsr	engine_clearbuffer
		move.l	engine__chunky+4,a0
		jsr	engine_clearbuffer+6

		move.l	#c_engine,$dff080
		move.l	#engine_advance,lv3_vblank
.loop		
		;wrast	255

		jsr	engine_cpu

		jsr	engine_clearbuffer
		;moveq.l	#0,d0
		;moveq.l	#0,d1
		;moveq.l	#0,d2
		;moveq.l	#0,d3
		;moveq.l	#0,d4
		;moveq.l	#0,d5
		;moveq.l	#0,d6	
		;moveq.l	#0,d7
		;sub.l	a0,a0
		;sub.l	a1,a1
		;sub.l	a2,a2
		;sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5

		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle

		tst.b	shyrley
		beq	.nop
		XREF	water_cop
		jsr	water_cop
		sf	shyrley
.nop
		tst.l	salir
		bne	.salengine
		cmp.w	#33,P61_Pos	;22
		blt	.loop
.salengine	jsr	engine_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

engine_advance
		jsr	engine_swap_screens

		;jsr	fader_setpalette

		add.l	#1,step
		move.l	nframes,d0
		cmp.l	step,d0
		bgt	.nada
		move.l	#0,step
.nada
		move.w	p61_pos,d0
		move.w	p61_crow,d1
		cmp.w	#32,p61_pos
		bne	.no
		lsl.w	#8,d0
		or.b	d1,d0
		cmp.w	#(32<<8)+36,d0
		blt	.no
		cmp.w	#(32<<8)+40,d0
		beq	.clear
		bgt	.next
		st	shyrley
		bra	.no

.next		cmp.w	#(32<<8)+44,d0
		blt	.no
		cmp.w	#(32<<8)+48,d0
		beq	.clear
		bgt	.next2
		st	shyrley
		bra	.no

.next2		cmp.w	#(32<<8)+52,d0
		blt	.no
		cmp.w	#(32<<8)+56,d0
		beq	.clear
		bgt	.next3
		st	shyrley
		bra	.no
		

.next3		cmp.w	#(32<<8)+58,d0
		blt	.no
		cmp.w	#(32<<8)+60,d0
		beq	.clear
		bgt	.next4
		st	shyrley
		bra	.no

.next4		cmp.w	#(32<<8)+60,d0
		blt	.no
		cmp.w	#(32<<8)+62,d0
		beq	.clear
		bgt	.next5
		st	shyrley
		bra	.no

.next5
.clear		move.w	#3,d0
		move.w	#31,d1
		jsr	water_fadeinit
		move.l	#c_engine,$dff080
		sf	shyrley	
.no

		rts

step		dc.l	0
nframes		dc.l	0
shyrley		dc.b	0
	

		cnop	0,16
engine_pal	dc.l	0


		CNOP	0,16

engine_clearbuffer
		move.l	engine__chunky,a0
		adda.l	#320*192,a0
		move.l	#((320*193)/(4*13*3))-1,d7
		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6

.loop		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		dbf	d7,.loop
		movem.l	d0-d6/a1-a4,-(a0)
		rts


		incdir	sources:scenes/part1_shirley

ObjectList	dc.l	.aa
		dc.w	%0	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.bb
		dc.w	%0	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.cc
		dc.w	%1	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.dd
		dc.w	%0	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.ee
		dc.w	%1	;(1<<0)	;pointertoobject,rotation flag
		dc.l	.ff
		dc.w	%0	;(1<<0)	;pointertoobject,rotation flag

.aa		incbin	"suelo.wob"
.bb		incbin	"picos.wob"
.cc		incbin	"donut.wob"
.dd		incbin	"tubo.wob"
.ee		incbin	"bolas.wob"
.ff		incbin	"entorno.wob"

SceneFile	incbin	"shirleyfloat.wsc"

TextureList	dc.l	c_engine_pal
		dc.l	shirley_tex1,.aap,0,256,256*256,0,0,0
		dc.l	shirley_tex2,0,0,0,256*256,0,0,0		;0=allign long
		dc.l	$ABA	DCAFE
		
		incdir	"sources:scenes/network"
;.aa		incbin	chk.Bola.Env6
.aap		incbin	pal.escena
;.bb		incbin	chk.roja

		section	engine,data_c
wid	set	320
hei	set	192

		cnop	0,64
c_engine
	dc.w	$1fc,$0007
	dc.w	$100,$0201

	dc.w	$08e,$2881
	dc.w	$090,$28C1

sprite	set	$120
c_engine_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

xst set 14	; 14 14
xnd set	36	; 44 36

	ifeq	wid-320
xnd	set	44
	else
xnd	set	36
	endc

yst set $100-(hei)
	dc.w	$08e,$0a81|(yst<<8)
	dc.w	$090,$0ac1

	dc.w	$092,xst*4
	dc.w	$094,xnd*4


	dc.w	$100,$0201|$010
	dc.w	$102,$0000
	dc.w	$104,$0200
	dc.w	$106,$0c40

c_engine_pal	dcb.b	2112	;incbin	"sources:scenes/fly/scene.cop.pal"

	dc.w	$108,0
	dc.w	$10a,0

c_engine_bpls
	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0

	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

	dc.w	$fe3f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8

