; Chunky To Planar 1x1, 2x2 version.
		
		;machine	68030
		
		opt	debug,c-,l+,p=68030

		XREF	engine__chunky
		XREF	engine_cpu
		XREF	engine_swap_screens
		XREF	engine_wait

		XREF	objs_tex1
		XREF	objs_tex2
		XREF	objs_tex3
		
		XREF	engine_chunky1
		XREF	engine_chunky2
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit
		XREF	salir
		XREF	P61_Pos
		XREF	P61_CRow
		XREF	senos

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_makecopper
		XREF	fader_initcrossfade
		XREF	fader_setpalette
		XREF	fader_finish

		XREF	blackpal

		XREF	Setup
		XREF	PrecalcCameraMotion
		XREF	PrecalcObjectsMotion
		XREF	CalcCameraStep
		XREF	CalcObjectsStep
		XREF	CalcCameraStepIEEE
		XREF	CalcObjectsStepIEEE
		XREF	PrecalcMatrix
		XREF	RotatePoints
		XREF	RotateNormals
		XREF	PrecalcCameraMatrix
		XREF	TransformToCamera
		XREF	MakeRadixTable
		XREF	RadixSort
		XREF	MakePolys
		XREF	MapTriangle
		XREF	tpolyclip_updown
		XREF	tpolyclip_leftright
		XREF	DDA_Main
		XREF	engine_texture

		XDEF	Engine_Main

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	include:
		include	exec/exec_lib.i

		incdir	textunnel

		section	engine,code

wid	set	320
hei	set	192
		
wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm
		
RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM


InitEngine
		lea	obj1_SceneFile,a0
		lea	obj1_ObjectList,a1
		lea	obj1_TextureList,a2
		lea	c_engine_bpls,a3
		jsr	Setup
		move.l	d0,nframes
		move.l	d1,engine_palette
		clr.l	step

		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle


		rts

InitEngine2
		lea	obj2_SceneFile,a0
		lea	obj2_ObjectList,a1
		lea	obj2_TextureList,a2
		lea	c_engine_bpls,a3
		jsr	Setup
		move.l	d0,nframes
		move.l	d1,engine_palette
		clr.l	step

		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle


		rts

Engine_Main
		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		jsr	engine_clearbuffer

		;RESET_SPRITES	c_engine_spr
		jsr	InitEngine	

		move.l	engine_palette,fader_target
		move.l	#blackpal,fader_original
		move.l	#c_engine_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade
		st	fadeya

		jsr	sprites
		move.l	#c_engine,$dff080
		move.l	#engine_advance,lv3_vblank
.loop		
		;wrast	255

		jsr	engine_cpu

		;jsr	engine_clearbuffer
		jsr	engine_copybackground
		move.l	step,d0
		jsr	CalcCameraStepIEEE
		move.l	step,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		;jsr	PrecalcCameraMatrix
		jsr	TransformToCamera
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle


		tst.b	.segundo
		bne	.no
		cmp.w	#12,p61_pos
		bne	.no
		cmp.w	#32,p61_crow
		ble	.no
		st	.segundo
		;btst	#2,$dff016
		;bne	.no
		move.l	engine_palette,fader_target
		move.l	engine_palette,fader_original
		move.l	#c_engine_pal,fader_copper
		move.w	#1,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
		bsr	initengine2		
		move.l	#$01f0,speed		
.no
		cmp.w	#13,p61_pos
		bne	.no2
		cmp.w	#0,p61_crow
		bne	.no2
		move.l	#blackpal,fader_target
		move.l	engine_palette,fader_original
		move.l	#c_engine_pal,fader_copper
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
		
.no2
		tst.l	salir
		bne	.salengine
		cmp.w	#14,P61_Pos
		blt	.loop
.salengine	jsr	engine_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


.segundo	dc.b	0

		cnop	0,16
fadeya		dc.b	0

		cnop	0,16
engine_advance
		jsr	engine_swap_screens
		
		jsr	fader_setpalette

		move.l	speed,d0
		add.l	d0,step+1
		move.l	nframes,d0
		cmp.l	step,d0
		bgt	.nada
		move.l	nframes,step
.nada
		rts

step		dc.l	0
		dc.l	0
nframes		dc.l	0
speed		dc.l	$1c0
	
		CNOP	0,16
engine_copybackground
		move.l	(engine__chunky).l,a0
		adda.l	#320*192,a0
		move.l	#((320*192)/(4*12))-1,d7
		lea	(obj1_texturelist+4).l,a1
		move.l	(a1),a1
		adda.l	#(320*192)-48,a1
.mierda
		movem.l	(a1),d0-d6/a2-a6
		movem.l	d0-d6/a2-a6,-(a0)
		suba.l	#48,a1
		dbf	d7,.mierda
		movem.l	(a1),d0-d6/a2-a6
		movem.l	d0-d6/a2-a6,-(a0)

		rts

		CNOP	0,16
engine_clearbuffer
		move.l	engine__chunky,a0
		adda.l	#320*200,a0
		move.l	#((320*200)/(4*13*3))-1,d7
		moveq.l	#0,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6

.loop		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		movem.l	d0-d6/a1-a6,-(a0)
		dbf	d7,.loop
		movem.l	d0-d6/a1-a4,-(a0)
		rts

engine_palette	dc.l	0


		cnop	0,16
sprites		lea	.sprpoi(pc),a0
		move.l	(a0),a1
		movem.l	(a1)+,d0-d2
		move.l	a1,(a0)

		cmp.l	#-1,d2
		bne	.cont
		clr.l	d5
		lea	c_sprs,a0
		bra	.clearsprites

.cont		move.l	d2,a1
		lea	c_sprs,a0
		move.l	(a1)+,d0	;numero de sprites
		move.l	d0,d5		;resto de sprites pa limpiar luego
		move.l	(a1)+,d1	;altura del sprite
		move.w	spr_xpos,d2

		move.w	#$2802,d3
		addq.l	#2,d1		;
		lsl.l	#4,d1		;altura*16


		move.l	#1,d0
.loop
		move.w	d2,(a1)
		move.w	d3,(8,a1)
		move.l	a1,d4
		move.w	d4,(6,a0)
		swap	d4
		move.w	d4,(2,a0)
		
		or.b	#$80,d3		;set ATT
		addq.l	#8,a0		;siguiente sprite
		add.l	d1,a1		

		move.w	d2,(a1)
		move.w	d3,(8,a1)
		move.l	a1,d4
		move.w	d4,(6,a0)
		swap	d4
		move.w	d4,(2,a0)
		
		add.b	#32,d2

		and.b	#$7f,d3		;clear ATT
		addq.l	#8,a0
		add.l	d1,a1
		
		dbf	d0,.loop

		;borra el resto de los sprites
.clearsprites	move.l	#null_sprites,d3
		add.l	d5,d5
		moveq.l	#8,d4
		sub.l	d5,d4
		beq	.nonewspr
		subq.l	#1,d4
.clrsprloop
		move.w	d3,(6,a0)
		swap	d3
		move.w	d3,(2,a0)
		swap	d3
		addq.l	#8,a0
		dbf	d4,.clrsprloop

.nonewspr	rts


.nomoresprites	dc.b	0
		even
		
.sprpoi		dc.l	.spr1
.spr1		dc.l	0,0,sprcode
		dc.l	-1

spr_xpos	dc.w	$28b9


		incdir	'sources:scenes/part1_objs'

obj1_ObjectList	dc.l	.dd
		dc.w	%11	;(1<<0)	;pointertoobject,rotation flag
.dd		;incbin	'bolapinchoaro.wob'		
		incbin	'arosmorphing.wob'

obj1_SceneFile	incbin	'1parte.1obj.wsc'

obj1_TextureList
		dc.l	c_engine_pal
		dc.l	objs_tex1,aap,0,128,320*200,0,0,0
		dc.l	objs_tex2,bbp,128,128,256*256,0,0,0	;0=allign long
		dc.l	$ABADCAFE


obj2_ObjectList	dc.l	.dd
		dc.w	%11	;(1<<0)	;pointertoobject,rotation flag
.dd		incbin	'bolapinchoaro.wob'

obj2_SceneFile	incbin	'1parte.2obj.wsc'

obj2_TextureList
		dc.l	c_engine_pal
		dc.l	objs_tex1,aap,0,128,320*200,0,0,0
		dc.l	objs_tex3,ccp,128,128,256*256,0,0,0	;0=allign long
		dc.l	$ABADCAFE


;aa		incbin	'Fondo4.320x192x128.bin'
aap		incbin	'Fondo4.320x192x128.pal'
;bb		incbin	'Foco40000.128nfloyd.bin'
bbp		incbin	'Foco40000.128nfloyd.pal'
;cc		incbin	'foco40001.128floyd.bin'
ccp		incbin	'foco40001.128floyd.pal'

		section	engine,data_c

c_engine
	dc.w	$1fc,$000f
	dc.w	$100,$0201

c_engine_bpls
	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0

	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0

	dc.w	$08e,$2880
	dc.w	$090,$28C0

xst set 14	; 14 14
xnd set	36	; 44 36

	ifeq	wid-320
xnd	set	44
	else
xnd	set	36
	endc

yst set $100-(hei)
	dc.w	$08e,$0a80|(yst<<8)
	dc.w	$090,$09c0

	dc.w	$092,xst*4
	dc.w	$094,xnd*4


	dc.w	$100,$0201|$0010
	dc.w	$102,$0000
	dc.w	$104,$0024
	dc.w	$106,$0022	;$0c40
	dc.w	$10c,$00ff

c_engine_pal	incbin	demo:blackpal.pal	;dcb.b	2112	;incbin	"sources:scenes/fly/scene.cop.pal"

	dc.w	$108,0
	dc.w	$10a,0


sprite	set	$120
c_sprs
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

	;dc.w	$fe3f,$fffe
	;dc.w	$9c,$8010		; set copper


	dc.l	-2,-2


	cnop	0,16
null_sprites
	dc.l	0,0,0,0,0,0,0,0

	cnop	0,16
sprcode	dc.l	2,256
	;incbin	demo:engine/spr.brocha.mixed
	incbin	demo:engine/spr.cabeza.sprite2.77x202.16.3
	;incbin	demo:recursive_1x1/spr.brocha
