		machine	68030

		opt	l+,c-

		XDEF	cross
		XDEF	raw_presents
		XDEF	cross_tex1
		XDEF	cross_tex2

		XREF	cross_texture1
		XREF	cross_texture2
		XREF	cross_texture3
		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	bltbuf3
		XREF	lv3_vblank
		XREF	lv3_blit
		XREF	P61_Pos
		XREF	P61_CRow
		XREF	P61_SetPosition
		XREF	fader_makecopper
		XREF	fader_palsize
		XREF	fader_copper
		XREF	sinus
		XREF	salir

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	'cross'

		section	cross,code
RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm


wid		set	160
hei		set	90

cross		RESET_SPRITES	c_cross_spr
		clr.l	lv3_vblank
		bsr 	cross_make1
		bsr	cross2
		rts


cross2
		lea	(bltbuf1+8*40*256).l,a0
		lea	(bltbuf2+8*40*256).l,a1
		lea	(bltbuf3+8*40*256).l,a2
		lea	(planes1+8*40*256).l,a4
		lea	(planes2+8*40*256).l,a5
		lea	(planes3+8*40*256).l,a6
		move.l	#((8*40*256)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5
.chiploop	rept	16
		movem.l	d1-d7/a3,-(a0)
		movem.l	d1-d7/a3,-(a1)
		movem.l	d1-d7/a3,-(a2)
		movem.l	d1-d7/a3,-(a4)
		movem.l	d1-d7/a3,-(a5)
		movem.l	d1-d7/a3,-(a6)
		endr
		dbf	d0,.chiploop

		lea	c_cross_bpls,a0
		move.l	#planes1,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*256,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		move.l	#cross_lv3,lv3_vblank

		move.l	#c_cross,$dff080

.loop1		jsr	cross_redraw
		jsr	c2p16_blit

		tst.l	salir
		bne	.salcross
		cmp.w	#12,P61_Pos
		blt.b	.loop1
.salcross
		clr.l	lv3_vblank

		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(40*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3-a5,-(a0)
		movem.l	d1-d7/a3-a5,-(a1)
		movem.l	d1-d7/a3-a5,-(a2)
		endr
		dbf	d0,.chiploop2

		rts


cross_pal1	dcb.l	256,$00dead00
cross_pal2	dcb.l	256,$0000beef

cross_palo1	incbin	'pal.network'
cross_palo2	incbin	'pal.synthesis'


cross_make1	lea	cross_pal1(pc),a1
		moveq.l	#15,d7
.loop1		lea	cross_palo1(pc),a0
		rept	16
		move.l	(a0)+,(a1)+
		endr
		dbra	d7,.loop1

		lea	cross_palo2(pc),a0
		lea	cross_pal2(pc),a1

		lea	(4*16)(a0),a0
		lea	(4*256)(a1),a1

		moveq.l	#15,d7
.loop2		move.l	-(a0),d0
		rept	16
		move.l	d0,-(a1)
		endr
		dbra	d7,.loop2

		move.l	#c_cross_pal,fader_copper
		jsr	fader_makecopper

		move.l	cross_tex1,a0
		move.l	cross_tex2,a1
		lea	cross_texture1,a2
		lea	cross_texture2,a3

		move.w	#127,d7
.yloop		move.w	#(256/8)-1,d6
.xloop
		move.l	(a0)+,d1

		move.l	d1,d0
		eor.w	d1,d0
		eor.l	d0,d1
		swap	d0

		lsl.l	#4,d0
		lsr.w	#4,d0
		lsl.l	#8,d0
		lsr.w	#4,d0
		lsr.b	#4,d0

		lsl.l	#4,d1
		lsr.w	#4,d1
		lsl.l	#8,d1
		lsr.w	#4,d1
		lsr.b	#4,d1

		rept	4
		rol.l	#8,d0
		move.b	d0,(32768.l,a2)
		move.b	d0,(a2)+
		endr
		rept	4
		rol.l	#8,d1
		move.b	d1,(32768.l,a2)
		move.b	d1,(a2)+
		endr

		move.l	(a1)+,d1

		move.l	d1,d0
		eor.w	d1,d0
		eor.l	d0,d1
		swap	d0

		lsl.l	#4,d0
		lsr.w	#4,d0
		lsl.l	#8,d0
		lsr.w	#4,d0
		lsr.b	#4,d0

		lsl.l	#4,d1
		lsr.w	#4,d1
		lsl.l	#8,d1
		lsr.w	#4,d1
		lsr.b	#4,d1

		rol.l	#4,d0
		rept	4
		rol.l	#8,d0
		move.b	d0,(32768.l,a3)
		move.b	d0,(a3)+
		endr

		rol.l	#4,d1
		rept	4
		rol.l	#8,d1
		move.b	d1,(32768.l,a3)
		move.b	d1,(a3)+
		endr

		dbra	d6,.xloop
		dbra	d7,.yloop

		add.l	#32768,a2
		add.l	#32768,a3
		move.l	#65536,d0
		move.l	a2,a4
		move.l	a3,a5
		sub.l	d0,a2
		sub.l	d0,a3

		lea	cross_texture3,a6

		move.w	#(65536/4)-1,d7
.cl1		move.l	(a2)+,(a4)+
		move.l	(a3)+,d0
		move.l	d0,(a5)+
		lsr.l	#4,d0
		move.l	d0,(a6)+
		dbra	d7,.cl1
		rts

cross_lv3	bsr	cross_synch
		bsr	cross_setpal

		lea	cross_ang1(pc),a0
		lea	cross_ans1(pc),a1
		rept	6
		move.l	(a1)+,d0
		add.l	d0,(a0)+
		endr

		cmp.w	#10,P61_Pos
		blt	.no
		cmp.w	#59,P61_CRow
		blt	.no
		cmp.w	#11,P61_Pos
		bge	.no
		lea	c_cross_diw,a0
		movem.w	.diwstrt_add,d0-d1
		add.w	#$007a,d0
		move.w	d0,.diwstrt_add
		add.w	#$007a,d1
		move.w	d1,.diwstop_add
		lsr.w	#8,d0
		lsr.w	#8,d1
		add.b	d0,(2,a0)
		sub.b	d1,(6,a0)
.no

		rts

.diwstrt_add	dc.w	$0000
.diwstop_add	dc.w	$0000

cross_synch	move.w	P61_Pos,d0
		move.w	P61_CRow,d1

		cmp.w	#3,d0
		bne.b	.no1
		cmp.w	#32,d1
		bne.b	.no1

		clr.l	cross_zps1
		move.l	#-16,cross_zps2
		clr.l	cross_key

.no1		cmp.w	#4,d0
		bne	.no2

		clr.l	cross_zps2
		move.l	#16,cross_zps1
		move.l	#256,cross_key

		cmp.w	#32,d1
		blt.b	.no2

		clr.l	cross_zps1
		move.l	#16,cross_zps2
		clr.l	cross_key

.no2		cmp.w	#5,d0
		blt	.no3
		cmp.w	#6,d0
		bgt	.no3

.ok2		move.l	cross_var1(pc),d2
		add.l	#37,d2
		move.l	d2,cross_var1
		lea	sinus,a6
		move.l	#16383,d7

		and.l	d7,d2
		move.w	(1,a6,d2.w*4),d2
		add.w	#512-128,d2
		move.l	d2,cross_zpo1

		move.l	#$fafa0303,cross_spd1
		move.l	#30,cross_ans1
		clr.l	cross_zps1
		move.l	#256,cross_key

		cmp.w	#32,d1
		blt.b	.no3

		move.l	cross_zpo1(pc),d2
		move.l	d2,cross_zpo2
		move.l	cross_pos1(pc),d2
		move.l	d2,cross_pos2

		move.l	#-70,cross_ans2
		clr.l	cross_zps2
		clr.l	cross_key

.no3		cmp.w	#7,d0
		blt	.no4
		cmp.w	#12,d0
		bgt	.no4

		move.l	#-50,cross_ans1
		move.l	#20,cross_ans2

		move.l	#$07070303,cross_spd1
		move.l	#$02020505,cross_spd2

		lea	sinus,a6
		move.l	#16383,d7

		move.l	cross_var1(pc),d2
		add.l	#37,d2
		move.l	d2,cross_var1
		and.l	d7,d2
		move.w	(1,a6,d2.w*4),d2
		add.w	#512-128,d2
		move.l	d2,cross_zpo1

		move.l	cross_var2(pc),d2
		add.l	#57,d2
		move.l	d2,cross_var2
		and.l	d7,d2
		move.w	(1,a6,d2.w*4),d2
		add.w	#512-128,d2
		move.l	d2,cross_zpo2

		move.l	cross_var3(pc),d2
		add.l	#50,d2
		move.l	d2,cross_var3
		and.l	d7,d2
		move.w	(1,a6,d2.w*4),d2
		asr.w	#1,d2
		add.w	#128,d2
		move.l	d2,cross_key

		cmp.w	#8,d0
		bne.b	.no4
		move.l	#50,cross_ans1
		move.l	#-40,cross_ans2

		cmp.w	#8,d0
		bne.b	.no31
		tst.w	d1
		bne.b	.no31
		neg.l	cross_ans1

.no31		cmp.w	#10,d0
		bne.b	.no4
		tst.w	d1
		bne.b	.no4
		neg.l	cross_ans1
	
.no4		cmp.w	#11,d0
		blt.b	.no5

		sub.l	#$00000020,cross_spd1
		sub.l	#$00000018,cross_spd2
		add.l	#100,cross_var3

.no5		rts

cross_key	dc.l	256

cross_ang1	dc.l	0
cross_ang2	dc.l	0
cross_pos1	dc.l	0
cross_pos2	dc.l	0
cross_zpo1	dc.l	128+(16*4*32)
cross_zpo2	dc.l	128+(16*4*32)

cross_var1	dc.l	0
cross_var2	dc.l	0
cross_var3	dc.l	0

cross_ans1	dc.l	0
cross_ans2	dc.l	0
cross_spd1	dc.l	0
cross_spd2	dc.l	0
cross_zps1	dc.l	-16
cross_zps2	dc.l	0

cross_pos1_	dc.l	0
cross_pos2_	dc.l	0

cross_setpal	move.l	cross_key(pc),d5
		lea	cross_pal1(pc),a5
		lea	cross_pal2(pc),a6

		move.l	#c_cross_pal,a0
		addq.l	#6,a0

		move.l	#$000f0f0f<<4,d6
		move.w	#7,d7
.loop1		swap	d7

		move.w	#31,d7
.loop2

cross_mix	macro
		moveq.l	#0,d0
		moveq.l	#0,d2
		move.b	(a5)+,d0
		move.b	(a6)+,d2
		sub.w	d2,d0
		muls.w	d5,d0
		asr.l	#8,d0
		add.w	d2,d0
		endm

		addq.l	#1,a5
		addq.l	#1,a6
		moveq.l	#0,d1

		cross_mix
		move.b	d0,d1
		rol.l	#8,d1

		cross_mix
		move.b	d0,d1
		rol.l	#8,d1

		cross_mix
		move.b	d0,d1

		move.l	d1,d0
		and.l	d6,d1
		eor.l	d1,d0

				; xxxRxGxB
		lsl.b	#4,d0	; xxxRxGBx
		lsl.w	#4,d0	; xxxRGBxx
		lsr.l	#8,d0	; xxxxxRGB

		move.w	d0,132(a0)

				; xxRxGxBx
		lsr.l	#4,d1	; xxxRxGxB
		lsl.b	#4,d1	; xxxRxGBx
		lsl.w	#4,d1	; xxxRGBxx
		lsr.l	#8,d1	; xxxxxRGB
		move.w	d1,(a0)

		addq.l	#4,a0

		dbra	d7,.loop2

		add.l	#136,a0

		swap	d7
		dbra	d7,.loop1
		rts

cross_redraw	lea	sinus,a6
		move.l	#16383,d0

		move.l	#$80808080,d2

		move.l	cross_pos1(pc),d1
		add.l	d2,d1
		move.l	d1,cross_pos1_
		move.l	cross_pos2(pc),d1
		add.l	d2,d1
		move.l	d1,cross_pos2_

		lea	cross_ang1(pc),a0
		move.l	(a0)+,d6
		move.l	(a0)+,d7
		and.l	d0,d6
		and.l	d0,d7

		move.l	(a0)+,d0
		move.l	(a0)+,d0

		move.w	(1,a6,d6.l*4),d0
		add.w	#4096,d6
		move.w	(1,a6,d6.l*4),d4

		move.w	(1,a6,d7.l*4),d1
		add.w	#4096,d7
		move.w	(1,a6,d7.l*4),d5

		move.l	(a0)+,d2
		muls.w	d2,d0
		muls.w	d2,d4
		asr.l	#8,d0
		asr.l	#8,d4

		move.l	(a0)+,d2
		muls.w	d2,d1
		muls.w	d2,d5
		asr.l	#8,d1
		asr.l	#8,d5

		moveq.l	#-wid/2,d2
		moveq.l	#-hei/2,d6
		muls.w	d4,d2
		muls.w	d0,d6
		add.l	d6,d2
		moveq.l	#-wid/2,d6
		moveq.l	#-hei/2,d7
		muls.w	d0,d6
		muls.w	d4,d7
		sub.l	d6,d7
		swap	d0
		move.w	d4,d0
		swap	d2
		move.w	d7,d2

		moveq.l	#-wid/2,d3
		moveq.l	#-hei/2,d6
		muls.w	d5,d3
		muls.w	d1,d6
		add.l	d6,d3
		moveq.l	#-wid/2,d6
		moveq.l	#-hei/2,d7
		muls.w	d1,d6
		muls.w	d5,d7
		sub.l	d6,d7
		swap	d1
		move.w	d5,d1
		swap	d3
		move.w	d7,d3

makeslope	macro
		move.l	d2,d6
		ror.w	#8,d6
		rol.l	#8,d6
		move.w	d6,(\1*4)(a2)
		add.l	d0,d2

		move.l	d3,d6
		ror.w	#8,d6
		rol.l	#8,d6
		move.w	d6,(2+(\1*4))(a2)
		add.l	d1,d3
		endm

		lea	(offsets-16)(pc),a2
		clr.l	(a2)+
		move.l	d0,(a2)+
		swap	d0
		neg.w	d0

		clr.l	(a2)+
		move.l	d1,(a2)+
		swap	d1
		neg.w	d1

		move.w	#(wid/16)-1,d7
.loop1		makeslope	$0
		makeslope	$4
		makeslope	$8
		makeslope	$c

		makeslope	$1
		makeslope	$5
		makeslope	$9
		makeslope	$d

		makeslope	$2
		makeslope	$6
		makeslope	$a
		makeslope	$e

		makeslope	$3
		makeslope	$7
		makeslope	$b
		makeslope	$f

		add.l	#4*16,a2
		dbra	d7,.loop1

		move.l	#$0f0f0f0f,d4
		move.l	a7,.oldsp

		move.l	c2p16__bltbuf_(pc),a7
		move.l	-(a7),a3
		move.l	-(a7),a4
		move.l	-(a7),a5
		move.l	-(a7),a6

		moveq.l	#0,d5

		move.w	#hei-1,d7
.yloop		swap	d7
		lea	(offsets-16)(pc),a2

		lea	cross_texture1,a0
		lea	cross_texture2,a1

		move.l	(a2)+,d2
		add.l	(a2)+,d2
		move.l	d2,-8(a2)
		add.l	cross_pos1_(pc),d2
		ror.w	#8,d2
		rol.l	#8,d2
		move.w	d2,d5
		lea	(a0,d5.l),a0

		move.l	(a2)+,d2
		add.l	(a2)+,d2
		move.l	d2,-8(a2)
		add.l	cross_pos2_(pc),d2
		ror.w	#8,d2
		rol.l	#8,d2
		move.w	d2,d5
		lea	(a1,d5.l),a1

		move.w	#(wid/16)-1,d7
.xloop		moveq.l	#1,d6
.inloop
		move.w	(a2)+,d5
		move.w	(a0,d5.l),d0
		move.w	(a2)+,d5
		or.w	(a1,d5.l),d0
		move.w	(a2)+,d5
		move.b	(a0,d5.l),d0
		move.w	(a2)+,d5
		or.b	(a1,d5.l),d0
		swap	d0
		move.w	(a2)+,d5
		move.w	(a0,d5.l),d0
		move.w	(a2)+,d5
		or.w	(a1,d5.l),d0
		move.w	(a2)+,d5
		move.b	(a0,d5.l),d0
		move.w	(a2)+,d5
		or.b	(a1,d5.l),d0

		move.w	(a2)+,d5
		move.w	(a0,d5.l),d1
		move.w	(a2)+,d5
		or.w	(a1,d5.l),d1
		move.w	(a2)+,d5
		move.b	(a0,d5.l),d1
		move.w	(a2)+,d5
		or.b	(a1,d5.l),d1
		swap	d1
		move.w	(a2)+,d5
		move.w	(a0,d5.l),d1
		move.w	(a2)+,d5
		or.w	(a1,d5.l),d1
		move.w	(a2)+,d5
		move.b	(a0,d5.l),d1
		move.w	(a2)+,d5
		or.b	(a1,d5.l),d1

		exg.l	d0,d2
		exg.l	d1,d3

		dbra	d6,.inloop

		move.l	a6,(a7)+
		merge	d0,d2,d6,d4,4

		move.l	a5,(a7)+
		merge	d1,d3,d6,d4,4
		move.l	#$33333333,d5

		move.l	a4,(a7)+
		merge	d0,d1,d6,d5,2

		move.l	d0,a6
		move.l	d1,a5
		move.l	a3,(a7)+
		merge	d2,d3,d6,d5,2

		move.l	d2,a4
		move.l	d3,a3

		moveq.l	#0,d5
		dbra	d7,.xloop

		swap	d7
		dbra	d7,.yloop

		move.l	a6,(a7)+
		move.l	a5,(a7)+
		move.l	a4,(a7)+
		move.l	a3,(a7)+

		move.l	.oldsp(pc),a7
		rts

.oldsp		dc.l	0

		dcb.l	4
offsets		dcb.l	160

c2p16__planes	dc.l	planes1
c2p16__planes_	dc.l	planes2

c2p16__bltbuf	dc.l	bltbuf1
c2p16__bltbuf_	dc.l	bltbuf2
		dc.l	bltbuf3

c2p16_stack	dc.l	0
c2p16_pixels	dc.l	160*128
c2p16_proceed	dc.l	0

c2p16_blit	BWAIT
		;move.l	_GfxBase,a6
		;jsr	_LVOWaitBlit(a6)

		tst.b	c2p16_proceed
		bne.b	c2p16_blit

		st	c2p16_proceed

		lea	$dff000,a6


bwid set 320
bhei set hei
bplsize set bwid*bhei/8

		moveq.l	#-1,d0
		moveq.l	#12,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	d0,$44(a6)
		move.l	#$0DE41000,$40(a6)

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		addq.l	#4,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#(bplsize/4),$5c(a6)	; size_v
		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_2,lv3_blit
		rts

c2p16_blit_2	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize,a1
		addq.l	#4,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_3,lv3_blit
		rts

c2p16_blit_3	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*2,a1
		add.l	#12,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_4,lv3_blit
		rts

c2p16_blit_4	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*3,a1
		add.l	#12,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_5,lv3_blit
		rts

c2p16_blit_5	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*4,a1
		addq.l	#8,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_6,lv3_blit
		rts

c2p16_blit_6	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*5,a1
		addq.l	#8,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_7,lv3_blit
		rts

c2p16_blit_7	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*6,a1

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_8,lv3_blit
		rts

c2p16_blit_8	lea	$dff000,a6

		move.l	c2p16__bltbuf,a0
		move.l	c2p16__planes,a1
		add.l	#bplsize*7,a1

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p16_blit_end,lv3_blit
		rts

c2p16_blit_end	clr.l	c2p16_proceed
		clr.l	lv3_blit

.no		cmp.b	#255,$dff006
		bne.b	.no

		lea	c2p16__bltbuf(pc),a0
		movem.l	(a0),d0-d2
		move.l	d1,(a0)+
		move.l	d2,(a0)+
		move.l	d0,(a0)+

		lea	c2p16__planes(pc),a0
		movem.l	(a0),d0-d1
		move.l	d1,(a0)+
		move.l	d0,(a0)+

		lea	c_cross_bpls,a0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#bplsize,d0
		addq.l	#8,a0
		dbra	d7,.sloop
		rts

		cnop	0,16
cross_tex1	dc.l	0	;incbin	'chp.network'
cross_tex2	dc.l	0	;incbin	'chp.synthesis'
raw_presents	dc.l	0	;incbin	'raw.presents'

		section	cross,data_c

		cnop	0,64
c_cross		dc.w	$1fc,$4007
		dc.w	$100,$0201

xst		set	14	; 14 14
xnd		set	44	; 44 36

yst set $108-(90*2)

c_cross_diw	dc.w	$08e,$0082|(yst<<8)
		dc.w	$090,$08c1
		dc.w	$092,xst*4
		dc.w	$094,xnd*4

sprite	set	$120
c_cross_spr
		dc.w	sprite,   0,sprite+2, 0
		dc.w	sprite+4, 0,sprite+6, 0
		dc.w	sprite+8, 0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

		dc.w	$100,$0201|$0010
		dc.w	$102,$0010
		dc.w	$104,$0200
		dc.w	$106,$0020

		dc.w	$108,-40
		dc.w	$10a,0

c_cross_bpls	dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

		dc.w	$ffdf,$fffe
		dc.w	$0807,$fffe
c_cross_pal	dcb.b	2112,0	;fader_palsize
		dc.l	-2,-2

	cnop	0,16
spr_off	dcb.l	8
