	opt	p=68030,c+

	include	'dev:devpac/macros.gs'
	;include	'lvo.gs'
	include	'exec/execbase.i'

	section	code,code

InitSys	bsr	OSout			; Quitamos el control al Amiga OS
	bsr	Main			; Nuestro PROGRAMA !!!
	bsr	OSin			; Devolvemos el control al Amiga OS
	rts				; ADIOS !!!

OSout	movea.l	4.w,a6			; System Base
	lea	GfxLib,a1
	moveq	#0,d0
	jsr	-552(a6)		; OpenLibrary
	move.l	d0,GfxBase		; Save Graphics_lib base
	move.l	d0,a6
	move.l	38(a6),OldCopper	; gb_CopInit	Sys Copper
	move.l	34(a6),OldView		; gb_ActiView	Sys View
	jsr	-456(a6)		; Own Blitter
	sub.l	a1,a1			;LoadView Null
	jsr	-222(a6)		;LoadView

	move.w	#(10*1)-1,d7
.loop	jsr	-270(a6)		; lots of WaitTOF
	dbra	d7,.loop

	movea.l	4.w,a6			; System Base
	jsr	-132(a6)		; Forbid
	jsr	-150(a6)		; SuperState
	move.l	d0,SysStack		; System stack
	btst.b	#0,$129(a6)		; are we at least 68010? ($129=AttnFlags+1)
	beq.b	.68000			; nope.
	dc.w	$4e7a,$0801		;=movec.l vbr,d0 ; pero MDevPac no lo acepta
	move.l	d0,VectorBase		; Get Real VBR

.68000
	move.l	SysStack,d0		; Systemstack
	jsr	-156(a6)		; UserState

	move	$dff01c,IntEnaR		; Initialize custom chips
	move	$dff01e,IntReqR		; Save old valours first
	move	$dff002,DmaConR
	move	$dff010,AdkConR
	move	#%0111111111111111,$dff09a	; INTENA
	move	#%1100000001100000,$dff09a	* Enable desired IRQs
.Spr	move.l	$dff004,D0			; Wait RASTER to
	and.l	#$0001FF00,D0			; disable SPRITES
	bne.b	.Spr
	move	#%0111111111111111,$dff096	; DMACONW
	move	#%1000001111000000,$dff096	* Enable desired DMAs

	move	$dff07c,d0			;Ponerlo en/antes/despues de Copper?
	cmp.b	#$f8,d0
	bne.b	.NotAGA				; Not AGA
	move	#0,$dff1fc			* Fix AGA Res     (Ponerlo en Copper?)

.NotAGA	move.l	VectorBase,a0
	move.l	$6c(a0),Int3Save		; Save level 3 vector
	move.l	#level3,$6c(a0)			; Set OUR! own interrupt
	rts

OSin	move.l	VectorBase,a0
	move.l	Int3Save,$6c(a0)	; Reset Interrupts

	move	IntEnaR,d7		; Reset custom chips
	bset	#$f,d7
	move	d7,$dff09a		; Reset Interrupts

	move	IntReqR,d7
	bset	#$f,d7
	move	d7,$dff09c		; Reset interrupt request

	move	DmaConR,d7
	bset	#$f,d7
	move	d7,$dff096		; Reset DMAConw

	move	AdkConR,d7
	bset	#$f,d7
	move	d7,$dff09e		; Reset ADK

	move.l	GfxBase,a6
	movea.l	OldView,a1
	jsr	-222(a6)		;LoadView
	move.l	OldCopper,$dff080	; Reset System Copper
	jsr	-462(a6)		; DisOwn Blitter

	movea.l	4.w,a6			; System Base
	move.l	GfxBase,a1		; Close Graphics_lib
	jsr	-414(a6)		; CloseLibrary
	jsr	-138(a6)		; Permit

	moveq.l	#0,D0
	rts

GfxLib		dc.b	"graphics.library",0,0
GfxBase		dc.l	0
IntEnaR		dc.w	0
IntReqR		dc.w	0
DmaConR		dc.w	0
AdkConR		dc.w	0
SysStack	dc.l	0
Int3Save	dc.l	0
OldCopper	dc.l	0
OldView		dc.l	0
VectorBase	dc.l	0

***************** INTERRUPCION

wrast		macro
.wr1\@		cmp.b	#\1,$dff006
		bne.b	.wr1\@
.wr2\@		cmp.b	#\1,$dff006
		beq.b	.wr2\@
		endm

level3		movem.l	d0/a0/a1/a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	lv3_blit,d0
		beq.b	.no0
		move.l	d0,a0
		jsr	(a0)

.no0		movem.l	(sp)+,d0/a0/a1/a6
		move.w	#$40,$dff09c
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		move.l	lv3_vblank,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)

.no1		movem.l	(sp)+,d0/a0/a1/a6
		move.w	#$20,$dff09c
		rte

.novblank	movem.l	(sp)+,d0/a0/a1/a6
		move.w	#$70,$dff09c
		rte

lv3_vblank	dc.l	0
lv3_blit	dc.l	0
