		;machine	68030

		opt	debug,p=68040,l+,c-

		XDEF	cross
		XREF	cross_gfx1
		XREF	cross_gfx2

		XREF	cross_texture1
		XREF	cross_texture2
		XREF	cross_pals
		XREF	planes1
		XREF	planes2
		XREF	bltbuf1
		XREF	bltbuf2
	
		XREF	lv3_vblank
		XREF	lv3_blit
		XREF	lv3_copper

		XREF	P61_Pos
		XREF	P61_CRow
		XREF	P61_SetPosition

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_makecopper
		XREF	fader_initcrossfade
		XREF	fader_setpalette

		XREF	sinus
		XREF	salir

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		include	include:exec/exec_lib.i
		
		incdir	'cross'

		section	cross,code
RESET_SPRITES MACRO	;\1=copperlist sprite label
		lea	\1,a0
		moveq.l	#7,d0
		move.w	#$0120,d1
		move.l	#spr_off,d2
.spr_count\@
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		dbf	d0,.spr_count\@
		ENDM

wrast		macro
.wr1\@		cmp.b	#\1,$dff006
		bne.b	.wr1\@
.wr2\@		cmp.b	#\1,$dff006
		beq.b	.wr2\@
		endm

		;include	'fader_old.asm'

wid	set	160
hei	set	100

		dc.b	'hi man!',10
		dc.b	'if you are trying to rip this efect (crossfading dual-rotozoomers)',10
		dc.b	'... one advise.... GOOD LUCK IN UNTERSTANDING IT!!! XD',10
		dc.b	'mmm... ok ok... if you need help, write me:',10
		dc.b	'network@redestb.es',10
		dc.b	'network@amigascne.org',10
		dc.b	0

		;cnop	0,16

cross
		RESET_SPRITES	c_cross_spr

		lea	(bltbuf1+8*40*256).l,a0
		lea	(bltbuf2+8*40*256).l,a1
		;lea	(bltbuf3+8*40*256).l,a2
		lea	(planes1+8*40*256).l,a4
		lea	(planes2+8*40*256).l,a5
		;lea	(planes3+8*40*256).l,a6
		move.l	#((8*40*256)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5
.chiploop	rept	16
		movem.l	d1-d7/a3,-(a0)
		movem.l	d1-d7/a3,-(a1)
		;movem.l	d1-d7/a3,-(a2)
		movem.l	d1-d7/a3,-(a4)
		movem.l	d1-d7/a3,-(a5)
		;movem.l	d1-d7/a3,-(a6)
		endr
		dbf	d0,.chiploop

		move.l	#planes2,d0
		lea	c_cross_bpls,a0
		moveq.l	#7,d1
.loop2		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	#320*256/8,d0
		dbf	d1,.loop2

		bsr	cross_setup

		move.l	#c_cross,$dff080
		move.l	#cross_move,lv3_vblank

.loop
		;move.w	#$555,$dff180
		wrast	255
		;move.w	#$000,$dff180

		jsr	c2p_blit
		bsr	cross_synch
		bsr	cross_redraw

		tst.l	salir
		bne.b	.salcross
		cmp.w	#12,p61_pos
		blt	.loop
.salcross	bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

		cnop	0,16
		dc.l	$075				; estas on dos variables nuevas
cross_tang0	dc.l	0
		dc.l	$065
cross_tang1	dc.l	0


cross_xspd0	dc.l	0
cross_xang0	dc.l	0

cross_xspd1	dc.l	0
cross_xang1	dc.l	0

cross_zasp0	dc.l	0
cross_zang0	dc.l	0

cross_zasp1	dc.l	0
cross_zang1	dc.l	0

cross_pspd0	dc.l	0
cross_pang0	dc.l	0

cross_spd0	dc.l	0
cross_pos0	dc.l	0

cross_spd1	dc.l	0
cross_pos1	dc.l	0

cross_zspd0	dc.l	-$1000
cross_zpos0	dc.l	$1800+($4000*30)
cross_zspd1	dc.l	0
cross_zpos1	dc.l	$1800+($4000*30)

cross_key	dc.l	256

cross_tort0	dc.l	0
cross_tort1	dc.l	0

cross_synch	move.w	P61_Pos,d0
		move.w	P61_CRow,d1

; network patras

		cmp.w	#3,d0
		bne.b	.no1
		cmp.w	#32,d1
		blt.b	.no1

; synthesis patras

		clr.l	cross_zspd0
		move.l	#-$1000,cross_zspd1
		clr.l	cross_key

.no1		cmp.w	#4,d0
		bne	.no2

; network palante

		move.l	#$1000,cross_zspd0
		clr.l	cross_zspd1
		move.l	#256,cross_key

		cmp.w	#32,d1
		blt.b	.no2

; synthesis palante

		clr.l	cross_zspd0
		move.l	#$1000,cross_zspd1
		clr.l	cross_key

.no2		cmp.w	#5,d0
		blt	.no3
		cmp.w	#6,d0
		bgt	.no3

; network/synthesis girando con zoom

		lea	sinus,a6
		move.w	#16383,d7

		move.l	#$0555fddd,cross_spd0
		move.l	#$feee0333,cross_spd1

		move.l	#60,cross_zasp0
		move.l	#70,cross_zasp1

		move.l	cross_zang0(pc),d5
		move.l	cross_zang1(pc),d6
		and.w	d7,d5
		and.w	d7,d6
		move.l	(a6,d5.w*4),d4
		move.l	(a6,d6.w*4),d5
		asl.l	#1,d4
		asl.l	#1,d5
		add.l	#$2e000,d4
		add.l	#$2e000,d5
		move.l	d4,cross_zpos0
		move.l	d5,cross_zpos1

		clr.l	cross_zspd0
		clr.l	cross_zspd1
		move.l	#-80,cross_xspd0
		move.l	#256,cross_key

		cmp.w	#32,d1
		blt.b	.no3

		move.l	#80,cross_xspd1
		clr.l	cross_key

.no3		cmp.w	#7,d0
		blt	.no4

; network+synthesis crossfading

		move.l	#70,cross_xspd0
		move.l	#-60,cross_xspd1
		move.l	#80,cross_zasp0
		move.l	#90,cross_zasp1
		move.l	#100,cross_pspd0

		lea	sinus,a6
		move.w	#16383,d7

		move.l	cross_pang0(pc),d5
		add.w	#8192,d5
		and.w	d7,d5
		move.l	(a6,d5.w*4),d4
		asr.l	#8,d4
		asr.l	#1,d4
		add.l	#128,d4
		move.l	d4,cross_key

		move.l	cross_zang0(pc),d5
		move.l	cross_zang1(pc),d6
		and.w	d7,d5
		and.w	d7,d6
		move.l	(a6,d5.w*4),d4
		move.l	(a6,d6.w*4),d5
		add.l	#$1c000,d4
		add.l	#$1c000,d5
		move.l	d4,cross_zpos0
		move.l	d5,cross_zpos1

.no4		rts

cross_setup	lea	cross_jumptab,a0
		move.l	(a0)+,a1
		move.w	#10-2,d7
.loop0		move.l	(a0)+,a2
		move.l	a1,a3
		move.w	#(cross_drawsize/2)-1,d6
.loop01		move.w	(a3)+,(a2)+
		dbra	d6,.loop01
		dbra	d7,.loop0

		lea	cross_gfx1,a0
		lea	cross_texture1,a6
		moveq.l	#0,d5
		bsr	maketex
		lea	cross_gfx2,a0
		lea	cross_texture2,a6
		move.l	#4,d5
		bsr	maketex

.makepal	lea	cross_pal1,a0
		move.w	#15,d7
.loop1		lea	cross_palo1,a1
		rept	16
		move.l	(a1)+,(a0)+
		endr
		dbra	d7,.loop1

		lea	cross_pal2,a0
		lea	cross_palo2,a1
		move.w	#15,d7
.loop2		move.l	(a1)+,d0
		rept	16
		move.l	d0,(a0)+
		endr
		dbra	d7,.loop2

		lea	fader_copper,a0
		move.l	#c_cross_pal,(a0)	;fader_copper
		move.l	#cross_pal1,fader_original
		move.l	#cross_pal2,fader_target
		move.w	#255,fader_colors
		move.w	#1,fader_steps
		jsr	fader_makecopper
	
		lea	cross_pals,a2
		move.w	#256,d7
.loop3		lea	cross_pal1,a0
		lea	cross_pal2,a1
		move.w	#255,d6
.loop4		addq.l	#1,a0
		addq.l	#1,a1
		clr.b	(a2)+

		rept	3
		moveq.l	#0,d0
		moveq.l	#0,d1
		move.b	(a0)+,d0
		move.b	(a1)+,d1
		sub.w	d0,d1
		muls.w	d7,d1
		asr.l	#8,d1
		add.b	d1,d0
		move.b	d0,(a2)+
		endr

		dbra	d6,.loop4
		dbra	d7,.loop3
		rts

maketex		move.l	#128*256/8,d0
		lea	(a0,d0.l),a1
		lea	(a1,d0.l),a2
		lea	(a2,d0.l),a3

		move.w	#127,d7
.loop1		swap	d7
		move.w	#(256/8)-1,d7
.loop2		move.b	(a0)+,d0
		move.b	(a1)+,d1
		move.b	(a2)+,d2
		move.b	(a3)+,d3
		moveq.l	#8-1,d6
.loop3		moveq.l	#0,d4
		add.b	d3,d3
		addx.b	d4,d4
		add.b	d2,d2
		addx.b	d4,d4
		add.b	d1,d1
		addx.b	d4,d4
		add.b	d0,d0
		addx.b	d4,d4
		lsl.b	d5,d4
		move.b	d4,(a6)+
		dbra	d6,.loop3
		dbra	d7,.loop2
		swap	d7
		dbra	d7,.loop1

		lea	-32768(a6),a0

		move.w	#127,d7
.loop4		swap	d7
		move.w	#(256/4)-1,d7
.loop5		move.l	(a0)+,(a6)+
		dbra	d7,.loop5
		swap	d7
		dbra	d7,.loop4
		rts

cross_xoffsets	ds.w	2*wid
cross_yoffsets	ds.l	2*hei

cross_jumptab	dc.l	cross_draw0
		dc.l	cross_draw1
		dc.l	cross_draw2
		dc.l	cross_draw3
		dc.l	cross_draw4
		dc.l	cross_draw5
		dc.l	cross_draw6
		dc.l	cross_draw7
		dc.l	cross_draw8
		dc.l	cross_draw9

cross_move	lea	cross_xang0-4,a0
		rept	7
		move.l	(a0)+,d0
		add.l	d0,(a0)+
		endr

		lea	cross_zspd0,a0
		rept	2
		move.l	(a0)+,d0
		add.l	d0,(a0)+
		endr

		movem.l	d0-a6,-(sp)

		move.l	cross_key(pc),d0
		lsl.l	#8,d0
		lsl.l	#2,d0

		lea	cross_pals,a1
		and.w	#$fc00,d0
		lea	(a1,d0.l),a1

		move.l	fader_copper,a0

		addq.l	#6,a0

		move.l	#$00ff0000,d5
		move.l	#$000f0f0f,d6
		move.w	#7,d7
.loop1		swap	d7
		move.w	#31,d7
.loop2		move.l	(a1)+,d0

		move.l	d0,d1
		and.l	d6,d0
		eor.l	d0,d1

				; xxxRxGxB
		lsl.b	#4,d0	; xxxRxGBx
		lsl.w	#4,d0	; xxxRGBxx
		lsr.l	#8,d0	; xxxxxRGB

		move.w	d0,132(a0)

				; xxRxGxBx
		lsr.l	#4,d1	; xxxRxGxB
		lsl.b	#4,d1	; xxxRxGBx
		lsl.w	#4,d1	; xxxRGBxx
		lsr.l	#8,d1	; xxxxxRGB
		move.w	d1,(a0)

		addq.l	#4,a0

		dbra	d7,.loop2

		add.l	#136,a0

		swap	d7
		dbra	d7,.loop1

		movem.l	(sp)+,d0-a6

		move.w	p61_pos+1,d0
		move.b	p61_crow+1,d0
		cmp.w	#(11<<8)+11,d0
		blt.b	.no
		cmp.w	#(11<<8)+14,d0
		bgt.b	.no
		lea	c_cross_diw,a0
		movem.w	.diwstrt_add,d0-d1
		add.w	#$0025,d0
		move.w	d0,.diwstrt_add
		add.w	#$0025,d1
		move.w	d1,.diwstop_add
		lsr.w	#8,d0
		lsr.w	#8,d1
		add.b	d0,(2,a0)
		sub.b	d1,(6,a0)
.no		rts

.diwstrt_add	dc.w	$0000
.diwstop_add	dc.w	$0000


cross_redraw
		lea	sinus,a6
		move.w	#16383,d7

		cmp.w	#9,p61_pos
		blt	.notortillo

; principio trozo nuevo

		move.l	cross_tang1(pc),d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d6
		asr.l	#3,d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d0
		add.w	#4096+2048,d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d1
		asl.l	#4,d0
		asr.l	#8,d1
		asr.l	#4,d1
		move.w	d1,d0
		move.l	d0,cross_tort0
		swap	d0
		move.l	d0,cross_tort1

; fin trozo nuevo

.notortillo
		move.l	cross_xang0(pc),d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d1
		add.w	#4096,d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d0

		move.l	cross_xang1(pc),d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d3
		add.w	#4096,d6
		and.w	d7,d6
		move.l	(a6,d6.w*4),d2

		move.l	cross_zpos0(pc),d4
		move.l	cross_zpos1(pc),d5


		muls.l	d4,d6:d0
		move.w	d6,d0
		muls.l	d4,d6:d1
		move.w	d6,d1
		swap	d0
		swap	d1

		muls.l	d5,d6:d2
		move.w	d6,d2
		muls.l	d5,d6:d3
		move.w	d6,d3
		swap	d2
		swap	d3

		moveq.l	#(-wid/4),d4
		moveq.l	#(-hei/4),d6
		muls.l	d2,d4
		muls.l	d3,d6
		sub.l	d6,d4
		moveq.l	#(-wid/4),d5
		moveq.l	#(-hei/4),d6
		muls.l	d3,d5
		muls.l	d2,d6
		add.l	d6,d5

		movem.l	d4/d5,-(sp)

		moveq.l	#(-wid/4),d4
		moveq.l	#(-hei/4),d6
		muls.l	d0,d4
		muls.l	d1,d6
		sub.l	d6,d4
		moveq.l	#(-wid/4),d5
		moveq.l	#(-hei/4),d6
		muls.l	d1,d5
		muls.l	d0,d6
		add.l	d6,d5

		asl.l	#8,d0
		asr.l	#8,d1
		move.w	d1,d0
		asl.l	#8,d2
		asr.l	#8,d3
		move.w	d3,d2

		asl.l	#8,d4
		asr.l	#8,d5
		move.l	d4,d1
		move.w	d5,d1

		movem.l	(sp)+,d4/d5

		asl.l	#8,d4
		asr.l	#8,d5
		move.l	d4,d3
		move.w	d5,d3

		add.l	cross_pos0(pc),d1
		add.l	cross_pos1(pc),d3

		move.w	#$7fff,d6

		movem.l	d0-d3,-(sp)

		neg.w	d0
		neg.w	d2
		swap	d0
		swap	d2

		lea	cross_yoffsets,a0
		lea	cross_texture1,a1
		lea	cross_texture2,a2

; principio trozo nuevo

		move.l	cross_tort0(pc),a5
		move.l	cross_tort1(pc),a6

		move.w	#hei-1,d7
.yloop1		move.l	d1,d4
		lsr.w	#8,d4
		rol.l	#8,d4
		add.l	a5,d0
		and.w	d6,d4
		add.l	d0,d1
		lea	(a1,d4.w),a3
		move.l	a3,(a0)+
		move.l	d3,d4
		lsr.w	#8,d4
		rol.l	#8,d4
		add.l	a6,d2
		and.w	d6,d4
		add.l	d2,d3
		lea	(a2,d4.w),a3
		move.l	a3,(a0)+
		dbra	d7,.yloop1

; fin trozo nuevo

		movem.l	(sp)+,d0-d3

		lea	cross_xoffsets,a0

		move.w	#wid-1,d7
.xloop1		move.l	d1,d4
		lsr.w	#8,d4
		rol.l	#8,d4
		and.w	d6,d4
		add.l	d0,d1
		move.w	d4,(a0)+
		move.l	d3,d4
		lsr.w	#8,d4
		rol.l	#8,d4
		and.w	d6,d4
		add.l	d2,d3
		move.w	d4,(a0)+
		dbra	d7,.xloop1

		lea	cross_xoffsets,a0
		lea	cross_jumptab,a1
		moveq.l	#9,d7
.xloop2		move.l	(a1)+,a2
		addq.l	#4,a2
		moveq.l	#3,d6
.xloop3		move.w	(0+4*00)(a0),002(a2)
		move.w	(2+4*00)(a0),006(a2)
		move.w	(0+4*04)(a0),010(a2)
		move.w	(2+4*04)(a0),014(a2)
		move.w	(0+4*08)(a0),020(a2)
		move.w	(2+4*08)(a0),024(a2)
		move.w	(0+4*12)(a0),028(a2)
		move.w	(2+4*12)(a0),032(a2)
		addq.l	#4,a0
		lea	34(a2),a2
		dbra	d6,.xloop3
		lea	(4*(16-4))(a0),a0
		dbra	d7,.xloop2

		move.l	4.w,a6
		jsr	_LVOCacheClearU(a6)


cross_drawblocks
		move.l	sp,cross_oldsp
		move.w	#9,cross_block
		move.l	c2p__bltbuf_,a7
		lea	-(160-16)(a7),a7
		lea	cross_jumptab,a6
		move.l	#$0f0f0f0f,d4
		move.l	#$33333333,d5
cross_blockloop
		lea	cross_yoffsets(pc),a2
		move.l	(a6)+,a0
		move.l	a7,cross_olda7
		move.l	a6,cross_olda6

		move.l	-(a7),a3
		move.l	-(a7),a4
		move.l	-(a7),a5
		move.l	-(a7),a6
		move.w	#hei-1,d7

		jmp	(a0)

cross_drawreturn
		move.l	cross_olda7,a7
		move.l	cross_olda6,a6
		lea	16(a7),a7

		subq.w	#1,cross_block
		bge.b	cross_blockloop

		move.l	cross_oldsp,sp
		rts

		cnop	0,16
cross_block	dc.l	0
cross_oldsp	dc.l	0
cross_olda6	dc.l	0
cross_olda7	dc.l	0



merge		macro
		move.l	\2,\3
		lsr.l	#\5,\3
		eor.l	\1,\3
		and.l	\4,\3
		eor.l	\3,\1
		ifnc	'','\6'
		move.l	\1,\6
		endc
		lsl.l	#\5,\3
		eor.l	\3,\2
		endm

blocka		macro
		move.w	$1234(a0),\1
		or.w	$1234(a1),\1
		move.b	$1234(a0),\1
		or.b	$1234(a1),\1
		swap	\1
		move.w	$1234(a0),\1
		or.w	$1234(a1),\1
		move.b	$1234(a0),\1
		or.b	$1234(a1),\1
		endm


		cnop	0,16
cross_draw0
.yloop		movem.l	(a2)+,a0/a1

		blocka	d0
		blocka	d1
		blocka	d2
		blocka	d3

		move.l	a6,(a7)+
		merge	d0,d2,d6,d4,4		; d4 = $0f0f0f0f
		move.l	a5,(a7)+
		merge	d1,d3,d6,d4,4
		move.l	a4,(a7)+
		merge	d0,d1,d6,d5,2		; d5 = $33333333
		move.l	d0,a6
		move.l	d1,a5
		move.l	a3,(a7)+
		merge	d2,d3,d6,d5,2
		move.l	d2,a4
		move.l	d3,a3
		lea	(160-16)(a7),a7
		dbra	d7,.yloop
		move.l	a6,(a7)+
		move.l	a5,(a7)+
		move.l	a4,(a7)+
		move.l	a3,(a7)+
		jmp	cross_drawreturn
cross_draw0e
cross_drawsize	equ	cross_draw0e-cross_draw0

number		set	1

blockb		macro
		cnop	0,16
cross_draw\<number>
		ds.b	cross_drawsize
number		set	number+1
		endm

		blockb
		blockb
		blockb
		blockb

		blockb
		blockb
		blockb
		blockb
		blockb

		cnop	0,16
cross_pal1	ds.l	256
cross_pal2	ds.l	256
cross_pal3	ds.l	256
jj		set	0
cross_palo1	incbin	'pal.network'
cross_palo2	incbin	'pal.synthesis'
;cross_gfx1	dc.l	0	;incbin	'bpl.synthesis'
;cross_gfx2	dc.l	0	;incbin	'bpl.network'

c2p_data
c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	160*128
c2p_proceed	dc.l	0

c2p_blit	lea	$dff000,a6

c2p_wait		tst.b	c2p_proceed
		bne.b	c2p_wait

		st	c2p_proceed

		bsr	c2p_dbuff

bwid		set	wid+wid
bhei		set	hei
bplsize		set	bwid*bhei/8

		moveq.l	#-1,d0
		moveq.l	#12,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	d0,$44(a6)
		move.l	#$0DE41000,$40(a6)

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		addq.l	#4,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#(bplsize/4),$5c(a6)	; size_v
		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_2,lv3_blit
		rts

c2p_blit_2	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize,a1
		addq.l	#4,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_3,lv3_blit
		rts

c2p_blit_3	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*2,a1
		add.l	#12,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_4,lv3_blit
		rts

c2p_blit_4	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*3,a1
		add.l	#12,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_5,lv3_blit
		rts

c2p_blit_5	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*4,a1
		addq.l	#8,a0

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_6,lv3_blit
		rts

c2p_blit_6	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*5,a1
		addq.l	#8,a0

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_7,lv3_blit
		rts

c2p_blit_7	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*6,a1

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_8,lv3_blit
		rts

c2p_blit_8	lea	$dff000,a6

		move.l	c2p__bltbuf,a0
		move.l	c2p__planes,a1
		add.l	#bplsize*7,a1

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#c2p_blit_end,lv3_blit
		rts

c2p_blit_end	clr.l	c2p_proceed
		clr.l	lv3_blit
		rts

c2p_dbuff	lea	c2p__bltbuf(pc),a0
		movem.l	(a0),d0-d1
		move.l	d1,(a0)+
		move.l	d0,(a0)+

		lea	c2p__planes(pc),a0
		movem.l	(a0),d0-d1
		move.l	d1,(a0)+
		move.l	d0,(a0)+

		lea	c_cross_bpls,a0
		moveq.l	#7,d7
		move.l	#bplsize,d1
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		addq.l	#8,a0
		add.l	d1,d0
		dbra	d7,.sloop
		rts

		section	data_c,data_c

		cnop	0,64
c_cross		dc.w	$1fc,$4003
		dc.w	$100,$0201

yst set $112-(hei*2)

c_cross_diw
		dc.w	$08e,$0082|(yst<<8)
		dc.w	$090,$12c1
		dc.w	$092,4*14
		dc.w	$094,4*44

		dc.w	$100,$0201|$0010
		dc.w	$102,$0010
		dc.w	$104,$0224
		dc.w	$106,$0020

		dc.w	$108,-40
		dc.w	$10a,0

sprite	set	$120
c_cross_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

		dc.w	$1007,$fffe

c_cross_bpls	dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

		dc.w	$ffdf,$fffe
		dc.w	$2807,$fffe
c_cross_pal	ds.b	2112
		dc.l	-2,-2

		cnop	0,16
spr_off		ds.l	8
