	;machine	68030

	
	opt	debug,l+,c-,p=68030

	XREF	ham8_empty
	XREF	ham8_chipplanes
	XREF	water_sprt00
	XREF	water_sprt01
	XREF	water_sprt02
	XREF	water_sprt03
	XREF	water_sprt04

	XREF	p61_pos
	XREF	p61_crow

	XREF	lv3_vblank
	XREF	lv3_copper
	XREF	lv3_blit

	XREF	salir

	XREF	planes4

	XREF	ham8_fastpic
	XDEF	ham8_show

	incdir	'animalreign'

	section	animalreign,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l \3,\1
	ifnc	'','\6'
	move.l	\1,\6
	endc
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

whitepal	dcb.l	256,$00ffffff
blackpal	dcb.l	256,$00000000

ham8_show	
	lea	(ham8_empty+1024*480).l,a0
	move.l	#((1024*480)/(40*16))-1,d0
	moveq.l	#0,d1
	moveq.l	#0,d2
	moveq.l	#0,d3
	moveq.l	#0,d4
	moveq.l	#0,d5
	moveq.l	#0,d6
	moveq.l	#0,d7
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a5,a5
.chiploop2
	rept	16
	movem.l	d1-d7/a3-a5,-(a0)
	endr
	dbf	d0,.chiploop2

	lea	cop_ham8,a0
	move.l	#ham8_empty,d0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#1024*480/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	jsr	water_setup
	jsr	water_make

	;lea	madepic,a1
	;move.l	ham8_fastpic,a0
	;jsr	decrunch


	bsr	ham8_c2p


.loop1	lea	cop_ham8,a0
	move.l	a0,a1
	move.l	#ham8_chipplanes,d0

	wrast	255
	btst	#7,$dff004
	beq.b	.no1
	add.l	#32*4,d0
.no1
	rept	8
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#1024*480/8,d0
	addq.l	#8,a1
	endr
	move.l	a0,$dff080


	subq.w	#2,water_time
	jsr	water_calc

	tst.l	salir
	bne	.salanimal
	cmp.w	#30,p61_crow
	blt	.loop1

.loop2	lea	cop_ham8,a0
	move.l	a0,a1
	move.l	#ham8_chipplanes,d0

	wrast	255
	btst	#7,$dff004
	beq.b	.no2
	add.l	#32*4,d0
.no2
	rept	8
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#1024*480/8,d0
	addq.l	#8,a1
	endr
	move.l	a0,$dff080

	addq.w	#2,water_time
	jsr	water_calc

	tst.l	salir
	bne	.salanimal
	cmp.w	#63,p61_crow
	blt	.loop2
.salanimal
	clr.l	lv3_vblank
	clr.l	lv3_blit
	clr.l	lv3_copper
	rts

ham8_c2p
	lea	ham8_fastpic,a6
	move.l	#1024*480,a5
	add.l	a6,a5

	move.l	#1024*480/8,d0
	lea	ham8_chipplanes,a0
	lea	(a0,d0.l),a1
	lea	(a1,d0.l),a2
	lea	(a2,d0.l),a3

	move.l	#$0f0f0f0f,a4
	move.l	#$00ff00ff,d4
	move.l	#$33333333,d5
	move.l	#$55555555,d6

.c2p_loop1
	move.l	a4,d0
	and.l	(a6)+,d0
	lsl.l	#4,d0
	move.l	a4,d7
	and.l	(a6)+,d7
	or.l	d7,d0

	move.l	a4,d1
	and.l	(a6)+,d1
	lsl.l	#4,d1
	move.l	a4,d7
	and.l	(a6)+,d7
	or.l	d7,d1

	move.l	a4,d2
	and.l	(a6)+,d2
	lsl.l	#4,d2
	move.l	a4,d7
	and.l	(a6)+,d7
	or.l	d7,d2

	move.l	a4,d3
	and.l	(a6)+,d3
	lsl.l	#4,d3
	move.l	a4,d7
	and.l	(a6)+,d7
	or.l	d7,d3

	merge	d0,d1,d7,d4,8
	merge	d2,d3,d7,d4,8

	wordmerge	d0,d2,d7
	wordmerge	d1,d3,d7

	merge	d0,d2,d7,d5,2
	merge	d1,d3,d7,d5,2

	merge	d0,d1,d7,d6,1
	move.l	d0,(a3)+
	move.l	d1,(a2)+

	merge	d2,d3,d7,d6,1
	move.l	d2,(a1)+
	move.l	d3,(a0)+

	cmp.l	a5,a6
	bne	.c2p_loop1

	move.l	#1024*480/8,d0
	move.l	a3,a0
	lea	(a0,d0.l),a1
	lea	(a1,d0.l),a2
	lea	(a2,d0.l),a3

	lea	ham8_fastpic,a6
	move.l	#1024*480,a5
	add.l	a6,a5

	move.l	#$f0f0f0f0,a4

.c2p_loop2
	move.l	a4,d0
	and.l	(a6)+,d0
	move.l	a4,d7
	and.l	(a6)+,d7
	lsr.l	#4,d7
	or.l	d7,d0

	move.l	a4,d1
	and.l	(a6)+,d1
	move.l	a4,d7
	and.l	(a6)+,d7
	lsr.l	#4,d7
	or.l	d7,d1

	move.l	a4,d2
	and.l	(a6)+,d2
	move.l	a4,d7
	and.l	(a6)+,d7
	lsr.l	#4,d7
	or.l	d7,d2

	move.l	a4,d3
	and.l	(a6)+,d3
	move.l	a4,d7
	and.l	(a6)+,d7
	lsr.l	#4,d7
	or.l	d7,d3

	merge	d0,d1,d7,d4,8
	merge	d2,d3,d7,d4,8

	wordmerge	d0,d2,d7
	wordmerge	d1,d3,d7

	merge	d0,d2,d7,d5,2
	merge	d1,d3,d7,d5,2

	merge	d0,d1,d7,d6,1
	move.l	d0,(a3)+
	move.l	d1,(a2)+

	merge	d2,d3,d7,d6,1
	move.l	d2,(a1)+
	move.l	d3,(a0)+

	cmp.l	a5,a6
	bne	.c2p_loop2
	rts

;	include	'stonedec.i'
	include	'waterwipe.asm'

;	cnop	0,16
;madepic	incbin	'chk.made1.stc'

;ham8_fastpic	dc.l	0

	section	data_c,data_c

	cnop	0,64
spr_off	dc.l	0,0,0,0,0,0,0,0,0,0,0,0

	cnop	0,64
cop_ham8
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0
	dc.w	$e0,0,$e2,0	; ham control
	dc.w	$e4,0,$e6,0

cop_water_spr
	dc.w	$120,0,$122,0
	dc.w	$124,0,$126,0
	dc.w	$128,0,$12a,0
	dc.w	$12c,0,$12e,0
	dc.w	$130,0,$132,0
	dc.w	$134,0,$136,0
	dc.w	$138,0,$13a,0
	dc.w	$13c,0,$13e,0

	dc.w	$1fc,$000f
	dc.w	$100,$0201

	incbin	'pal.made1'

	dc.w	$08e,$3081+32
	dc.w	$090,$20c1-32
	dc.w	$092,4*(14+4)
	dc.w	$094,4*(44+8-4)

	dc.w	$100,$0200|$0810|$0044
	dc.w	$102,$0000
	dc.w	$104,$0024	; prioridad de sprites sobre todos los planos
	dc.w	$106,$0240	; sprites en baja por fuerza
	dc.w	$10c,$0044	; paleta 1 para sprites pares e impares
	dc.w	$108,4*32
	dc.w	$10a,4*32
	dc.l	-2,-2

