
		opt	c-
;----------------------------------------------------------------------------
; XELElink    (sistema linkador de Ficheros para Trashcan
;----------------------------------------------------------------------------

; Debe existir un fichero llamado Xelelink.list
; que contenga el listado de los ficheros a linkar

	Include	"TrashcanX:Source/TR_Macro/Macros_libraries"
	Include	"TrashcanX:Source/TR_Macro/Macros_generales"
	include	"TrashcanX:Source/TR_Data/Data_Constantes"

; Reserva memoria para el buffer

Principiodelfin
;----------------------------------------------------------------------------

	BASE	Exec
	move.l	#MaxMem,d0
	move.l	#MEMF_ANY,d1
	jsr	allocmem(a6)
	tst.l	d0
	beq	fueraya
	move.l	d0,MemBuffer

	OPENLIB	Dos

;----------------------------------------------------------------------------

; Averiguamos inicio de ficheros

	move.l	#Numfiles,d0
	;wasi: mulu #8 sin flag
	mulu	#9,d0		;cada entrada de la header son 8 bytes
	add.l	#4,d0		;Numfiles = 4 bytes !
	move.l	d0,d6		;d6 = Ancho en bytes de la cabecera

; Comenzamos bucle principal de lectura de ficheros -> buffer

	lea	FileList,a0	;a0 apunta a la lista de ficheros
	move.l	Membuffer,a2	;a2 apunta al comienzo del header
	move.l	a2,a3
	add.l	d6,a3		;a3 apunta al comienzo de la seccion datos

; inicializa la cabecera

	move.l	#numfiles,(a2)+	; 1er valor es el numero de files linkados
	move.l	d6,d3		; variable SeekPos = D3 = HeaderLenght

	move.l	#numfiles,d0
	subq	#1,d0
.MainLoop
	
; copiamos nombre de fichero a FILENAME

	;this added by Wasi
	;Flag que nos dice si el fichero tiene que ir en fast o en
	;chip: 0=fast, 1=chip
	move.b	(a0)+,flag

	lea	filename,a1	;a1 apunta a FILENAME (parametro para rutinas)
.loop1
	move.b	(a0)+,(a1)+
	move.b	(a0),d5
	bne	.loop1
	move.b	#0,(a1)
	lea	1(a0),a0

; averiguamos longitud del fichero y lo ponemos en la cabecera

	bsr	Verlongitud
	cmp.l	#1,d7
	beq	salirse

	move.l	filesize,d1
	move.b	flag,(a2)+
	move.l	d3,(a2)+	;pone Seekpos del file
	move.l	d1,(a2)+	;pone longitud del file
	add.l	d1,d3
	;addq.l	#1,d3

; ahora carga el fichero en el buffer

	move.l	a3,filebuffer
	move.l	d1,filelenght
	bsr	CargarFichero
	cmp.l	#1,d7
	beq	salirse

	add.l	d1,a3		;incrememntamos puntero a buffer en memoria

	dbra	d0,.MainLoop

; por ltimo, creamos y grabamos el fichero objeto directa-> de la memoria

.crea
	lea	Destino,a0
	lea	filename,a1
.loop2
	move.b	(a0)+,(a1)+
	move.b	(a0),d5
	bne	.loop2
	move.b	#0,(a1)
	bsr	crearfichero

	move.l	d3,filelenght
	move.l	Membuffer,filebuffer
	bsr	EscribirDatos

	BASE	Dos
	move.l	FileHandle,d1		;cerrar el fichero
	jsr	Close(a6)


;----------------------------------------------------------------------------

Salirse
	CLOSELIB dos

	BASE	Exec
	move.l	#Maxmem,d0
	move.l	Membuffer,a1
	jsr	freemem(a6)

fueraya		; por algn motivo Xele no tiene memoria Fast, ser porque
		; se la han sirlado en la party mientras dormia
	move.l	d7,d0
	rts



;----------------------------------------------------------------------------
; Averigua longitud de un fichero dado su nombre y si existe o no
;----------------------------------------------------------------------------
VerLongitud

	METEPILA2
	moveq	#0,d7

	BASE	dos
	move.l	#FileName,d1
	move.l	#-2,d2
	jsr	Lock(a6)		;funcin lock
	tst.l	d0
	beq	.error
	move.l	d0,FileLock

	move.l	d0,d1
	move.l	#FileInfoBlock,d2
	jsr	Examine(a6)		;funcin examine
	tst.l	d0
	beq	.error

	lea	FileInfoBlock,a0	;Averiguar tamao
	move.l	FIB_Size(a0),FileSize

	move.l	filelock,d1
	jsr	unlock(a6)
	
	SACAPILA2
	rts

.Error
	moveq	#1,d7
	SACAPILA2
	rts

;----------------------------------------------------------------------------
; Abrir un fichero, leer un trozo determinado y cerrar el fichero
;----------------------------------------------------------------------------
CargarFichero

	METEPILA2
	moveq	#0,d7

	BASE	dos
	move.l	#FileName,d1
	move.l	#MODE_READONLY,d2
	jsr	Open(a6)
	tst.l	d0
	beq	.error
	move.l	d0,FileHandle

	move.l	FileHandle,d1		;leer los datos y pasarlos al buffer
	move.l	FileBuffer,d2
	move.l	FileLenght,d3
	jsr	Read(a6)
	cmp.l	#-1,d0
	beq	.error

	move.l	FileHandle,d1		;cerrar el fichero
	jsr	Close(a6)

	SACAPILA2
	rts

.error
	move.l	#1,d7
	SACAPILA2
	rts


;----------------------------------------------------------------------------
; Crear un nuevo fichero y dejarlo abierto listo para escribir en l
;----------------------------------------------------------------------------
CrearFichero

	METEPILA2
	moveq	#0,d7

	BASE	dos
	move.l	#FileName,d1
	move.l	#MODE_NEWFILE,d2
	jsr	Open(a6)
	tst.l	d0
	beq	.error
	move.l	d0,FileHandle

	SACAPILA2
	rts

.error
	move.l	#1,d7
	SACAPILA2
	rts

;----------------------------------------------------------------------------
; ESCRIBIR datos a un fichero
;----------------------------------------------------------------------------
EscribirDatos

	METEPILA2
	moveq	#0,d7

	BASE	Dos
	move.l	FileHandle,d1		
	move.l	FileSeekPos,d2
	move.l	#-1,d3
	jsr	Seek(a6)
	cmp.w	#-1,d0
	beq	.error

	move.l	FileHandle,d1		;leer los datos y pasarlos al buffer
	move.l	FileBuffer,d2
	move.l	FileLenght,d3
	jsr	Write(a6)
	cmp.w	#-1,d0
	beq	.error

	SACAPILA2
	rts
.error
	move.l	#1,d7
	SACAPILA2
	rts

;------------------------------------------------------------------------
; Fichero include de punteros y nombres de librerias para Trashcan
;------------------------------------------------------------------------
		 								SECTION	datos,DATA
flag		dc.l	0

MemBuffer	dc.l	0
		CNOP	0,4
		INCLUDE	"TrashcanX:Source/TR_Data/Data_Punteros"

Filelist
*		INCLUDE	"demo:NTW_SYNTH1.s"
		INCLUDE	"demo:NTW_SYNTH2.s"
*		INCLUDE	"demo:NTW_SYNTH3.s"
*		INCLUDE	"demo:NTW_SYNTH4.s"
