/* COS(X)+COS(Y)+COS(Z)=w RAYTRACER */
/* SoopaDoopa 2002 */

#include "tracer.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "malloc.h"
#include "timing.h"
#include "main.h"

//-------------------------------------------------------------------
// Display information
//-------------------------------------------------------------------

static int iframe;
extern int PAL;
static texture *tempscreen;
static texture *screen;

//-------------------------------------------------------------------
// VU code/data externs
//-------------------------------------------------------------------

extern unsigned int tracer_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int tracer_vucodeend  __attribute__((section(".vudata")));
extern unsigned int tracer_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int tracer_vudataend  __attribute__((section(".vudata")));

extern int128 tracer_e_start,tracer_e_delta,tracer_e_giftag,tracer_e_gifsetup,tracer_e_matrix,tracer_e_seed   __attribute__((section(".vudata")));
extern vec tracer_e_light,tracer_e_eye,tracer_e_step,tracer_e_stepdeltax,tracer_e_stepdeltay   __attribute__((section(".vudata")));
extern vec tracer_e_stepdeltaxcos,tracer_e_stepdeltaxsin   __attribute__((section(".vudata")));
extern vec tracer_e_stepdeltaycos,tracer_e_stepdeltaysin   __attribute__((section(".vudata")));
extern fvec tracer_e_sinedata,tracer_e_sinetable[16]  __attribute__((section(".vudata")));

//-------------------------------------------------------------------
// Textures
//-------------------------------------------------------------------

extern char binary_tex1_start[];

static texture tex1;
static texture tracescreen;

//-------------------------------------------------------------------
// Variables
//-------------------------------------------------------------------

#define BLOCKSX 20
#define BLOCKSY 16
#define HEIGHT (BLOCKSY*8)

static int dybdetabel[BLOCKSY+1][BLOCKSX+1];

//-------------------------------------------------------------------
// Timing variables
//-------------------------------------------------------------------

int color;

//-------------------------------------------------------------------
// Timing variables
//-------------------------------------------------------------------
static float rotate;

//-------------------------------------------------------------------
// Functions
//-------------------------------------------------------------------

static fvec vsin(fvec &v)
{
  fvec w;
  
  w.x=sin(v.x);
  w.y=sin(v.y);
  w.z=sin(v.z);
  
  return w;
}

static fvec vcos(fvec &v)
{
  fvec w;
  
  w.x=cos(v.x);
  w.y=cos(v.y);
  w.z=cos(v.z);
	
  return w;
}

#define max(a,b) ((a) > (b) ? (a) : (b))
#define min(a,b) ((a) > (b) ? (b) : (a))


//-------------------------------------------------------------------
// Class methods
//-------------------------------------------------------------------

static void vutest(float frames)
{
  static float angle;
  int x,y,t;
  float s;
  fmatrix M;
  int minx;
  gif_env;
  float level=0;//sin(frames*0.03)+0.5;

  static float z;
  z+=0.1;
  z+=timing::get(0)*0.2+timing::get(1)*0.12;

  vec stepdeltax;
  vec stepdeltay;
  fvec corners[4];

  // Setup view coordinates
  {
    float scale=2;
    static float angle;
    fmatrix m;
    fvec corners1[4];
    angle+=0.1*0.1;
    
    corners1[0]=fvec_(-1,-1,1,0);		
    corners1[1]=fvec_(1,-1,1,0);		
    corners1[2]=fvec_(-1,1,1,0);		
    corners1[3]=fvec_(1,1,1,0);		
		
    resetmatrixf(&m);
    scalematrixf(&m,1.25,1,1);
    rotatematrixxf(&m,angle+rotate);
    rotatematrixyf(&m,angle-rotate);
    scalematrixf(&m,0.3,0.3,0.3);

    transformf(&m,corners1,corners,4);
    
    tracer_e_step.fv=corners[0];
    stepdeltax.fv=tracer_e_stepdeltax.fv=0.5*fvec_((corners[1].x-corners[0].x)/320*scale,(corners[1].y-corners[0].y)/320*scale,(corners[1].z-corners[0].z)/320*scale,0);	
    stepdeltay.fv=tracer_e_stepdeltay.fv=0.5*fvec_((corners[2].x-corners[0].x)/HEIGHT*scale,(corners[2].y-corners[0].y)/HEIGHT*scale,(corners[2].z-corners[0].z)/HEIGHT*scale,0);	

    tracer_e_stepdeltaxcos.fv=vcos(stepdeltax.fv);
    tracer_e_stepdeltaxsin.fv=vsin(stepdeltax.fv);
    
    tracer_e_stepdeltaycos.fv=vcos(stepdeltay.fv);
    tracer_e_stepdeltaysin.fv=vsin(stepdeltay.fv);

    tracer_e_light.fv=fvec_(0,0,16,0);
    tracer_e_light.fv=2.5*(corners[0]+corners[1]+corners[2]+corners[3]);	
    tracer_e_eye.fv=fvec_(0,0,z,0);	
  }

  // Setup render states for context 2 in vif1 dma list - render to tracescreen
  {
    //    initvifdmalist();

    tracescreen.setcurrent_vif2(0);

    dma01_beginp();
    vif_nop();
    vif_nop();
    vif_nop();
    vif_direct_begin();
    gif_tag(0xe,1,0,0,0);
    gTEX0_2(tex1.TEX0()+((int64)3<<35));
    gTEX1_2(1<<5);				//bilinear
    gTEST_2(0x0000);
    gTEST_2(0x20000);
    gFOGCOL(rgb(80,120,155));
    gif_endfinal();
    vif_direct_end();
    dma01_endp();
  }

  // Clear and upload to vu memory (vif1 dma list)
  uploadvucode(&tracer_vucodebegin,&tracer_vucodeend);
  clearvudata();
  uploadvudata((char*)&tracer_vudatabegin,(char*)&tracer_vudataend);

  // Compute low resoulution grid using main cpu

  int blocksx=BLOCKSX;
  int blocksy=PAL?BLOCKSY:13;
  int blocksyoffset=PAL?0:2;

  for(int y=blocksyoffset;y<=blocksy+blocksyoffset;y++)
    {
      for(int x=0;x<=blocksx;x++)
	{
	  int t;
	  
	  fvec pos=fvec_(0,0,z,0);
	  fvec temp;
	  
	  fvec r=vcos(pos);
	  fvec i=vsin(pos);
	  
	  fvec step=(((float)blocksx-x)/blocksx)*corners[0]+((float)x/blocksx)*corners[1]+((float)y/BLOCKSY)*(corners[2]-corners[0]);
	  fvec stepr=vcos(step);
	  fvec stepi=vsin(step);
	  
	  for(t=0;t<40;t++)
	    {
	      temp=r*stepr-i*stepi;
	      i=r*stepi+i*stepr;
	      r=temp;
	      
	      if(r.x+r.y+r.z+level<0)break;
	    }
	  dybdetabel[y][x]=t;
	}
    }
	
  // Now we transfer the results to the vif1 dma list

  dma01_beginp();
  vif_nop();
  vif_nop();

  for(int y=blocksyoffset;y<blocksy+blocksyoffset;y++)
    {
      for(int x=0;x<blocksx;x++)
	{
	  int startd=max(min(min(dybdetabel[y][x],dybdetabel[y][x+1]),min(dybdetabel[y+1][x],dybdetabel[y+1][x+1]))-2,0);
	  vec screenpos;
	  vec pos;
	  vec posr;
	  vec posi;
	  vec posdeltax;
	  vec posdeltaxr;
	  vec posdeltaxi;
	  vec posdeltay;
	  vec posdeltayr;
	  vec posdeltayi;
	  vec step;
	  vec stepr;
	  vec stepi;

	  screenpos.fv.x=32000+16*16*x;
	  screenpos.fv.y=32000+8*16*y;
	  
	  step.fv=(((float)blocksx-x)/blocksx)*corners[0]+((float)x/blocksx)*corners[1]+((float)y/BLOCKSY)*(corners[2]-corners[0]);
	  stepr.fv=vcos(step.fv);
	  stepi.fv=vsin(step.fv);
	  
	  pos.fv=fvec_(0,0,z,0)+float(startd)*step.fv;
	  posr.fv=vcos(pos.fv);
	  posi.fv=vsin(pos.fv);
	  
	  pos.fv.w=level;
	  
	  posdeltax.fv=fvec_(0,0,0,0)+float(startd)*stepdeltax.fv;
	  posdeltaxr.fv=vcos(posdeltax.fv);
	  posdeltaxi.fv=vsin(posdeltax.fv);
	  
	  posdeltay.fv=fvec_(0,0,0,0)+float(startd)*stepdeltay.fv;
	  posdeltayr.fv=vcos(posdeltay.fv);
	  posdeltayi.fv=vsin(posdeltay.fv);
	  
	  posr.fv.w=level;
	  pos.fv.w=16*255-6*16*(float)startd;
	  step.fv.w=-6*16;
	  posdeltax.fv.w=0;
	  posdeltay.fv.w=0;

	  vif_flushe();
	  vif_unpack(13,0+0x8000);
	  
	  vif_128(screenpos.i128);
	  
	  vif_128(pos.i128);
	  vif_128(posr.i128);
	  vif_128(posi.i128);
	  
	  vif_128(posdeltax.i128);
	  vif_128(posdeltaxr.i128);
	  vif_128(posdeltaxi.i128);
	  
	  vif_128(posdeltay.i128);
	  vif_128(posdeltayr.i128);
	  vif_128(posdeltayi.i128);
	  
	  vif_128(step.i128);
	  vif_128(stepr.i128);
	  vif_128(stepi.i128);
	  
	  vif_mscal(0x0);
	  vif_nop();
	}
    }
  vif_nop();
  vif_nop();
  dma01_endp();

  // FlushA

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_flusha();
  dma01_endp();

  // When vif1 reaches this point in the dma list vu1 and gs
  // have rendered the screen in resolution 320x128.
  // All there is left to do is to render the low resolution
  // screen to the main screen. ...using vif1

  screen->setcurrent_vif2(iframe);
  tracescreen.boxuv_vif(0,0,640*16,512*16,0,hhw(320*16,HEIGHT*16),0,0,color);

  if(PAL)
    main_renderBackground(iframe,true);//no time for this with NTSC

  dma01_endchain();
}


void tracer_init()
{
  tracescreen.init();
  tracescreen.width=320;
  tracescreen.height=128;
  
  tex1.init();
  tex1.load(binary_tex1_start);
}

void tracer_init2()
{
  tex1.allocupload();
  tex1.upload(tex1.addr);
}


void tracer_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_)
{
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  
  int v=int(128+70*timing::get(6));
  color=RGB(v,128,v);

  rotate+=0.02*timing::get(10);

  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval2(11)>0)
      {
	rotate+=0.1*timing::getval2(11);
      }
    oldTime11=timing::gettime(11);
  }

  tracescreen.addr=tempscreen->addr;
  vutest(frames);
}

void tracer_deinit()
{
}
