#ifndef __TIMING_H
#define __TIMING_H


#define TIMING_MAXPATTERNS 40
#define TIMING_MAXPATTERNITEMS 13000
#define TIMING_MAXTRACKLENGTH 140
#define TIMING_MAXINSTR 100
#define TIMING_MAXACTIVE 40

class patternitem
{
 public:
  class patternitem *next;
  /*	int t1,t2,t3,t4;
	int instr;
	float p1,p2,p3;
  */
  unsigned char t1;
  unsigned char t2,t3,t4;
  unsigned char instr;
  unsigned char p1,p2,p3;
};

class pattern
{
 public:
  int length;
  patternitem *list;
  pattern();
};

class trackitem
{
 public:
  int pnum;
  int t,rep;
};

class activeitem
{
 public:
  activeitem *next;
  trackitem *item;
  patternitem *current;
  int rep;
};

class instrument
{
 public:
  float time;
  float p1,p2,p3;
};

class timing
{
  static int voice98map;
  //	static instrument instruments[TIMING_MAXINSTR];
  //	static patternitem patternitems[TIMING_MAXPATTERNITEMS];
  static int nextfreepatternitem;
  activeitem activelist[TIMING_MAXACTIVE];
  patternitem *newpatternitem(int t1, int t2, int t3, int t4, int instr, float p1, float p2, float p3);
  enum midiLineEnum{
    midiOn,
    midiUnknown,
    midiTrackBegin,
    midiTrackEnd
  };
  midiLineEnum parseMidiLine(char **midiFile, int &time1, int &time2, int &time3, int &ch, int &n, int &v);
 public:
  activeitem *activefirst;
  activeitem *activefree;
	
  static	float time;
  int nexttrackitem;
  float bpm;
  int length;
  int npatterns;
  int ntrackitems;
  timing();
  pattern patterns[TIMING_MAXPATTERNS];
  trackitem track[TIMING_MAXTRACKLENGTH];
  float toms(int t);
  void load(char *mem, char *midiFile);
  void clear();
  void step(float t);
  static float get(int instr);
  static int getval(int instr);
  static int getval2(int instr);
  static int getval3(int instr);
  static int gettime(int instr);
  int currentpos(); //times 4
  void mapvoice98(int voicenum);
};



#endif
