/* Text Bar */
/* Soopadoopa 2003 */

#include "textbar.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "glow.h"
#include "timing.h"
#include "spline.h"
#include "font.h"

static texture fonttexture;
font theDemoFont;

extern char binary_font2_start[];
extern char binary_font2_alpha_start[];

static texture *tempscreen;
static texture *screen;
static int iframe;
static float timing;

extern int PAL;

static int currentBarHeight;
static float currentAnimationPos;

static void renderLine(float ax, float ay, float bx, float by, int color)
{
  gif_env;

  int x,y;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  gALPHA_1(0x8000000029);
  // gALPHA_1(0x8000000000);
  
  gTEST_1(0x30000);
  
  gPRIM(PRIMline+0*PRIMtexture+0*PRIMuv+PRIMalpha);
  gPABE(0);
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  
  x=65535&(int)(ax*16+32000);
  y=65535&(int)(ay*16/2+32000);
  gXYZ2(hhw(x,y));
  
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  x=65535&(int)(bx*16+32000);
  y=65535&(int)(by*16/2+32000);
  gXYZ2(hhw(x,y));

  gif_endfinal();
  dma_endgp();
}


void textbar_init()
{
  fonttexture.init();
  fonttexture.load(binary_font2_start);
  fonttexture.loadalpha(binary_font2_alpha_start);
 
}


void textbar_init2()
{
  fonttexture.allocupload();
   theDemoFont.init(&fonttexture,19,0,1,
	       "ABCDEFGHIJKLMNOPQRSTUVWXYZÆØÅ\n"
	       "0123456789+-*=,.;:!?\"#@$%&/\\<>()[]|_'^\n"
	       ,0xff000000);
}

static void bar(int x, int y, char *s, float blur)
{
  if(currentBarHeight>14)currentBarHeight=14;
  if(currentBarHeight>0)
    {

      fonttexture.boxNoTexture(0*16,(y-currentBarHeight)*16,640*16,(y+currentBarHeight)*16,0);
      renderLine(0,y-1-currentBarHeight,640,y-1-currentBarHeight,0x202020);
      renderLine(0,(y+currentBarHeight),640,(y+currentBarHeight),0x202020);
      theDemoFont.setalpha(22);
      theDemoFont.setadditive(true);
      //      for(int t=0;t<16;t++)
      for(int t=0;t<16;t++)
	{
	  theDemoFont.putstring(s,x+blur*t,y+2-14);
	}
      //thefont.setalpha(256);
      //thefont.setadditive(false);
      //      thefont.putstring(s,x+300,y+2-14);
    }
}


void textbar_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_, float timing_)
{
    static int localFrames;
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  timing=timing_;
  
  static int num;

  //  fonttexture.boxuv(0,0,3*16*(fonttexture.width),3*16*(fonttexture.height),0,hhw(16*384,16*64));


  if(((int)frames)&1)
    {
      int barHeightDest=timing::getval2(19);
      if(barHeightDest>currentBarHeight)currentBarHeight++;
      if(barHeightDest<currentBarHeight)currentBarHeight--;
    }

  int animationPosDest=timing::getval3(19);
  
  if(animationPosDest==0)currentAnimationPos=0;
  if(animationPosDest==1 && currentAnimationPos<1)currentAnimationPos+=0.05;
  if(animationPosDest==2 && currentAnimationPos<2)currentAnimationPos+=0.05;

  //  float blur=2*(1+sin(frames*0.05));

  float blur=0;
  float xpos=0;
  
  if(currentAnimationPos<1)
    {
      //      xpos=640-640*currentAnimationPos;
      xpos=640-640*sin(currentAnimationPos*3.1415*0.5);
      blur=(100-100*currentAnimationPos)/32.0f;
    }
  else
    if(currentAnimationPos<2)
      {
	xpos=640-640*(2-cos((currentAnimationPos-1)*3.1415*0.5));
	blur=(100-100*(2-currentAnimationPos))/32.0f;
      }
    else
      {
	xpos=640;
      }

  switch(timing::getval(19))
    {
    case 1:
      bar(120+int(xpos),316,"SOOPADOOPA PRESENTS",blur);
      break;
    case 2:
      bar(120+int(xpos),316,"A SCENE EVENT 2003 DEMO",blur);
      break;
    case 3:
      bar(120+int(xpos),316,"AURA FOR LAURA",blur);
      break;
    case 4:
      bar(120+int(xpos),196,"CODE: DRUCKLUFT",blur);
      break;
    case 5:
      bar(120+int(xpos),196,"AUDIO AND VISUALS: THORSTEN",blur);
      break;
    case 6:
      bar(120+int(xpos),316,"YOU HAVE BEEN WATCHING...",blur);
      break;
    case 100:
      bar(0,196+12,"",blur);//DUMMYGREETINGS
      break;
    default:
      break;
    }
  
  localFrames++;
  
}

void textbar_deinit()
{
}
