#include "spline.h"
#include <kernel.h>
#include "myassert.h"

#define MAXSPLINEKEYS 1024

static linearSplineKey splineKeyMemory[MAXSPLINEKEYS];
static int nextFree;

void linearSpline::init()
{
  setInterpolationEnabled(true);
  head.time=0;
  head.value=0;
  head.next=&head;
  head.prev=&head;
  cached=&head;
}

void linearSpline::setInterpolationEnabled(bool enabled)
{
  interpolationEnabled=enabled;
}


void linearSpline::search(float time)
{
  while(cached->time>time && cached!=&head)cached=cached->prev;
  while(cached->next->time<time && cached->next!=&head)cached=cached->next;
}


void linearSpline::addKeyValue(float time, float value)
{
  search(time);

  myassert(nextFree<MAXSPLINEKEYS);
  linearSplineKey *key=splineKeyMemory+(nextFree++);
  key->next=cached->next;
  key->prev=cached;
  cached->next->prev=key;
  cached->next=key;
  key->value=value;
  key->time=time;
}


float linearSpline::evaluate(float time)
{
  search(time);

  if(cached==&head)return cached->next->value;
  if(cached->next==&head)return cached->value;

  if(!interpolationEnabled)return cached->value;

  float a=cached->time-time;
  float b=cached->next->time-time;

  //  printf("test\n");

  return (b*cached->value-a*cached->next->value)/(b-a);
}


void linearSpline::print()
{
  return;
  linearSplineKey *i=&head;
  printf("-------------------\n");
  do
    {
      printf("KEY addr:%x next:%x, prev: %x, time: %i, value: %i\n",i,i->next,i->prev,(int)(i->time),(int)(i->value));
      i=i->next;
    }
  while(i!=&head);
  printf("-------------------\n");
}
