/* PLASMA */
/* SoopaDoopa 2001 */

#include "plasma.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "timing.h"

#define TIMING1 0
#define TIMING2 98
#define TIMING3 70 //antal delte ringe


static int128	list[40];

extern unsigned int plasma_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int plasma_vucodeend  __attribute__((section(".vudata")));
extern unsigned int plasma_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int plasma_vudataend  __attribute__((section(".vudata")));
extern unsigned int plasma_vudataend2  __attribute__((section(".vudata")));



extern int128 plasma_e_start,plasma_e_delta,plasma_e_giftag,plasma_e_matrix,plasma_e_seed   __attribute__((section(".vudata")));
extern vec plasma_e_light,plasma_e_lightcolor   __attribute__((section(".vudata")));

static float sss1,sss2,sss3;
static float maxzoom;


static texture *tempscreen;
static texture *screen;
static int iframe;
static float timing;

static int antaldelte;

static fvec ver(float x, float y, float z)
{
  fvec v;
  
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=1.0;
  
  return v;
}

static ivec fac(int x, int y, int z)
{
  ivec v;
  
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=0;
  
  return v;
}

extern int PAL;

void sendhexagon()
{
  static ivec f[13];
  static fvec v[20];
  float a=0.5;
  float b=0.87;
  float c=0.25;
  
  
  v[0]=ver(1.0,0,c);
  v[1]=ver(a,b,c);
  v[2]=ver(-a,b,c);
  v[3]=ver(-1.0,0,c);
  v[4]=ver(-a,-b,c);
  v[5]=ver(a,-b,c);
  v[6]=ver(1.0,0,-c);
  v[7]=ver(a,b,-c);
  v[8]=ver(-a,b,-c);
  v[9]=ver(-1.0,0,-c);
  v[10]=ver(-a,-b,-c);
  v[11]=ver(a,-b,-c);

  float scalenor=0.5;
  b*=scalenor;
  a*=scalenor;
  
  v[12]=ver(0,0,1);
  v[13]=ver(b,a,0);
  v[14]=ver(0,1*scalenor,0);
  v[15]=ver(-b,a,0);
  v[16]=ver(-b,-a,0);
  v[17]=ver(0,-1*scalenor,0);
  v[18]=ver(b,-a,0);
  v[19]=ver(0,0,-1);
  
  f[0]=fac(3,4,12);
  f[1]=fac(2,5,12);
  f[2]=fac(1,0,12);
  f[3]=fac(0,6,13);
  f[4]=fac(1,7,13);
  f[5]=fac(2,8,14);
  f[6]=fac(3,9,15);
  f[7]=fac(4,10,16);
  f[8]=fac(5,11,17);
  f[9]=fac(0,6,18);
  f[10]=fac(6,7,19);
  f[11]=fac(11,8,19);
  f[12]=fac(10,9,19);
  
  dma01_beginp();
  vif_stcycl(0x101);
  vif_stmask(0);
  vif_unpack(20,20);
  dma01_endp();
  
  dma01_ref(&v,(&v[20]));
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_unpack(13,50);
  dma01_endp();
  
  dma01_ref(&f,&(f[13]));

  plasma_e_giftag.hi=0x551;
  plasma_e_giftag.lo=0x300240000000800d;
}

void setupvif()
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_mpg(((char*)&plasma_vucodeend-(char*)&plasma_vucodebegin)>>3,0);
  dma01_endp();
  
  dma01_ref(&plasma_vucodebegin,&plasma_vucodeend);
  
  sendhexagon();
  
  dma01_beginp();
  vif_stcycl(0x101);
  vif_stmask(0);
  vif_unpack(((char*)&plasma_vudataend-(char*)&plasma_vudatabegin)>>4,0);
  dma01_endp();
  
  dma01_ref(&plasma_vudatabegin,&plasma_vudataend);
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gPRMODECONT(1);				// refer to prim attributes
    gCOLCLAMP(1);
    gDTHE(0);				// Dither off
    gTEST_1(0x70000);
    gALPHA_1(0x8000000068);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}


static float timingRotate;
static float timingScale;

static float tunnelrotate1(float pos)
{
	return 0.04*sin(2*cos(0.07*pos))+0.04*sin(0.003*pos)*sin(0.1*pos);
}

static float tunnelrotate2(float pos)
{
	return 0.04*cos(2*sin(0.06*pos))-0.04*cos(0.003*pos)*sin(0.09*pos);;//0.05*cos(0.1*0.9*pos)+0.03*sin(0.1*1.5*pos);
}

static fvec tunnelcol(float pos)
{
  fvec col;
  
  col.x=0.4+0.1*cos(0.2*pos);	//red
  col.y=0.4+0.0*cos(0.2*pos);	//green
  col.z=0.4+0.1*cos(3+0.2*pos);	//blue
  
  return col;
}

void	rotatematrixzf2(fmatrix *m, float c, float s)
{
  float t;
  
  t=m->xu;
  m->xu=t*c-m->yu*s;
  m->yu=t*s+m->yu*c;
  
  t=m->xv;
  m->xv=t*c-m->yv*s;
  m->yv=t*s+m->yv*c;
  
  t=m->xw;
  m->xw=t*c-m->yw*s;
  m->yw=t*s+m->yw*c;
  
  t=m->xx;
  m->xx=t*c-m->yy*s;
  m->yy=t*s+m->yy*c;
}

static void rotcam(float a, float b, float *newx, float *newy)
{
  static float oldx=1,oldy;
  
  float x=a*oldx+b*oldy;
  float y=-a*oldy+b*oldx;
  
  float s=1;
  x*=s;
  y*=s;
  
  float c;
  float k=1/4.0;
  
  
  if(y<-k)c=-k;
  else if(y>k)c=k;
  else c=k*sin(0.5*3.1415927/k*y);
  
  float Y=-x*c+y*sqrt(x*x+y*y-c*c);
  float X=y*c+x*sqrt(x*x+y*y-c*c);
  
  
  float temp=X*oldx-Y*oldy;
  oldy=X*oldy+Y*oldx;
  oldx=temp;
  
  float l=sqrt(oldx*oldx+oldy*oldy);
  
  *newx=oldx=oldx/l;
  *newy=oldy=oldy/l;
}


static void tunnelsingleframe(float frames, float pos)
{
  static float angle;
  int x,y;
  float s;
  fmatrix M;
  gif_env;
  float posrel;
  int posint;
  
  frames*=0.10;
  pos*=0.10;

  posint=(int)(pos);
  posint&=-1;
  posrel=pos-posint;
  
  angle=0.005*3*4*frames;
  
  {
    resetmatrixf(&M);
    scalematrixf(&M,37,37,17);
    rotatematrixyf(&M,3.1415/2);
    scalematrixf(&M,2,1,1);
    {
      float s,c,l;
			
      s=tunnelrotate2(pos-1);
      c=-tunnelrotate1(pos-1);
      l=sqrt(s*s+c*c);
      s/=l;
      c/=l;
    }
    scalematrixf(&M,1,320.0/256,1);
    movematrixf(&M,0,0,500);
    screenmatrixf(&M,640*16,256*16,32000,32000);
    scalematrixf(&M,100,100,100);
    
    //hvis posrel er 0 sker ingenting
    //hvis posrel er 1 rykkes der 1 takker tilbage
    frotatematrixyf(&M,-posrel*(posrel*tunnelrotate2(pos-1)+(1-posrel)*tunnelrotate2(pos)));
    frotatematrixzf(&M,-posrel*(posrel*tunnelrotate1(pos-1)+(1-posrel)*tunnelrotate1(pos)));
    fmovematrixf(&M,2*posrel,0,0);
  }

  
  float modifierscale=0.7*timing::get(98);
  
  for(x=0;x<50;x++)
    {
      if((((unsigned int)(x+posint)*19)%51)>=antaldelte)
	{
	  s=0.2+(x-posrel+1)*0.014;
	  
	  fvec col=tunnelcol(x+posint);
	  
	  fmovematrixf(&M,-2,0,0);
	  frotatematrixzf(&M,tunnelrotate1(x+posint));
	  frotatematrixyf(&M,tunnelrotate2(x+posint));
	  
	
	  {
	    // upload lightvector
	    vec light;
	    s*=7900;
	    light.fv.x=0;
	    light.fv.y=0;
	    light.fv.z=-7/sqrt(s)/16.0;
	    
	    dma01_beginp();
	    vif_flushe();
	    vif_nop();
	    vif_base(0);
	    vif_offset(5);
	    vif_stcycl(0x101);
	    vif_stmask(0);
	    vif_unpack(1,10);
	    vif_128(*((int128*)&light));
	    
	    dma01_endp();
	  }
	
	  dma01_beginp();
	  vif_nop();
	  vif_nop();
	  
	  for(y=0;y<20;y++)
	    {
	      fmatrix *m;
	      
	      vif_nop();
	      vif_unpack(5,0+0x8000);
	      m=(fmatrix*)dma01_currentpos;
	      vif_128(((int128*)&M)[0]);
	      vif_128(((int128*)&M)[1]);
	      vif_128(((int128*)&M)[2]);
	      vif_128(((int128*)&M)[3]);
	      
	      frotatematrixxf(m,((int)(y*1.5)+1.5*((x+posint)&1))*2*3.1415/30);
	      fmovematrixf(m,0,0,10+timingScale);
	      
	      frotatematrixyf(m,frames*0.05+0.5*(x+posint)+(y/30.0*2*3.14)+timingRotate);
	      
	      vif_128(*((int128*)&col));
	      
	      vif_mscal(0x0);
	      vif_nop();
	    }
	  vif_nop();
	  vif_nop();
	  dma01_endp();
	}
      else
	{
	  s=0.2+(x-posrel+1)*0.014;
	  float vz,vy;
	  
	  fvec col=tunnelcol(x+posint);
	  
	  fmatrix MB=M;
	  
	  fmovematrixf(&M,-2,0,0);
	  frotatematrixzf(&M,vz=tunnelrotate1(x+posint));
	  frotatematrixyf(&M,vy=tunnelrotate2(x+posint));
	  
	
	  {
	    // upload lightvector
	    vec light;
	    s*=7900/9;
	    light.fv.x=0;
	    light.fv.y=0;
	    light.fv.z=-7/sqrt(s)/16.0;
	    
	    dma01_beginp();
	    vif_flushe();
	    vif_nop();
	    vif_base(0);
	    vif_offset(5);
	    vif_stcycl(0x101);
	    vif_stmask(0);
	    vif_unpack(1,10);
	    vif_128(*((int128*)&light));
	    
	    dma01_endp();
	  }
	  
	  fscalematrixf(&MB,0.333,0.333,0.333);	
	  for(int i=0;i<3;i++)
	    {
	      fmovematrixf(&MB,-2,0,0);
	      frotatematrixzf(&MB,vz*0.33333f);
	      frotatematrixyf(&MB,vy*0.33333f);
	      
	      dma01_beginp();
	      vif_nop();
	      vif_nop();
		
	      for(y=0;y<60;y++)
		{
		  fmatrix *m;
		  
		  vif_nop();
		  vif_unpack(5,0+0x8000);
		  m=(fmatrix*)dma01_currentpos;
		  vif_128(((int128*)&MB)[0]);
		  vif_128(((int128*)&MB)[1]);
		  vif_128(((int128*)&MB)[2]);
		  vif_128(((int128*)&MB)[3]);
		  
		  
		  float modifier1=sin2(3*(y/60.0f)*(2*3.1415f))+0.5;
		  float modifier2=cos2(3*(y/60.0f)*(2*3.1415f));
		  
		  frotatematrixxf(m,((int)(y*1.5)+1.5*(((x+posint)*3+i)&1))*0.3333*2*3.1415/30);
		  //					fmovematrixf(m,0,0,10*3);
		  //faster:
		  {
		    float z=30.0f+modifierscale*modifier1*12+timingScale;
		    m->xx+=z*m->xw;
		    m->yy+=z*m->yw;
		    m->zz+=z*m->zw;
		  }
		  
		  frotatematrixyf(m,modifierscale*modifier2+frames*0.05+0.3333*0.5*((x+posint)*3+i)+(y/60.0*2*3.14));
		  vif_128(*((int128*)&col));
		  
		  vif_mscal(0x0);
		  vif_nop();
		}
	      vif_nop();
	      vif_nop();
	      dma01_endp();
	    }
	}
    }
}

static void setcurrent(texture *screen, int interlace)
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  vif_direct_end_(screen->dmalistframe1(interlace,(int128*)dma01_currentpos));
  dma01_endp();
}

static void mixscreen(texture *source, int alpha)
{
  gif_env;

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  gif_tag(0xe,1,0,0,0);
  
  gCLAMP_1(0);
  gALPHA_1(0x0000000064+(((int64)alpha)<<32));
  gTEX0_1(source->TEX0());
  gTEX1_1(0);//1<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPABE(0);
  
  gRGBAQ(0x3F80000000000000+0x40808080);
  gUV(0);
  gXYZ2(hhw(32000,32000));
  gUV(hhw(640*16,256*16));
  gXYZ2(hhw(32000+640*16,32000+256*16));
  
  gif_endfinal();
  vif_direct_end();
  dma01_endp();
}


static void clearscreen()
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gTEST_1(0x30000);
    gPRIM(6);
    gRGBAQ(0x3F80000000000000);		// Background RGBA
    gXYZ2(hhw(32000+0*16,32000));
    gXYZ2(hhw(32000+16*640,32000+16*256));
    gTEST_1(0x70000);
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endp();
}

static int testtest;

void tunnel(float pos)
{
  static float frames;
  static float oldframes;
  static float oldpos;
  
  int subframes=5;//5;
  
  timingRotate+=0.5*timing::get(3);
  timingScale=1.5*timing::get(1);
  
  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval2(11)>0)
      {
	testtest++;
      }
    oldTime11=timing::gettime(11);
  }
  
  if(antaldelte!=0)antaldelte++;
  if(testtest>8)antaldelte++;

  if(antaldelte!=0)subframes=1;	
  
  frames+=10;

  frames+=20*timing::get(TIMING1);//timing;

  
  static float oldTimingRotate;
  static float oldTimingScale;
  
  float deltaTimingRotate=timingRotate-oldTimingRotate;
  float deltaTimingScale=timingScale-oldTimingScale;
  
  deltaTimingRotate/=subframes;
  deltaTimingScale/=subframes;
  timingRotate=oldTimingRotate;
  timingScale=oldTimingScale;
  
  gif_env;
  if(frames>10)
    {
      setupvif();
      
      for(int t=0;t<subframes;t++)
	{
	  setcurrent(tempscreen,1-iframe);
	  clearscreen();
	  tunnelsingleframe(frames*((float)t/subframes)+oldframes*(1-(float)t/subframes)
			    ,pos*((float)t/subframes)+oldpos*(1-(float)t/subframes));
	  setcurrent(screen,0);
	  mixscreen(tempscreen,(int)(128.0/(t+1.0)));
	  
	  timingRotate+=deltaTimingRotate;
	  timingScale+=deltaTimingScale;
	}
      dma01_endchain();
    }
  oldframes=frames;
  oldpos=pos;
  
  oldTimingScale=timingScale;
  oldTimingRotate=timingRotate;
  
  setbgcolor(RGB(255,255,255));
  dma01_wait();
  setbgcolor(RGB(0,255,255));
}

void plasma_init()
{
}

void plasma_init2()
{
}

void plasma_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_, float timing_)
{
  static float extra;
  extra+=5*timing::get(TIMING2);
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  timing=timing_;
  
  return tunnel(frames*3+5*20*sin(frames/200)+extra);
}

void plasma_deinit()
{
}
