//---------------------------------------------------------------------------
// Sound decruncher using PSX VAG-Packer by bITmASTER and Ogg Vorbis library
//---------------------------------------------------------------------------

#include <kernel.h>
#include "math.h"
#include "oggvorbisuse.h"
#include "oggvorbis/vorbis/codec.h"

static ogg_int16_t convbuffer[4096]; /* take 8k out of the data segment, not the stack */
static int convsize=4096;

extern void _VDBG_dump(void);

static void find_predict( short *samples, double *d_samples, int *predict_nr, int *shift_factor, double *_s_1, double *_s_2 );

static void pack( double *d_samples, short *four_bit, int predict_nr, int shift_factor, double *s_1, double *s_2 );

static int writeIndex;
static int writeIndexModulo;
static int numberOfBytesWritten;

static int myread(char **source, char **sourceEnd, char *buffer, int n)
{
  int i;
  int bytesLeft=*sourceEnd-*source;
  
  int ret;

  if(bytesLeft<n)ret=bytesLeft;
  else ret=n;

  for(i=0;i<ret;i++)buffer[i]=(*source)[i];

  *source+=ret;

  return ret;
}

/*static void mywriteold(char *source, int a, int b, char **dest)
{
  int t;
  for(t=0;t<a*b;t++)
    {
      //      if((t&1)==0)printf("mywrite:%x (%x)\n",((unsigned short*)source)[t/2],(*dest)+t);
      (*dest)[t]=source[t];
    }
  (*dest)+=a*b;
}
*/

static unsigned char tempBuffer[28*2*2];
static short rawBufferLeft[28];
static short rawBufferRight[28];
static int tempBufferIndex;

static void callVagPack(short *rawBuffer, char **dest, double *static0, double *static1, double *static2, double *static3)
{
  int flags=0;
  double d_samples[28];
  int predict_nr;
  int shift_factor;
  short four_bit[28];
  unsigned char d;
  int k;
  find_predict( rawBuffer, d_samples, &predict_nr, &shift_factor, static0, static1 );
  pack( d_samples, four_bit, predict_nr, shift_factor, static2, static3 );
  d = ( predict_nr << 4 ) | shift_factor;
  *((*dest)++)=d;
  //    fputc( d, vag );
  *((*dest)++)=flags;
  // fputc( flags, vag );
  for ( k = 0; k < 28; k += 2 ) {
    d = ( ( four_bit[k+1] >> 8 ) & 0xf0 ) | ( ( four_bit[k] >> 12 ) & 0xf );
    *((*dest)++)=d;
    //fputc( d, vag );
  }
}


static double left_s_1;
static double left_s_2;
static double left__s_1;
static double left__s_2;
static double right_s_1;
static double right_s_2;
static double right__s_1;
static double right__s_2;

static int mywrite(char *source, int a, int b, char **destLeft, char *destLeftEnd, char **destRight)
{
  int i;
  for(i=0;i<a*b;i++)
    {
      tempBuffer[tempBufferIndex++]=source[i];
      if(tempBufferIndex==28*2*2)
	{
	  if((*destLeft)+128<destLeftEnd)
	    {
	      int j;
	      for(j=0;j<28;j++)
		{
		  rawBufferRight[j]=256*(int)(tempBuffer[j*2*2+1])+tempBuffer[j*2*2+0]; //little endian
		  rawBufferLeft[j]=256*(int)(tempBuffer[j*2*2+3])+tempBuffer[j*2*2+2]; //little endian
		  //	      rawBufferRight[j]=256*(int)(tempBuffer[j*2*2+0])+tempBuffer[j*2*2+1]; //big endian
		  //	      rawBufferLeft[j]=256*(int)(tempBuffer[j*2*2+2])+tempBuffer[j*2*2+3]; //big endian
		}
	      {
		char *destLeftLocal=(*destLeft)+(writeIndex%writeIndexModulo);
		char *destRightLocal=(*destRight)+(writeIndex%writeIndexModulo);
		callVagPack(rawBufferLeft,&destLeftLocal,&left_s_1,&left_s_2,&left__s_1,&left__s_2);
		callVagPack(rawBufferRight,&destRightLocal,&right_s_1,&right_s_2,&right__s_1,&right__s_2);
		
		writeIndex+=16;
		numberOfBytesWritten+=16;
		tempBufferIndex=0;
	      }
	    }
	  else
	    {
	      return 0;
	    }
	}
    }
  return 1;
}

static int packetLength;

static   ogg_sync_state   oy; /* sync and verify incoming physical bitstream */
static   ogg_stream_state os; /* take physical pages, weld into a logical
			  stream of packets */
static  ogg_page         og; /* one Ogg bitstream page.  Vorbis packets are inside */
static  ogg_packet       op; /* one raw packet of data for decode */
  
static  vorbis_info      vi; /* struct that stores all the static vorbis bitstream
			  settings */
static  vorbis_comment   vc; /* struct that stores all the bitstream user comments */
static  vorbis_dsp_state vd; /* central working state for the packet->PCM decoder */
static  vorbis_block     vb; /* local working space for packet->PCM decode */
  
static  char *buffer;
static  int  bytes;


static char *source;
static char *sourceEnd;
char *destLeft;
char *destLeftEnd;
char *destRight;

static  int eos;
static  int i;

int oggVorbisUseGetNumberOfBytesWrittenInEachChannel()
{
  return numberOfBytesWritten;
}

int oggVorbisUseDecodeInit(char *source_, char *sourceEnd_, char *destLeft_, char *destLeftEnd_, char *destRight_, int packetLength_)
{//returns 0 on error

  printf("OggVorbis decoder running\n");

  writeIndex=0;
  numberOfBytesWritten=0;
  writeIndexModulo=destLeftEnd_-destLeft_;

  source=source_;
  sourceEnd=sourceEnd_;
  destLeft=destLeft_;
  destLeftEnd=destLeftEnd_;
  destRight=destRight_;
  packetLength=packetLength_;

  left_s_1=left_s_2=left__s_1=left__s_2=0;
  right_s_1=right_s_2=right__s_1=right__s_2=0;


  /********** Decode setup ************/

  ogg_sync_init(&oy); /* Now we can read pages */
  

  //  while(1){ /* we repeat if the bitstream is chained */
    eos=0;

    /* grab some data at the head of the stream.  We want the first page
       (which is guaranteed to be small and only contain the Vorbis
       stream initial header) We need the first page to get the stream
       serialno. */

    /* submit a 4k block to libvorbis' Ogg layer */
    buffer=ogg_sync_buffer(&oy,4096);
    //    bytes=fread(buffer,1,4096,stdin);
    bytes=myread(&source,&sourceEnd,buffer,4096);
    ogg_sync_wrote(&oy,bytes);
    
    /* Get the first page. */
    if(ogg_sync_pageout(&oy,&og)!=1){
      /* have we simply run out of data?  If so, we're done. */
      if(bytes<4096)
	{
	  printf("breaking\n");
	  return 0;//goto breakbreak;
	} 
      /* error case.  Must not be Vorbis data */
      printf("Input does not appear to be an Ogg bitstream.\n");
      exit(1);
    }
  
    /* Get the serial number and set up the rest of decode. */
    /* serialno first; use it to set up a logical stream */
    ogg_stream_init(&os,ogg_page_serialno(&og));
    
    /* extract the initial header from the first page and verify that the
       Ogg bitstream is in fact Vorbis data */
    
    /* I handle the initial header first instead of just having the code
       read all three Vorbis headers at once because reading the initial
       header is an easy way to identify a Vorbis bitstream and it's
       useful to see that functionality seperated out. */
    
    vorbis_info_init(&vi);
    vorbis_comment_init(&vc);
    if(ogg_stream_pagein(&os,&og)<0){ 
      /* error; stream version mismatch perhaps */
     printf("Error reading first page of Ogg bitstream data.\n");
      exit(1);
    }
    
    if(ogg_stream_packetout(&os,&op)!=1){ 
      /* no page? must not be vorbis */
      printf("Error reading initial header packet.\n");
      exit(1);
    }
    
    if(vorbis_synthesis_headerin(&vi,&vc,&op)<0){ 
      /* error case; not a vorbis header */
      printf("This Ogg bitstream does not contain Vorbis "
	      "audio data.\n");
      exit(1);
    }
    
    /* At this point, we're sure we're Vorbis.  We've set up the logical
       (Ogg) bitstream decoder.  Get the comment and codebook headers and
       set up the Vorbis decoder */
    
    /* The next two packets in order are the comment and codebook headers.
       They're likely large and may span multiple pages.  Thus we reead
       and submit data until we get our two pacakets, watching that no
       pages are missing.  If a page is missing, error out; losing a
       header page is the only place where missing data is fatal. */
    
    i=0;
    while(i<2){
      while(i<2){
	int result=ogg_sync_pageout(&oy,&og);
	if(result==0)break; /* Need more data */
	/* Don't complain about missing or corrupt data yet.  We'll
	   catch it at the packet output phase */
	if(result==1){
	  ogg_stream_pagein(&os,&og); /* we can ignore any errors here
					 as they'll also become apparent
					 at packetout */
	  while(i<2){
	    result=ogg_stream_packetout(&os,&op);
	    if(result==0)break;
	    if(result<0){
	      /* Uh oh; data at some point was corrupted or missing!
		 We can't tolerate that in a header.  Die. */
	      printf("Corrupt secondary header.  Exiting.\n");
	      exit(1);
	    }
	    vorbis_synthesis_headerin(&vi,&vc,&op);
	    i++;
	  }
	}
      }
      /* no harm in not checking before adding more */
      buffer=ogg_sync_buffer(&oy,4096);
      //      bytes=fread(buffer,1,4096,stdin);
    bytes=myread(&source,&sourceEnd,buffer,4096);
      if(bytes==0 && i<2){
	printf("End of file before finding all Vorbis headers!\n");
	exit(1);
      }
      ogg_sync_wrote(&oy,bytes);
    }
    
    /* Throw the comments plus a few lines about the bitstream we're
       decoding */
    {
      char **ptr=vc.user_comments;
      while(*ptr){
	printf("%s\n",*ptr);
	++ptr;
      }
      printf("\nBitstream is %d channel, %ldHz\n",vi.channels,vi.rate);
      printf("Encoded by: %s\n\n",vc.vendor);
    }
    
    convsize=4096/vi.channels;

    /* OK, got and parsed all three headers. Initialize the Vorbis
       packet->PCM decoder. */
    vorbis_synthesis_init(&vd,&vi); /* central decode state */
    vorbis_block_init(&vd,&vb);     /* local state for most of the decode
				       so multiple block decodes can
				       proceed in parallel.  We could init
				       multiple vorbis_block structures
				       for vd here */
    return 1;
}


int oggVorbisUseDecodePacket() //returns 0 if done
{
  if(eos)return 0;
  while(!eos){
    int result=ogg_sync_pageout(&oy,&og);
    //static int test;
    //    if((test++&255)==0)printf("loop\n");
    if(result==0)break; /* need more data */
    if(result<0){ /* missing or corrupt data at this page position */
      printf("Corrupt or missing data in bitstream; "
	     "continuing...\n");
    }else{
      ogg_stream_pagein(&os,&og); /* can safely ignore errors at
				     this point */
      while(1){
	result=ogg_stream_packetout(&os,&op);

	if(result==0)break; /* need more data */
	if(result<0){ /* missing or corrupt data at this page position */
	  /* no reason to complain; already complained above */
	}else{
	  /* we have a packet.  Decode it */
	  float **pcm;
	  int samples;
	      
	  if(vorbis_synthesis(&vb,&op)==0) /* test for success! */
	    vorbis_synthesis_blockin(&vd,&vb);
	  /* 
	  **pcm is a multichannel float vector.  In stereo, for
	  example, pcm[0] is left, and pcm[1] is right.  samples is
	  the size of each channel.  Convert the float values
	  (-1.<=range<=1.) to whatever PCM format and write it out */
	      
	  while((samples=vorbis_synthesis_pcmout(&vd,&pcm))>0){
	    int j;
	    int clipflag=0;
	    int bout=(samples<convsize?samples:convsize);
		
	    /* convert floats to 16 bit signed ints (host order) and
	       interleave */
	    for(i=0;i<vi.channels;i++){
	      ogg_int16_t *ptr=convbuffer+i;
	      float  *mono=pcm[i];
	      for(j=0;j<bout;j++){
#if 1
		int val=mono[j]*32767.f;
#else /* optional dither */
		int val=mono[j]*32767.f+drand48()-0.5f;
#endif
		/* might as well guard against clipping */
		if(val>32767){
		  val=32767;
		  clipflag=1;
		}
		if(val<-32768){
		  val=-32768;
		  clipflag=1;
		}
		*ptr=val;
		ptr+=vi.channels;
	      }
	    }
	    // f(clipflag)printf("Clipping in frame %ld\n",(long)(vd.sequence));
	    if(0==mywrite((char*)convbuffer,2*vi.channels,bout,&destLeft,destLeftEnd,&destRight))
	      {
		printf("done done doneee\n");
		eos=1; //make sure that we do nothing in the next call of this routine
		return 0;
	      }
	    vorbis_synthesis_read(&vd,bout); /* tell libvorbis how many samples we actually consumed */
	  }	    
	}
      }
      if(ogg_page_eos(&og))eos=1;
    }
  }
  if(!eos){
    buffer=ogg_sync_buffer(&oy,packetLength);
    bytes=myread(&source,&sourceEnd,buffer,packetLength);
    ogg_sync_wrote(&oy,bytes);
    if(bytes==0)eos=1;
  }
  return 1;
}

int oggVorbisUseDecodeDeinit()
{
      /* clean up this logical bitstream; before exit we see if we're
	 followed by another [chained] */
      
      ogg_stream_clear(&os);
      
      /* ogg_page and ogg_packet structs always point to storage in
	 libvorbis.  They're never freed or manipulated directly */
      
      vorbis_block_clear(&vb);
      vorbis_dsp_clear(&vd);
      vorbis_comment_clear(&vc);
      vorbis_info_clear(&vi);  /* must be called last */

  /* OK, clean up the framer */
  ogg_sync_clear(&oy);

  return 1;
}

int oggVorbisUseDecode(char *source_, char *sourceEnd_, char *destLeft_, char *destLeftEnd_, char *destRight_)
{
  // example using DecodeInit, DecodePacket and DecodeDeinit

  if(!oggVorbisUseDecodeInit(source_,sourceEnd_,destLeft_,destLeftEnd_,destRight_,512))return 0;
  //  printf("entering main decoding loop\n");
  while((oggVorbisUseDecodePacket()));
  oggVorbisUseDecodeDeinit();
  printf("Done.\n");
  return 1;
}


/*

    PSX VAG-Packer, hacked by bITmASTER@bigfoot.com

    v0.1                              

*/

static double f[5][2] = { { 0.0, 0.0 },
                            {  -60.0 / 64.0, 0.0 },
                            { -115.0 / 64.0, 52.0 / 64.0 },
                            {  -98.0 / 64.0, 55.0 / 64.0 },
                            { -122.0 / 64.0, 60.0 / 64.0 } };


void find_predict( short *samples, double *d_samples, int *predict_nr, int *shift_factor, double *_s_1, double *_s_2 )
{
    int i, j;
    double buffer[28][5];
    double min = 1e10;
    double max[5];
    double ds;
    int min2;
    int shift_mask;
    //    static double _s_1 = 0.0;                            // s[t-1]
    //    static double _s_2 = 0.0;                            // s[t-2]
    double s_0, s_1, s_2;

    for ( i = 0; i < 5; i++ ) {
        max[i] = 0.0;
        s_1 = *_s_1;
        s_2 = *_s_2;
        for ( j = 0; j < 28; j ++ ) {
            s_0 = (double) samples[j];                      // s[t-0]
            if ( s_0 > 30719.0 )
                s_0 = 30719.0;
            if ( s_0 < - 30720.0 )
                s_0 = -30720.0;
            ds = s_0 + s_1 * f[i][0] + s_2 * f[i][1];
            buffer[j][i] = ds;
            if ( fabs( ds ) > max[i] )
                max[i] = fabs( ds );
//                printf( "%+5.2f\n", s2 );
                s_2 = s_1;                                  // new s[t-2]
                s_1 = s_0;                                  // new s[t-1]
        }
        
        if ( max[i] < min ) {
            min = max[i];
            *predict_nr = i;
        }
        if ( min <= 7 ) {
            *predict_nr = 0;
            break;
        }
        
    }

// store s[t-2] and s[t-1] in a static variable
// these than used in the next function call

    *_s_1 = s_1;
    *_s_2 = s_2;
    
    for ( i = 0; i < 28; i++ )
        d_samples[i] = buffer[i][*predict_nr];

//  if ( min > 32767.0 )
//      min = 32767.0;
        
    min2 = ( int ) min;
    shift_mask = 0x4000;
    *shift_factor = 0;
    
    while( *shift_factor < 12 ) {
        if ( shift_mask  & ( min2 + ( shift_mask >> 3 ) ) )
            break;
        (*shift_factor)++;
        shift_mask = shift_mask >> 1;
    }
      
}

void pack( double *d_samples, short *four_bit, int predict_nr, int shift_factor, double *s_1, double *s_2)
{
    double ds;
    int di;
    double s_0;
    //    static double s_1 = 0.0;
    //    static double s_2 = 0.0;
    int i;

    for ( i = 0; i < 28; i++ ) {
        s_0 = d_samples[i] + *s_1 * f[predict_nr][0] + *s_2 * f[predict_nr][1];
        ds = s_0 * (double) ( 1 << shift_factor );

        di = ( (int) ds + 0x800 ) & 0xfffff000;

        if ( di > 32767 )
            di = 32767;
        if ( di < -32768 )
            di = -32768;
            
        four_bit[i] = (short) di;

        di = di >> shift_factor;
        *s_2 = *s_1;
        *s_1 = (double) di - s_0;

    }
}

