/* METABALLS */
/* SoopaDoopa 2002 */

#include <kernel.h>
#include "plasma.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "mesh.h"
#include "cubemap.h"
#include "spline.h"
#include "timing.h"

static int128	list[40];

extern char binary_metunnel_start[];
extern char binary_metuntext_start[];
extern char binary_tuncm_UP_start[];
extern char binary_tuncm_DN_start[];
extern char binary_tuncm_LF_start[];
extern char binary_tuncm_RT_start[];
extern char binary_tuncm_FR_start[];
extern char binary_tuncm_BK_start[];

extern unsigned int meta_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int meta_vucodeend  __attribute__((section(".vudata")));
extern unsigned int meta_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int meta_vudataend  __attribute__((section(".vudata")));
extern unsigned int meta_vudataend2  __attribute__((section(".vudata")));
extern unsigned int meta_vucodesync  __attribute__((section(".vudata")));

extern int128 meta_e_start,meta_e_delta,meta_e_giftag,meta_e_giftag2,meta_e_matrix,meta_e_seed   __attribute__((section(".vudata")));
extern vec meta_e_light,meta_e_lightcolor   __attribute__((section(".vudata")));
extern vec meta_e_envvec   __attribute__((section(".vudata")));
extern int meta_e_scroll   __attribute__((section(".vudata")));

static texture *tempscreen;
static texture *screen;
static int iframe;

//extern char binary_phong_start[];
extern char binary_envmap_start[];
extern char binary_metaalpha_start[];
extern char binary_metaalpha_alpha_start[];

static texture tunnelTexture;
static texture tex1;
static texture cubeTex[6];
extern int PAL;

static texture envMapAlpha;
static texture *currentTexture;

static void setupvif()
{
  gif_env;

  meta_e_giftag.hi=0x535353;
  meta_e_giftag.lo=0x6000000000008001+GTP(PRIMtexture+PRIMcontext2+PRIMuv+PRIMtrianglestrip);
  meta_e_giftag2.hi=0x535353535353;
  meta_e_giftag2.lo=0x8000000000008001+GTP(PRIMtexture+PRIMcontext2+PRIMuv+PRIMtrianglestrip);

  dma01_beginp();
  vif_offset(0);
  vif_base(0);
  vif_nop();
  vif_nop();

  vif_flush();
  vif_flusha();
  vif_nop();
  vif_flushe();
  dma01_endp();

  uploadvucode(&meta_vucodebegin,&meta_vucodeend);

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_mscalf(1);
  dma01_endp();

  if(0)
    {
      static int128 l[1024];
      dma01_beginp();
      vif_stcycl(0x101);
      vif_stmask(0);
      vif_unpack(1024,0+0x000);
      dma01_endp();
      dma01_ref((l),(l+1024));
    }

  dma01_beginp();
  vif_stcycl(0x101);
  vif_stmask(0);
  vif_unpack(((char*)&meta_vudataend-(char*)&meta_vudatabegin)>>4,0);
  dma01_endp();

  dma01_ref(&meta_vudatabegin,&meta_vudataend);

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();

  {
    gif_tag(0xe,1,0,0x200,0);
    gPRMODECONT(1);
    gCOLCLAMP(1);
    gDTHE(0);
    gTEST_2(0x70000);
    gALPHA_2(0x8000000068);
    gRGBAQ(0x3F80000000ffffff);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}

#define DIMZ 3
#define DIMY 3
#define DIMX 45

#define DIM 16

static float grid[DIMX][DIM][DIM];

static inline float sqrdist(fvec &v, fvec &u)
{
  return (v.x-u.x)*(v.x-u.x)+(v.y-u.y)*(v.y-u.y)+(v.z-u.z)*(v.z-u.z);
}

//#define NBALLS 120
#define NBALLS 40 //45 //(60) //20 //28
#define BRAD 4

fvec ball[NBALLS];
fvec ball_vel[NBALLS];
#define max(x,y) (x)>(y)?(x):(y)
#define min(x,y) (x)<(y)?(x):(y)

static int fillgrid2(float *grid, int x, int starty, int startz, int endy, int endz)
{
  static int nz2;
  setbgcolor(0xffff);

  float *g=grid;
  int nz=0;

  for(int z=startz;z<endz;z++)
    for(int y=starty;y<endy;y++)
      {
	float r=-0.5;
	*(grid++)=r;
      }


  int nballs=PAL?NBALLS:NBALLS-10;
  for(int t=0;t<nballs;t++)
    {
      if(((ball[t].x-x)*(ball[t].x-x))<(BRAD*BRAD))
	{
	  float localBRAD=sqrt((BRAD*BRAD)-(ball[t].x-x)*(ball[t].x-x));	
	  int ballmin=(int)(ball[t].z-localBRAD);
	  int startz2=max(startz,ballmin);
	  int endz2=min(endz,((int)(ball[t].z+localBRAD+1)));
	  int starty2=max(starty,((int)(ball[t].y-localBRAD)));
	  int endy2=min(endy,((int)(ball[t].y+localBRAD+1)));
	
	  fvec p=fvec_(x,0,0);

	  for(int z=startz2;z<endz2;z++)
	    {
	      p.z=z;
	      float sd=(ball[t].x-p.x)*(ball[t].x-p.x)+(ball[t].z-p.z)*(ball[t].z-p.z);
	      float bt=ball[t].y-starty2;
	      float sd2=(BRAD*BRAD)-sd;
	      for(int y=starty2;y<endy2;y++)
		{
		  float v;
		  v=bt*bt;
		  bt--;
		  if(v<sd2)
		    {
		      v+=sd;
		      v*=1.0f/(BRAD*BRAD);
		      g[DIM*(z-startz)+y-starty]+=(v-1)*(v-1);
		      nz=1;
		    }
		}
	    }
	}
    }
  nz2=((nz2+nz2)+nz)&15;

  setbgcolor(0x0);
  return nz2&6;
}

void meta_fillgrid()
{
  static float v=0;
  v+=0.03*3.02;

  if(0)
    {
      for(int t=0;t<NBALLS;t++)
	ball[t]=fvec_(5+30*(0.5+0.5*sin(v*(0.4+t*0.04)+t)),5+30*(0.5+0.5*sin(v*(0.3+t*0.05)+t)),5+30*(0.5+0.5*sin(v*(0.5+t*0.03)+t)));
    }
  else
    {
      int t=0;
      //		fvec a=fvec_(5+30*(0.5+0.5*sin(v*(0.4+t*0.04)+t)),5+30*(0.5+0.5*sin(v*(0.3+t*0.05)+t)),5+30*(0.5+0.5*sin(v*(0.5+t*0.03)+t)));
      fvec a[3];
      a[0]=fvec_(10+20*(0.5+0.5*sin(v*(0.4)+t)),10+20*(0.5+0.5*sin(v*(0.3)+t)),10+20*(0.5+0.5*sin(v*(0.5)+t)));
      //a[0]=fvec_(20,5+30*(0.5+0.5*sin(v*200)),20);
      t=2;
      a[1]=fvec_(10+20*(0.5+0.5*sin(v*(0.3)+t)),10+20*(0.5+0.5*sin(v*(0.5)+t)),10+20*(0.5+0.5*sin(v*(0.4)+t)));
      t=4;
      a[2]=fvec_(5+30*(0.5+0.5*sin(v*(0.5)+t)),5+30*(0.5+0.5*sin(v*(0.4)+t)),5+30*(0.5+0.5*sin(v*(0.3)+t)));

      for(t=0;t<NBALLS;t++)
	{

	  for(int i=0;i<2;i++)
	    {
	      fvec d;
	      d.x=a[i].x-ball[t].x;
	      d.y=a[i].y-ball[t].y;
	      d.z=a[i].z-ball[t].z;
			
	      float s=0.003+0.00001;

	      s/=sqrt(d.x*d.x+d.y*d.y+d.z*d.z);

	      d.x*=s;
	      d.y*=s;
	      d.z*=s;

	      ball_vel[t].x+=d.x;
	      ball_vel[t].y+=d.y;
	      ball_vel[t].z+=d.z;
	    }
	  float S=0.9999;
	  ball_vel[t].x*=S;
	  ball_vel[t].y*=S;
	  ball_vel[t].z*=S;
	  ball[t].x+=ball_vel[t].x;
	  ball[t].y+=ball_vel[t].y;
	  ball[t].z+=ball_vel[t].z;

	  ball[t].x=max(5,min(34,ball[t].x));
	  ball[t].y=max(5,min(34,ball[t].y));
	  ball[t].z=max(5,min(34,ball[t].z));
	}
    }
}



static void effect(float frames, float pos, fmatrix *rotationMatrix)
{
  fmatrix M;
  gif_env;
  fvec envvec1,envvec2,envvec3;

  meta_fillgrid();

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();

  {
    gif_tag(0xe,1,0,0x200,0);
    gTEST_2(0x30000);
    gPRIM(6);
    gRGBAQ(0x3F800000000000ff);

    gTEX0_2(currentTexture->TEX0()+((int64)0<<35));
    gTEX1_2(1<<5);

    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();



  fvec uppercorner,stepx,stepy,stepz;

  {
    static float a;
    a+=0.01*3;


    M=*rotationMatrix;
    fmovematrixf(&M,-DIMX/2+2.5,-(DIM*DIMY/2.0-4),-(DIM*DIMZ/2.0-4));
		
    scalematrixf(&M,1.6,1.6,1.6);
    movematrixf(&M,0,0,50);
    scalematrixf(&M,256/320.0,1,1);
    screenmatrixf(&M,640*16,256*16,32000,32000);
		
    uppercorner=fvec_(M.xx,M.yy,M.zz);
    stepx=fvec_(M.xu,M.yu,M.zu);
    stepy=fvec_(M.xv,M.yv,M.zv);
    stepz=fvec_(M.xw,M.yw,M.zw);

    M=*rotationMatrix;

    envvec1=fvec_(M.xu,M.yu,M.zu);
    envvec2=fvec_(M.xv,M.yv,M.zv);
    envvec3=fvec_(M.xw,M.yw,M.zw);
  }
	
  dma01_beginp();
  vif_nop();
  vif_nop();

  static float s;
  s+=0.01;

  for(int Y=0;Y<DIMY;Y++)
    for(int Z=0;Z<DIMZ;Z++)
      for(int x=0;x<DIMX;x++)
	{
	  int notempty;
	  fvec corner=x*stepx+uppercorner+13*Y*stepy+13*Z*stepz;

	  corner=uppercorner+x*stepx;
	  for(int a=0;a<13*Y;a++)corner+=stepy;
	  for(int a=0;a<13*Z;a++)corner+=stepz;

	  vif_mscal(((((char*)&meta_e_scroll)-((char*)&meta_vucodebegin))>>3));
	  vif_nop();
	  vif_nop();
	  //		vif_nop();
	  vif_flushe();


	  {
	    vif_stmask(0x3f3f3f3f);
	    vif_nop();
	    vif_nop();
	    vif_nop();
	    vif_unpack_s32((((DIM*DIM)&255)+(int)0x1000),0+0x8000+600);
			
	    notempty=fillgrid2((float*)dma01_currentpos,x,Y*13,Z*13,Y*13+DIM,Z*13+DIM);
	    dma01_currentpos+=DIM*DIM;
	    vif_nop();
	    vif_nop();
	    vif_stmask(0);
	    vif_nop();
	    vif_nop();
	  }
	  if((x>=3)&&notempty)
	    {
	      vif_nop();
	      vif_unpack(3,0+0x8000+((((char*)&meta_e_envvec)-((char*)&meta_vudatabegin))/16));
	      vif_128(*((int128*)&envvec1));
	      vif_128(*((int128*)&envvec2));
	      vif_128(*((int128*)&envvec3));


	      vif_nop();
	      vif_nop();
	      vif_nop();
	      vif_direct_begin();

	      {
		gif_tag(0xe,1,0,0,0);
		gTEST_2(0x70000);
		gPRIM(0x206);
		if((x)&1)
		  {
		    gRGBAQ(0x3F800000008080c0);
		  }
		else
		  {
		    gRGBAQ(0x3F8000000080c080);
		  }
		gRGBAQ(0x3F80000000808080);
		gif_endfinal();
	      }
	      vif_direct_end();
	      
	      ivec voddeven;
	      voddeven.x=2*((x+Y+Z)&1)-1;

	      vif_nop();
	      vif_nop();
	      vif_nop();
	      vif_unpack(5,0+0x8000+100);
	      vif_128(*((int128*)&corner));
	      vif_128(*((int128*)&stepx));
	      vif_128(*((int128*)&stepy));
	      vif_128(*((int128*)&stepz));
	      vif_128(*((int128*)&voddeven));

	      vif_mscal(0);
	      vif_nop();
	      vif_nop();
	      vif_nop();
	    }
	  vif_nop();
	  vif_flushe();
	}

  dma01_endp();
}

static mesh themesh;

static CubeMap cubeMap;

static linearVectorSpline camSpline;
static linearVectorSpline targetSpline;

void meta_init()
{
  envMapAlpha.init();
  envMapAlpha.load(binary_metaalpha_start);
  envMapAlpha.loadalpha(binary_metaalpha_alpha_start);



  tex1.init();
  tex1.load(binary_envmap_start);
  
  themesh.tetrahedron();
  themesh.load(binary_metunnel_start,"Line02",1,1);
  
  tunnelTexture.init();
  tunnelTexture.load(binary_metuntext_start);
  
  
  for(int i=0;i<6;i++)cubeTex[i].init();
  cubeTex[0].load(binary_tuncm_UP_start);
  cubeTex[1].load(binary_tuncm_DN_start);
  cubeTex[2].load(binary_tuncm_LF_start);
  cubeTex[3].load(binary_tuncm_RT_start);
  cubeTex[4].load(binary_tuncm_FR_start);
  cubeTex[5].load(binary_tuncm_BK_start);
  
  cubeMap.init(10,256,256,&cubeTex[0],&cubeTex[1],&cubeTex[2],&cubeTex[3],&cubeTex[4],&cubeTex[5]);

  camSpline.init();
  targetSpline.init();

  camSpline.addKeyValue(0,fvec_(-30.3645,32.0520,48.1455));
  targetSpline.addKeyValue(0,fvec_(-4.8684,-2.4485,112.6072));
  camSpline.addKeyValue(1,fvec_(-23.8467,-15.6090,23.7149));
  targetSpline.addKeyValue(1,fvec_(1.6494,-6.4895,90.3448));
  camSpline.addKeyValue(2,fvec_(29.2130,27.0526,-19.5955));
  targetSpline.addKeyValue(2,fvec_(11.0058,12.3467,-85.6804));
  camSpline.addKeyValue(3,fvec_(38.0000,2.8771,-21.8598));
  targetSpline.addKeyValue(3,fvec_(0,-89,5));
  camSpline.addKeyValue(4,fvec_(-32.9355,8.7033,-26.2701));
  targetSpline.addKeyValue(4,fvec_(1.6494,2.2997,25.2462));
  camSpline.addKeyValue(5,fvec_(34.7902,-19.5165,-25.2878));
  targetSpline.addKeyValue(5,fvec_(0,-104,10));
  camSpline.addKeyValue(6,fvec_(24.1747,7.4169,35.1215));
  targetSpline.addKeyValue(6,fvec_(-15.4450,1.9296,-72.8832));
  camSpline.addKeyValue(7,fvec_(-32.0462,-21.0285,0.0000));
  targetSpline.addKeyValue(7,fvec_(27,119,5));
  camSpline.addKeyValue(8,fvec_(35.0000,17.3424,-16.7404));
  targetSpline.addKeyValue(8,fvec_(0,59,-8));
  camSpline.addKeyValue(9,fvec_(-39.7518,-9.7467,-0.5049));
  targetSpline.addKeyValue(9,fvec_(0,2,-6));

  camSpline.setInterpolationEnabled(false);
  targetSpline.setInterpolationEnabled(false);
}


void meta_init2()
{
  for(int i=0;i<6;i++)cubeTex[i].allocupload();

  for(int t=0;t<NBALLS;t++)
    {
      ball[t]=fvec_(rand()%20+10,rand()%20+10,rand()%20+10);
      ball_vel[t]=fvec_((rand()%200-100)*0.005f,(rand()%200-100)*0.0051f,(rand()%200-100)*0.005f);
    }

  tunnelTexture.allocclut();
  tunnelTexture.uploadclut();
}
static int splineIndex=-7;

void meta_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_)
{
  static float localFrameCounter;
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;

  localFrameCounter++;
  static float angle;
  angle+=0.01f*10;
  
  // Clear the screen

  screen->setcurrent_vif(1-iframe);
  screen->setcurrent_vif2(1-iframe);
  screen->clear_vif(0xffffff,0);


  // Render tunnel geometry

  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval(11)>0)
      {
	splineIndex++;
      }
    oldTime11=timing::gettime(11);
  }
  {
    static float oldTime10; 
    if(timing::gettime(10)!=oldTime10 && timing::getval(10)>0)
      {
	splineIndex+=7;
      }
    oldTime10=timing::gettime(10);
  }
  splineIndex=((unsigned int)splineIndex)%10;

  fvec target=targetSpline.evaluate(splineIndex+0.01);
  fvec cam=camSpline.evaluate(splineIndex+0.01);

  float temp;
  temp=target.y;target.y=target.z;target.z=temp;
  temp=cam.y;cam.y=cam.z;cam.z=temp;

  static float camOffset;
  {
    static float oldCamYPos;
    if(oldCamYPos!=cam.y)camOffset=0;
    oldCamYPos=cam.y;
    camOffset+=0.1;
  }

  cam+=fvec_(0,camOffset,0);


  fmatrix rotationRelativeToCamera;

  lookatmatrixf(&rotationRelativeToCamera,cam-target,fvec_(0,1,0));

  static float rotateY;
  rotateY+=0.01;

  rotatematrixyf(&rotationRelativeToCamera,(splineIndex&1)?rotateY:-rotateY);

  fmatrix cameraMatrixTunnel=rotationRelativeToCamera;
  fmovematrixf(&cameraMatrixTunnel,cam.x,cam.y,cam.z);

  setupvif();
  tex1.upload_vif(tempscreen->addr);

  screen->setcurrent_vif2(1-iframe);
  screen->setcurrent_vif(1-iframe);
  screen->setcurrent_vif2(1-iframe);

  tunnelTexture.upload_vif(tempscreen->addr);

  tunnelTexture.setSourceContext2_vif();
  setbgcolor(0xff00ff);
  fscalematrixf(&cameraMatrixTunnel,-1,1,1);
  themesh.draw_zclipRel(&cameraMatrixTunnel);
  setbgcolor(0x00ff00);


  // Render cube map at set this to currentTexture

  screen->setcurrent_vif2(1-iframe);
  fmatrix cubeMapRotation=rotationRelativeToCamera;
  frotatematrixxf(&cubeMapRotation,-3.14159*0.5);

  texture *envMap=cubeMap.getEnvMap(tempscreen->addr);
  envMap->image=envMapAlpha.image;
  envMap->upload_vif(envMap->addr);

  currentTexture=cubeMap.computeEnvMap(&cubeMapRotation, tempscreen->addr+0*65536*4);

  // Render the meta balls
  screen->setcurrent_vif2(1-iframe);
  effect(frames,frames,&rotationRelativeToCamera);
  
  // Dummy wait?
  uploadvucode(&meta_vucodebegin,&meta_vucodeend);
  
  dma01_endchain();
}

void meta_deinit()
{
}
