/* Mesh test2 */
/* SoopaDoopa 2002 */


#include "meshtest.h"
#include "main.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "glow.h"
#include "timing.h"
#include "mesh.h"
#include "spline.h"


extern char binary_obj01_start[];
extern char binary_obj03_start[];
extern char binary_obj04_start[];
extern char binary_spik512_start[];
extern char binary_phong_start[];
extern char binary_clipme_start[];

static texture *tempscreen;
static texture *screen;
static int iframe;
static float frames;

static mesh themesh,themesh2;
static texture tex1;
static mesh mesh2,mesh3[2];

static linearSpline objectPosition;

static int localFrames;

void meshtest2_init()
{
  tex1.init();
  tex1.load(binary_clipme_start);
  
  themesh.tetrahedron();
  themesh.load(binary_obj04_start,"Hedra04");
  themesh2.load(binary_obj04_start,"Hedra04");
  
  mesh2.init(themesh.nfac*3*2*2,themesh.nfac*2*2);
  mesh3[0].init(themesh.nfac*3*2*2,themesh.nfac*2*2);
  mesh3[1].init(themesh.nfac*3*2*2,themesh.nfac*2*2);
  
  mesh3[0].vudataalloc(3*1024);
  mesh3[1].vudataalloc(3*1024);
  
  objectPosition.init();
  objectPosition.addKeyValue(0,240);
  objectPosition.addKeyValue(1,0);
  objectPosition.addKeyValue(124,0);
  objectPosition.addKeyValue(125,240);
}

void meshtest2_init2()
{
  tex1.allocclut();
  tex1.uploadclut();
  //	tex1.allocupload();
}

static float v;

float zoffset(float x, float y)
{
  return 40*sin(0.8*x+v*0.7)+40*sin(y-v*0.6)+40*sin((0.5*(x-y))*1.1-v*0.5);
}

void meshtest2_frame(float frames_, texture *screen_, texture *tempscreen_, int iframe_)
{
  static int flip;
  float suboffset;
  static float moveX2;
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  frames=frames_;
  
  localFrames++;

  moveX2+=timing::get(1)/10;
  v+=0.05;
  
  flip=1-flip;
  
  float movex;
  float supoffset;
  movex=suboffset=0.25*v*0.4*6+moveX2;
  suboffset-=(int)(suboffset);
  supoffset=movex-suboffset;
  
  tex1.upload_vif(tempscreen->addr);


  screen->setcurrent_vif(1-iframe);
  screen->clear_vif(0x202030);
  
  {
    fmatrix M;
    fmatrix Mb;
    static float angle;
    static float angle2;
    static float angle3;
    angle+=0.01;
    angle3+=0.012*timing::get(3)+0.001;
    
    {
      fmatrix m;
      
      resetmatrixf(&m);
      rotatematrixxf(&m,angle3*0.4);
      rotatematrixyf(&m,2*angle3*0.8);
      rotatematrixzf(&m,2*angle3*1.4*0.3);
      
      scalematrixf(&m,2,2,2);
      
      transformf(&m,themesh2.vlist,themesh.vlist,themesh2.nvec);
    }
    
    
    angle2+=0.03*timing::get(0);
    {
      gif_env;
      
      resetmatrixf(&M);
      resetmatrixf(&Mb);
      
      
      rotatematrixzf(&M,-0.5);
      rotatematrixxf(&M,-0.8);
      rotatematrixzf(&M,-0.5);
      rotatematrixyf(&M,-0.8);
      
      rotatematrixzf(&Mb,-0.5);
      rotatematrixxf(&Mb,-0.8);
      rotatematrixzf(&Mb,-0.5);
      rotatematrixyf(&Mb,-0.8);
      
      scalematrixf(&M,1,320.0/256,1);
      movematrixf(&M,0,0,2900);
      
      {
	//set fov
	movematrixf(&M,0,0,-1200);
	scalematrixf(&M,0.63,0.63,1);
      }
      
      
      
      screenmatrixf(&M,640*16,256*16,32000,32000);
      scalematrixf(&M,1000,1000,1000);
      fscalematrixf(&M,3,3,3);
      
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_direct_begin();
      
      {
	
	gif_tag(0xe,1,0,0,0);
	gTEX0_1(tex1.TEX0()+((int64)0<<35));
	gTEX1_1(1<<5);				//bilinear
	gTEX0_2(tex1.TEX0()+((int64)0<<35));
	gTEX1_2(1<<5);				//bilinear
	gif_endfinal();
	
      }
      gif_endfinal();
      vif_direct_end();
      
      dma01_endp();
     
      
#define SCALE 100
      
      float offsetx=-50+100*sin(angle*0.5);
      float offsety=+50+100*sin(1.8*angle*0.5)+objectPosition.evaluate(localFrames/50.0f);
      
      mesh3[flip].planeclip(themesh,fvec_(1,0,0,0-offsetx));
      mesh2.planeclip(mesh3[flip],fvec_(-0.5,-sqrt(0.75),0,0.5*offsetx+sqrt(0.75)*offsety));
      mesh3[flip].planeclip(mesh2,fvec_(-0.5,+sqrt(0.75),0,SCALE*sqrt(0.75)+0.5*offsetx-sqrt(0.75)*offsety+0*1000));
      
      mesh3[flip].buildvudata();

      screen->setcurrent_vif2(1-iframe);
      mesh::setupvif();
      
      int maxy=PAL?7:5;

      for(int x=-3;x<7;x++)
	for(int y=-4;y<maxy;y++)
	  {
	    float z[6];
	    float z_=zoffset(x+supoffset,y);
	    z[0]=zoffset(x+supoffset+0.333333333,y+0.33333333);
	    z[1]=zoffset(x+supoffset-0.333333333,y+0.66666666);
	    z[2]=zoffset(x+supoffset-0.666666666,y+0.33333333);
	    z[3]=zoffset(x+supoffset-0.333333333,y-0.33333333);
	    z[4]=zoffset(x+supoffset+0.333333333,y-0.66666666);
	    z[5]=zoffset(x+supoffset+0.666666666,y-0.33333333);
		

	    for(int t=0;t<6;t++)
	      {
		fmatrix M3;
		fmatrix M2=M;
		fmovematrixf(&M2,2*(x-suboffset+0.5)*SCALE*sqrt(0.75),0,0);
		fmovematrixf(&M2,y*SCALE*sqrt(0.75),1.5*y*SCALE,0);


		fmovematrixf(&M2,0,0,-z_);


		M3=Mb;
		frotatematrixzf(&M2,(t>>1)*2*3.141596/3);
		frotatematrixzf(&M3,(t>>1)*2*3.141596/3);

		if((t)&1)
		  {
		    fscalematrixf(&M2,-1,1,1);
		    fscalematrixf(&M3,-1,1,1);
		  }

		fskewmatrixxtozf(&M2,(z[(2*((t+1)>>1))%6]-0.5*z[2*(t>>1)+1]-0.5*z_)/(SCALE*sqrt(0.75)));
		fskewmatrixxtozf(&M3,(z[(2*((t+1)>>1))%6]-0.5*z[2*(t>>1)+1]-0.5*z_)/(SCALE*sqrt(0.75)));
		fskewmatrixytozf(&M2,(z[2*(t>>1)+1]-z_)/SCALE);
		fskewmatrixytozf(&M3,(z[2*(t>>1)+1]-z_)/SCALE);

		fscalematrixf(&M2,1,-1,1);
		fscalematrixf(&M3,1,-1,1);
		fmovematrixf(&M2,-offsetx,-offsety,0);



		if(M2.zz>700*1000)
		  if(M2.xx>(32000-16*200)*M2.zz)
		    if(M2.yy>(32000-16*50)*M2.zz)
		      if(M2.xx<(32000+16*760)*M2.zz)
			mesh3[flip].draw_vu(&M2,&M3);
	      }
	  }
    }
  }



  main_renderBackground(iframe,true);

  dma01_endchain();

  setbgcolor(RGB(255,255,255));
  dma01_wait();
  setbgcolor(RGB(0,255,255));

}

void meshtest2_deinit()
{
}
