/* Mesh test */
/* SoopaDoopa 2002 */


#include "meshtest.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "glow.h"
#include "timing.h"
#include "mesh.h"
#include "spline.h"
#include "main.h"

#define TIMING1 3

extern char binary_obj01_start[];
extern char binary_obj03_start[];
extern char binary_spik512_start[];
extern char binary_phong_start[];

static texture *tempscreen;
static texture *screen;
static int iframe;
static float frames;

static mesh themesh;
static texture tex1;
//static mesh mesh2;

void meshtest_init()
{
  tex1.init();
  tex1.load(binary_spik512_start);
  
  themesh.tetrahedron();
  themesh.load(binary_obj01_start,"Object01",2,2);
}

void meshtest_init2()
{
  tex1.allocclut();
  tex1.uploadclut();
}

void meshtest_frame(float frames_, texture *screen_, texture *tempscreen_, int iframe_)
{
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  frames=frames_;

  tex1.upload_vif(tempscreen->addr);

  screen->setcurrent_vif(1-iframe);
  screen->setcurrent_vif2(1-iframe);
  main_renderBackground(iframe,false);

  {
    fmatrix M;
    static float angle;
    static float angle2;
    angle+=0.01;

    angle2+=0.03*timing::get(0);
    {
      gif_env;
		
      resetmatrixf(&M);

      frotatematrixzf(&M,0.3*sin(angle*0.08));
      frotatematrixxf(&M,0.15*sin(angle*0.07)*cos2(angle*0.4));
      frotatematrixyf(&M,0.13*sin(angle*0.08));
      frotatematrixxf(&M,angle);
      frotatematrixzf(&M,angle2);
      frotatematrixyf(&M,angle*0.4);
      scalematrixf(&M,1,320.0/256,1);
      movematrixf(&M,0,0,1000);
      screenmatrixf(&M,640*16,256*16,32000,32000);
      scalematrixf(&M,100,100,100);
      fscalematrixf(&M,3,3,3);
      fscalematrixf(&M,1-0.5*timing::get(TIMING1),1-0.5*timing::get(TIMING1),1-0.5*timing::get(TIMING1));

      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_direct_begin();

      {

	gif_tag(0xe,1,0,0,0);
	gTEX0_1(tex1.TEX0()+((int64)0<<35));
	gTEX1_1(1<<5);				//bilinear
	gif_endfinal();

      }
      gif_endfinal();
      vif_direct_end();

      dma01_endp();

      themesh.draw(&M);

      glow_copy(screen,tempscreen);
      glow_borrowzbuf(screen);
      glow_copy(tempscreen,&glow_zbuf);

      int forhold=48-(int)(48*timing::get(TIMING1));
      glow_radialblur(&glow_zbuf,tempscreen,320+0*100*cos(frames*0.01*0.8),128+0*50*sin(frames*0.01),sqrt(0.5),6,64-forhold,64+forhold);

      glow_copy(tempscreen,screen);
    }
  }

  dma01_endchain();
}

void meshtest_deinit()
{
}
