#ifndef __MESH_H
#define __MESH_H

#include "types.h"
#include "matrix.h"
#include "texture.h"

class face
{
public:
  face(){};
  face(int a, int b, int c, int col=0){this->a=a;this->b=b;this->c=c;this->col=col;}
  int a,b,c;
  int col;
};

class mesh
{
  int128 *vudata;
 public:
  fvec *vlist;
  face *flist;
  int nvec;
  int nfac;
  void init();
  void init(int nvec, int nfac);
  void tetrahedron();
  void load(char *file, char *objectname, float uscale=1, float vscale=1);
  void draw(fmatrix *m);
  void draw_zclip(fmatrix *m);
  void draw_zclipRel(fmatrix *m, texture *dest=0, bool zteston=true);
  void draw_vu(fmatrix *m, fmatrix *m2=0);
  static void setupvif();
  void planeclip(mesh &source, fvec);
  void vudataalloc(int n);
  void buildvudata();
  void removeFaceList();
};


#endif
