#include "math.h"
#include "myassert.h"

float math_sinetable[MATH_N][4] __attribute__((aligned(16)));

void math_init()
{
  int i;
  float k=(2*pi/MATH_N);
  
  for(i=0;i<MATH_N;i++)
    {
      float a0=i*(2*pi/MATH_N);
      float a1=(i+1)*(2*pi/MATH_N);
      float v0,d0,v1,d1;
		
      v0=sin(a0);
      d0=cos(a0);
      v1=sin(a1);
      d1=cos(a1);

      math_sinetable[i][0]=v0;
      math_sinetable[i][1]=d0;
      math_sinetable[i][2]=(3*(v1-v0)-k*(d1+2*d0))/(k*k);
      math_sinetable[i][3]=(k*(d1+d0)-2*(v1-v0))/(k*k*k);
    }
}

#ifdef __cplusplus
extern "C" {
#endif

static unsigned long int next=1;
int rand()
{
  next=next*1103515245+12345;

  return (next/65536)%32768;
}

// Taylor series
double cos(double v)
{
  float res,w;
  int t;
  float fac;
  int i=(int)((v)/(2*pi));
  v-=i*2*pi;
  
  fac=1;
  res=0;
  w=1;
  for(t=0;t<__my_math_iter;)
    {
      res+=fac*w;
      w*=v*v;
      t++;
      fac/=t;
      t++;
      fac/=t;
      
      res-=fac*w;
      w*=v*v;
      t++;
      fac/=t;
      t++;
      fac/=t;
    }
  return res;
}


double sin(double v)
{
  float res,w;
  int t;
  float fac;
  int i=(int)((v)/(2*pi));
  v-=i*2*pi;
  
  fac=1;
  res=0;
  w=v;
  for(t=1;t<__my_math_iter;)
    {
      res+=fac*w;
      w*=v*v;
      t++;
      fac/=t;
      t++;
      fac/=t;
      
      res-=fac*w;
      w*=v*v;
      t++;
      fac/=t;
      t++;
      fac/=t;
    }
  return res;
}


double fabs(double x)
{
  if(x>=0)return x;
  return -x;
}


int abs(int x)
{
  if(x>=0)return x;
  return -x;
}


long labs(long x)
{
  if(x>=0)return x;
  return -x;
}


float floor(float x)
{
  int a=(int)(x+100000);
  return (int)(a-100000);
}


float ceil(float x)
{
  return -floor(-x);
}


float rint(float x)
{
  return floor(x+0.5);
}


float exp(float x)
{
  int t;
  float r=1;
  float m=1;
  float p=1;

  for(t=1;t<15;t++)
    {
      m/=t;
      p*=x;
      r+=m*p;
    }

  return r;
}


static float atan01(float x)
{
  float t=(x-1)/(x+1);

  float t1=t;
  float t2=t*t;
  float t3=t2*t;
  float t4=t2*t2;
  float t5=t3*t2;
  float t7=t3*t4;
  float t9=t5*t4;
  float t11=t7*t4;
  float t13=t9*t4;
  float t15=t11*t4;

  return
     0.785398195253143
    +0.999999344348907*t1
    -0.333298563957214*t3
    +0.199465364217758*t5
    -0.139085337519646*t7
    +0.096420042216778*t9
    -0.055909886956215*t11
    +0.021861229091883*t13
    -0.004054057877511*t15;
}



static float atan0i(float x)
{
  if(x<1)return atan01(x);
  return 3.141592653*0.5-atan01(1/x);
}

float atan(float x)
{
  tag();
  if(x<0)return -atan0i(-x);
  return atan0i(x);
}


float acos(float x)
{
  float sinus=sqrt(1-x*x);
  if(x>=0)
    return atan(sinus/x);
  return atan(sinus/x)+3.1415926535;
}


float log(float x)
{
  float hi=1000000;
  float lo=-1000000;
  int t;

  for(t=0;t<40;t++)
    {
      float med=(hi+lo)*0.5f;
      if(exp(med)<x)
	lo=med;
      else
	hi=med;
    }
  return hi;
}


float pow(float x, float y)
{
  if(x==0)return 0;
  return exp(y*log(x));
}


float ldexp(float x, int n)
{
  while(n>0)
    {
      x*=2;
      n--;
    }
  while(n<0)
    {
      x*=0.5;
      n++;
    }
  return x;
}


float frexp(float x, int *exp)
{
  *exp=0;
  if(x==0){return 0;}
  while(x>=1 || x<=-1)
    {
      x*=0.5;
      (*exp)++;
    }
  while(x<0.5 && x>-0.5)
    {
      x*=2;
      (*exp)--;
    }
  return x;
}


float atan2(float y, float x)
{
  myassert("not implemented!"==0);
  
  return y/x;
}


#ifdef __cplusplus
}
#endif
