#include <tamtypes.h>
#include <sifcmd.h>
#include <kernel.h>
#include <sifrpc.h>

#include <fileio.h>

#define DUMPFRAMES 0

//#include "myassert.h"
#include "main.h"
#include "malloc.h"
#include "dma.h"
#include "gif.h"
#include "types.h"
#include "matrix.h"
#include "texture.h"
#include "math.h"
#include "sound.h"
#include "tracer.h"
#include "plasma.h"
#include "radial.h"
#include "vu.h"
#include "draw.h"
#include "font.h"
#include "glow.h"
#include "meta.h"
#include "bonbon.h"
#include "meshtest.h"
#include "meshtest2.h"
#include "pixel.h"
#include "greetings.h"
#include "textbar.h"
#include "timing.h"
#include "oggvorbisuse.h"
#include "paduse.h"
#include "string.h"
#include "jpguse.h"

#include "overlay.h"

#define PAD 1
#define SOUND (1&&PAD)
//#define BARS_TO_SKIP 92
#define BARS_TO_SKIP 0
//#define BARS_TO_SKIP (29-1)
//#define BARS_TO_SKIP (45-1)
//#define BARS_TO_SKIP (55-1)
//#define BARS_TO_SKIP (77-1)
//#define BARS_TO_SKIP (91-1)
//#define BARS_TO_SKIP (97-1)
//#define BARS_TO_SKIP (121-1)
//#define BARS_TO_SKIP (141-1)

#define  musicLength 40
#define musicFrequency 44100
#define soundBufferLength (128*8*1048/16)
static int128 musicDataLeft[soundBufferLength];
static int128 *musicDataLeftEnd=musicDataLeft+soundBufferLength;
static int128 musicDataRight[soundBufferLength];
static int128 *musicDataRightEnd=musicDataRight+soundBufferLength;

extern "C" void FlushCache(int);
extern "C" void Init_GS(void);
extern "C" void Init_GS_PAL(void);
extern "C" void Init_GS_NTSC(void);

static int128 dmamem[1024*1024/16];//large dma-area

int PAL;

extern char binary_jpegtest_start[];
extern char binary_jpegtest_end[];
extern char binary_motorvej_start[];
extern char binary_motorvej_end[];
extern char binary_test_alpha_start[];
extern char binary_kalaidoskopimage_start[];
extern char binary_kalaidoskopimage_end[];
extern char binary_kalaidoskopimage_alpha_start[];
extern char binary_greetingsbg_start[];
extern char binary_greetingsbg_end[];
extern char binary_introbg_start[];
extern char binary_introbg_end[];
extern char binary_tuntracer_start[];
extern char binary_tuntracer_end[];
extern char binary_tuntracer01_alpha_start[];
extern char binary_tuntracer02_alpha_start[];
extern char binary_smadr_start[];
extern char binary_smadr_end[];
extern char binary_smadr2_start[];
extern char binary_smadr2_end[];
extern char binary_smadr3_start[];
extern char binary_smadr3_end[];
extern char binary_spiky_start[];
extern char binary_spiky_end[];
extern char binary_flyver_start[];
extern char binary_flyver_end[];
extern char binary_metablobbg_start[];
extern char binary_metablobbg_end[];

extern char binary_soundtrack_start[];
extern char binary_soundtrack_end[];
extern char binary_musik_start[];
extern char binary_musik_end[];

extern char binary_font1_start[];
extern char binary_font1_alpha_start[];

extern char binary_timings_start[];
extern char binary_midifile_start[];

static int screenzbuf;
texture screen[2];
texture tempscreen[1];
static int screenindex;

texture jpegBank[3][2];
texture jpegBankVRam;

static texture fonttexture;
static font thefont;

static int iframe;

static bool vSyncInterruptEnabled;
static void myVSync()
{
  if(vSyncInterruptEnabled)
    SleepThread();
  else
    vsync();
}

static void flipscreen()
{
  gif_env;
  int interlaceframe;
		
  interlaceframe=GIF_[0x40*2]&(1<<13);
  if(interlaceframe)interlaceframe=1;	

  if(!DUMPFRAMES)
    iframe=interlaceframe;
  else
    {
      interlaceframe=iframe=1-iframe;
	
    }

  GIF_[0]=0x000000000000FF62;
  GIF_[4]=0x0000000000000002;


  if(PAL)
    {
      GIF_[18]=0x0000000000001400+screen[interlaceframe].addr/2048/4;
      GIF_[20]=0x000ff9FF01824290;
    }
  else
    {
      GIF_[18]=0x0000000000001400+screen[interlaceframe].addr/2048/4+10;
      GIF_[20]=0x000c79FF01824290;
    }

  interlaceframe=1-interlaceframe;

  screenindex=(screenindex+1)&1;

  screenindex=interlaceframe;
}

static void showvideoram()
{
  int y=0;

  while(1)
    {
      int t;
      for(t=0;t<15;t++)
	myVSync();
      GIF_[0]=0x000000000000FF62;
      GIF_[4]=0x0000000000000002;
      GIF_[18]=0x0000000000001400+((y));
      GIF_[20]=0x000ff9FF01824290;

      y+=5*2;
      if(y>511)y=0;
    }
}


#define NTSCPAL *((char*)0x1fc80000-0xae)

void hexdump(int *addr)
{
  char test[799];
  int y=10;

  string_setmindigits(8);
  string_setsign(0);
  thefont.monospacingon(12);

  for(int i=0;i<22;i++)
    {
      int x=12;
      itog((int)addr,test);
      thefont.putstring(test,x,y);

      for(int j=0;j<4;j++)
	{
	  x+=12*10;
	  itog(*addr,test);
	  thefont.putstring(test,x,y);
	  addr++;
	}
      y+=18;
    }
}




void PRINT(char *s, int a, int *hd)
{
  static char test[799];
  itog(a,test);

  int frames=0;

  while(frames<5)
    {
      frames++;
      myVSync();
      flipscreen();

      dma_beginchain(dmamem);

      screen[1-screenindex].dmalistframe1(1-iframe);
      clearscreen(RGB(30,60,80));

      thefont.putstring(s,40,440);
      thefont.putstring(test,40,460);

      if(hd)hexdump(hd);

      dma_endchain();
      FlushCache(0);
      dma02_wait();
      dma_sendchain();
      dma02_wait();
    }
}

#define CONSOLE_ROWS 29
#define CONSOLE_COLS 80
static char console_screen[CONSOLE_ROWS][CONSOLE_COLS];
static int console_row,console_col;
static int console_on=1;

void console_show(int nframes)
{
  int frames=0;

  if(!console_on)return;
  while(frames<nframes)
    {
      frames++;
      myVSync();
      flipscreen();

      // init dmachain
      dma_beginchain(dmamem);

      screen[1-screenindex].dmalistframe1(iframe);
      clearscreen(RGB(30,80,40));
      clearscreen(RGB(0,0,0));

      for(int y=0;y<CONSOLE_ROWS;y++)
	{
	  //			thefont.putstring(console_screen[y],40,16*y+16);
	}

      dma_endchain();
      FlushCache(0);
      dma02_wait();
      dma_sendchain();
      dma02_wait();
    }
}


void console_scroll()
{
  for(int y=0; y<CONSOLE_ROWS-1;y++)
    {
      for(int x=0;x<CONSOLE_COLS;x++)
	{
	  console_screen[y][x]=console_screen[y+1][x];
	}
    }
  int y=CONSOLE_ROWS-1;
  for(int x=0;x<CONSOLE_COLS;x++)
    console_screen[y][x]=0;
}


void console_clear()
{
  for(int y=0;y<CONSOLE_ROWS;y++)
    for(int x=0;x<CONSOLE_COLS;x++)
      console_screen[y][x]=0;
  console_row=0;
  console_col=0;
}


void console_newline()
{
  console_row++;
  console_col=0;
  if((PAL&&(console_row>=CONSOLE_ROWS))||((!PAL)&&(console_row>=CONSOLE_ROWS-10)))
    {
      console_scroll();
      console_row--;
    }
}


void console_printnonl(char *s)
{
  int i=0;
  while(s[i])
    {
      if(console_col<CONSOLE_COLS)
	{
	  console_screen[console_row][console_col]=s[i];
	}
      console_col++;
      i++;
    }
}


void console_print(char *s)
{
  console_printnonl(s);
  console_newline();
}


void console_printint(int i)
{
  char temp[16];

  itoa(i,temp);
  console_print(temp);
}


void console_printshow(char *s, int nframes)
{
  console_print(s);
  console_show(nframes);
}


void _myassert(char *exp, char *file, char *function, int line)
{
  char temp[16];

  itoa(line,temp);
  console_printnonl("Myassertion failed:   ");
  console_printnonl(exp);
  console_printnonl("   FILE: ");
  console_printnonl(file);
  console_printnonl("   FUNCTION: ");
  console_printnonl(function);
  console_printnonl("   LINE: ");
  console_print(temp);
  console_show(500);
}


void _tag(char *file, char *function, int line)
{
  char temp[16];

  itoa(line,temp);
  console_printnonl("TAG:");
  console_printnonl("   FILE: ");
  console_printnonl(file);
  console_printnonl("   FUNCTION: ");
  console_printnonl(function);
  console_printnonl("   LINE: ");
  console_print(temp);
  console_show(3);
}


void drawline2(int x1, int y1, int x2, int y2, int col)
{
  gif_env;
	
  x1*=2;
  x2*=2;

  dma_begingp();

  gif_tag(0xe,1,0,0,0);

  gPRMODECONT(1);
  gCOLCLAMP(1);
  gDTHE(0);
  gPRIM(1);

  gRGBAQ(0x3F80000000000000+col);
  gXYZ2(hhw(32000+(int)x1,32000+(int)y1));
  gXYZ2(hhw(32000+(int)x2,32000+(int)y2));

  gif_endfinal();

  dma_endgp();
}


static void renderLine(float ax, float ay, float bx, float by, int color)
{
  gif_env;

  int x,y;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);
  gCOLCLAMP(1);
  gDTHE(0);
  
  gCLAMP_1(0);
  gALPHA_1(0x8000000000);
  
  gTEST_1(0x30000);
  
  gPRIM(PRIMline+0*PRIMtexture+0*PRIMuv+PRIMalpha);
  gPABE(0);
  gRGBAQ(0x3F80000080000000+color);
  
  x=65535&(int)(ax*16+32000);
  y=65535&(int)(ay*16/2+32000);
  gXYZ2(hhw(x,y));
  
  gRGBAQ(0x3F80000080000000+color);
  x=65535&(int)(bx*16+32000);
  y=65535&(int)(by*16/2+32000);
  gXYZ2(hhw(x,y));

  gif_endfinal();
  dma_endgp();
}


static void drawbar(int x, int y, int width, int col)
{
  x-=80;
  for(int t=0;t<10;t++)
    drawline2(x*8,(y+t)*8,(x+width)*8,(y+t)*8,col);
}

static float dotp[8];
static float dotp2[8];
static float dotp3[8];

static int spectrumon=0;


static float clamp(float x)
{
  if(x>0)return x;
  return 0;
}

void loadJpegToBank(char *binary_jpegtest_start, char *binary_jpegtest_end, char *binary_alphachannel_begin, int n)
{
  //  myassert(n>=0 && n<3);

  loadJpegToTextureEvenLines(binary_jpegtest_start,binary_jpegtest_end,&jpegBank[n][0],0);
  loadJpegToTextureOddLines(binary_jpegtest_start,binary_jpegtest_end,&jpegBank[n][1],0);
  if(binary_alphachannel_begin)
    {
      texture temp;
      temp.init();
      temp.width=640;
      temp.height=512;
      temp.bitsperpixel=32;
      temp.image=jpegBank[n][0].image;
      temp.loadalpha(binary_alphachannel_begin);

      for(int x=0;x<640;x++)
	{
	  static char temp2[512];
	  for(int y=0;y<512;y++)
	    {
	      temp2[y]=temp.image[x+y*640]>>24;
	    }
	  for(int y=0;y<256;y++)
	    {
	      temp.image[x+y*640]=(temp.image[x+y*640]&0xffffff)+(((int)(temp2[y*2]))<<24);
	    }
	  for(int y=0;y<256;y++)
	    {
	      temp.image[x+(y+256)*640]=(temp.image[x+(y+256)*640]&0xffffff)+(((int)(temp2[y*2+1]))<<24);
	    }
	}
    }
}


void uploadJpegToVRam(int n, int i)
{
  jpegBankVRam.image=jpegBank[n][i].image;
  jpegBankVRam.upload_vif(jpegBankVRam.addr);
}


int currentJpeg;


void setCurrentJpeg(int n)
{
  currentJpeg=n;
}


void main_renderBackground(int iframe, bool alphaEnabled)
{
  int alpha;
  uploadJpegToVRam(currentJpeg,iframe);
  if(alphaEnabled)
    alpha=0x44;
  else
    alpha=0x20;
  jpegBankVRam.boxuv_vif(0,0,640*16,512*16,hhw(0,0),hhw(jpegBankVRam.width*16,jpegBankVRam.height*16),alpha);
}

static timing tim;

#define PAD_FFWD_ENABLED 1
#define PAD_SHOWVIDEORAM_ENABLED 1
#define PAD_PAUSE_ENABLED 1
#define PAD_TIMINGSELECT_ENABLED 0
#define PAD_TOGGLESPECTRUM_ENABLED 1
#define PAD_QUIT_ENABLED 1
#define PAD_SCREENDUMP_ENABLED 0

int writedata(char *filename, char *data, int nbytes)
{
  int file;

  file=fioOpen(filename, O_WRONLY + O_CREAT);
  if (file< 0)
    {
      printf("File open error\n");
      while(1);//myassert(0);
    }

  // Read file contents into buffer
  int ret = fioWrite(file, data, nbytes);
  if(nbytes!=ret)
    {
      printf("File write error\n");
      fioClose(file);
      while(1);//myassert(0);
    }
  fioClose(file);
  printf("file closed\n");
}

static void removeAlpha(char *screen, int bytes)
{
  char *source,*dest;
  source=dest=screen;
  int m=0;
  while(bytes-->0)
    {
      if((++m)&3)
	{
	  *(dest++)=*source;
	}
      source++;
    }
}


void dumpScreen()
{
  texture *t=&(screen[0]);

  for(int i=0;i<5;i++)
    myVSync();
  
  t->image=(int*)malloc(t->width*t->height*4);
  t->download();

  writedata("host:/home/craft/screendump.raw",(char*)(t->image),t->width*t->height*4);
  for(int i=0;i<5;i++)
    myVSync();
  free(t->image);
}


void dumpFrame(int iframe)
{
  static int framenum;

  if(framenum==10551)
    {
      texture *t=&(screen[iframe]);
      
      if(!screen[0].image)screen[0].image=screen[1].image=(int*)malloc(t->width*t->height*4);
      
      for(int i=0;i<5;i++)
	myVSync();
      
      printf("mem.%x\n",(int)(t->image));
      t->download();
      
      removeAlpha((char*)(t->image),t->width*t->height*4);

      static char fileName[80];
      sprintf(fileName,"host:/home/craft/screendumps/frame.raw");
      writedata(fileName,(char*)(t->image),t->width*t->height*3);
      printf("done writing\n");
      for(int i=0;i<5;i++)
	myVSync();
      //  free(t->image);
      printf("done dumping\n");
    }
  framenum++;
}

static volatile int jpegDecodeSource,jpegDecodeNum=-1; 

static int jpegDecodeSourceStored,jpegDecodeNumStored=-1; 

char* jpegFileList[][3]=//alpha channel is stored as pcx file
  {
    {binary_introbg_start,binary_introbg_end,0},
    {binary_metablobbg_start,binary_metablobbg_end,0},
    {binary_tuntracer_start,binary_tuntracer_end,binary_tuntracer01_alpha_start},
    {binary_tuntracer_start,binary_tuntracer_end,binary_tuntracer02_alpha_start},
    {binary_smadr_start,binary_smadr_end,0},
    {binary_smadr2_start,binary_smadr2_end,0},
    {binary_smadr3_start,binary_smadr3_end,0},
    {binary_greetingsbg_start,binary_greetingsbg_end,0},
    {binary_kalaidoskopimage_start,binary_kalaidoskopimage_end,binary_kalaidoskopimage_alpha_start},
    {binary_spiky_start,binary_spiky_end,0},
    {binary_flyver_start,binary_flyver_end,0}
  };

static volatile int musicDecruncherPositionInSeconds;

static int128 decruncherThreadStack[4096];
static ee_thread_t decruncherThread;
static int decruncherThreadId;
static int mainThreadId;
extern "C"
{
  void decruncherThreadMain()
  {
    int a=0;
    int oggVorbisNotEnded=true;
    while(1)
      {
	if((jpegDecodeSource!=jpegDecodeSourceStored)||(jpegDecodeNum!=jpegDecodeNumStored))
	  {
	    if(jpegFileList[jpegDecodeSource][0])
	      {
		loadJpegToBank(jpegFileList[jpegDecodeSource][0],jpegFileList[jpegDecodeSource][1],jpegFileList[jpegDecodeSource][2],jpegDecodeNum);
	      }
	    jpegDecodeNumStored=jpegDecodeNum;
	    jpegDecodeSourceStored=jpegDecodeSource;
	  }
#ifdef SOUND
	else if(oggVorbisNotEnded&&((oggVorbisUseGetNumberOfBytesWrittenInEachChannel()/16)<(musicDecruncherPositionInSeconds*musicFrequency/28)))
	  {
	    if(!oggVorbisUseDecodePacket())
	      {
		printf("oggVorbis done\n");
		oggVorbisNotEnded=false;
	      }
	  }
#endif
      }
    while(1)
      {
	setbgcolor(a);
       	a+=0x506070;
      }
  }
}

extern "C"
{
  int VBlankInterruptHandler(int cause)
  {
    if(GIF_CSR&8)
      {
	static int a=0;
	setbgcolor(a+=0x506070);

	iWakeupThread(mainThreadId);
	GIF_CSR=8;
      }
    return -1;
  }
}

#define INTC_GS 0


void setupVBlankInterrupt()
{
  mainThreadId=GetThreadId();
  AddIntcHandler(INTC_GS,VBlankInterruptHandler,0);
  EnableIntc(INTC_GS);
  vSyncInterruptEnabled=true;

  GIF_CSR=8;
  GIF_IMR=0x7700;
}



int getGp()
{
  int gp;

  __asm__ __volatile__("sd $28,0x0(%0)"
		       : : "r" (&gp));
  return gp;
}

void forkDecruncherThread()
{
  extern void *_gp;

  decruncherThread.func=(void *)decruncherThreadMain;
  decruncherThread.stack=decruncherThreadStack;
  decruncherThread.stack_size=4096*16;
  decruncherThread.gp_reg=(void*)getGp();
  decruncherThread.initial_priority=65;// this number should be higher than the main threads priority - meaning that the decruncher thread has lower priority than the main thread
  
  //  printf("gp: %x\n",(int)getGp());

  decruncherThreadId=CreateThread(&decruncherThread);

  if(decruncherThreadId<0)
    {
      printf("error while creating decruncher thread\n");
      while(1);
    }
  StartThread(decruncherThreadId, 0);
}


static void wait_ms(int msec)
{
  volatile int a;
  
  for(int s=0;s<msec;s++)
    {
      for(int t=0;t<70000;t++)a=t;
    }
}


int main(int argc, char *argv[])
{
  //  printf("SooPADoopa test %s\n",argv[0]);  // really really stupid - this was the line that made the demo crash when using Naplink

  int up_press=0,down_press=0;
  int	paddata=0;
  unsigned int voiceselect=0;

  float frames=0;


  if(NTSCPAL!='E')
    PAL=0;
  else
    PAL=1;

  //  PAL=0; //ntsc test

  //PAL=1; //force PAL

  if(PAL)
    Init_GS_PAL();
  else
    Init_GS_NTSC();
	  
  texture_allocinit(0);

  dma_reset();
  math_init();

  texture_cleartexturemem(0x80ff00ff);	//fill texturemem with ugly color

  screen[0].init();
  screen[0].width=640;
  screen[0].height=PAL?256:256;
  screen[0].alloc();

  screen[1].init();
  screen[1].width=640;
  screen[1].height=PAL?256:256;
  screen[1].alloc();

  tempscreen[0].init();
  tempscreen[0].width=640;
  tempscreen[0].height=256;
  tempscreen[0].alloc();

  if(SOUND)
    {
      oggVorbisUseDecodeInit((char*)binary_musik_start,(char*)binary_musik_end,(char*)musicDataLeft,(char*)musicDataLeftEnd,(char*)musicDataRight,512);
      for(int i=0;i<220;i++)oggVorbisUseDecodePacket();
    }

  screenzbuf=texture_allocvideomem(256*640*4);

  screen[0].zbufaddr=screenzbuf;
  screen[1].zbufaddr=screenzbuf;
  tempscreen[0].zbufaddr=screenzbuf;


  for(int n=0;n<3;n++)
    for(int i=0;i<2;i++)
      {
	jpegBank[n][i].init();
	jpegBank[n][i].width=640;
	jpegBank[n][i].height=256;
	if(i==0)
	  jpegBank[n][i].image=(int *)malloc(jpegBank[n][i].width*jpegBank[n][i].height*4*2);
	else
	  jpegBank[n][i].image=jpegBank[n][0].image+jpegBank[n][i].width*jpegBank[n][i].height;
      }
 
	
  loadJpegToBank(jpegFileList[0][0],jpegFileList[0][1],0,0);

  jpegBankVRam.init();
  jpegBankVRam.width=640;
  jpegBankVRam.height=256;
  jpegBankVRam.alloc();

  fonttexture.init();
  fonttexture.load(binary_font1_start);
  fonttexture.loadalpha(binary_font1_alpha_start);


  fonttexture.allocupload();
  thefont.init(&fonttexture,18,0,1,"abcdefghijklmnopqrstuvwxyz\n"
	       "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n"
	       "0123456789_!\"\"#%&/()=?@${[|]}-+/*\n"
	       ".,:\n"
	       //		.,:;'<>\\^~\n
	       ,0xff000000);

  console_printshow("Soopadoopa PS2 demosystem");
  console_printshow("Succesfully initialised!");
  if(PAL)
    console_printshow("Running PAL mode");
  else
    console_printshow("Running NTSC mode");


  console_on=0;
  console_printshow("Initialising textbar.cpp");
  printf("Initialising textbar\n");
  textbar_init();
  textbar_init2();
	

  console_printshow("Initialising glow.cpp");
  printf("Initialising glow\n");
  glow_init();


  printf("Initialising overlay\n");
  initOverlay();

  console_printshow("Initialising tracer.cpp");
  printf("Initialising tracer\n");
  tracer_init();
  tracer_init2();

  printf("Initialising tunnel\n");
  console_printshow("Initialising plasma.cpp");
  plasma_init();
  plasma_init2();

  printf("Initialising greetings\n");
  console_printshow("Initialising greetings.cpp");
  greetings_init(); //should be initialised after textbar
  greetings_init2();


  console_printshow("Initialising meta.cpp");
  printf("Initialising meta\n");
  meta_init();
  meta_init2();
  for(int i=0;i<100;i++)meta_fillgrid();

  printf("Initialising bonbon\n");
  console_printshow("Initialising bonbon.cpp");
  bonbon_init();
  bonbon_init2();

  console_on=0;
  printf("Initialising meshtest\n");
  console_printshow("Initialising meshtest.cpp");
  meshtest_init();
  meshtest_init2();
  meshtest2_init();
  meshtest2_init2();

  console_on=1;
  printf("Initialising pixel\n");
  pixel_init();
  pixel_init2();

  printf("Initialising timing\n");
  console_printshow("Initialising timing.cpp");
  tim.load(binary_timings_start,binary_midifile_start);
  tim.clear();

  tim.step(tim.toms(BARS_TO_SKIP));

#if PAD
  console_on=1;
  console_printshow("Danger!! Initialising pad");
  pad_init();
  console_printshow("Pad succesfully initialised!");
#endif

  console_on=1;
  console_on=0;

#if SOUND
  console_on=1;
  console_printshow("Danger!! Initialising sound");
  sound_init((char*)musicDataLeft, (char*)musicDataLeftEnd, (char*)musicDataRight, (char*)musicDataRightEnd);
  console_on=0;
  //	console_printshow("Sound souccesfully initialised!");
#endif

  printf("Malloc test:%x\n",malloc(128)); 

  {
    setupVBlankInterrupt();
    forkDecruncherThread();
  }

  for(int i=0;i<8;i++)tim.step(1000.0f/(PAL?50:60));// HT's trick

  while(timing::getval(99)!=255 && (((PAD_QUIT_ENABLED==0)||(!(paddata&PAD_TRIANGLE)))||(frames<50)))
    {
      static float speed=1;	
      static float pos=0;
      static int effectshift=0;

      musicDecruncherPositionInSeconds=(int)(frames/(PAL?50.0:60.0))+30;
      //		tim.step(1000.0f/(PAL?50:60));

      float ntscRefreshRate=60.025f;
      float palRefreshRate=50.02f;

      tim.step(1000.0f/(PAL?palRefreshRate:ntscRefreshRate));

      int jSource=timing::getval(97);
      int jDest=timing::getval2(97);
      jpegDecodeNum=jDest;
      jpegDecodeSource=jSource;
		
#if PAD
      do
	{
	  paddata=pad_get();
	}while((PAD_PAUSE_ENABLED==1)&&(paddata&PAD_CIRCLE));
#endif
      if(PAD_FFWD_ENABLED)
	{
	  if(paddata&PAD_RIGHT)
	    {
#if SOUND
	      tim.step(1000*sound_addpacketoffset(sound_packetsperseconds(1)));
#else
	      tim.step(1000);
#endif
	    }
	  if(paddata&PAD_LEFT)
	    {
	      float t=tim.time;
	      tim.clear();
#if SOUND
	      t+=1000*sound_addpacketoffset(sound_packetsperseconds(-1));
#else
	      t+=-1000;
#endif
	      tim.step(t);
	    }
	}

      if(PAD_SCREENDUMP_ENABLED)
	if(paddata&PAD_L1)dumpScreen();


      if(PAD_TIMINGSELECT_ENABLED)
	{
	  if(paddata&PAD_UP){if(++up_press>10){voiceselect--;up_press=0;}}else up_press=0;
	  if(paddata&PAD_DOWN){if(++down_press>10){voiceselect++;down_press=0;}}else down_press=0;
	  voiceselect%=10;
	  tim.mapvoice98(voiceselect);
	  {
	    static int temp;
	    temp++;
	    temp&=15;
	    if(temp==0)
	      {
		if(paddata&PAD_L2)effectshift++;
	      }
	    {
	      if(paddata&PAD_UP)speed+=0.01;
	      if(paddata&PAD_DOWN)speed-=0.01;
	      pos+=speed;
	    }
	  }
	}
      if(PAD_TOGGLESPECTRUM_ENABLED)
	if(paddata&PAD_R1)spectrumon=1-spectrumon;

      vu1_wait();
      //		setbgcolor(RGB(39,67,104));

      myVSync();

      flipscreen();

      setbgcolor(RGB(0,0,0));
#if SOUND
      sound_play();
#endif

      dma_beginchain(dmamem);

      if(timing::getval(96))renderOverlay(frames, &(screen[1-screenindex]), &(screen[screenindex]), iframe, timing::getval(96));

      screen[1-screenindex].dmalistframe1(iframe);

      if(spectrumon)
	{
	  screen[0].boxNoTexture(16*230,16*80,16*260,16*100,rgb(38,38,68));
		    
	  static char test[40];
	  itoa(65535&(int)(tim.currentpos()>>2),test);
	  thefont.putstring(test,230,80);
	  itoa(3&(int)tim.currentpos(),test);
	  thefont.putstring(test,250,80);
		    
	  int posx=100,posy=100;
	  for(int t=0;t<12;t++)
	    {
	      if(voiceselect==t)screen[0].boxNoTexture(16*posx-64,16*posy+t*24*16,16*posx-640,16*(posy+20+t*24),rgb(38,38,68));
	      itoa(65535&(int)(t),test);
	      thefont.putstring(test,posx-40,posy+24*t);
	      screen[0].boxNoTexture(16*posx,16*posy+t*24*16,16*posx+(int)(1600*timing::get(t)),16*(posy+20+t*24),rgb(138,38,168));
	    }
	}


      textbar_frame(frames,&(screen[1-screenindex]),&tempscreen[0],iframe,dotp3[4]);
      greetings_drawText(frames,&(screen[1-screenindex]),&tempscreen[0],iframe,dotp3[4]);

      // kick the main display overlay

      renderLine(0,0,0,512,0);//


      if(DUMPFRAMES)
	{
	  wait_ms(40);
	  //		    wait_ms(100);
	  //for(int i=0;i<50;i++)myVSync();
	}


      dma_endchain();
      FlushCache(0);
      dma02_wait();
      dma_sendchain();
      dma02_wait();


      if(DUMPFRAMES)
	{
	  dumpFrame(1-screenindex);
	  myVSync();
	}


      setCurrentJpeg(0);

      int effektnum=(((((int)frames)>>12)+5+effectshift)%9);

      effektnum=(timing::getval(99));

      switch(effektnum)
	{
	case 6:
	  initvifdmalist();
	  //	  parti_frame(frames,&(screen[1-screenindex]),&tempscreen[0],iframe,dotp3[4]);
	  break;
	case 4:
	  initvifdmalist();
	  plasma_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe,dotp3[4]);
	  break;
	case 0:
	case 1:
	  setCurrentJpeg(timing::getval(18));//1,2,0 understj
	  initvifdmalist();
	  screen[1-screenindex].setcurrent_vif2(iframe);
	  main_renderBackground(iframe,false);
	  bonbon_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe);
	  break;
	case 2:
	  setCurrentJpeg(2);//0
	  initvifdmalist();
	  tracer_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe);
	  break;
	case 3:
	  initvifdmalist();
	  meta_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe);
	  break;
	case 5:
	  setCurrentJpeg(0);
	  initvifdmalist();
	  meshtest_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe);
	  break;
	case 7:
	  setCurrentJpeg(2);
	  initvifdmalist();
	  meshtest2_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe);
	  break;
	case 8:
	  setCurrentJpeg(1);
	  pixel_frame(frames,&(screen[1-screenindex]),&tempscreen[0],1-iframe,&jpegBankVRam);
	  break;
	case 10:
	  setCurrentJpeg(1);
	  initvifdmalist();
	  greetings_frame(frames,&(screen[1-screenindex]),&tempscreen[0],iframe,dotp3[4]);
	  break;
	default:
	  break;
	}

      frames+=1.0;
      if(PAD_SHOWVIDEORAM_ENABLED)if(frames>200)if(paddata&PAD_SQUARE)showvideoram();
    }

#if SOUND
  sound_deinit();
#endif
  while(1)
    {
      texture_cleartexturemem(0);
    }
  //	meshtest_deinit();
  bonbon_deinit();
  //	meta_deinit();
  //	radial_deinit();
  //	tracer_deinit();

  //  oggVorbisUseDecodeDeinit();
  return 0;
}
