//#include <stdlib.h>
//#include <stdio.h>
#include <tamtypes.h>
#include <sifcmd.h>
#include <kernel.h>
#include <sifrpc.h>

u8 send_buffer[512] __attribute__((aligned(128)));
//static u8 recieve_buffer[512] __attribute__((aligned(128)));


static void flush_cache(u64 val)
{
	__asm__ __volatile__("

		daddu			$4,$0,%0
  	addiu			$3,$0,0x64
		syscall		0		
		nop
	"
	:
	:"r"(val)
	:"$3","$4","memory"
	);
}

static u64 sif_dma_stat(u64 hdma)
{
	u64 ret=0;
	u64 *pret = &ret;
	u64 *phdma = &hdma;

	__asm__ __volatile__("

		ld				$4,0(%0)
  	addiu			$3,$0,0x76
		syscall		0		
		nop
		sd			  $2,0(%1)
	"
	:
	:"r"(phdma),"r"(pret)
	:"$2","$3","$4","memory"	
	);
	return ret;
}

static u64 sif_set_dma(void *blk, int cmd)
{
	u64 ret=0;
	u64 *pret = &ret;
	int *pcmd = &cmd;

	__asm__ __volatile__("

		daddu			$4,$0,%0
		lw				$5,0(%1)
  	addiu			$3,$0,0x77
		syscall		0		
		nop
		sd				$2,0(%2)
	"
	:
	:"r"(blk),"r"(pcmd),"r"(pret)
	:"$2","$3","$4","$5","memory"	
	);
	return ret;
}

int iop_dma_upload(void *src,u32 dst,int size)
{
// kald til denne rutine med -03 option virker ikke!!!!! src:=size!!!!!

  int i=0,len=0;
  u8  *pkt;
  u64 ret=0;
  long ret2=0;
  
  flush_cache(0);
  
//	src=0;
  
  /* build packet */
  pkt = send_buffer; 
  PUSHDATA( u32, pkt, (u32)src, i);
  pkt += i; len += i;
  PUSHDATA( u32, pkt, dst, i);
  pkt += i; len += i;
  PUSHDATA( int, pkt, size, i);
  pkt += i; len += i;
  PUSHDATA( int, pkt, 0, i);
  pkt += i; len += i;

  flush_cache(0);
  
  ret = sif_set_dma(send_buffer,1);
  //tag();
  while((ret2 = sif_dma_stat(ret))>=0);
  //tag();
  flush_cache(0);
  
  return (ret2 < -1);
}

