/* Greetings */
/* Soopadoopa 2003 */

#include "greetings.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "glow.h"
#include "timing.h"
#include "spline.h"
#include "main.h"
#include "hsvrgb.h"
#include "textbar.h"

extern char binary_sprite_start[];

static texture *tempscreen;
static texture *screen;
static int iframe;
static float timing;

static texture tex3;

extern int PAL;

static linearSpline numParticles;

#define NSTRINGS 32

static char *greetingStrings[]={
  "LOONIES  |  ", 
  "BYPASS  |  ",
  "THE PIMP BRIGADE  |  ",
  "DAMAGE  |  ",
  "ALIEN PROPHETS  |  ",
  "SQUIRRELZ  |  ",
  "FUDGE  |  ",
  "PURPLE  |  ",
  "LITEWERX  |  ",
  "FARBRAUSCH  |  ",
  "BLASPHEMY  |  ",
  "EFFEKT  |  ",
  "EXCESS  |  ",
  "HAUJOBB  |  ",
  "TRAUMA  |  ",
  "THREESTATE  |  ",
  "AARDBEI  |  ",
  "CALODOX  |  ",
  "VIBRANTS  |  ",
  "TBC  |  ",
  "TPOLM  |  ",
  "MAINLOOP  |  ",
  "SCARAB  |  ",
  "DXM  |  ",
  "SUNFLOWER  |  ",
  "HALCYON  |  ",
  "NAPALM  |  ",
  "SYL  |  ",
  "DEATURE  |  ",
  "PRONE  |  ",
  "PS2DEV  |  ",
  "LOOPIT"


/*                              "ANARCHY |",
				"BALANCE |",
				"COMPLEX",
				"DEXION",
				"E",
				"F",
				"GOTO10",
				"H",
				"INFECT",
				"JESKOLA",
				"K",
				"LEMON",
				"MAJIC 12",
				"N",
				"ORANGE",
				"PARASITE",
				"QUARTEX",
				"REBELS",
				"SANITY",
				"T",
				"U",
				"V",
				"W",
				"X",
				"Y",
				"Z"*/
};
static int greetingPositions[]={00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00,
				00};

void eks2_frame2(float frames, int maxpart)
{
  /* thorstens seje effekt*/
  
  int t;
  float sc;
  float sc2;
  int max2;

  if(PAL)
    max2=2*1048;
  else
    max2=1000;
  
  
  
  for(t=0;t<min(max2,maxpart);t++)
    {
      float scalet=0.7;
      sc = 0.8*(60*sin2(frames*0.008+t*scalet*0.017)+80*sin2(frames*0.013+t*scalet*0.02));
      sc2 = 0.3*(60*sin2(frames*0.014+t*scalet*0.012)+80*sin2(frames*0.012+t*scalet*0.013));
      
      float x=320+2*sc*2*sin2(t*scalet*0.015*sc2*0.014);
      float y=2*100+sc*cos2(t*scalet*0.014*sc2*0.013);
      float sx=36*sin2(t*scalet*0.04)+40;
      float sy=2*18*sin2(t*scalet*0.04)+2*20;

      if(!PAL)sy*=5.0f/6.0f;

      int c=rgb(int(10*(10+4*cos2(t*scalet*0.004))),10*9,10*6);
      c=fvecToRgb(0.1f*hsvToRgb(rgbToHsv(rgbToFvec(c))+fvec_(frames,0,0)));
      tex3.boxuv_vif(16*(x-sx),16*(y-sy),16*(x+sx),16*(y+sy),0,0x08000800,0x4000000048,tex3.TEX1(),c);
    }
}


void greetings_init()
{
  tex3.init();
  tex3.load(binary_sprite_start);

  numParticles.init();
  numParticles.addKeyValue(0,0);
  numParticles.addKeyValue(3,1300);
  numParticles.addKeyValue(15,1300);
  numParticles.addKeyValue(18,0);
}

void greetings_init2()
{
  for(int i=0;i<NSTRINGS;i++)
    {
      greetingPositions[i]+=theDemoFont.pixlen(greetingStrings[i]);
    }

  tex3.allocupload();
}


void putGreetingStrings(float pos)
{
  const int splits=16;
  static float oldPos;

  theDemoFont.setalpha(22);
  theDemoFont.setadditive(true);
  
  for(int t=0;t<splits;t++)
    {
      float a=1*(float)t/splits;
      float b=1-a;
      float pos2=a*pos+b*oldPos;
      float pos3=pos2;
      for(int i=0;i<NSTRINGS;i++)
	{
	  if(pos3>-200 && pos3<640)
	    {
	      theDemoFont.putstring(greetingStrings[i],pos3,196);
	    }
	  pos3+=greetingPositions[i];
	}
    }
  oldPos=pos;
}
  

static float thisFrame;


void greetings_drawText(float frames, texture *screen, texture *tempscreen, int iframe, float timing)
{
  if(thisFrame==frames-1)
    {
      static int localFrames;
      localFrames++;
      
      static float textPos;
      
      textPos+=2;
      textPos+=4*timing::get(3);
      
      theDemoFont.setalpha(256);
      theDemoFont.setadditive(false);
      putGreetingStrings(640-textPos);
    }
}


void greetings_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_, float timing_)
{
  static int localFrames;
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  timing=timing_;
  
  thisFrame=frames;

  static int num;
  
  localFrames++;

  {
    static float oldTime6; 
    if(timing::gettime(3)!=oldTime6 && timing::getval2(3)>0)
      {
	num++;
      }
    oldTime6=timing::gettime(3);
  }
  
  screen->setcurrent_vif2(iframe);
  main_renderBackground(iframe,false);
  
  eks2_frame2(frames, int(numParticles.evaluate(localFrames/(PAL?50.0f:60.0f))));

  dma01_endchain();
}

void greetings_deinit()
{
}
