#ifndef __GIF_H
#define __GIF_H

#include "hwreg.h"

#ifdef __cplusplus
extern "C" {
#endif

#define RGB(r,g,b) ((b<<16)+(g<<8)+r)

#define dd(a,b) a,b
#define wwd(a,b) ((((long)b)<<32)+(long)a)
#define hhw(a,b) ((((long)b)<<16)+(long)a)

int rgb(int r, int g, int b);
void setvideomode();
void setbgcolor(int c);
void vsync();

#define gif_FRAME_1 0x4c
#define gif_FRAME_2 0x4d
#define gif_ZBUF_1 0x4e
#define gif_ZBUF_2 0x4f
#define gif_XYOFFSET_1 0x18
#define gif_XYOFFSET_2 0x19
#define gif_SCISSOR_1 0x40
#define gif_SCISSOR_2 0x41
#define gif_PRMODECONT 0x1a
#define gif_COLCLAMP 0x46
#define gif_DTHE 0x45
#define gif_TEST_1 0x47
#define gif_TEST_2 0x48
#define gif_PRIM 0x0
#define gif_RGBAQ 0x1
#define gif_XYZ2 0x5
#define gif_UV 0x3
#define gif_ST 0x2
#define gif_TEX0_1 0x6
#define gif_TEX0_2 0x7
#define gif_TEX1_1 0x14
#define gif_TEX1_2 0x15
#define gif_TEX2_1 0x16
#define gif_TEX2_2 0x17
#define gif_CLAMP_1 0x8
#define gif_CLAMP_2 0x9
#define gif_ALPHA_1 0x42
#define gif_ALPHA_2 0x43
#define gif_PABE 0x49
#define gif_SCANMSK 0x22
#define gif_TEXFLUSH 0x3f
#define gif_FOGCOL 0x3d
#define gif_FINISH 0x61

#define gif_env int GIF_i; int128 *GIF_p,*GIF_beg;int64 GIF_nreg;int64 GIF_flg,GIF_prim,GIF_pre
#define gif_begin(a){GIF_p=(int128*)a;GIF_beg=(int128*)a;}
#define gif_tag(regs,nreg,flg,prim,pre) {GIF_i=1;GIF_nreg=nreg;GIF_flg=flg;GIF_prim=prim;GIF_pre=pre;GIF_p[0].hi=regs;}
#define gif_end() 	{GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+			(GIF_i-1)/(int)GIF_nreg;GIF_p+=GIF_i;GIF_i=0;}
#define gif_endfinal() 	{GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(((int)1)<<15)+	(GIF_i-1)/(int)GIF_nreg;GIF_p+=GIF_i;GIF_i=0;}
#define gif_endfinalregmode() 	{GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(((int)1)<<15)+	(2*(GIF_i-1))/(int)GIF_nreg;GIF_p+=GIF_i;GIF_i=0;}
#define gif_endimagemode(a) {GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(((int)1)<<15)+a;GIF_p+=GIF_i;GIF_i=0;}

#define gif_length ((GIF_p-GIF_beg)+GIF_i)


#define gSCANMSK(a)    		{GIF_p[GIF_i].hi=gif_SCANMSK       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gPABE(a)    		{GIF_p[GIF_i].hi=gif_PABE       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gALPHA_1(a)    		{GIF_p[GIF_i].hi=gif_ALPHA_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gALPHA_2(a)    		{GIF_p[GIF_i].hi=gif_ALPHA_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gCLAMP_1(a)    		{GIF_p[GIF_i].hi=gif_CLAMP_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gCLAMP_2(a)    		{GIF_p[GIF_i].hi=gif_CLAMP_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gUV(a)    		{GIF_p[GIF_i].hi=gif_UV       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gST(a)    		{GIF_p[GIF_i].hi=gif_ST       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX0_1(a)    		{GIF_p[GIF_i].hi=gif_TEX0_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX0_2(a)    		{GIF_p[GIF_i].hi=gif_TEX0_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX1_1(a)    		{GIF_p[GIF_i].hi=gif_TEX1_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX1_2(a)    		{GIF_p[GIF_i].hi=gif_TEX1_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX2_1(a)    		{GIF_p[GIF_i].hi=gif_TEX2_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEX2_2(a)    		{GIF_p[GIF_i].hi=gif_TEX2_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gFRAME_1(a)    		{GIF_p[GIF_i].hi=gif_FRAME_1       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gFRAME_2(a)    		{GIF_p[GIF_i].hi=gif_FRAME_2       ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gZBUF_1(a)    		{GIF_p[GIF_i].hi=gif_ZBUF_1        ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gZBUF_2(a)    		{GIF_p[GIF_i].hi=gif_ZBUF_2        ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gXYOFFSET_1(a)   	{GIF_p[GIF_i].hi=gif_XYOFFSET_1    ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gXYOFFSET_2(a)   	{GIF_p[GIF_i].hi=gif_XYOFFSET_2    ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gSCISSOR_1(a)   	{GIF_p[GIF_i].hi=gif_SCISSOR_1     ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gSCISSOR_2(a)   	{GIF_p[GIF_i].hi=gif_SCISSOR_2     ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gPRMODECONT(a)   	{GIF_p[GIF_i].hi=gif_PRMODECONT    ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gCOLCLAMP(a)   		{GIF_p[GIF_i].hi=gif_COLCLAMP      ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gDTHE(a)   		{GIF_p[GIF_i].hi=gif_DTHE     	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEST_1(a)   		{GIF_p[GIF_i].hi=gif_TEST_1    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gTEST_2(a)   		{GIF_p[GIF_i].hi=gif_TEST_2    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gPRIM(a)   		{GIF_p[GIF_i].hi=gif_PRIM    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gRGBAQ(a)   		{GIF_p[GIF_i].hi=gif_RGBAQ    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gXYZ2(a)   		{GIF_p[GIF_i].hi=gif_XYZ2    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gVEC(a,b)   		{GIF_p[GIF_i].hi=a      	   ;   GIF_p[GIF_i].lo=b;   GIF_i++;}
#define gTEXFLUSH()   		{GIF_p[GIF_i].hi=gif_TEXFLUSH	   ;   GIF_p[GIF_i].lo=0;    GIF_i++;}
#define gFOGCOL(a)   		{GIF_p[GIF_i].hi=gif_FOGCOL    	   ;   GIF_p[GIF_i].lo=a;    GIF_i++;}
#define gFINISH()   		{GIF_p[GIF_i].hi=gif_FINISH    	   ;   GIF_p[GIF_i].lo=0;    GIF_i++;}

#ifdef __cplusplus
}
#endif

#endif
