#include "draw.h"

#include "math.h"

void clearscreen(int color)
{
  gif_env;
  
  dma_begingp();
  
  gif_tag(0xe,1,0,0,0);
  gSCISSOR_1(wwd(hhw(0,639),hhw(0,255)));
  gPRMODECONT(1);
  gCOLCLAMP(1);
  gDTHE(0);
  gTEST_1(0x70000);
  gTEST_1(0x30000);
  gPRIM(6);
  gRGBAQ(0x3F80000000000000+color);
  gXYZ2(hhw(32000+0*16,32000));
  gXYZ2(hhw(32000+16*640,32000+16*256));
  
  gif_endfinal();
  
  dma_endgp();
}


void drawline(int x1, int y1, int x2, int y2)
{
  gif_env;
  
  x1*=2;
  x2*=2;
  
  dma_begingp();

  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);
  gCOLCLAMP(1);
  gDTHE(0);
  gPRIM(1);
  
  gRGBAQ(0x3F80000000000000+0xff8800);
  gXYZ2(hhw(32000+(int)x1,32000+(int)y1));
  gXYZ2(hhw(32000+(int)x2,32000+(int)y2));
  
  gif_endfinal();

  dma_endgp();
}


void drawcircle(int x, int y, int r)
{
  int t;
  float angle=0;
  float oangle;
  
  for(t=0;t<100;t++)
    {
      oangle=angle;
      angle+=2*3.1415927/100;
      
      drawline((int)(x+r*cos(oangle)),(int)(y+r*sin(oangle)),(int)(x+r*cos(angle)),(int)(y+r*sin(angle)));
    }
}


void draw_triangleg(int x1, int y1, int col1, int x2, int y2, int col2, int x3, int y3, int col3)
{
  gif_env;
  
  dma_begingp();

  gif_tag(0xe,1,0,0,0);
  gPRMODECONT(1);
  gCOLCLAMP(1);
  gDTHE(0);
  gTEST_1(0x70000);
  gTEST_1(0x30000);
  gPRIM(3+8);
  
  gRGBAQ(0x3F80000000000000+col1);
  gXYZ2(hhw(32000+x1,32000+y1));
  gRGBAQ(0x3F80000000000000+col2);
  gXYZ2(hhw(32000+x2,32000+y2));
  gRGBAQ(0x3F80000000000000+col3);
  gXYZ2(hhw(32000+x3,32000+y3));
  
  gif_endfinal();
  
  dma_endgp();
}

