#include "alloca.h"
#include <kernel.h>
#include "myassert.h"
#include "types.h"

#define alloc_size 1024

static int128 array[alloc_size];
static int next;
static int numberOfPushes;

void *alloca_(int n, char *file, char *function, int line)
{
  int n2=(n+15)&(-15);

  int nextOld=next;

  next+=n2/16;

  if(!(next<alloc_size-1))printf("%s %s LINE:%i\n",file,function,line);
  myassert(next<alloc_size-1);

  *(int*)(array+next)=nextOld;
  next++;

  numberOfPushes++;

  return (void*)(array+nextOld);
}

void alloca_pop()
{
  numberOfPushes++;
  myassert(numberOfPushes>=0);

  next=*(int*)(array+next-1);
}
