#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <math.h>

extern int plot_choice;
static int frame;
static FILE    *fp;
static char fname[100];
static int ix_old, iy_old, started;
extern int     Red, Blue, Green, Black, White, Magenta, Orange, Gray, Color;
extern double RRmax;


static int last_color;

void setcolor_ps();

char *words[] = {
	"%!",
	"/m {moveto} def",
	"/l {lineto} def",
	"/s {stroke} def",
	"/S {show} def",
	"gsave",
	"1 setlinewidth",
	"54 67 m 54 725 l 558 725 l 558 67 l closepath",
	"56 69 m 56 723 l 556 723 l 556 69 l closepath",
	"stroke",
	"/figure_no where {pop figure_no} if",
	"grestore",
	"57 57 translate",
	"/in 72 def",
	"1 in mul 4 in mul translate",
	"/f (Helvetica) def",
	"",
	"/ellipsedict 8 dict def",
	"ellipsedict /mtrx matrix put",
	"/ellipse",
	"{ ellipsedict begin",
	"/endangle exch def",
	"/startangle exch def",
	"/yrad exch def",
	"/xrad exch def",
	"/y exch def",
	"/x exch def",
	"/savematrix mtrx currentmatrix def",
	"x y translate",
	"xrad yrad scale",
	"0 0 1 startangle endangle arc",
	"savematrix setmatrix",
	"end",
	"} def",
	0
};

void
plots_ps()
{
	char    **cpp, buf[100];

	if (plot_choice==1 || plot_choice==3) {         /* here need a file */
		if (access(".", W_OK)) {
			fprintf(stderr, "Can't create files in .\n");
			return;
		}

		do {
			sprintf(fname, "NSPS_frame%d", frame++);
			sprintf(buf, "Trying %s\n", fname);
		} while (!access(fname, F_OK));

		fp=fopen(fname, "w");
	} else if (plot_choice == 2)
		fp=popen("lpr -h", "w");

	if (fp == NULL) {
		fprintf(stderr, "Something is wrong plot_ps\n");
		return;
	}

	for (cpp=words; *cpp; cpp++) {
		fputs(*cpp, fp);
		fputc('\n', fp);
	}
	started = 0;
}

void
frame_ps()
{
	char buf2[100];

	if (started) {
		fputs("s\n", fp);
		started = 0;
	}

	fputs("showpage\n", fp);

	if (plot_choice == 2)
		pclose(fp);
	else
		fclose(fp);

	if (plot_choice == 3) {
		strcpy(buf2, "lpr ");
		strcat(buf2, fname);
		system(buf2);
	}
}

void
plot_ps(x,y,ic)
double  x,y;
int	ic;
{
	int     ix, iy;

	ix = 72*x;      /* convert inches to points */
	iy = 72*y;

	if (Color != last_color) {
		if (ic == 3) {
			if (started) {
				fputs("s\n", fp);
				started = 0;
			}
			setcolor_ps();
		} else {
			if (!started) {
				fprintf(stderr, "Sequence error plot_ps\n");
				return;
			}
			fprintf(fp, "%d %d l\n", ix, iy);
			fputs("s\n", fp);
			setcolor_ps();
			started = 0;
			ic = 3;
		}
	}

	if (ic == 3) {
		if (started)
			fputs("s\n", fp);

		fprintf(fp, "%d %d m\n", ix, iy);
		started = 1;
	} else {
		if (!started) {
			fprintf(stderr, "Sequence error plot_ps\n");
			return;
		}
		if (ix!=ix_old || iy!=iy_old)
			fprintf(fp, "%d %d l\n", ix, iy);
	}
	ix_old = ix;
	iy_old = iy;
}


void
Text_ps(double x, double y, char *s)
{
	int     ix, iy;

	if (started) {          /* is there a line in progress? */
		fputs("s\n", fp);
		started = 0;
	}

	ix  = 72*x;     /* convert inches to points */
	iy  = 72*y;

	fprintf(fp, "%d %d m\ngsave\n", ix, iy);
	fprintf(fp, "f findfont 9 scalefont setfont\n");
	fprintf(fp, "(%s) S\ngrestore\n", s);
}


void
satellite_ps (int id, int az, int el, int posn)
{
	char line[5];
	double Az, El;
	extern double pi;
	double r, th;
	double x0, y0;
	int    ix, iy;

	/* convert Lat,Lon to (x,y) */

	if (started) {          /* is there a line in progress? */
		fputs("s\n", fp);
		started = 0;
	}

	Az = az;
	El = el;

	r = ((90.-El)/90.)*RRmax;
	th = 2.0*pi*(Az/360.);

	x0 = 2.5 + r*sin(th);
	y0 = 2.5 + r*cos(th);

	/* now to points */

	ix  = 72*x0;    /* convert inches to points */
	iy  = 72*y0;

	setcolor_ps();
	fprintf(fp, "newpath %d %d  9 5 0 360 ellipse fill\n", ix, iy);

	Color = Black;
	setcolor_ps();
	if (posn)
		fprintf(fp, "newpath %d %d  9 5 0 360 ellipse stroke\n", ix, iy);

	/* now label */

	sprintf(line, "%02d", id);
	Text_ps(x0-0.06, y0-0.04, line);
}


void
circle_ps(double x, double y, double R)
{
	int     ix, iy, ir;

	if (started) {          /* is there a line in progress? */
		fputs("s\n", fp);
		started = 0;
	}

	ix  = 72*x;     /* convert inches to points */
	iy  = 72*y;
	ir  = 72*R;

	setcolor_ps();
	fprintf(fp, "newpath %d %d moveto %d %d %d 0 360 arc closepath stroke\n", ix+ir, iy, ix, iy, ir);
}

void
setcolor_ps()
{
	if (Color == last_color)
		return;

	if (started)            /* is there a line in progress? */
		fputs("s\n", fp);

	last_color = Color;
	switch(Color) {
	case 1: /* red */
		fprintf(fp, "1 0 0 setrgbcolor\n");
		break;
	case 2: /* blue */
		fprintf(fp, "0 0 1 setrgbcolor\n");
		break;
	case 3: /* green */
		fprintf(fp, "0 1 0 setrgbcolor\n");
		break;
	case 4: /* black */
		fprintf(fp, "0 0 0 setrgbcolor\n");
		break;
	case 5: /* white */
		fprintf(fp, "1 1 1 setrgbcolor\n");
		break;
	case 6: /* magenta */
		fprintf(fp, "1 0 1 setrgbcolor\n");
		break;
	case 7: /* orange */
		fprintf(fp, "1 0.65 0 setrgbcolor\n");
		break;
	case 8: /* gray */
		fprintf(fp, "0.44 0.5 0.56 setrgbcolor\n");
		break;
	default:
		fprintf(fp, "0 0 0 setrgbcolor\n");
		break;
	}
}
