/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (options.h)
 *
 *  It has been AutoGen-ed  March 25, 2013 at 02:10:26 PM by AutoGen 5.17.3.pre9
 *  From the definitions    funcs.def
 *  and the template file   options_h
 *
 *  This file defines all the global structures and special values
 *  used in the automated option processing library.
 *
 *  Automated Options Copyright (C) 1992-2013 by Bruce Korb
 *
 *  This file is part of AutoOpts, a companion to AutoGen.
 *  AutoOpts is free software.
 *  AutoOpts is Copyright (C) 1992-2013 by Bruce Korb - all rights reserved
 *
 *  AutoOpts is available under any one of two licenses.  The license
 *  in use must be one of these two and the choice is under the control
 *  of the user of the license.
 *
 *   The GNU Lesser General Public License, version 3 or later
 *      See the files "COPYING.lgplv3" and "COPYING.gplv3"
 *
 *   The Modified Berkeley Software Distribution License
 *      See the file "COPYING.mbsd"
 *
 *  These files have the following sha256 sums:
 *
 *  8584710e9b04216a394078dc156b781d0b47e1729104d666658aecef8ee32e95  COPYING.gplv3
 *  4379e7444a0e2ce2b12dd6f5a52a27a4d02d39d247901d3285c88cf0d37f477b  COPYING.lgplv3
 *  13aa749a5b0a454917a944ed8fffc530b784f5ead522b1aacaf4ec8aa55a6239  COPYING.mbsd
 */
#ifndef AUTOOPTS_OPTIONS_H_GUARD
#define AUTOOPTS_OPTIONS_H_GUARD 1
/** \file options.h
 *
 * @addtogroup autoopts
 * @{
 */
#include <sys/types.h>
#include <stdio.h>

#ifndef COMPAT_H_GUARD
/*
 * This is needed for test compilations where the "compat.h"
 * header is not usually available.
 */
#  if defined(HAVE_STDINT_H)
#    include <stdint.h>
#  elif defined(HAVE_INTTYPES_H)
#    include <inttypes.h>
#  endif /* HAVE_STDINT/INTTYPES_H */

#  if defined(HAVE_LIMITS_H)
#    include <limits.h>
#  elif defined(HAVE_SYS_LIMITS_H)
#    include <sys/limits.h>
#  endif /* HAVE_LIMITS/SYS_LIMITS_H */

#  if defined(HAVE_SYSEXITS_H)
#    include <sysexits.h>
#  endif /* HAVE_SYSEXITS_H */

#  if defined(HAVE_STDBOOL_H)
#    include <stdbool.h>
#  else
     typedef enum { false = 0, true = 1 } _Bool;
#    define bool _Bool

     /* The other macros must be usable in preprocessor directives.  */
#    define false 0
#    define true 1
#  endif /* HAVE_SYSEXITS_H */
#endif /* COMPAT_H_GUARD */
// END-CONFIGURED-HEADERS

/**
 * Defined to abnormal value of EX_USAGE.  Used to indicate that paged usage
 * was requested.  It is used to distinguish a --usage from a --help request.
 * --usage is abbreviated and --help gives as much help as possible.
 */
#define AO_EXIT_REQ_USAGE 10064

/**
 *  PUBLIC DEFINES
 *
 *  The following defines may be used in applications that need to test the
 *  state of an option.  To test against these masks and values, a pointer
 *  to an option descriptor must be obtained.  There are two ways:
 *
 *  1. inside an option processing procedure, it is the second argument,
 *     conventionally "tOptDesc* pOD".
 *
 *  2. Outside of an option procedure (or to reference a different option
 *     descriptor), use either "&DESC( opt_name )" or "&pfx_DESC( opt_name )".
 *
 *  See the relevant generated header file to determine which and what
 *  values for "opt_name" are available.
 * @group version
 * @{
 */
/// autoopts structure version
#define OPTIONS_STRUCT_VERSION      155648
/// autoopts structure version string
#define OPTIONS_VERSION_STRING      "38:0:13"
/// minimum version the autoopts library supports
#define OPTIONS_MINIMUM_VERSION     102400
/// minimum version the autoopts library supports as a string
#define OPTIONS_MIN_VER_STRING      "25:0:0"
/// the display version of the autoopts library, as a string
#define OPTIONS_DOTTED_VERSION      "38.0"
/// convert a version/release number pair to an integer value
#define OPTIONS_VER_TO_NUM(_v, _r)  (((_v) * 4096) + (_r))
/// @}

/**
 * Option argument types.  This must fit in the OPTST_ARG_TYPE_MASK
 * field of the fOptState field of an option descriptor (tOptDesc).
 * It will be a problem to extend beyond 4 bits.
 */
typedef enum {
    OPARG_TYPE_NONE         =  0, ///< does not take an argument
    OPARG_TYPE_STRING       =  1, ///< default type/ vanilla string
    OPARG_TYPE_ENUMERATION  =  2, ///< opt arg is an enum (keyword list)
    OPARG_TYPE_BOOLEAN      =  3, ///< opt arg is boolean-valued
    OPARG_TYPE_MEMBERSHIP   =  4, ///< opt arg sets set membership bits
    OPARG_TYPE_NUMERIC      =  5, ///< opt arg is a long int
    OPARG_TYPE_HIERARCHY    =  6, ///< option arg is hierarchical value
    OPARG_TYPE_FILE         =  7, ///< option arg names a file
    OPARG_TYPE_TIME         =  8, ///< opt arg is a time duration
    OPARG_TYPE_FLOAT        =  9, ///< opt arg is a floating point num
    OPARG_TYPE_DOUBLE       = 10, ///< opt arg is a double prec. float
    OPARG_TYPE_LONG_DOUBLE  = 11, ///< opt arg is a long double prec.
    OPARG_TYPE_LONG_LONG    = 12  ///< opt arg is a long long int
} teOptArgType;

/**
 * value descriptor for sub options
 */
typedef struct optionValue {
    teOptArgType        valType;        ///< which argument type
    char *              pzName;         ///< name of the sub-option
    union {
        char            strVal[1];      ///< OPARG_TYPE_STRING
        unsigned int    enumVal;        ///< OPARG_TYPE_ENUMERATION
        unsigned int    boolVal;        ///< OPARG_TYPE_BOOLEAN
        unsigned long   setVal;         ///< OPARG_TYPE_MEMBERSHIP
        long            longVal;        ///< OPARG_TYPE_NUMERIC
        void*           nestVal;        ///< OPARG_TYPE_HIERARCHY
    } v;
} tOptionValue;

/**
 * file argument state and handling.
 */
typedef enum {
    FTYPE_MODE_MAY_EXIST        = 0x00, ///< may or may not exist
    FTYPE_MODE_MUST_EXIST       = 0x01, ///< must pre-exist
    FTYPE_MODE_MUST_NOT_EXIST   = 0x02, ///< must *not* pre-exist
    FTYPE_MODE_EXIST_MASK       = 0x03, ///< mask for these bits
    FTYPE_MODE_NO_OPEN          = 0x00, ///< leave file closed
    FTYPE_MODE_OPEN_FD          = 0x10, ///< call open(2)
    FTYPE_MODE_FOPEN_FP         = 0x20, ///< call fopen(3)
    FTYPE_MODE_OPEN_MASK        = 0x30  ///< open/fopen/not open
} teOptFileType;

/**
 * the open flag bits or the mode string, depending on the open type.
 */
typedef union {
    int             file_flags;  ///< open(2) flag bits
    char const *    file_mode;   ///< fopen(3) mode string
} tuFileMode;

/// initial number of option argument holders to allocate
#define MIN_ARG_ALLOC_CT   6
/// amount by which to increment the argument holder allocation.
#define INCR_ARG_ALLOC_CT  8  
/**
 * an argument list.  When an option appears multiple times and
 * the values get "stacked".  \a apzArgs  holds 8 pointers initially
 * and is incremented by \a INCR_ARG_ALLOC_CT as needed.
 */
typedef struct {
    int             useCt;  ///< elements in use

    /// allocated elements, mininum \a MIN_ARG_ALLOC_CT
    /// steps by \a INCR_ARG_ALLOC_CT
    int             allocCt;
    char const *    apzArgs[MIN_ARG_ALLOC_CT]; ///< element array
} tArgList;

/**
 *  Bits in the fOptState option descriptor field.
 * @{
 */

/** integral type for holding opt_state masks */
typedef uint32_t opt_state_mask_t;

#define OPTST_ARG_TYPE_SHIFT 12
/** bits defined for opt_state_mask_t */
/** opt_state_mask_t - Set via the "SET_OPT()" macro */
#define OPTST_SET              0x0000001U
/** opt_state_mask_t - Set via an RC/INI file */
#define OPTST_PRESET           0x0000002U
/** opt_state_mask_t - Set via a command line option */
#define OPTST_DEFINED          0x0000004U
/** opt_state_mask_t - Reset via command line option */
#define OPTST_RESET            0x0000008U
/** opt_state_mask_t - selected by equiv'ed option */
#define OPTST_EQUIVALENCE      0x0000010U
/** opt_state_mask_t - option is in disabled state */
#define OPTST_DISABLED         0x0000020U
/** opt_state_mask_t - pzOptArg was allocated */
#define OPTST_ALLOC_ARG        0x0000040U
/** opt_state_mask_t - option cannot be preset */
#define OPTST_NO_INIT          0x0000100U
/** opt_state_mask_t - opt value (flag) is any digit */
#define OPTST_NUMBER_OPT       0x0000200U
/** opt_state_mask_t - opt uses optionStackArg proc */
#define OPTST_STACKED          0x0000400U
/** opt_state_mask_t - option defaults to enabled */
#define OPTST_INITENABLED      0x0000800U
/** opt_state_mask_t - bit 1 of arg type enum */
#define OPTST_ARG_TYPE_1       0x0001000U
/** opt_state_mask_t - bit 2 of arg type enum */
#define OPTST_ARG_TYPE_2       0x0002000U
/** opt_state_mask_t - bit 3 of arg type enum */
#define OPTST_ARG_TYPE_3       0x0004000U
/** opt_state_mask_t - bit 4 of arg type enum */
#define OPTST_ARG_TYPE_4       0x0008000U
/** opt_state_mask_t - the option arg not required */
#define OPTST_ARG_OPTIONAL     0x0010000U
/** opt_state_mask_t - process opt on first pass */
#define OPTST_IMM              0x0020000U
/** opt_state_mask_t - process disablement immed. */
#define OPTST_DISABLE_IMM      0x0040000U
/** opt_state_mask_t - compiled out of program */
#define OPTST_OMITTED          0x0080000U
/** opt_state_mask_t - must be set or pre-set */
#define OPTST_MUST_SET         0x0100000U
/** opt_state_mask_t - opt is for doc only */
#define OPTST_DOCUMENT         0x0200000U
/** opt_state_mask_t - process opt twice - imm + reg */
#define OPTST_TWICE            0x0400000U
/** opt_state_mask_t - process disabled option twice */
#define OPTST_DISABLE_TWICE    0x0800000U
/** opt_state_mask_t - scaled integer value */
#define OPTST_SCALED_NUM       0x1000000U
/** opt_state_mask_t - disable from cmd line */
#define OPTST_NO_COMMAND       0x2000000U
/** opt_state_mask_t - support is being removed */
#define OPTST_DEPRECATED       0x4000000U
/** opt_state_mask_t - alias for other option */
#define OPTST_ALIAS            0x8000000U

/** bits in SET mask:
 *  set     preset  reset   defined */
#define OPTST_SET_MASK         0x000000FU

/** bits in MUTABLE mask:
 *  set         preset      reset       defined     equivalence disabled
 *  alloc_arg */
#define OPTST_MUTABLE_MASK     0x000007FU

/** bits omitted from PERSISTENT mask:
 *  mutable_mask */
#define OPTST_PERSISTENT_MASK  0xFFFFF00U

/** bits in SELECTED mask:
 *  set     defined */
#define OPTST_SELECTED_MASK    0x0000005U

/** bits in ARG_TYPE mask:
 *  arg_type_1 arg_type_2 arg_type_3 arg_type_4 */
#define OPTST_ARG_TYPE_MASK    0x000F000U

/** bits in NO_USAGE mask:
 *  omitted    no_command deprecated */
#define OPTST_NO_USAGE_MASK    0x6080000U

/** bits in IMMUTABLE mask:
 *  document omitted */
#define OPTST_IMMUTABLE_MASK   0x0280000U

/** bits in DO_NOT_SAVE mask:
 *  document omitted  no_init */
#define OPTST_DO_NOT_SAVE_MASK 0x0280100U

/** bits in NO_OUTPUT mask:
 *  document omitted  alias */
#define OPTST_NO_OUTPUT_MASK   0x8280000U

/** all bits in opt_state_mask_t masks */
#define OPTST_MASK_ALL         0xFFFFF7FU

/** no bits in opt_state_mask_t */
#define OPTST_INIT             0x0000000U
/** @} */

#ifdef NO_OPTIONAL_OPT_ARGS
# undef  OPTST_ARG_OPTIONAL
# define OPTST_ARG_OPTIONAL   0
#endif

#define VENDOR_OPTION_VALUE   'W'

#define SELECTED_OPT(_od)     ((_od)->fOptState  & OPTST_SELECTED_MASK)
#define UNUSED_OPT(  _od)     (((_od)->fOptState & OPTST_SET_MASK) == 0)
#define DISABLED_OPT(_od)     ((_od)->fOptState  & OPTST_DISABLED)
#define OPTION_STATE(_od)     ((_od)->fOptState)
#define OPTST_SET_ARGTYPE(_n) ((_n) << OPTST_ARG_TYPE_SHIFT)
#define OPTST_GET_ARGTYPE(_f) \
    (((_f)&OPTST_ARG_TYPE_MASK) >> OPTST_ARG_TYPE_SHIFT)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  PRIVATE INTERFACES
 *
 *  The following values are used in the generated code to communicate
 *  with the option library procedures.  They are not for public use
 *  and may be subject to change.
 */

/**
 *  Define the processing state flags
 * @{
 */

/** integral type for holding proc_state masks */
typedef uint32_t proc_state_mask_t;

/** bits defined for proc_state_mask_t */
/** proc_state_mask_t - Process long style options */
#define OPTPROC_LONGOPT       0x000001U
/** proc_state_mask_t - Process short style "flags" */
#define OPTPROC_SHORTOPT      0x000002U
/** proc_state_mask_t - Stop on argument errors */
#define OPTPROC_ERRSTOP       0x000004U
/** proc_state_mask_t - Current option is disabled */
#define OPTPROC_DISABLEDOPT   0x000008U
/** proc_state_mask_t - no options are required */
#define OPTPROC_NO_REQ_OPT    0x000010U
/** proc_state_mask_t - there is a number option */
#define OPTPROC_NUM_OPT       0x000020U
/** proc_state_mask_t - have inits been done? */
#define OPTPROC_INITDONE      0x000040U
/** proc_state_mask_t - any negation options? */
#define OPTPROC_NEGATIONS     0x000080U
/** proc_state_mask_t - check environment? */
#define OPTPROC_ENVIRON       0x000100U
/** proc_state_mask_t - Disallow remaining arguments */
#define OPTPROC_NO_ARGS       0x000200U
/** proc_state_mask_t - Require args after options */
#define OPTPROC_ARGS_REQ      0x000400U
/** proc_state_mask_t - reorder operands after opts */
#define OPTPROC_REORDER       0x000800U
/** proc_state_mask_t - emit usage in GNU style */
#define OPTPROC_GNUUSAGE      0x001000U
/** proc_state_mask_t - Translate strings in tOptions */
#define OPTPROC_TRANSLATE     0x002000U
/** proc_state_mask_t - no usage on usage error */
#define OPTPROC_MISUSE        0x004000U
/** proc_state_mask_t - immediate options active */
#define OPTPROC_IMMEDIATE     0x008000U
/** proc_state_mask_t - suppress for config only */
#define OPTPROC_NXLAT_OPT_CFG 0x010000U
/** proc_state_mask_t - suppress xlation always */
#define OPTPROC_NXLAT_OPT     0x020000U
/** proc_state_mask_t - vendor options active */
#define OPTPROC_VENDOR_OPT    0x040000U
/** proc_state_mask_t - opt processing in preset state */
#define OPTPROC_PRESETTING    0x080000U
/** proc_state_mask_t - Ignore pzFullUsage, compute usage text */
#define OPTPROC_COMPUTE       0x100000U

/** bits in NO_XLAT mask:
 *  nxlat_opt_cfg nxlat_opt */
#define OPTPROC_NO_XLAT_MASK  0x030000U

/** all bits in proc_state_mask_t masks */
#define OPTPROC_MASK_ALL      0x1FFFFFU

/** no bits in proc_state_mask_t */
#define OPTPROC_NONE          0x000000U
/** @} */

#define STMTS(s)  do { s; } while (false)

/**
 *  Abbreviation for const memory character.
 */
#define tCC         char const

/**
 * Magical values for the program's option pointer
 * @{
 */
typedef enum {
    OP_VAL_EMIT_USAGE       = 1,  ///< request for usage
    OP_VAL_EMIT_SHELL       = 2,  ///< emit value for Bourne shell evaluation
    OP_VAL_RETURN_VALNAME   = 3,  ///< return the value as a string
    OP_VAL_EMIT_LIMIT       = 15  ///< limit for magic values
} opt_proc_vals_t;

/// \a OPT_VAL_EMIT_USAGE cast as a pointer
#define OPTPROC_EMIT_USAGE      ((tOptions *)OP_VAL_EMIT_USAGE)

/// \a OPT_VAL_EMIT_SHELL cast as a pointer
#define OPTPROC_EMIT_SHELL      ((tOptions *)OP_VAL_EMIT_SHELL)

/// \a OPT_VAL_RETURN_VALNAME cast as a pointer
#define OPTPROC_RETURN_VALNAME  ((tOptions *)OP_VAL_RETURN_VALNAME)

/// \a OPT_VAL_EMIT_LIMIT cast as a pointer
#define OPTPROC_EMIT_LIMIT      ((tOptions *)OP_VAL_EMIT_LIMIT)
/** @} */

/** group option processing procedure types
 * @{
 */
/** forward declaration for tOptDesc */
typedef struct opt_desc tOptDesc;
/** forward declaration for tOptiond */
typedef struct options  tOptions;

/**
 *  The option procedures do the special processing for each
 *  option flag that needs it.
 */
typedef void (tOptProc)(tOptions * pOpts, tOptDesc * pOptDesc);

/**
 * a pointer to an option processing procedure
 */
typedef tOptProc * tpOptProc;

/**
 *  The usage procedure will never return.  It calls "exit(2)"
 *  with the "exitCode" argument passed to it.
 */
// coverity[+kill]
typedef void (tUsageProc)(tOptions* pOpts, int exitCode);

/**
 * a pointer to a procedure that prints usage and exits.
 */
typedef tUsageProc * tpUsageProc;
/** @} */

/**
 *  Special definitions.  "NOLIMIT" is the 'max' value to use when
 *  a flag may appear multiple times without limit.  "NO_EQUIVALENT"
 *  is an illegal value for 'optIndex' (option description index).
 * @{
 */
#define NOLIMIT          USHRT_MAX  ///< no occurrance count limit
#define OPTION_LIMIT     SHRT_MAX   ///< maximum number of option types
/// option index to indicate no equivalance or alias
#define NO_EQUIVALENT    (OPTION_LIMIT+1)
/** @} */

/**
 * Option argument value.  Which is valid is determined by:
 * (fOptState & OPTST_ARG_TYPE_MASK) >> OPTST_ARG_TYPE_SHIFT
 * which will yield one of the teOptArgType values.
 */
typedef union {
    char const *    argString;  ///< as a string
    uintptr_t       argEnum;    ///< as an enumeration value
    uintptr_t       argIntptr;  ///< as an integer big enough to hold pointer
    long            argInt;     ///< as a long integer
    unsigned long   argUint;    ///< as an unsigned long ingeger
    unsigned int    argBool;    ///< as a boolean value
    FILE *          argFp;      ///< as a FILE * pointer
    int             argFd;      ///< as a file descriptor (int)
} opt_arg_union_t;

/// Compatibility define: \a pzLastArg is now \a optArg.argString
#define             pzLastArg       optArg.argString
/// The old amorphous argument bucket is now the opt_arg_union_t union.
#define             optArgBucket_t  opt_arg_union_t

/**
 * Enumeration of AutoOpts defined options.  The enumeration is used in
 * marking each option that is defined by AutoOpts so libopts can find
 * the correct descriptor.  This renders \a option_spec_idx_t redundant.
 */
typedef enum {
    AOUSE_USER_DEFINED = 0,     ///< user specified option
    AOUSE_RESET_OPTION,         ///< reset option state option
    AOUSE_VERSION,              ///< request version
    AOUSE_HELP,                 ///< request usage help
    AOUSE_MORE_HELP,            ///< request paged usage
    AOUSE_USAGE,                ///< request short usage
    AOUSE_SAVE_OPTS,            ///< save option state
    AOUSE_LOAD_OPTS,            ///< load options from file
    AOUSE_VENDOR_OPT            ///< specify a vendor option
} opt_usage_t;

/**
 *  Descriptor structure for each option.
 *  Only the fields marked "PUBLIC" are for public use.
 */
struct opt_desc {
    /// Public, the index of this descriptor
    uint16_t const      optIndex;
    /// Public, the flag character (value)
    uint16_t const      optValue;
    /// Public, the index of the option used to activate option
    uint16_t            optActualIndex;
    /// Public, the flag character of the activating option
    uint16_t            optActualValue;

    /// Public, the index of the equivalenced-to option.
    /// This is NO_EQUIVALENT unless activated.
    uint16_t const      optEquivIndex;
    /// Private, the minimum occurrance count
    uint16_t const      optMinCt;
    /// Private, the maximum occurrance count (NOLIMIT, if unlimited)
    uint16_t const      optMaxCt;
    /// Public, the actual occurrance count
    uint16_t            optOccCt;

    /// Public, the option processing state
    opt_state_mask_t    fOptState;
    /// Private, how the option is used (opt_usage_t)
    uint32_t            optUsage;
    /// Public, The current option argument value
    opt_arg_union_t     optArg;
    /// Public, data that is actually private to the code that handles
    /// this particular option.  It is public IFF you have your own
    /// handling function.
    void *              optCookie;

    /// Private, a list of options that must be specified when this option
    /// has been specified
    int const  * const  pOptMust;

    /// Private, a list of options that cannot be specified when this option
    /// has been specified
    int const  * const  pOptCant;

    /// Private, the function to call for handling this option
    tpOptProc    const  pOptProc;

    /// Private, usage information about this option
    char const * const  pzText;

    /// Public, the UPPER CASE, shell variable name syntax name of the option
    char const * const  pz_NAME;

    /// the unmodified name of the option
    char const * const  pz_Name;

    /// the option name to use to disable the option.  Long options names
    /// must be active.
    char const * const  pz_DisableName;

    /// the special prefix that makes the normal option name become the
    /// disablement name.
    char const * const  pz_DisablePfx;
};

/**
 *  Some options need special processing, so we store their
 *  indexes in a known place.
 */
typedef struct {
    uint16_t const  more_help;      ///< passes help text through pager
    uint16_t const  save_opts;      ///< stores option state to a file
    uint16_t const  number_option;  ///< the option "name" is an integer
    /// all arguments are options, this is the default option that must
    /// take an argument.  That argument is the unrecognized option.
    uint16_t const  default_opt;
} option_spec_idx_t;

/**
 *  The procedure generated for translating option text
 */
typedef void (tOptionXlateProc)(void);

/**
 * Everything marked "PUBLIC" is also marked "const".  Public access is not
 * a license to modify.  Other fields are used and modified by the library.
 * They are also subject to change without any notice.
 * Do not even look at these outside of libopts.
 */
struct options {
    int const                   structVersion; ///< The version of this struct
    unsigned int                origArgCt;     ///< program argument count
    char **                     origArgVect;   ///< program argument vector
    proc_state_mask_t           fOptSet;       ///< option proc. state flags
    unsigned int                curOptIdx;     ///< current option index
    char *                      pzCurOpt;      ///< current option text

    /// Public, the full path of the program
    char const * const          pzProgPath;
    /// Public, the name of the executable, without any path
    char const * const          pzProgName;
    /// Public, the upper-cased, shell variable syntax-ed program name
    char const * const          pzPROGNAME;
    /// the name of the "rc file" (configuration file)
    char const * const          pzRcName;
    /// the copyright text
    char const * const          pzCopyright;
    /// the full copyright notice
    char const * const          pzCopyNotice;
    /// a string with the program name, project name and version
    char const * const          pzFullVersion;
    /// a list of pointers to directories to search for the config file
    char const * const *        const papzHomeList;
    /// the title line for usage
    char const * const          pzUsageTitle;
    /// some added explanation for what this program is trying to do
    char const * const          pzExplain;
    /// a detailed explanation of the program's purpose, for use when
    /// full help has been requested
    char const * const          pzDetail;
    /// The public array of option descriptors
    tOptDesc   * const          pOptDesc;
    /// the email address for reporting bugs
    char const * const          pzBugAddr;

    /// Reserved for future use
    void *                      pExtensions;
    /// A copy of the option state when optionSaveState was called.
    void *                      pSavedState;

    /// The procedure to call to print usage text
    // coverity[+kill]
    tpUsageProc                 pUsageProc;
    /// The procedure to call to translate translatable option messages
    tOptionXlateProc *          pTransProc;

    /// Special option indexes.
    option_spec_idx_t           specOptIdx;
    /// the total number of options for the program
    int const                   optCt;
    /// The number of "presettable" options, though some may be marked
    /// "no-preset".  Includes all user specified options, plus a few
    /// that are specified by AutoOpts.
    int const                   presetOptCt;
    /// user specified full usage text
    char const *                pzFullUsage;
    /// user specifed short usage (usage error triggered) message
    char const *                pzShortUsage;
    /// The option argument settings active when optionSaveState was called
    opt_arg_union_t const * const originalOptArgArray;
    /// any saved cookie value
    void * const * const        originalOptArgCookie;
    /// the package data directory (e.g. global configuration files)
    char const * const          pzPkgDataDir;
    /// email address of the project packager
    char const * const          pzPackager;
};

/*
 *  Versions where in various fields first appear:
 *  ($AO_CURRENT * 4096 + $AO_REVISION, but $AO_REVISION must be zero)
 */
/**
 * The version that first stored the original argument vector
 */
#define originalOptArgArray_STRUCT_VERSION  0x20000 /* AO_CURRENT = 32 */
#define HAS_originalOptArgArray(_opt) \
    ((_opt)->structVersion >= originalOptArgArray_STRUCT_VERSION)

/**
 * The version that first stored the package data directory
 */
#define pzPkgDataDir_STRUCT_VERSION  0x22000 /* AO_CURRENT = 34 */
#define HAS_pzPkgDataDir(_opt) \
    ((_opt)->structVersion >= pzPkgDataDir_STRUCT_VERSION)

/**
 * The version that first stored the option usage in each option descriptor
 */
#define opt_usage_t_STRUCT_VERSION  0x26000 /* AO_CURRENT = 38 */
#define HAS_opt_usage_t(_opt) \
    ((_opt)->structVersion >= opt_usage_t_STRUCT_VERSION)

/**
 *  "token list" structure returned by "string_tokenize()"
 */
typedef struct {
    unsigned long   tkn_ct;      ///< number of tokens found
    unsigned char*  tkn_list[1]; ///< array of pointers to tokens
} token_list_t;

/*
 *  Hide the interface - it pollutes a POSIX claim, but leave it for
 *  anyone #include-ing this header
 */
#define strneqvcmp      option_strneqvcmp
#define streqvcmp       option_streqvcmp
#define streqvmap       option_streqvmap
#define strequate       option_strequate
#define strtransform    option_strtransform

/**
 *  Everything needed to be known about an mmap-ed file.
 *
 *  This is an output only structure used by text_mmap and text_munmap.
 *  Clients must not alter the contents and must provide it to both
 *  the text_mmap and text_munmap procedures.  BE ADVISED: if you are
 *  mapping the file with PROT_WRITE the NUL byte at the end MIGHT NOT
 *  BE WRITABLE.  In any event, that byte is not be written back
 *  to the source file.  ALSO: if "txt_data" is valid and "txt_errno"
 *  is not zero, then there *may* not be a terminating NUL.
 */
typedef struct {
    void *      txt_data;      ///< text file data
    size_t      txt_size;      ///< actual file size
    size_t      txt_full_size; ///< mmaped mem size
    int         txt_fd;        ///< file descriptor
    int         txt_zero_fd;   ///< fd for /dev/zero
    int         txt_errno;     ///< warning code
    int         txt_prot;      ///< "prot" flags
    int         txt_flags;     ///< mapping type
} tmap_info_t;

/**
 * mmap result wrapper that yields "true" when mmap has failed.
 */
#define TEXT_MMAP_FAILED_ADDR(a)  ((void*)(a) ==  (void*)MAP_FAILED)

#ifdef  __cplusplus
#define CPLUSPLUS_OPENER extern "C" {
CPLUSPLUS_OPENER
#define CPLUSPLUS_CLOSER }
#else
#define CPLUSPLUS_CLOSER
#endif

/**
 *  The following routines may be coded into AutoOpts client code:
 */

/**
 * ao_string_tokenize - tokenize an input string
 *
 *  This function will convert one input string into a list of strings.
 *  The list of strings is derived by separating the input based on
 *  white space separation.  However, if the input contains either single
 *  or double quote characters, then the text after that character up to
 *  a matching quote will become the string in the list.
 *
 *  The returned pointer should be deallocated with @code{free(3C)} when
 *  are done using the data.  The data are placed in a single block of
 *  allocated memory.  Do not deallocate individual token/strings.
 *
 *  The structure pointed to will contain at least these two fields:
 *  @table @samp
 *  @item tkn_ct
 *  The number of tokens found in the input string.
 *  @item tok_list
 *  An array of @code{tkn_ct + 1} pointers to substring tokens, with
 *  the last pointer set to NULL.
 *  @end table
 *
 *  There are two types of quoted strings: single quoted (@code{'}) and
 *  double quoted (@code{"}).  Singly quoted strings are fairly raw in that
 *  escape characters (@code{\\}) are simply another character, except when
 *  preceding the following characters:
 *  @example
 *  @code{\\}  double backslashes reduce to one
 *  @code{'}   incorporates the single quote into the string
 *  @code{\n}  suppresses both the backslash and newline character
 *  @end example
 *
 *  Double quote strings are formed according to the rules of string
 *  constants in ANSI-C programs.
 *
 * @param string       string to be tokenized
 *
 * @return token_list_t* - pointer to a structure that lists each token
 */
extern token_list_t* ao_string_tokenize(char const*);


/**
 * configFileLoad - parse a configuration file
 *
 *  This routine will load a named configuration file and parse the
 *  text as a hierarchically valued option.  The option descriptor
 *  created from an option definition file is not used via this interface.
 *  The returned value is "named" with the input file name and is of
 *  type "@code{OPARG_TYPE_HIERARCHY}".  It may be used in calls to
 *  @code{optionGetValue()}, @code{optionNextValue()} and
 *  @code{optionUnloadNested()}.
 *
 * @param fname        the file to load
 *
 * @return const tOptionValue* - An allocated, compound value structure
 */
extern const tOptionValue* configFileLoad(char const*);


/**
 * optionFileLoad - Load the locatable config files, in order
 *
 *  This function looks in all the specified directories for a configuration
 *  file ("rc" file or "ini" file) and processes any found twice.  The first
 *  time through, they are processed in reverse order (last file first).  At
 *  that time, only "immediate action" configurables are processed.  For
 *  example, if the last named file specifies not processing any more
 *  configuration files, then no more configuration files will be processed.
 *  Such an option in the @strong{first} named directory will have no effect.
 *
 *  Once the immediate action configurables have been handled, then the
 *  directories are handled in normal, forward order.  In that way, later
 *  config files can override the settings of earlier config files.
 *
 *  See the AutoOpts documentation for a thorough discussion of the
 *  config file format.
 *
 *  Configuration files not found or not decipherable are simply ignored.
 *
 * @param opts         program options descriptor
 * @param prog         program name
 *
 * @return int - 0 -> SUCCESS, -1 -> FAILURE
 */
extern int optionFileLoad(tOptions*, char const*);


/**
 * optionFindNextValue - find a hierarcicaly valued option instance
 *
 *  This routine will find the next entry in a nested value option or
 *  configurable.  It will search through the list and return the next entry
 *  that matches the criteria.
 *
 * @param odesc        an option with a nested arg type
 * @param pPrevVal     the last entry
 * @param name         name of value to find
 * @param value        the matching value
 *
 * @return const tOptionValue* - a compound value structure
 */
extern const tOptionValue* optionFindNextValue(const tOptDesc*, const tOptionValue*, char const*, char const*);


/**
 * optionFindValue - find a hierarcicaly valued option instance
 *
 *  This routine will find an entry in a nested value option or configurable.
 *  It will search through the list and return a matching entry.
 *
 * @param odesc        an option with a nested arg type
 * @param name         name of value to find
 * @param val          the matching value
 *
 * @return const tOptionValue* - a compound value structure
 */
extern const tOptionValue* optionFindValue(const tOptDesc*, char const*, char const*);


/**
 * optionFree - free allocated option processing memory
 *
 *  AutoOpts sometimes allocates memory and puts pointers to it in the
 *  option state structures.  This routine deallocates all such memory.
 *
 * @param pOpts        program options descriptor
 */
extern void optionFree(tOptions*);


/**
 * optionGetValue - get a specific value from a hierarcical list
 *
 *  This routine will find an entry in a nested value option or configurable.
 *  If "valueName" is NULL, then the first entry is returned.  Otherwise,
 *  the first entry with a name that exactly matches the argument will be
 *  returned.  If there is no matching value, NULL is returned and errno is
 *  set to ENOENT. If the provided option value is not a hierarchical value,
 *  NULL is also returned and errno is set to EINVAL.
 *
 * @param pOptValue    a hierarchcal value
 * @param valueName    name of value to get
 *
 * @return const tOptionValue* - a compound value structure
 */
extern const tOptionValue* optionGetValue(const tOptionValue*, char const*);


/**
 * optionLoadLine - process a string for an option name and value
 *
 *  This is a client program callable routine for setting options from, for
 *  example, the contents of a file that they read in.  Only one option may
 *  appear in the text.  It will be treated as a normal (non-preset) option.
 *
 *  When passed a pointer to the option struct and a string, it will find
 *  the option named by the first token on the string and set the option
 *  argument to the remainder of the string.  The caller must NUL terminate
 *  the string.  The caller need not skip over any introductory hyphens.
 *  Any embedded new lines will be included in the option
 *  argument.  If the input looks like one or more quoted strings, then the
 *  input will be "cooked".  The "cooking" is identical to the string
 *  formation used in AutoGen definition files (@pxref{basic expression}),
 *  except that you may not use backquotes.
 *
 * @param opts         program options descriptor
 * @param line         NUL-terminated text
 */
extern void optionLoadLine(tOptions*, char const*);


/**
 * optionNextValue - get the next value from a hierarchical list
 *
 *  This routine will return the next entry after the entry passed in.  At the
 *  end of the list, NULL will be returned.  If the entry is not found on the
 *  list, NULL will be returned and "@var{errno}" will be set to EINVAL.
 *  The "@var{pOldValue}" must have been gotten from a prior call to this
 *  routine or to "@code{opitonGetValue()}".
 *
 * @param pOptValue    a hierarchcal list value
 * @param pOldValue    a value from this list
 *
 * @return const tOptionValue* - a compound value structure
 */
extern const tOptionValue* optionNextValue(const tOptionValue*, const tOptionValue*);


/**
 * optionOnlyUsage - Print usage text for just the options
 *
 *  This routine will print only the usage for each option.
 *  This function may be used when the emitted usage must incorporate
 *  information not available to AutoOpts.
 *
 * @param pOpts        program options descriptor
 * @param ex_code      exit code for calling exit(3)
 */
extern void optionOnlyUsage(tOptions*, int);


/**
 * optionProcess - this is the main option processing routine
 *
 *  This is the main entry point for processing options.  It is intended
 *  that this procedure be called once at the beginning of the execution of
 *  a program.  Depending on options selected earlier, it is sometimes
 *  necessary to stop and restart option processing, or to select completely
 *  different sets of options.  This can be done easily, but you generally
 *  do not want to do this.
 *
 *  The number of arguments processed always includes the program name.
 *  If one of the arguments is "--", then it is counted and the processing
 *  stops.  If an error was encountered and errors are to be tolerated, then
 *  the returned value is the index of the argument causing the error.
 *  A hyphen by itself ("-") will also cause processing to stop and will
 *  @emph{not} be counted among the processed arguments.  A hyphen by itself
 *  is treated as an operand.  Encountering an operand stops option
 *  processing.
 *
 * @param opts         program options descriptor
 * @param a_ct         program arg count
 * @param a_v          program arg vector
 *
 * @return int - the count of the arguments processed
 */
extern int optionProcess(tOptions*, int, char**);


/**
 * optionRestore - restore option state from memory copy
 *
 *  Copy back the option state from saved memory.
 *  The allocated memory is left intact, so this routine can be
 *  called repeatedly without having to call optionSaveState again.
 *  If you are restoring a state that was saved before the first call
 *  to optionProcess(3AO), then you may change the contents of the
 *  argc/argv parameters to optionProcess.
 *
 * @param pOpts        program options descriptor
 */
extern void optionRestore(tOptions*);


/**
 * optionSaveFile - saves the option state to a file
 *
 *  This routine will save the state of option processing to a file.  The name
 *  of that file can be specified with the argument to the @code{--save-opts}
 *  option, or by appending the @code{rcfile} attribute to the last
 *  @code{homerc} attribute.  If no @code{rcfile} attribute was specified, it
 *  will default to @code{.@i{programname}rc}.  If you wish to specify another
 *  file, you should invoke the @code{SET_OPT_SAVE_OPTS(@i{filename})} macro.
 *
 *  The recommend usage is as follows:
 *  @example
 *  optionProcess(&progOptions, argc, argv);
 *  if (i_want_a_non_standard_place_for_this)
 *  SET_OPT_SAVE_OPTS("myfilename");
 *  optionSaveFile(&progOptions);
 *  @end example
 *
 * @param opts         program options descriptor
 */
extern void optionSaveFile(tOptions*);


/**
 * optionSaveState - saves the option state to memory
 *
 *  This routine will allocate enough memory to save the current option
 *  processing state.  If this routine has been called before, that memory
 *  will be reused.  You may only save one copy of the option state.  This
 *  routine may be called before optionProcess(3AO).  If you do call it
 *  before the first call to optionProcess, then you may also change the
 *  contents of argc/argv after you call optionRestore(3AO)
 *
 *  In fact, more strongly put: it is safest to only use this function
 *  before having processed any options.  In particular, the saving and
 *  restoring of stacked string arguments and hierarchical values is
 *  disabled.  The values are not saved.
 *
 * @param pOpts        program options descriptor
 */
extern void optionSaveState(tOptions*);


/**
 * optionUnloadNested - Deallocate the memory for a nested value
 *
 *  A nested value needs to be deallocated.  The pointer passed in should
 *  have been gotten from a call to @code{configFileLoad()} (See
 *  @pxref{libopts-configFileLoad}).
 *
 * @param pOptVal      the hierarchical value
 */
extern void optionUnloadNested(tOptionValue const *);


/**
 * optionVersion - return the compiled AutoOpts version number
 *
 *  Returns the full version string compiled into the library.
 *  The returned string cannot be modified.
 *
 * @return char const* - the version string in constant memory
 */
extern char const* optionVersion(void);


/**
 * strequate - map a list of characters to the same value
 *
 *  Each character in the input string get mapped to the first character
 *  in the string.
 *  This function name is mapped to option_strequate so as to not conflict
 *  with the POSIX name space.
 *
 * @param ch_list      characters to equivalence
 */
extern void strequate(char const*);


/**
 * streqvcmp - compare two strings with an equivalence mapping
 *
 *  Using a character mapping, two strings are compared for "equivalence".
 *  Each input character is mapped to a comparison character and the
 *  mapped-to characters are compared for the two NUL terminated input strings.
 *  This function name is mapped to option_streqvcmp so as to not conflict
 *  with the POSIX name space.
 *
 * @param str1         first string
 * @param str2         second string
 *
 * @return int - the difference between two differing characters
 */
extern int streqvcmp(char const*, char const*);


/**
 * streqvmap - Set the character mappings for the streqv functions
 *
 *  Set the character mapping.  If the count (@code{ct}) is set to zero, then
 *  the map is cleared by setting all entries in the map to their index
 *  value.  Otherwise, the "@code{From}" character is mapped to the "@code{To}"
 *  character.  If @code{ct} is greater than 1, then @code{From} and @code{To}
 *  are incremented and the process repeated until @code{ct} entries have been
 *  set. For example,
 *  @example
 *  streqvmap('a', 'A', 26);
 *  @end example
 *  @noindent
 *  will alter the mapping so that all English lower case letters
 *  will map to upper case.
 *
 *  This function name is mapped to option_streqvmap so as to not conflict
 *  with the POSIX name space.
 *
 * @param from         Input character
 * @param to           Mapped-to character
 * @param ct           compare length
 */
extern void streqvmap(char, char, int);


/**
 * strneqvcmp - compare two strings with an equivalence mapping
 *
 *  Using a character mapping, two strings are compared for "equivalence".
 *  Each input character is mapped to a comparison character and the
 *  mapped-to characters are compared for the two NUL terminated input strings.
 *  The comparison is limited to @code{ct} bytes.
 *  This function name is mapped to option_strneqvcmp so as to not conflict
 *  with the POSIX name space.
 *
 * @param str1         first string
 * @param str2         second string
 * @param ct           compare length
 *
 * @return int - the difference between two differing characters
 */
extern int strneqvcmp(char const*, char const*, int);


/**
 * strtransform - convert a string into its mapped-to value
 *
 *  Each character in the input string is mapped and the mapped-to
 *  character is put into the output.
 *  This function name is mapped to option_strtransform so as to not conflict
 *  with the POSIX name space.
 *
 *  The source and destination may be the same.
 *
 * @param dest         output string
 * @param src          input string
 */
extern void strtransform(char*, char const*);

/*  AutoOpts PRIVATE FUNCTIONS:  */
tOptProc optionStackArg, optionUnstackArg, optionBooleanVal, optionNumericVal;

extern char* ao_string_cook(char*, int*);

extern unsigned int ao_string_cook_escape_char(char const*, char*, unsigned int);

extern void genshelloptUsage(tOptions*, int);

extern int optionAlias(tOptions *, tOptDesc *, unsigned int);

extern void optionBooleanVal(tOptions*, tOptDesc*);

extern uintptr_t optionEnumerationVal(tOptions*, tOptDesc*, char const * const *, unsigned int);

extern void optionFileCheck(tOptions*, tOptDesc*, teOptFileType, tuFileMode);

extern char const * optionKeywordName(tOptDesc*, unsigned int);

extern void optionLoadOpt(tOptions*, tOptDesc*);

extern bool optionMakePath(char*, int, char const*, char const*);

extern void optionNestedVal(tOptions*, tOptDesc*);

extern void optionNumericVal(tOptions*, tOptDesc*);

extern void optionPagedUsage(tOptions*, tOptDesc*);

extern void optionParseShell(tOptions*);

extern void optionPrintParagraphs(char const *, bool, FILE *);

extern void optionPrintVersion(tOptions*, tOptDesc*);

extern void optionPutShell(tOptions*);

extern char const * optionQuoteString(char const *, char const *);

extern void optionResetOpt(tOptions*, tOptDesc*);

extern void optionSetMembers(tOptions*, tOptDesc*, char const * const *, unsigned int);

extern void optionShowRange(tOptions*, tOptDesc*, void *, int);

extern void optionStackArg(tOptions*, tOptDesc*);

extern void optionTimeDate(tOptions*, tOptDesc*);

extern void optionTimeVal(tOptions*, tOptDesc*);

extern void optionUnstackArg(tOptions*, tOptDesc*);

extern void optionUsage(tOptions*, int);

extern void optionVendorOption(tOptions *, tOptDesc *);

extern void optionVersionStderr(tOptions*, tOptDesc*);

extern void* text_mmap(char const*, int, int, tmap_info_t*);

extern int text_munmap(tmap_info_t*);

CPLUSPLUS_CLOSER
#endif /* AUTOOPTS_OPTIONS_H_GUARD */
/** @}
 *
 * Local Variables:
 * c-file-style: "stroustrup"
 * indent-tabs-mode: nil
 * End:
 * options.h ends here */
