/*
 *  Intelligent Platform Management Interface driver for Linux 2.x
 *
 *  (c) Copyright 1999  San Mehat & VA Linux Systems
 *        1382 Bordeaux Dr.
 *        Sunnyvale, California
 *        94089
 *
 *  http://www.valinux.com
 *
 *  This driver is provided under the GNU public license, incorporated
 *  herein by reference. The driver is provided without warranty or
 *  support.
 *
 *  IOCTL definitions for IPMI KCS driver
 */

#ifndef _IPMI_KCS_IOCTLS_H
#define _IPMI_KCS_IOCTLS_H
  
#define  IOCTL_WATCHDOG_SET          0x01
  #define WATCHDOG_ACTION_REBOOT      0x01
  #define WATCHDOG_ACTION_NMI         0x02

#define IOCTL_WATCHDOG_PING         0x02

#define IOCTL_PANEL_LED_SET_BLINK   0x03
  #define PANEL_LED_NORMAL            0x00
  #define PANEL_LED_BLINK             0x01

#define IOCTL_READ_SENSOR           0x04
struct sensor_request
  {
  unsigned char sensor_number;
  unsigned char result_buffer[64];
  int           result_length;
  };

#define IOCTL_SET_ASSET_TAG         0x05
struct asset_tag_request
  {
  unsigned char buffer_len;
  char          *buffer;
  };

#define IOCTL_REFRESH_FRU           0x06

#define IOCTL_ADD_SEL_ENTRY         0x07
struct sel_entry_request
  {
  unsigned char data[6];
  };
#endif
