#include "types.h"
#include <string.h>
#include <assert.h>

extern u8 empty_zero_page[];

int raid6_regen_twodisks(int ndisks, int faila, int failb, void **data, size_t blksize)
{
  u8 **xdata = data;

  if ( faila > failb ) {
    int tmp = failb;
    failb = faila;
    faila = tmp;
  }
  assert(faila < failb);

  memset(data[faila], 0, blksize);
  memset(data[failb], 0, blksize);

  raid6_gen_syndrome(ndisks, data, blksize);

  
